/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.security.zza;
import java.lang.reflect.Method;

public class ProviderInstaller {
    @NonNull
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";
    private static final GoogleApiAvailabilityLight zza;
    private static final Object zzb;
    @GuardedBy(value="ProviderInstaller.lock")
    private static Method zzc;
    @GuardedBy(value="ProviderInstaller.lock")
    private static Method zzd;

    static {
        Object object;
        zza = GoogleApiAvailabilityLight.getInstance();
        zzb = object = new Object();
        zzc = null;
        zzd = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void installIfNeeded(@NonNull Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        Object object;
        Preconditions.checkNotNull(context, "Context must not be null");
        zza.verifyGooglePlayServicesIsAvailable((Context)object, 11925000);
        Object object2 = zzb;
        synchronized (object2) {
            Object object3;
            block10: {
                Object object4;
                block9: {
                    Object[] objectArray;
                    long l = SystemClock.elapsedRealtime();
                    try {
                        object4 = DynamiteModule.load((Context)object, DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING, "com.google.android.gms.providerinstaller.dynamite");
                        object4 = object4.getModuleContext();
                    }
                    catch (DynamiteModule.LoadingException loadingException) {
                        object3 = "ProviderInstaller";
                        objectArray = "Failed to load providerinstaller module: ";
                        object4 = String.valueOf(loadingException.getMessage());
                        int n = object4.length();
                        object4 = n != 0 ? objectArray.concat((String)object4) : new String((String)objectArray);
                        Log.w((String)object3, (String)object4);
                        object4 = null;
                    }
                    if (object4 != null) break block9;
                    long l2 = SystemClock.elapsedRealtime();
                    object3 = GooglePlayServicesUtilLight.getRemoteContext((Context)object);
                    if (object3 == null) break block10;
                    try {
                        object4 = zzd;
                        if (object4 == null) {
                            object4 = new Class[]{Context.class, Long.TYPE, Long.TYPE};
                            zzd = ProviderInstaller.zzb((Context)object3, "com.google.android.gms.common.security.ProviderInstallerImpl", "reportRequestStats", object4);
                        }
                        object4 = zzd;
                        objectArray = new Object[]{object, l, l2};
                        object4.invoke(null, objectArray);
                    }
                    catch (Exception exception) {
                        objectArray = "ProviderInstaller";
                        String string2 = "Failed to report request stats: ";
                        String string3 = String.valueOf(exception.getMessage());
                        int n = string3.length();
                        string3 = n != 0 ? string2.concat(string3) : new String(string2);
                        Log.w((String)objectArray, string3);
                    }
                }
                ProviderInstaller.zzc((Context)object4, (Context)object, "com.google.android.gms.providerinstaller.ProviderInstallerImpl");
                return;
            }
            if (object3 != null) {
                ProviderInstaller.zzc((Context)object3, (Context)object, "com.google.android.gms.common.security.ProviderInstallerImpl");
                return;
            }
            Log.e("ProviderInstaller", "Failed to get remote context");
            object = new GooglePlayServicesNotAvailableException(8);
            throw object;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void installIfNeededAsync(@NonNull Context context, @NonNull ProviderInstallListener listener) {
        Context context2;
        void var1_1;
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(var1_1, "Listener must not be null");
        Preconditions.checkMainThread("Must be called on the UI thread");
        zza zza2 = new zza(context2, (ProviderInstallListener)var1_1);
        zza2.execute(new Void[0]);
    }

    static /* bridge */ /* synthetic */ GoogleApiAvailabilityLight zza() {
        return zza;
    }

    private static Method zzb(Context context, String string2, String string3, Class[] classArray) throws ClassNotFoundException, NoSuchMethodException {
        return context.getClassLoader().loadClass(string2).getMethod(string3, classArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GuardedBy(value="ProviderInstaller.lock")
    private static void zzc(Context context, Context object, String objectArray) throws GooglePlayServicesNotAvailableException {
        try {
            object = zzc;
            if (object == null) {
                object = new Class[]{Context.class};
                zzc = ProviderInstaller.zzb(context, (String)objectArray, "insertProvider", (Class[])object);
            }
            object = zzc;
            objectArray = new Object[]{context};
            ((Method)object).invoke(null, objectArray);
            return;
        }
        catch (Exception exception) {
            Object object2;
            object = exception.getCause();
            if (Log.isLoggable("ProviderInstaller", 6)) {
                object2 = object == null ? exception.getMessage() : ((Throwable)object).getMessage();
                object2 = String.valueOf(object2);
                object = "Failed to install provider: ";
                object2 = ((String)object2).length() != 0 ? ((String)object).concat((String)object2) : new String((String)object);
                Log.e("ProviderInstaller", (String)object2);
            }
            object2 = new GooglePlayServicesNotAvailableException(8);
            throw object2;
        }
    }

    public static interface ProviderInstallListener {
        public void onProviderInstallFailed(int var1, @Nullable Intent var2);

        public void onProviderInstalled();
    }
}

