/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.view;

import com.google.firebase.database.core.EventRegistration;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.core.view.Change;
import com.google.firebase.database.core.view.DataEvent;
import com.google.firebase.database.core.view.Event;
import com.google.firebase.database.core.view.QuerySpec;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.Index;
import com.google.firebase.database.snapshot.IndexedNode;
import com.google.firebase.database.snapshot.NamedNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EventGenerator {
    private final QuerySpec query;
    private final Index index;

    public EventGenerator(QuerySpec query) {
        this.query = query;
        this.index = query.getIndex();
    }

    private void generateEventsForType(List<DataEvent> events, Event.EventType type, List<Change> changes, List<EventRegistration> eventRegistrations, IndexedNode eventCache) {
        ArrayList<Change> filteredChanges = new ArrayList<Change>();
        for (Change change : changes) {
            if (!change.getEventType().equals((Object)type)) continue;
            filteredChanges.add(change);
        }
        Collections.sort(filteredChanges, this.changeComparator());
        for (Change change : filteredChanges) {
            for (EventRegistration registration : eventRegistrations) {
                if (!registration.respondsTo(type)) continue;
                events.add(this.generateEvent(change, registration, eventCache));
            }
        }
    }

    private DataEvent generateEvent(Change change, EventRegistration registration, IndexedNode eventCache) {
        Change newChange;
        if (change.getEventType().equals((Object)Event.EventType.VALUE) || change.getEventType().equals((Object)Event.EventType.CHILD_REMOVED)) {
            newChange = change;
        } else {
            ChildKey prevChildKey = eventCache.getPredecessorChildName(change.getChildKey(), change.getIndexedNode().getNode(), this.index);
            newChange = change.changeWithPrevName(prevChildKey);
        }
        return registration.createEvent(newChange, this.query);
    }

    public List<DataEvent> generateEventsForChanges(List<Change> changes, IndexedNode eventCache, List<EventRegistration> eventRegistrations) {
        ArrayList<DataEvent> events = new ArrayList<DataEvent>();
        ArrayList<Change> moves = new ArrayList<Change>();
        for (Change change : changes) {
            if (!change.getEventType().equals((Object)Event.EventType.CHILD_CHANGED) || !this.index.indexedValueChanged(change.getOldIndexedNode().getNode(), change.getIndexedNode().getNode())) continue;
            moves.add(Change.childMovedChange(change.getChildKey(), change.getIndexedNode()));
        }
        this.generateEventsForType(events, Event.EventType.CHILD_REMOVED, changes, eventRegistrations, eventCache);
        this.generateEventsForType(events, Event.EventType.CHILD_ADDED, changes, eventRegistrations, eventCache);
        this.generateEventsForType(events, Event.EventType.CHILD_MOVED, moves, eventRegistrations, eventCache);
        this.generateEventsForType(events, Event.EventType.CHILD_CHANGED, changes, eventRegistrations, eventCache);
        this.generateEventsForType(events, Event.EventType.VALUE, changes, eventRegistrations, eventCache);
        return events;
    }

    private Comparator<Change> changeComparator() {
        return new Comparator<Change>(){

            @Override
            public int compare(Change a, Change b) {
                Utilities.hardAssert(a.getChildKey() != null && b.getChildKey() != null);
                NamedNode namedNodeA = new NamedNode(a.getChildKey(), a.getIndexedNode().getNode());
                NamedNode namedNodeB = new NamedNode(b.getChildKey(), b.getIndexedNode().getNode());
                return EventGenerator.this.index.compare(namedNodeA, namedNodeB);
            }
        };
    }
}

