/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.heartbeatinfo;

import android.content.Context;
import android.util.Base64OutputStream;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.core.os.UserManagerCompat;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.components.Component;
import com.google.firebase.components.Dependency;
import com.google.firebase.heartbeatinfo.HeartBeatConsumer;
import com.google.firebase.heartbeatinfo.HeartBeatController;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.heartbeatinfo.HeartBeatInfoStorage;
import com.google.firebase.heartbeatinfo.HeartBeatResult;
import com.google.firebase.inject.Provider;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultHeartBeatController
implements HeartBeatController,
HeartBeatInfo {
    private final Provider<HeartBeatInfoStorage> storageProvider;
    private final Context applicationContext;
    private final Provider<UserAgentPublisher> userAgentProvider;
    private final Set<HeartBeatConsumer> consumers;
    private final Executor backgroundExecutor;
    private static final ThreadFactory THREAD_FACTORY = r -> new Thread(r, "heartbeat-information-executor");

    public Task<Void> registerHeartBeat() {
        boolean inDirectBoot;
        if (this.consumers.size() <= 0) {
            return Tasks.forResult(null);
        }
        boolean bl = inDirectBoot = !UserManagerCompat.isUserUnlocked(this.applicationContext);
        if (inDirectBoot) {
            return Tasks.forResult(null);
        }
        return Tasks.call(this.backgroundExecutor, () -> {
            DefaultHeartBeatController defaultHeartBeatController = this;
            synchronized (defaultHeartBeatController) {
                this.storageProvider.get().storeHeartBeat(System.currentTimeMillis(), this.userAgentProvider.get().getUserAgent());
            }
            return null;
        });
    }

    @Override
    public Task<String> getHeartBeatsHeader() {
        boolean inDirectBoot;
        boolean bl = inDirectBoot = !UserManagerCompat.isUserUnlocked(this.applicationContext);
        if (inDirectBoot) {
            return Tasks.forResult("");
        }
        return Tasks.call(this.backgroundExecutor, () -> {
            DefaultHeartBeatController defaultHeartBeatController = this;
            synchronized (defaultHeartBeatController) {
                HeartBeatInfoStorage storage = this.storageProvider.get();
                List<HeartBeatResult> allHeartBeats = storage.getAllHeartBeats();
                storage.deleteAllHeartBeats();
                JSONArray array = new JSONArray();
                for (int i = 0; i < allHeartBeats.size(); ++i) {
                    HeartBeatResult result = allHeartBeats.get(i);
                    JSONObject obj = new JSONObject();
                    obj.put("agent", result.getUserAgent());
                    obj.put("dates", new JSONArray(result.getUsedDates()));
                    array.put(obj);
                }
                JSONObject output = new JSONObject();
                output.put("heartbeats", array);
                output.put("version", "2");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (Base64OutputStream b64os = new Base64OutputStream(out, 11);
                     GZIPOutputStream gzip = new GZIPOutputStream(b64os);){
                    gzip.write(output.toString().getBytes("UTF-8"));
                }
                return out.toString("UTF-8");
            }
        });
    }

    private DefaultHeartBeatController(Context context, String persistenceKey, Set<HeartBeatConsumer> consumers, Provider<UserAgentPublisher> userAgentProvider) {
        this(() -> new HeartBeatInfoStorage(context, persistenceKey), consumers, new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY), userAgentProvider, context);
    }

    @VisibleForTesting
    DefaultHeartBeatController(Provider<HeartBeatInfoStorage> testStorage, Set<HeartBeatConsumer> consumers, Executor executor, Provider<UserAgentPublisher> userAgentProvider, Context context) {
        this.storageProvider = testStorage;
        this.consumers = consumers;
        this.backgroundExecutor = executor;
        this.userAgentProvider = userAgentProvider;
        this.applicationContext = context;
    }

    @NonNull
    public static Component<DefaultHeartBeatController> component() {
        return Component.builder(DefaultHeartBeatController.class, HeartBeatController.class, HeartBeatInfo.class).add(Dependency.required(Context.class)).add(Dependency.required(FirebaseApp.class)).add(Dependency.setOf(HeartBeatConsumer.class)).add(Dependency.requiredProvider(UserAgentPublisher.class)).factory(c -> new DefaultHeartBeatController(c.get(Context.class), c.get(FirebaseApp.class).getPersistenceKey(), c.setOf(HeartBeatConsumer.class), c.getProvider(UserAgentPublisher.class))).build();
    }

    @Override
    @NonNull
    public synchronized HeartBeatInfo.HeartBeat getHeartBeatCode(@NonNull String heartBeatTag) {
        long presentTime = System.currentTimeMillis();
        HeartBeatInfoStorage storage = this.storageProvider.get();
        boolean shouldSendGlobalHB = storage.shouldSendGlobalHeartBeat(presentTime);
        if (shouldSendGlobalHB) {
            storage.postHeartBeatCleanUp();
            return HeartBeatInfo.HeartBeat.GLOBAL;
        }
        return HeartBeatInfo.HeartBeat.NONE;
    }
}

