/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import androidx.annotation.Nullable;
import androidx.core.os.OperationCanceledException;

public final class CancellationSignal {
    private boolean mIsCanceled;
    private OnCancelListener mOnCancelListener;
    private Object mCancellationSignalObj;
    private boolean mCancelInProgress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            return this.mIsCanceled;
        }
    }

    public void throwIfCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object obj;
        OnCancelListener listener;
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            if (this.mIsCanceled) {
                return;
            }
            this.mIsCanceled = true;
            this.mCancelInProgress = true;
            listener = this.mOnCancelListener;
            obj = this.mCancellationSignalObj;
        }
        try {
            if (listener != null) {
                listener.onCancel();
            }
            if (obj != null && Build.VERSION.SDK_INT >= 16) {
                ((android.os.CancellationSignal)obj).cancel();
            }
        }
        finally {
            cancellationSignal = this;
            synchronized (cancellationSignal) {
                this.mCancelInProgress = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnCancelListener(@Nullable OnCancelListener listener) {
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            this.waitForCancelFinishedLocked();
            if (this.mOnCancelListener == listener) {
                return;
            }
            this.mOnCancelListener = listener;
            if (!this.mIsCanceled || listener == null) {
                return;
            }
        }
        listener.onCancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getCancellationSignalObject() {
        if (Build.VERSION.SDK_INT < 16) {
            return null;
        }
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            if (this.mCancellationSignalObj == null) {
                this.mCancellationSignalObj = new android.os.CancellationSignal();
                if (this.mIsCanceled) {
                    ((android.os.CancellationSignal)this.mCancellationSignalObj).cancel();
                }
            }
            return this.mCancellationSignalObj;
        }
    }

    private void waitForCancelFinishedLocked() {
        while (this.mCancelInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static interface OnCancelListener {
        public void onCancel();
    }
}

