/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zada;
import com.google.android.gms.common.api.internal.zadb;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zas;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@KeepName
@KeepForSdk
public abstract class BasePendingResult<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zaa;
    private final Object zae;
    @NonNull
    protected final CallbackHandler<R> zab;
    @NonNull
    protected final WeakReference<GoogleApiClient> zac;
    private final CountDownLatch zaf;
    private final ArrayList<PendingResult.StatusListener> zag;
    @Nullable
    private ResultCallback<? super R> zah;
    private final AtomicReference<zadb> zai;
    @Nullable
    private R zaj;
    private Status zak;
    @KeepName
    private zas mResultGuardian;
    private volatile boolean zal;
    private boolean zam;
    private boolean zan;
    @Nullable
    private ICancelToken zao;
    private volatile zada<R> zap;
    private boolean zaq;
    public static final /* synthetic */ int zad;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public final R await() {
        Preconditions.checkNotMainThread("await must not be called on the UI thread");
        Preconditions.checkState(this.zal ^ true, "Result has already been consumed");
        boolean bl = this.zap == null;
        Preconditions.checkState(bl, "Cannot await if then() has been called.");
        try {
            this.zaf.await();
        }
        catch (InterruptedException interruptedException) {
            this.forceFailureUnlessReady(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState(this.isReady(), "Result is not ready.");
        return this.zaa();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public final R await(long l, @NonNull TimeUnit timeUnit) {
        if (l > 0L) {
            Preconditions.checkNotMainThread("await must not be called on the UI thread when time is greater than zero.");
        }
        Preconditions.checkState(this.zal ^ true, "Result has already been consumed.");
        boolean bl = this.zap == null;
        Preconditions.checkState(bl, "Cannot await if then() has been called.");
        try {
            boolean bl2 = this.zaf.await(l, timeUnit);
            if (!bl2) {
                this.forceFailureUnlessReady(Status.RESULT_TIMEOUT);
            }
        }
        catch (InterruptedException interruptedException) {
            this.forceFailureUnlessReady(Status.RESULT_INTERRUPTED);
        }
        Preconditions.checkState(this.isReady(), "Result is not ready.");
        return this.zaa();
    }

    @NonNull
    @KeepForSdk
    protected abstract R createFailedResult(@NonNull Status var1);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> object) {
        Preconditions.checkState(this.zal ^ true, "Result has already been consumed.");
        Object object2 = this.zae;
        synchronized (object2) {
            zada<R> zada2 = this.zap;
            boolean bl = zada2 == null;
            Preconditions.checkState(bl, "Cannot call then() twice.");
            ResultCallback<? super R> resultCallback = this.zah;
            boolean bl2 = resultCallback == null;
            Preconditions.checkState(bl2, "Cannot call then() if callbacks are set.");
            bl2 = this.zam;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            {
                Preconditions.checkState(bl2 ^= true, "Cannot call then() if result was canceled.");
                this.zaq = true;
                zada zada3 = new zada(this.zac);
                this.zap = zada3;
                object = this.zap.then(object);
                boolean bl3 = this.isReady();
                if (bl3) {
                    this.zab.zaa(this.zap, this.zaa());
                } else {
                    zada<? super R> zada4 = this.zap;
                    this.zah = zada4;
                }
                return object;
            }
        }
    }

    static {
        zaq zaq2;
        zaa = zaq2 = new zaq();
    }

    @Deprecated
    BasePendingResult() {
        WeakReference<Object> weakReference = new WeakReference<Object>();
        this.zae = weakReference;
        weakReference = new WeakReference<Object>(1);
        this.zaf = weakReference;
        weakReference = new WeakReference<Object>();
        this.zag = weakReference;
        this.zai = weakReference;
        this.zaq = false;
        weakReference = new WeakReference<Object>(Looper.getMainLooper());
        this.zab = weakReference;
        weakReference = new WeakReference<Object>(null);
        this.zac = weakReference;
    }

    @Deprecated
    @KeepForSdk
    protected BasePendingResult(@NonNull Looper looper) {
        WeakReference<Object> weakReference;
        CallbackHandler callbackHandler = new CallbackHandler();
        this.zae = callbackHandler;
        callbackHandler = new CallbackHandler(1);
        this.zaf = callbackHandler;
        callbackHandler = new CallbackHandler();
        this.zag = callbackHandler;
        this.zai = callbackHandler;
        this.zaq = false;
        callbackHandler = new CallbackHandler((Looper)((Object)weakReference));
        this.zab = callbackHandler;
        weakReference = new WeakReference<Object>(null);
        this.zac = weakReference;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    protected BasePendingResult(@Nullable GoogleApiClient apiClient) {
        void var1_1;
        Object object = new Object();
        this.zae = object;
        object = new Object(1);
        this.zaf = object;
        object = new Object();
        this.zag = object;
        this.zai = object;
        this.zaq = false;
        object = var1_1 != null ? var1_1.getLooper() : Looper.getMainLooper();
        CallbackHandler callbackHandler = new CallbackHandler((Looper)object);
        this.zab = callbackHandler;
        object = new Object(var1_1);
        this.zac = object;
    }

    @VisibleForTesting
    @KeepForSdk
    protected BasePendingResult(@NonNull CallbackHandler<R> callbackHandler) {
        WeakReference<Object> weakReference;
        Serializable serializable = new Serializable();
        this.zae = serializable;
        serializable = new Serializable(1);
        this.zaf = serializable;
        serializable = new Serializable();
        this.zag = serializable;
        this.zai = serializable;
        this.zaq = false;
        this.zab = (CallbackHandler)Preconditions.checkNotNull(weakReference, "CallbackHandler must not be null");
        weakReference = new WeakReference<Object>(null);
        this.zac = weakReference;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void addStatusListener(@NonNull PendingResult.StatusListener statusListener) {
        boolean bl = statusListener != null;
        Preconditions.checkArgument(bl, "Callback cannot be null.");
        Object object = this.zae;
        synchronized (object) {
            boolean bl2 = this.isReady();
            if (bl2) {
                statusListener.onComplete(this.zak);
            } else {
                this.zag.add(statusListener);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public void cancel() {
        Object object = this.zae;
        synchronized (object) {
            boolean bl = this.zam;
            if (bl || (bl = this.zal)) {
                return;
            }
            ICancelToken iCancelToken = this.zao;
            if (iCancelToken != null) {
                try {
                    iCancelToken.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            BasePendingResult.zal(this.zaj);
            this.zam = true;
            this.zab(this.createFailedResult(Status.RESULT_CANCELED));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @KeepForSdk
    public final void forceFailureUnlessReady(@NonNull Status status) {
        Object object = this.zae;
        synchronized (object) {
            void var1_2;
            boolean bl = this.isReady();
            if (bl) return;
            this.setResult(this.createFailedResult((Status)var1_2));
            this.zan = true;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    protected final void setCancelToken(@NonNull ICancelToken cancelToken) {
        Object object = this.zae;
        synchronized (object) {
            void var1_2;
            this.zao = var1_2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public final void setResult(@NonNull R result) {
        Object object = this.zae;
        synchronized (object) {
            void var1_2;
            boolean bl = this.zan;
            if (!bl && !(bl = this.zam)) {
                this.isReady();
                bl = this.isReady();
                Preconditions.checkState(bl ^= true, "Results have already been set");
                bl = this.zal;
                Preconditions.checkState(bl ^= true, "Result has already been consumed");
                this.zab(var1_2);
                return;
            }
            BasePendingResult.zal((Result)var1_2);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(@Nullable ResultCallback<? super R> callback) {
        var3_3 = this.zae;
        synchronized (var3_3) {
            if (var1_2 != null) ** GOTO lbl7
            this.zah = null;
            return;
lbl7:
            // 1 sources

            var2_4 = this.zal;
            {
                catch (Throwable var0_1) {}
                {
                    throw var0_1;
                }
            }
            {
                Preconditions.checkState(var2_4 ^= true, "Result has already been consumed.");
                var2_5 = this.zap;
                var2_6 = var2_5 == null;
                Preconditions.checkState(var2_6, "Cannot set callbacks if then() has been called.");
                var2_6 = this.isCanceled();
                if (var2_6) {
                    return;
                }
                var2_6 = this.isReady();
                if (var2_6) {
                    this.zab.zaa((ResultCallback<R>)var1_2, this.zaa());
                } else {
                    this.zah = var1_2;
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public final void setResultCallback(@NonNull ResultCallback<? super R> callback, long time, @NonNull TimeUnit units) {
        var6_5 = this.zae;
        synchronized (var6_5) {
            if (var1_2 != null) ** GOTO lbl7
            this.zah = null;
            return;
lbl7:
            // 1 sources

            var5_6 = this.zal;
            {
                catch (Throwable var0_1) {}
                {
                    throw var0_1;
                }
            }
            {
                Preconditions.checkState(var5_6 ^= true, "Result has already been consumed.");
                var5_7 = this.zap;
                var5_8 = var5_7 == null;
                Preconditions.checkState(var5_8, "Cannot set callbacks if then() has been called.");
                var5_8 = this.isCanceled();
                if (var5_8) {
                    return;
                }
                var5_8 = this.isReady();
                if (var5_8) {
                    this.zab.zaa((ResultCallback<R>)var1_2, this.zaa());
                } else {
                    this.zah = var1_2;
                    var1_2 = this.zab;
                    var7_9 = var4_4.toMillis((long)var2_3);
                    var1_2.sendMessageDelayed(var1_2.obtainMessage(2, this), var7_9);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean isCanceled() {
        Object object = this.zae;
        synchronized (object) {
            return this.zam;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    public final boolean isReady() {
        return this.zaf.getCount() == 0L;
    }

    static /* bridge */ /* synthetic */ Result zaj(BasePendingResult basePendingResult) {
        return basePendingResult.zaj;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final R zaa() {
        R r;
        Object object = this.zae;
        synchronized (object) {
            boolean bl = this.zal;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            {
                Preconditions.checkState(bl ^= true, "Result has already been consumed.");
                Preconditions.checkState(this.isReady(), "Result is not ready.");
                r = this.zaj;
                this.zaj = null;
                this.zah = null;
                this.zal = true;
            }
        }
        object = this.zai.getAndSet(null);
        if (object == null) return (R)((Result)Preconditions.checkNotNull(r));
        ((zadb)object).zaa.zab.remove(this);
        return (R)((Result)Preconditions.checkNotNull(r));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zak() {
        boolean bl = !this.zaq ? zaa.get().booleanValue() : true;
        this.zaq = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zal(@Nullable Result object) {
        if (!(object instanceof Releasable)) return;
        try {
            ((Releasable)object).release();
            return;
        }
        catch (RuntimeException runtimeException) {
            object = String.valueOf(object);
            String.valueOf(object).length();
            Log.w("BasePendingResult", "Unable to release ".concat(String.valueOf(object)), runtimeException);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void zab(R object) {
        this.zaj = object;
        this.zak = object.getStatus();
        this.zao = null;
        this.zaf.countDown();
        if (this.zam) {
            this.zah = null;
        } else {
            ResultCallback<? super R> resultCallback = this.zah;
            if (resultCallback == null) {
                if (this.zaj instanceof Releasable) {
                    zas zas2;
                    this.mResultGuardian = zas2 = new zas(this, null);
                }
            } else {
                this.zab.removeMessages(2);
                this.zab.zaa(resultCallback, (R)this.zaa());
            }
        }
        ArrayList<PendingResult.StatusListener> arrayList = this.zag;
        int n = arrayList.size();
        boolean bl = false;
        while (true) {
            void var1_4;
            if (var1_4 >= n) {
                this.zag.clear();
                return;
            }
            ((PendingResult.StatusListener)arrayList.get((int)var1_4)).onComplete(this.zak);
            ++var1_4;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean zam() {
        Object object = this.zae;
        synchronized (object) {
            GoogleApiClient googleApiClient = (GoogleApiClient)this.zac.get();
            if (googleApiClient != null) {
                boolean bl = this.zaq;
                if (bl) return this.isCanceled();
            }
            this.cancel();
            return this.isCanceled();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zan(@Nullable zadb zadb2) {
        this.zai.set(zadb2);
    }

    @VisibleForTesting
    public static class CallbackHandler<R extends Result>
    extends com.google.android.gms.internal.base.zaq {
        public CallbackHandler() {
            super(Looper.getMainLooper());
        }

        public CallbackHandler(@NonNull Looper looper) {
            super(looper);
        }

        public final void handleMessage(@NonNull Message object) {
            switch (((Message)object).what) {
                case 2: {
                    ((BasePendingResult)((Message)object).obj).forceFailureUnlessReady(Status.RESULT_TIMEOUT);
                    return;
                }
                case 1: {
                    Object object2 = (Pair)((Message)object).obj;
                    object = (ResultCallback)((Pair)object2).first;
                    object2 = (Result)((Pair)object2).second;
                    try {
                        object.onResult(object2);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        BasePendingResult.zal((Result)object2);
                        throw runtimeException;
                    }
                }
            }
            int n = ((Message)object).what;
            object = new StringBuilder(45);
            ((StringBuilder)object).append("Don't know how to handle message: ");
            ((StringBuilder)object).append(n);
            Exception exception = new Exception();
            Log.wtf("BasePendingResult", ((StringBuilder)object).toString(), exception);
        }

        public final void zaa(@NonNull ResultCallback<? super R> resultCallback, @NonNull R r) {
            resultCallback = Preconditions.checkNotNull(resultCallback);
            Pair<ResultCallback<? super R>, R> pair = new Pair<ResultCallback<? super R>, R>(resultCallback, r);
            this.sendMessage(this.obtainMessage(1, pair));
        }
    }
}

