/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.security.ProviderInstaller;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.emulators.EmulatedServiceSettings;
import com.google.firebase.functions.ContextProvider;
import com.google.firebase.functions.FirebaseFunctionsException;
import com.google.firebase.functions.FunctionsMultiResourceComponent;
import com.google.firebase.functions.HttpsCallOptions;
import com.google.firebase.functions.HttpsCallableContext;
import com.google.firebase.functions.HttpsCallableReference;
import com.google.firebase.functions.HttpsCallableResult;
import com.google.firebase.functions.Serializer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseFunctions {
    private static final TaskCompletionSource<Void> providerInstalled = new TaskCompletionSource();
    private static boolean providerInstallStarted = false;
    private final FirebaseApp app;
    private final OkHttpClient client;
    private final Serializer serializer;
    private final ContextProvider contextProvider;
    private final String projectId;
    private final String region;
    @Nullable
    private final String customDomain;
    private String urlFormat = "https://%1$s-%2$s.cloudfunctions.net/%3$s";
    @Nullable
    private EmulatedServiceSettings emulatorSettings;

    FirebaseFunctions(FirebaseApp app, Context context, String projectId, String regionOrCustomDomain, ContextProvider contextProvider) {
        boolean isRegion;
        this.app = app;
        this.client = new OkHttpClient();
        this.serializer = new Serializer();
        this.contextProvider = Preconditions.checkNotNull(contextProvider);
        this.projectId = Preconditions.checkNotNull(projectId);
        try {
            new URL(regionOrCustomDomain);
            isRegion = false;
        }
        catch (MalformedURLException malformedURLException) {
            isRegion = true;
        }
        if (isRegion) {
            this.region = regionOrCustomDomain;
            this.customDomain = null;
        } else {
            this.region = "us-central1";
            this.customDomain = regionOrCustomDomain;
        }
        FirebaseFunctions.maybeInstallProviders(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void maybeInstallProviders(Context context) {
        TaskCompletionSource<Void> taskCompletionSource = providerInstalled;
        synchronized (taskCompletionSource) {
            if (providerInstallStarted) {
                return;
            }
            providerInstallStarted = true;
        }
        Runnable runnable = () -> ProviderInstaller.installIfNeededAsync(context, new ProviderInstaller.ProviderInstallListener(){

            @Override
            public void onProviderInstalled() {
                providerInstalled.setResult(null);
            }

            @Override
            public void onProviderInstallFailed(int i, Intent intent) {
                Log.d("FirebaseFunctions", "Failed to update ssl context");
                providerInstalled.setResult(null);
            }
        });
        Handler handler = new Handler(context.getMainLooper());
        handler.post(runnable);
    }

    @NonNull
    public static FirebaseFunctions getInstance(@NonNull FirebaseApp app, @NonNull String regionOrCustomDomain) {
        Preconditions.checkNotNull(app, "You must call FirebaseApp.initializeApp first.");
        Preconditions.checkNotNull(regionOrCustomDomain);
        FunctionsMultiResourceComponent component = app.get(FunctionsMultiResourceComponent.class);
        Preconditions.checkNotNull(component, "Functions component does not exist.");
        return component.get(regionOrCustomDomain);
    }

    @NonNull
    public static FirebaseFunctions getInstance(@NonNull FirebaseApp app) {
        return FirebaseFunctions.getInstance(app, "us-central1");
    }

    @NonNull
    public static FirebaseFunctions getInstance(@NonNull String regionOrCustomDomain) {
        return FirebaseFunctions.getInstance(FirebaseApp.getInstance(), regionOrCustomDomain);
    }

    @NonNull
    public static FirebaseFunctions getInstance() {
        return FirebaseFunctions.getInstance(FirebaseApp.getInstance(), "us-central1");
    }

    @NonNull
    public HttpsCallableReference getHttpsCallable(@NonNull String name) {
        return new HttpsCallableReference(this, name);
    }

    @NonNull
    public HttpsCallableReference getHttpsCallableFromUrl(@NonNull URL url) {
        return new HttpsCallableReference(this, url);
    }

    @VisibleForTesting
    URL getURL(String function) {
        EmulatedServiceSettings emulatorSettings = this.emulatorSettings;
        if (emulatorSettings != null) {
            this.urlFormat = "http://" + emulatorSettings.getHost() + ":" + emulatorSettings.getPort() + "/%2$s/%1$s/%3$s";
        }
        String str = String.format(this.urlFormat, this.region, this.projectId, function);
        if (this.customDomain != null && emulatorSettings == null) {
            str = this.customDomain + "/" + function;
        }
        try {
            return new URL(str);
        }
        catch (MalformedURLException mfe) {
            throw new IllegalStateException(mfe);
        }
    }

    public void useFunctionsEmulator(@NonNull String origin) {
        Preconditions.checkNotNull(origin, "origin cannot be null");
        this.urlFormat = origin + "/%2$s/%1$s/%3$s";
    }

    public void useEmulator(@NonNull String host, int port) {
        this.emulatorSettings = new EmulatedServiceSettings(host, port);
    }

    Task<HttpsCallableResult> call(String name, @Nullable Object data, HttpsCallOptions options) {
        return providerInstalled.getTask().continueWithTask(task -> this.contextProvider.getContext()).continueWithTask(task -> {
            if (!task.isSuccessful()) {
                return Tasks.forException(task.getException());
            }
            HttpsCallableContext context = (HttpsCallableContext)task.getResult();
            URL url = this.getURL(name);
            return this.call(url, data, context, options);
        });
    }

    Task<HttpsCallableResult> call(URL url, @Nullable Object data, HttpsCallOptions options) {
        return providerInstalled.getTask().continueWithTask(task -> this.contextProvider.getContext()).continueWithTask(task -> {
            if (!task.isSuccessful()) {
                return Tasks.forException(task.getException());
            }
            HttpsCallableContext context = (HttpsCallableContext)task.getResult();
            return this.call(url, data, context, options);
        });
    }

    private Task<HttpsCallableResult> call(@NonNull URL url, @Nullable Object data, HttpsCallableContext context, HttpsCallOptions options) {
        Preconditions.checkNotNull(url, "url cannot be null");
        HashMap<String, Object> body = new HashMap<String, Object>();
        Object encoded = this.serializer.encode(data);
        body.put("data", encoded);
        JSONObject bodyJSON = new JSONObject(body);
        MediaType contentType = MediaType.parse((String)"application/json");
        RequestBody requestBody = RequestBody.create((MediaType)contentType, (String)bodyJSON.toString());
        Request.Builder request = new Request.Builder().url(url).post(requestBody);
        if (context.getAuthToken() != null) {
            request = request.header("Authorization", "Bearer " + context.getAuthToken());
        }
        if (context.getInstanceIdToken() != null) {
            request = request.header("Firebase-Instance-ID-Token", context.getInstanceIdToken());
        }
        if (context.getAppCheckToken() != null) {
            request = request.header("X-Firebase-AppCheck", context.getAppCheckToken());
        }
        OkHttpClient callClient = options.apply(this.client);
        Call call = callClient.newCall(request.build());
        final TaskCompletionSource tcs = new TaskCompletionSource();
        call.enqueue(new Callback(){

            public void onFailure(Call ignored, IOException e) {
                if (e instanceof InterruptedIOException) {
                    FirebaseFunctionsException exception = new FirebaseFunctionsException(FirebaseFunctionsException.Code.DEADLINE_EXCEEDED.name(), FirebaseFunctionsException.Code.DEADLINE_EXCEEDED, null, e);
                    tcs.setException(exception);
                } else {
                    FirebaseFunctionsException exception = new FirebaseFunctionsException(FirebaseFunctionsException.Code.INTERNAL.name(), FirebaseFunctionsException.Code.INTERNAL, null, e);
                    tcs.setException(exception);
                }
            }

            public void onResponse(Call ignored, Response response) throws IOException {
                JSONObject bodyJSON;
                String body;
                FirebaseFunctionsException.Code code = FirebaseFunctionsException.Code.fromHttpStatus(response.code());
                FirebaseFunctionsException exception = FirebaseFunctionsException.fromResponse(code, body = response.body().string(), FirebaseFunctions.this.serializer);
                if (exception != null) {
                    tcs.setException(exception);
                    return;
                }
                try {
                    bodyJSON = new JSONObject(body);
                }
                catch (JSONException je) {
                    FirebaseFunctionsException e = new FirebaseFunctionsException("Response is not valid JSON object.", FirebaseFunctionsException.Code.INTERNAL, null, je);
                    tcs.setException(e);
                    return;
                }
                Object dataJSON = bodyJSON.opt("data");
                if (dataJSON == null) {
                    dataJSON = bodyJSON.opt("result");
                }
                if (dataJSON == null) {
                    FirebaseFunctionsException e = new FirebaseFunctionsException("Response is missing data field.", FirebaseFunctionsException.Code.INTERNAL, null);
                    tcs.setException(e);
                    return;
                }
                HttpsCallableResult result = new HttpsCallableResult(FirebaseFunctions.this.serializer.decode(dataJSON));
                tcs.setResult(result);
            }
        });
        return tcs.getTask();
    }
}

