/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.legacy.content.WakefulBroadcastReceiver;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzba;
import javax.annotation.concurrent.GuardedBy;

public final class FirebaseInstanceIdReceiver
extends WakefulBroadcastReceiver {
    @GuardedBy(value="FirebaseInstanceIdReceiver.class")
    private static zzba zza;

    public final void onReceive(@NonNull Context context, @NonNull Intent intent) {
        if (intent == null) {
            return;
        }
        Parcelable parcelable = intent.getParcelableExtra("wrapped_intent");
        Intent intent2 = parcelable instanceof Intent ? (Intent)((Object)parcelable) : null;
        if (intent2 != null) {
            this.zza(context, intent2);
            return;
        }
        this.zza(context, intent);
    }

    private final void zza(Context context, Intent intent) {
        int n;
        String string2;
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        if (Build.VERSION.SDK_INT <= 18) {
            intent.removeCategory(context.getPackageName());
        }
        if ("google.com/iid".equals(string2 = intent.getStringExtra("from"))) {
            Intent intent2 = intent;
            String string3 = intent2.getStringExtra("CMD");
            if (string3 != null) {
                if (Log.isLoggable("FirebaseInstanceId", 3)) {
                    String string4 = String.valueOf(intent2.getExtras());
                    Log.d("FirebaseInstanceId", new StringBuilder(21 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Received command: ").append(string3).append(" - ").append(string4).toString());
                }
                if ("RST".equals(string3) || "RST_FULL".equals(string3)) {
                    FirebaseInstanceId.getInstance().zze();
                } else if ("SYNC".equals(string3)) {
                    FirebaseInstanceId.getInstance().zzg();
                }
            }
            n = -1;
        } else {
            String string5 = intent.getStringExtra("gcm.rawData64");
            if (string5 != null) {
                intent.putExtra("rawData", Base64.decode(string5, 0));
                intent.removeExtra("gcm.rawData64");
            }
            n = FirebaseInstanceIdReceiver.zza(this, context, intent);
        }
        if (this.isOrderedBroadcast()) {
            this.setResultCode(n);
        }
    }

    @ShowFirstParty
    @SuppressLint(value={"InlinedApi"})
    public static int zza(BroadcastReceiver broadcastReceiver, Context context, Intent intent) {
        boolean bl;
        boolean bl2 = PlatformVersion.isAtLeastO() && context.getApplicationInfo().targetSdkVersion >= 26;
        boolean bl3 = bl = (intent.getFlags() & 0x10000000) != 0;
        if (bl2 && !bl) {
            return FirebaseInstanceIdReceiver.zzb(broadcastReceiver, context, intent);
        }
        int n = zzaq.zza().zza(context, intent);
        if (PlatformVersion.isAtLeastO() && n == 402) {
            FirebaseInstanceIdReceiver.zzb(broadcastReceiver, context, intent);
            return 403;
        }
        return n;
    }

    private static int zzb(BroadcastReceiver broadcastReceiver, Context context, Intent intent) {
        if (Log.isLoggable("FirebaseInstanceId", 3)) {
            Log.d("FirebaseInstanceId", "Binding to service");
        }
        if (broadcastReceiver.isOrderedBroadcast()) {
            broadcastReceiver.setResultCode(-1);
        }
        FirebaseInstanceIdReceiver.zza(context, "com.google.firebase.MESSAGING_EVENT").zza(intent, broadcastReceiver.goAsync());
        return -1;
    }

    private static synchronized zzba zza(Context context, String string2) {
        if (zza == null) {
            zza = new zzba(context, string2);
        }
        return zza;
    }
}

