/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import androidx.core.content.ContextCompat;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzas;
import com.google.firebase.iid.zzq;
import com.google.firebase.iid.zzs;
import com.google.firebase.iid.zzt;
import java.io.File;
import java.io.IOException;
import java.util.Map;

final class zzat {
    private final SharedPreferences zza;
    private final Context zzb;
    private final zzq zzc;
    @GuardedBy(value="this")
    private final Map<String, zzs> zzd;

    public zzat(Context context) {
        this(context, new zzq());
    }

    private zzat(Context context, zzq zzq2) {
        block4: {
            this.zzd = new ArrayMap();
            this.zzb = context;
            this.zza = context.getSharedPreferences("com.google.android.gms.appid", 0);
            this.zzc = zzq2;
            String string2 = "com.google.android.gms.appid-no-backup";
            zzat zzat2 = this;
            File file = ContextCompat.getNoBackupFilesDir(zzat2.zzb);
            File file2 = new File(file, string2);
            if (!file2.exists()) {
                try {
                    if (file2.createNewFile() && !zzat2.zzc()) {
                        Log.i("FirebaseInstanceId", "App restored, clearing state");
                        zzat2.zzb();
                        FirebaseInstanceId.getInstance().zze();
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable("FirebaseInstanceId", 3)) break block4;
                    String string3 = String.valueOf(iOException.getMessage());
                    Log.d("FirebaseInstanceId", string3.length() != 0 ? "Error creating file in no backup dir: ".concat(string3) : new String("Error creating file in no backup dir: "));
                }
            }
        }
    }

    public final synchronized String zza() {
        return this.zza.getString("topic_operation_queue", "");
    }

    public final synchronized void zza(String string2) {
        this.zza.edit().putString("topic_operation_queue", string2).apply();
    }

    private final synchronized boolean zzc() {
        return this.zza.getAll().isEmpty();
    }

    private static String zzc(String string2, String string3, String string4) {
        return new StringBuilder(4 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append("|T|").append(string3).append("|").append(string4).toString();
    }

    static String zza(String string2, String string3) {
        return new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("|S|").append(string3).toString();
    }

    public final synchronized void zzb() {
        this.zzd.clear();
        zzq.zza(this.zzb);
        this.zza.edit().clear().commit();
    }

    public final synchronized zzas zza(String string2, String string3, String string4) {
        return zzas.zza(this.zza.getString(zzat.zzc(string2, string3, string4), null));
    }

    public final synchronized void zza(String string2, String string3, String string4, String string5, String string6) {
        String string7 = zzas.zza(string5, string6, System.currentTimeMillis());
        if (string7 == null) {
            return;
        }
        SharedPreferences.Editor editor = this.zza.edit();
        editor.putString(zzat.zzc(string2, string3, string4), string7);
        editor.commit();
    }

    public final synchronized void zzb(String string2, String string3, String string4) {
        String string5 = zzat.zzc(string2, string3, string4);
        SharedPreferences.Editor editor = this.zza.edit();
        editor.remove(string5);
        editor.commit();
    }

    public final synchronized zzs zzb(String string2) {
        zzs zzs2 = this.zzd.get(string2);
        if (zzs2 != null) {
            return zzs2;
        }
        try {
            zzs2 = this.zzc.zza(this.zzb, string2);
        }
        catch (zzt zzt2) {
            Log.w("FirebaseInstanceId", "Stored data is corrupt, generating new identity");
            FirebaseInstanceId.getInstance().zze();
            zzs2 = this.zzc.zzb(this.zzb, string2);
        }
        this.zzd.put(string2, zzs2);
        return zzs2;
    }

    public final synchronized void zzc(String string2) {
        String string3 = String.valueOf(string2).concat("|T|");
        zzat zzat2 = this;
        SharedPreferences.Editor editor = zzat2.zza.edit();
        for (String string4 : zzat2.zza.getAll().keySet()) {
            if (!string4.startsWith(string3)) continue;
            editor.remove(string4);
        }
        editor.commit();
    }
}

