/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.LibraryVersion;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.zza;
import com.google.firebase.iid.zzai;
import com.google.firebase.iid.zzao;
import com.google.firebase.iid.zzm;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzp;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.concurrent.Executor;

final class zzl {
    private final FirebaseApp zza;
    private final zzai zzb;
    private final zzao zzc;
    private final Executor zzd;
    private final UserAgentPublisher zze;
    private final HeartBeatInfo zzf;

    zzl(FirebaseApp firebaseApp, zzai zzai2, Executor executor, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo) {
        this(firebaseApp, zzai2, executor, new zzao(firebaseApp.getApplicationContext(), zzai2), userAgentPublisher, heartBeatInfo);
    }

    @VisibleForTesting
    private zzl(FirebaseApp firebaseApp, zzai zzai2, Executor executor, zzao zzao2, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo) {
        this.zza = firebaseApp;
        this.zzb = zzai2;
        this.zzc = zzao2;
        this.zzd = executor;
        this.zze = userAgentPublisher;
        this.zzf = heartBeatInfo;
    }

    public final Task<String> zza(String string2, String string3, String string4) {
        Task<Bundle> task = this.zza(string2, string3, string4, new Bundle());
        return this.zzb(task);
    }

    public final Task<Void> zzb(String string2, String string3, String string4) {
        Bundle bundle = new Bundle();
        bundle.putString("delete", "1");
        Task<Bundle> task = this.zza(string2, string3, string4, bundle);
        return this.zza(this.zzb(task));
    }

    public final Task<Void> zza(String string2) {
        Bundle bundle = new Bundle();
        bundle.putString("iid-operation", "delete");
        bundle.putString("delete", "1");
        Task<Bundle> task = this.zza(string2, "*", "*", bundle);
        return this.zza(this.zzb(task));
    }

    public final Task<Void> zzc(String string2, String string3, String string4) {
        Bundle bundle = new Bundle();
        String string5 = String.valueOf("/topics/");
        String string6 = String.valueOf(string4);
        bundle.putString("gcm.topic", string6.length() != 0 ? string5.concat(string6) : new String(string5));
        String string7 = string3;
        String string8 = String.valueOf("/topics/");
        String string9 = String.valueOf(string4);
        String string10 = string9.length() != 0 ? string8.concat(string9) : new String(string8);
        Task<Bundle> task = this.zza(string2, string7, string10, bundle);
        return this.zza(this.zzb(task));
    }

    public final Task<Void> zzd(String string2, String string3, String string4) {
        Bundle bundle = new Bundle();
        String string5 = String.valueOf("/topics/");
        String string6 = String.valueOf(string4);
        bundle.putString("gcm.topic", string6.length() != 0 ? string5.concat(string6) : new String(string5));
        bundle.putString("delete", "1");
        String string7 = string3;
        String string8 = String.valueOf("/topics/");
        String string9 = String.valueOf(string4);
        String string10 = string9.length() != 0 ? string8.concat(string9) : new String(string8);
        Task<Bundle> task = this.zza(string2, string7, string10, bundle);
        return this.zza(this.zzb(task));
    }

    private final Task<Bundle> zza(String string2, String string3, String string4, Bundle bundle) {
        Bundle bundle2 = bundle;
        String string5 = string4;
        String string6 = string3;
        String string7 = string2;
        zzl zzl2 = this;
        bundle2.putString("scope", string5);
        bundle2.putString("sender", string6);
        bundle2.putString("subtype", string6);
        bundle2.putString("appid", string7);
        bundle2.putString("gmp_app_id", zzl2.zza.getOptions().getApplicationId());
        bundle2.putString("gmsv", Integer.toString(zzl2.zzb.zzd()));
        bundle2.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle2.putString("app_ver", zzl2.zzb.zzb());
        bundle2.putString("app_ver_name", zzl2.zzb.zzc());
        String string8 = LibraryVersion.getInstance().getVersion("firebase-iid");
        if ("UNKNOWN".equals(string8)) {
            int n = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
            string8 = new StringBuilder(19).append("unknown_").append(n).toString();
        }
        String string9 = String.valueOf(string8);
        bundle2.putString("cliv", string9.length() != 0 ? "fiid-".concat(string9) : new String("fiid-"));
        HeartBeatInfo.HeartBeat heartBeat = zzl2.zzf.getHeartBeatCode("fire-iid");
        if (heartBeat != HeartBeatInfo.HeartBeat.NONE) {
            bundle2.putString("Firebase-Client-Log-Type", Integer.toString(heartBeat.getCode()));
            bundle2.putString("Firebase-Client", zzl2.zze.getUserAgent());
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzd.execute(new zzn(this, bundle, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    private static String zza(Bundle bundle) throws IOException {
        if (bundle == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string2 = bundle.getString("registration_id");
        if (string2 != null) {
            return string2;
        }
        String string3 = bundle.getString("unregistered");
        if (string3 != null) {
            return string3;
        }
        String string4 = bundle.getString("error");
        if ("RST".equals(string4)) {
            throw new IOException("INSTANCE_ID_RESET");
        }
        if (string4 != null) {
            throw new IOException(string4);
        }
        String string5 = String.valueOf(bundle);
        Log.w("FirebaseInstanceId", new StringBuilder(21 + String.valueOf(string5).length()).append("Unexpected response: ").append(string5).toString(), new Throwable());
        throw new IOException("SERVICE_NOT_AVAILABLE");
    }

    private final <T> Task<Void> zza(Task<T> task) {
        return task.continueWith(com.google.firebase.iid.zza.zza(), new zzm(this));
    }

    private final Task<String> zzb(Task<Bundle> task) {
        return task.continueWith(this.zzd, new zzp(this));
    }

    final /* synthetic */ void zza(Bundle bundle, TaskCompletionSource taskCompletionSource) {
        try {
            Bundle bundle2 = this.zzc.zza(bundle);
            taskCompletionSource.setResult(bundle2);
            return;
        }
        catch (IOException iOException) {
            taskCompletionSource.setException(iOException);
            return;
        }
    }

    static /* synthetic */ String zza(zzl zzl2, Bundle bundle) throws IOException {
        return zzl.zza(bundle);
    }
}

