/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.internal.firebase_messaging.zzm;
import com.google.firebase.iid.zzai;
import com.google.firebase.iid.zzat;
import com.google.firebase.iid.zzb;
import com.google.firebase.iid.zzs;
import com.google.firebase.iid.zzt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;

final class zzq {
    zzq() {
    }

    @WorkerThread
    final zzs zza(Context context, String string2) throws zzt {
        zzs zzs2 = this.zzc(context, string2);
        if (zzs2 != null) {
            return zzs2;
        }
        return this.zzb(context, string2);
    }

    @WorkerThread
    final zzs zzb(Context context, String string2) {
        String string3 = zzai.zza(zzb.zza().getPublic());
        zzs zzs2 = new zzs(string3, System.currentTimeMillis());
        zzs zzs3 = this.zza(context, string2, zzs2, true);
        if (zzs3 != null && !zzs3.equals(zzs2)) {
            if (Log.isLoggable("FirebaseInstanceId", 3)) {
                Log.d("FirebaseInstanceId", "Loaded key after generating new one, using loaded one");
            }
            return zzs3;
        }
        if (Log.isLoggable("FirebaseInstanceId", 3)) {
            Log.d("FirebaseInstanceId", "Generated new key");
        }
        this.zza(context, string2, zzs2);
        return zzs2;
    }

    static void zza(Context context) {
        for (File file : zzq.zzb(context).listFiles()) {
            if (!file.getName().startsWith("com.google.InstanceId")) continue;
            file.delete();
        }
    }

    @Nullable
    private final zzs zzc(Context context, String string2) throws zzt {
        zzs zzs2;
        Object var3_3 = null;
        try {
            zzs2 = this.zzd(context, string2);
            if (zzs2 != null) {
                this.zza(context, string2, zzs2);
                return zzs2;
            }
        }
        catch (zzt zzt2) {
            // empty catch block
        }
        try {
            String string3 = string2;
            Context context2 = context;
            zzs2 = zzq.zza(context2.getSharedPreferences("com.google.android.gms.appid", 0), string3);
            if (zzs2 != null) {
                this.zza(context, string2, zzs2, false);
                return zzs2;
            }
        }
        catch (zzt zzt3) {
            // empty catch block
        }
        if (var3_3 != null) {
            throw var3_3;
        }
        return null;
    }

    private static PublicKey zza(String string2) throws zzt {
        byte[] byArray;
        try {
            byArray = Base64.decode(string2, 8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new zzt(illegalArgumentException);
        }
        try {
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(byArray));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string3 = String.valueOf(generalSecurityException);
            Log.w("FirebaseInstanceId", new StringBuilder(19 + String.valueOf(string3).length()).append("Invalid key stored ").append(string3).toString());
            throw new zzt(generalSecurityException);
        }
    }

    @Nullable
    private final zzs zzd(Context context, String string2) throws zzt {
        File file = zzq.zze(context, string2);
        if (!file.exists()) {
            return null;
        }
        try {
            return this.zza(file);
        }
        catch (zzt | IOException exception) {
            String string3;
            if (Log.isLoggable("FirebaseInstanceId", 3)) {
                string3 = String.valueOf(exception);
                Log.d("FirebaseInstanceId", new StringBuilder(39 + String.valueOf(string3).length()).append("Failed to read ID from file, retrying: ").append(string3).toString());
            }
            try {
                return this.zza(file);
            }
            catch (IOException iOException) {
                string3 = String.valueOf(iOException);
                Log.w("FirebaseInstanceId", new StringBuilder(45 + String.valueOf(string3).length()).append("IID file exists, but failed to read from it: ").append(string3).toString());
                throw new zzt(iOException);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private final zzs zza(Context var1_1, String var2_2, zzs var3_3, boolean var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File zzb(Context context) {
        File file = ContextCompat.getNoBackupFilesDir(context);
        if (file != null && file.isDirectory()) {
            return file;
        }
        Log.w("FirebaseInstanceId", "noBackupFilesDir doesn't exist, using regular files directory instead");
        return context.getFilesDir();
    }

    private static File zze(Context context, String string2) {
        String string3;
        if (TextUtils.isEmpty(string2)) {
            string3 = "com.google.InstanceId.properties";
        } else {
            try {
                String string4 = Base64.encodeToString(string2.getBytes("UTF-8"), 11);
                string3 = new StringBuilder(33 + String.valueOf(string4).length()).append("com.google.InstanceId_").append(string4).append(".properties").toString();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
        }
        return new File(zzq.zzb(context), string3);
    }

    /*
     * Loose catch block
     */
    private final zzs zza(File file) throws zzt, IOException {
        zzs zzs2;
        FileChannel fileChannel;
        FileInputStream fileInputStream;
        block10: {
            fileInputStream = new FileInputStream(file);
            fileChannel = fileInputStream.getChannel();
            fileChannel.lock(0L, Long.MAX_VALUE, true);
            zzs2 = zzq.zza(fileChannel);
            if (fileChannel == null) break block10;
            fileChannel.close();
        }
        fileInputStream.close();
        return zzs2;
        {
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            zzm.zza(throwable, throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable4) {
                        zzm.zza(throwable3, throwable4);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private static zzs zza(FileChannel fileChannel) throws zzt, IOException {
        long l;
        Properties properties = new Properties();
        properties.load(Channels.newInputStream(fileChannel));
        try {
            l = Long.parseLong(properties.getProperty("cre"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new zzt(numberFormatException);
        }
        String string2 = properties.getProperty("id");
        if (string2 == null) {
            String string3 = properties.getProperty("pub");
            if (string3 == null) {
                throw new zzt("Invalid properties file");
            }
            string2 = zzai.zza(zzq.zza(string3));
        }
        return new zzs(string2, l);
    }

    @Nullable
    private static zzs zza(SharedPreferences sharedPreferences, String string2) throws zzt {
        long l = zzq.zzb(sharedPreferences, string2);
        String string3 = sharedPreferences.getString(zzat.zza(string2, "id"), null);
        if (string3 == null) {
            String string4 = sharedPreferences.getString(zzat.zza(string2, "|P|"), null);
            if (string4 == null) {
                return null;
            }
            string3 = zzai.zza(zzq.zza(string4));
        }
        return new zzs(string3, l);
    }

    private final void zza(Context context, String string2, zzs zzs2) {
        Object object;
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.appid", 0);
        try {
            object = zzq.zza(sharedPreferences, string2);
            if (zzs2.equals(object)) {
                return;
            }
        }
        catch (zzt zzt2) {}
        if (Log.isLoggable("FirebaseInstanceId", 3)) {
            Log.d("FirebaseInstanceId", "Writing key to shared preferences");
        }
        object = sharedPreferences.edit();
        object.putString(zzat.zza(string2, "id"), zzs2.zza());
        object.putString(zzat.zza(string2, "cre"), String.valueOf(zzs.zza(zzs2)));
        object.commit();
    }

    private static long zzb(SharedPreferences sharedPreferences, String string2) {
        String string3 = sharedPreferences.getString(zzat.zza(string2, "cre"), null);
        if (string3 != null) {
            try {
                return Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }
}

