/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.UserManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesIncorrectManifestValueException;
import com.google.android.gms.common.GooglePlayServicesMissingManifestValueException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.R;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.zza;
import com.google.android.gms.common.wrappers.Wrappers;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;

@ShowFirstParty
@KeepForSdk
public class GooglePlayServicesUtilLight {
    @Deprecated
    @KeepForSdk
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @Deprecated
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_GAMES_PACKAGE = "com.google.android.play.games";
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    @KeepForSdk
    static final int GMS_GENERAL_ERROR_NOTIFICATION_ID = 39789;
    @KeepForSdk
    static final int GMS_AVAILABILITY_NOTIFICATION_ID = 10436;
    @VisibleForTesting
    @KeepForSdk
    static final AtomicBoolean sCanceledAvailabilityNotification;
    private static boolean zzb;
    @VisibleForTesting
    static boolean zza;
    private static final AtomicBoolean zzc;

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static int getApkVersion(@NonNull Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w("GooglePlayServicesUtil", "Google Play services is missing.");
            return 0;
        }
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static int getClientVersion(@NonNull Context context) {
        Context context2;
        Preconditions.checkState(true);
        return ClientLibraryUtils.getClientVersion(context2, context2.getPackageName());
    }

    @Deprecated
    @HideFirstParty
    @KeepForSdk
    public static int isGooglePlayServicesAvailable(@NonNull Context context) {
        return GooglePlayServicesUtilLight.isGooglePlayServicesAvailable(context, GOOGLE_PLAY_SERVICES_VERSION_CODE);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @KeepForSdk
    public static int isGooglePlayServicesAvailable(@NonNull Context context, int minApkVersion) {
        PackageInfo packageInfo;
        Object object;
        void var1_3;
        int n;
        Object object2;
        try {
            context.getResources().getString(R.string.common_google_play_services_unknown_issue);
        }
        catch (Throwable throwable) {
            Log.e("GooglePlayServicesUtil", "The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
        }
        if (!GOOGLE_PLAY_SERVICES_PACKAGE.equals(((Context)object2).getPackageName()) && !zzc.get()) {
            n = zzag.zza((Context)object2);
            if (n == 0) {
                object2 = new GooglePlayServicesMissingManifestValueException();
                throw object2;
            }
            if (n != GOOGLE_PLAY_SERVICES_VERSION_CODE) {
                object2 = new GooglePlayServicesIncorrectManifestValueException(n);
                throw object2;
            }
        }
        n = !DeviceProperties.isWearableWithoutPlayStore((Context)object2) ? (!DeviceProperties.zzb((Context)object2) ? 1 : 0) : 0;
        boolean bl = var1_3 >= 0;
        Preconditions.checkArgument(bl);
        String string2 = ((Context)object2).getPackageName();
        PackageManager packageManager = ((Context)object2).getPackageManager();
        if (n != 0) {
            object = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, 8256);
        }
        object = null;
        try {
            packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w("GooglePlayServicesUtil", String.valueOf(string2).concat(" requires Google Play services, but they are missing."));
            return 1;
        }
        GoogleSignatureVerifier.getInstance((Context)object2);
        if (!GoogleSignatureVerifier.zzb(packageInfo, true)) {
            Log.w("GooglePlayServicesUtil", String.valueOf(string2).concat(" requires Google Play services, but their signature is invalid."));
            return 9;
        }
        if (n != 0) {
            Preconditions.checkNotNull(object);
            if (!GoogleSignatureVerifier.zzb((PackageInfo)object, true)) {
                Log.w("GooglePlayServicesUtil", String.valueOf(string2).concat(" requires Google Play Store, but its signature is invalid."));
                return 9;
            }
        }
        if (n != 0 && object != null && !((PackageInfo)object).signatures[0].equals((Object)packageInfo.signatures[0])) {
            Log.w("GooglePlayServicesUtil", String.valueOf(string2).concat(" requires Google Play Store, but its signature doesn't match that of Google Play services."));
            return 9;
        }
        if (com.google.android.gms.common.util.zza.zza(packageInfo.versionCode) < com.google.android.gms.common.util.zza.zza((int)var1_3)) {
            int n2 = packageInfo.versionCode;
            String string3 = String.valueOf(string2);
            int n3 = string3.length();
            object = new StringBuilder(n3 + 82);
            ((StringBuilder)object).append("Google Play services out of date for ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(".  Requires ");
            ((StringBuilder)object).append((int)var1_3);
            ((StringBuilder)object).append(" but found ");
            ((StringBuilder)object).append(n2);
            Log.w("GooglePlayServicesUtil", ((StringBuilder)object).toString());
            return 2;
        }
        object2 = packageInfo.applicationInfo;
        if (object2 == null) {
            object2 = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
        }
        if (((ApplicationInfo)object2).enabled) return 0;
        return 3;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w("GooglePlayServicesUtil", String.valueOf(string2).concat(" requires the Google Play Store, but it is missing."));
            return 9;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.wtf("GooglePlayServicesUtil", String.valueOf(string2).concat(" requires Google Play services, but they're missing when getting application info."), nameNotFoundException);
            return 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    @Nullable
    public static PendingIntent getErrorPendingIntent(int errorCode, @NonNull Context context, int requestCode) {
        void var2_2;
        int n;
        void var1_1;
        return GoogleApiAvailabilityLight.getInstance().getErrorResolutionPendingIntent((Context)var1_1, n, (int)var2_2);
    }

    @KeepForSdk
    @Nullable
    public static Context getRemoteContext(@NonNull Context context) {
        try {
            Context context2 = context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
            return context2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    @Nullable
    public static Intent getGooglePlayServicesAvailabilityRecoveryIntent(int errorCode) {
        int n;
        return GoogleApiAvailabilityLight.getInstance().getErrorResolutionIntent(null, n, null);
    }

    @KeepForSdk
    @Nullable
    public static Resources getRemoteResource(@NonNull Context context) {
        try {
            Resources resources = context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
            return resources;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @Deprecated
    @VisibleForTesting
    @KeepForSdk
    @NonNull
    public static String getErrorString(int errorCode) {
        return ConnectionResult.zza(errorCode);
    }

    static {
        AtomicBoolean atomicBoolean;
        GOOGLE_PLAY_SERVICES_VERSION_CODE = 12451000;
        zzb = false;
        zza = false;
        sCanceledAvailabilityNotification = atomicBoolean = new AtomicBoolean();
        zzc = atomicBoolean = new AtomicBoolean();
    }

    @KeepForSdk
    GooglePlayServicesUtilLight() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    @KeepForSdk
    public static void cancelAvailabilityErrorNotifications(@NonNull Context context) {
        Context context2;
        if (sCanceledAvailabilityNotification.getAndSet(true)) {
            return;
        }
        try {
            context2 = (NotificationManager)context2.getSystemService("notification");
            if (context2 == null) return;
        }
        catch (SecurityException securityException) {
            return;
        }
        context2.cancel(10436);
    }

    @ShowFirstParty
    @KeepForSdk
    public static void enableUsingApkIndependentContext() {
        zzc.set(true);
    }

    @Deprecated
    @KeepForSdk
    public static void ensurePlayServicesAvailable(@NonNull Context context, int minApkVersion) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        int n;
        Object object;
        n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable((Context)object, n);
        if (n != 0) {
            object = GoogleApiAvailabilityLight.getInstance().getErrorResolutionIntent((Context)object, n, "e");
            Serializable serializable = new StringBuilder(57);
            serializable.append("GooglePlayServices not available due to error ");
            serializable.append(n);
            Log.e("GooglePlayServicesUtil", serializable.toString());
            if (object == null) {
                object = new GooglePlayServicesNotAvailableException(n);
                throw object;
            }
            serializable = new GooglePlayServicesRepairableException(n, "Google Play Services not available", (Intent)object);
            throw serializable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ShowFirstParty
    @KeepForSdk
    public static boolean honorsDebugCertificates(@NonNull Context context) {
        if (!zza) {
            try {
                boolean bl;
                Context context2;
                PackageInfo packageInfo = Wrappers.packageManager(context2).getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
                GoogleSignatureVerifier.getInstance(context2);
                zzb = packageInfo != null && !(bl = GoogleSignatureVerifier.zzb(packageInfo, false)) && (bl = GoogleSignatureVerifier.zzb(packageInfo, true));
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w("GooglePlayServicesUtil", "Cannot find Google Play services package name.", nameNotFoundException);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        if (zzb) return true;
        if (DeviceProperties.isUserBuild()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    public static boolean isGooglePlayServicesUid(@NonNull Context context, int uid) {
        void var1_1;
        return UidVerifier.isGooglePlayServicesUid(context, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static boolean isPlayServicesPossiblyUpdating(@NonNull Context context, int connectionStatusCode) {
        void var1_1;
        if (connectionStatusCode == 18) {
            return true;
        }
        if (var1_1 == true) {
            Context context2;
            return GooglePlayServicesUtilLight.zza(context2, GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        return false;
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static boolean isPlayStorePossiblyUpdating(@NonNull Context context, int connectionStatusCode) {
        if (connectionStatusCode == 9) {
            Context context2;
            return GooglePlayServicesUtilLight.zza(context2, GOOGLE_PLAY_STORE_PACKAGE);
        }
        return false;
    }

    @TargetApi(value=18)
    @KeepForSdk
    public static boolean isRestrictedUserProfile(@NonNull Context context) {
        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
            Bundle bundle;
            Object object = ((Context)((Object)bundle)).getSystemService("user");
            Preconditions.checkNotNull(object);
            bundle = ((UserManager)object).getApplicationRestrictions(((Context)((Object)bundle)).getPackageName());
            if (bundle != null && "true".equals(bundle.getString("restricted_profile"))) {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @ShowFirstParty
    @VisibleForTesting
    @KeepForSdk
    public static boolean isSidewinderDevice(@NonNull Context context) {
        return DeviceProperties.isSidewinder(context);
    }

    @Deprecated
    @KeepForSdk
    public static boolean isUserRecoverableError(int errorCode) {
        switch (errorCode) {
            default: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @TargetApi(value=19)
    @KeepForSdk
    public static boolean uidHasPackageName(@NonNull Context context, int uid, @NonNull String packageName) {
        void var2_2;
        void var1_1;
        return UidVerifier.uidHasPackageName(context, (int)var1_1, (String)var2_2);
    }

    /*
     * Loose catch block
     */
    @TargetApi(value=21)
    static boolean zza(Context context, String object) {
        block10: {
            block9: {
                Iterator iterator;
                boolean bl = ((String)object).equals(GOOGLE_PLAY_SERVICES_PACKAGE);
                if (PlatformVersion.isAtLeastLollipop()) {
                    iterator = context.getPackageManager().getPackageInstaller().getAllSessions();
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        if (!((String)object).equals(((PackageInstaller.SessionInfo)iterator.next()).getAppPackageName())) continue;
                        return true;
                    }
                }
                iterator = context.getPackageManager();
                try {
                    object = ((PackageManager)((Object)iterator)).getApplicationInfo((String)object, 8192);
                    if (!bl) break block9;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
                boolean bl2 = ((ApplicationInfo)object).enabled;
                return bl2;
            }
            boolean bl = ((ApplicationInfo)object).enabled;
            if (!bl) break block10;
            boolean bl3 = GooglePlayServicesUtilLight.isRestrictedUserProfile(context);
            if (bl3) break block10;
            return true;
        }
        return false;
        catch (Exception exception) {
            return false;
        }
    }
}

