/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.zaad;
import com.google.android.gms.common.api.internal.zaae;
import com.google.android.gms.common.api.internal.zabm;
import com.google.android.gms.common.api.internal.zabn;
import com.google.android.gms.common.api.internal.zabp;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zabu;
import com.google.android.gms.common.api.internal.zac;
import com.google.android.gms.common.api.internal.zaci;
import com.google.android.gms.common.api.internal.zact;
import com.google.android.gms.common.api.internal.zah;
import com.google.android.gms.common.api.internal.zai;
import com.google.android.gms.common.api.internal.zal;
import com.google.android.gms.common.api.internal.zau;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.zap;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class zabq<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zau {
    private final Queue<zai> zab;
    @NotOnlyInitialized
    private final Api.Client zac;
    private final ApiKey<O> zad;
    private final zaad zae;
    private final Set<zal> zaf;
    private final Map<ListenerHolder.ListenerKey<?>, zaci> zag;
    private final int zah;
    @Nullable
    private final zact zai;
    private boolean zaj;
    private final List<zabs> zak;
    @Nullable
    private ConnectionResult zal;
    private int zam;
    final /* synthetic */ GoogleApiManager zaa;

    public final int zab() {
        return this.zah;
    }

    @WorkerThread
    final int zac() {
        return this.zam;
    }

    @WorkerThread
    @Nullable
    public final ConnectionResult zad() {
        Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
        return this.zal;
    }

    @WorkerThread
    @Nullable
    private final Feature zaB(@Nullable Feature[] featureArray) {
        Object object;
        if (featureArray == null || featureArray.length == 0) {
            return null;
        }
        Feature[] featureArray2 = featureArray2.zac.getAvailableFeatures();
        if (featureArray2 == null) {
            featureArray2 = new Feature[]{};
        }
        int n = featureArray2.length;
        ArrayMap arrayMap = new ArrayMap(n);
        for (int i = 0; i < n; ++i) {
            object = featureArray2[i];
            arrayMap.put(((Feature)object).getName(), ((Feature)object).getVersion());
        }
        for (Feature feature : featureArray) {
            object = (Long)arrayMap.get(feature.getName());
            if (object != null && (Long)object >= feature.getVersion()) continue;
            return feature;
        }
        return null;
    }

    static /* bridge */ /* synthetic */ Api.Client zae(zabq zabq2) {
        return zabq2.zac;
    }

    public final Api.Client zaf() {
        return this.zac;
    }

    static /* bridge */ /* synthetic */ ApiKey zag(zabq zabq2) {
        return zabq2.zad;
    }

    public final Map<ListenerHolder.ListenerKey<?>, zaci> zah() {
        return this.zag;
    }

    static /* bridge */ /* synthetic */ void zai(zabq zabq2, Status status) {
        zabq2.zaD(status);
    }

    static /* bridge */ /* synthetic */ void zaj(zabq zabq2) {
        zabq2.zaG();
    }

    static /* bridge */ /* synthetic */ void zak(zabq zabq2, int n) {
        zabq2.zaH(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zal(zabq zabq2, zabs zabs2) {
        if (!zabq2.zak.contains(zabs2) || zabq2.zaj) {
            return;
        }
        if (!zabq2.zac.isConnected()) {
            zabq2.zao();
            return;
        }
        zabq2.zaF();
    }

    static /* bridge */ /* synthetic */ void zam(zabq zabq2, zabs object) {
        if (zabq2.zak.remove(object)) {
            Object object2;
            GoogleApiManager.zaf(zabq2.zaa).removeMessages(15, object);
            GoogleApiManager.zaf(zabq2.zaa).removeMessages(16, object);
            Feature feature = zabs.zaa((zabs)object);
            ArrayList<zai> arrayList = new ArrayList<zai>(zabq2.zab.size());
            for (zai zai2 : zabq2.zab) {
                if (!(zai2 instanceof zac) || (object2 = ((zac)zai2).zab(zabq2)) == null || !ArrayUtils.contains(object2, feature)) continue;
                arrayList.add(zai2);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                object2 = (zai)arrayList.get(i);
                zabq2.zab.remove(object2);
                UnsupportedApiCallException unsupportedApiCallException = new UnsupportedApiCallException(feature);
                ((zai)object2).zae(unsupportedApiCallException);
            }
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zabq(GoogleApiManager googleApiManager, GoogleApi googleApi) {
        this.zaa = googleApiManager;
        Object object = new LinkedList();
        this.zab = object;
        this.zaf = object;
        super();
        this.zag = object;
        super();
        this.zak = object;
        this.zal = null;
        this.zam = 0;
        this.zac = googleApi.zab(GoogleApiManager.zaf(googleApiManager).getLooper(), this);
        this.zad = googleApi.getApiKey();
        this.zae = object = new zaad();
        this.zah = googleApi.zaa();
        if (this.zac.requiresSignIn()) {
            this.zai = googleApi.zac(GoogleApiManager.zae(googleApiManager), GoogleApiManager.zaf(googleApiManager));
            return;
        }
        this.zai = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zaC(ConnectionResult connectionResult) {
        Iterator<zal> iterator = this.zaf.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.zaf.clear();
                return;
            }
            zal zal2 = iterator.next();
            String string2 = Objects.equal(connectionResult, ConnectionResult.RESULT_SUCCESS) ? this.zac.getEndpointPackageName() : null;
            zal2.zac(this.zad, connectionResult, string2);
        }
    }

    @WorkerThread
    public final void zan() {
        Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
        this.zal = null;
    }

    @WorkerThread
    public final void zao() {
        Object object;
        block9: {
            int n;
            Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
            if (this.zac.isConnected() || this.zac.isConnecting()) {
                return;
            }
            try {
                GoogleApiManager googleApiManager = this.zaa;
                object = GoogleApiManager.zan(googleApiManager);
                n = ((com.google.android.gms.common.internal.zal)object).zab(GoogleApiManager.zae(googleApiManager), this.zac);
                if (n == 0) break block9;
            }
            catch (IllegalStateException illegalStateException) {
                object = new ConnectionResult(10);
                this.zar((ConnectionResult)object, illegalStateException);
                return;
            }
            object = new ConnectionResult(n, null);
            String string2 = "GoogleApiManager";
            String string3 = this.zac.getClass().getName();
            String string4 = object.toString();
            int n2 = String.valueOf(string3).length();
            n2 += 35;
            int n3 = string4.length();
            n2 += n3;
            StringBuilder stringBuilder = new StringBuilder(n2);
            stringBuilder.append("The service for ");
            stringBuilder.append(string3);
            stringBuilder.append(" is not available: ");
            stringBuilder.append(string4);
            Log.w(string2, stringBuilder.toString());
            this.zar((ConnectionResult)object, null);
            return;
        }
        object = this.zaa;
        Api.Client client = this.zac;
        zabu zabu2 = new zabu((GoogleApiManager)object, client, this.zad);
        if (client.requiresSignIn()) {
            Preconditions.checkNotNull(this.zai).zae(zabu2);
        }
        try {
            this.zac.connect(zabu2);
            return;
        }
        catch (SecurityException securityException) {
            object = new ConnectionResult(10);
            this.zar((ConnectionResult)object, securityException);
            return;
        }
    }

    @WorkerThread
    public final void zap(zai object) {
        Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
        if (this.zac.isConnected()) {
            if (this.zaL((zai)object)) {
                this.zaI();
                return;
            }
            this.zab.add((zai)object);
            return;
        }
        this.zab.add((zai)object);
        object = this.zal;
        if (object != null && ((ConnectionResult)object).hasResolution()) {
            this.zar(this.zal, null);
            return;
        }
        this.zao();
    }

    @WorkerThread
    private final void zaD(Status status) {
        Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
        this.zaE(status, null, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zaE(@Nullable Status status, @Nullable Exception exception, boolean bl) {
        Iterator iterator;
        Preconditions.checkHandlerThread(GoogleApiManager.zaf(((zabq)((Object)iterator)).zaa));
        boolean bl2 = status == null;
        boolean bl3 = exception == null;
        if (bl2 == bl3) {
            iterator = new Iterator("Status XOR exception should be null");
            throw iterator;
        }
        iterator = ((zabq)((Object)iterator)).zab.iterator();
        while (iterator.hasNext()) {
            zai zai2 = (zai)iterator.next();
            if (bl && zai2.zac != 2) continue;
            if (status != null) {
                zai2.zad(status);
            } else {
                zai2.zae(exception);
            }
            iterator.remove();
        }
        return;
    }

    @WorkerThread
    private final void zaF() {
        ArrayList<zai> arrayList = new ArrayList<zai>(this.zab);
        int n = arrayList.size();
        int n2 = 0;
        while (true) {
            zai zai2;
            block6: {
                block5: {
                    if (n2 >= n) break block5;
                    zai2 = (zai)arrayList.get(n2);
                    if (this.zac.isConnected()) break block6;
                }
                return;
            }
            if (this.zaL(zai2)) {
                this.zab.remove(zai2);
            }
            ++n2;
        }
    }

    @WorkerThread
    final void zaq() {
        ++this.zam;
    }

    @Override
    public final void onConnected(@Nullable Bundle object) {
        if (Looper.myLooper() == GoogleApiManager.zaf(this.zaa).getLooper()) {
            this.zaG();
            return;
        }
        object = this.zaa;
        object = GoogleApiManager.zaf((GoogleApiManager)object);
        zabm zabm2 = new zabm(this);
        ((Handler)object).post(zabm2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zaG() {
        this.zan();
        this.zaC(ConnectionResult.RESULT_SUCCESS);
        this.zaK();
        Iterator<zaci> iterator = this.zag.values().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (this.zaB(((zaci)object).zaa.getRequiredFeatures()) != null) {
                iterator.remove();
                continue;
            }
            try {
                object = ((zaci)object).zaa;
                Api.Client client = this.zac;
                TaskCompletionSource<Void> taskCompletionSource = new TaskCompletionSource<Void>();
                ((RegisterListenerMethod)object).registerListener(client, taskCompletionSource);
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(3);
                this.zac.disconnect("DeadObjectException thrown while calling register listener method.");
                break;
            }
            catch (RemoteException remoteException) {
                iterator.remove();
            }
        }
        this.zaF();
        this.zaI();
    }

    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        this.zar(connectionResult, null);
    }

    @WorkerThread
    public final void zar(@NonNull ConnectionResult object, @Nullable Exception exception) {
        Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
        Object object2 = this.zai;
        if (object2 != null) {
            ((zact)object2).zaf();
        }
        this.zan();
        GoogleApiManager.zan(this.zaa).zac();
        this.zaC((ConnectionResult)object);
        if (this.zac instanceof zap && ((ConnectionResult)object).getErrorCode() != 24) {
            GoogleApiManager.zav(this.zaa, true);
            object2 = this.zaa;
            GoogleApiManager.zaf((GoogleApiManager)object2).sendMessageDelayed(GoogleApiManager.zaf((GoogleApiManager)object2).obtainMessage(19), 300000L);
        }
        if (((ConnectionResult)object).getErrorCode() == 4) {
            this.zaD(GoogleApiManager.zah());
            return;
        }
        if (this.zab.isEmpty()) {
            this.zal = object;
            return;
        }
        if (exception != null) {
            Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
            this.zaE(null, exception, false);
            return;
        }
        if (GoogleApiManager.zaE(this.zaa)) {
            this.zaE(GoogleApiManager.zai(this.zad, (ConnectionResult)object), null, true);
            if (this.zab.isEmpty()) {
                return;
            }
            if (this.zaM((ConnectionResult)object)) {
                return;
            }
            if (!this.zaa.zaG((ConnectionResult)object, this.zah)) {
                if (((ConnectionResult)object).getErrorCode() == 18) {
                    this.zaj = true;
                }
                if (this.zaj) {
                    object = this.zaa;
                    GoogleApiManager.zaf((GoogleApiManager)object).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zaf((GoogleApiManager)object), (int)9, this.zad), GoogleApiManager.zab(this.zaa));
                    return;
                }
                this.zaD(GoogleApiManager.zai(this.zad, (ConnectionResult)object));
                return;
            }
            return;
        }
        this.zaD(GoogleApiManager.zai(this.zad, (ConnectionResult)object));
    }

    @Override
    public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        throw null;
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == GoogleApiManager.zaf(this.zaa).getLooper()) {
            this.zaH(n);
            return;
        }
        Object object = this.zaa;
        object = GoogleApiManager.zaf((GoogleApiManager)object);
        zabn zabn2 = new zabn(this, n);
        ((Handler)object).post(zabn2);
    }

    @WorkerThread
    private final void zaH(int n) {
        ((zabq)((Object)iterator)).zan();
        ((zabq)((Object)iterator)).zaj = true;
        ((zabq)((Object)iterator)).zae.zae(n, ((zabq)((Object)iterator)).zac.getLastDisconnectMessage());
        GoogleApiManager googleApiManager = ((zabq)((Object)iterator)).zaa;
        GoogleApiManager.zaf(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zaf(googleApiManager), (int)9, ((zabq)((Object)iterator)).zad), GoogleApiManager.zab(((zabq)((Object)iterator)).zaa));
        googleApiManager = ((zabq)((Object)iterator)).zaa;
        GoogleApiManager.zaf(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zaf(googleApiManager), (int)11, ((zabq)((Object)iterator)).zad), GoogleApiManager.zac(((zabq)((Object)iterator)).zaa));
        GoogleApiManager.zan(((zabq)((Object)iterator)).zaa).zac();
        Iterator<zaci> iterator = ((zabq)((Object)iterator)).zag.values().iterator();
        while (iterator.hasNext()) {
            ((zaci)iterator.next()).zac.run();
        }
    }

    @WorkerThread
    public final void zas(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
        Api.Client client = this.zac;
        String string2 = client.getClass().getName();
        String string3 = String.valueOf(connectionResult);
        String string4 = String.valueOf(string2);
        int n = string4.length();
        String string5 = String.valueOf(string3);
        int n2 = string5.length();
        StringBuilder stringBuilder = new StringBuilder(n + 25 + n2);
        stringBuilder.append("onSignInFailed for ");
        stringBuilder.append(string2);
        stringBuilder.append(" with ");
        stringBuilder.append(string3);
        client.disconnect(stringBuilder.toString());
        this.zar(connectionResult, null);
    }

    @WorkerThread
    public final void zat(zal zal2) {
        Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
        this.zaf.add(zal2);
    }

    private final void zaI() {
        GoogleApiManager.zaf(this.zaa).removeMessages(12, this.zad);
        GoogleApiManager googleApiManager = this.zaa;
        GoogleApiManager.zaf(googleApiManager).sendMessageDelayed(GoogleApiManager.zaf(googleApiManager).obtainMessage(12, this.zad), GoogleApiManager.zad(this.zaa));
    }

    @WorkerThread
    public final void zau() {
        Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
        if (this.zaj) {
            this.zao();
            return;
        }
    }

    @WorkerThread
    private final void zaJ(zai zai2) {
        zai2.zag(this.zae, this.zaz());
        try {
            zai2.zaf(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zac.disconnect("DeadObjectException thrown while running ApiCallRunner.");
            return;
        }
    }

    @WorkerThread
    public final void zav() {
        Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
        this.zaD(GoogleApiManager.zaa);
        this.zae.zaf();
        for (ListenerHolder.ListenerKey listenerKey : this.zag.keySet().toArray(new ListenerHolder.ListenerKey[0])) {
            TaskCompletionSource<Boolean> taskCompletionSource = new TaskCompletionSource<Boolean>();
            zah zah2 = new zah(listenerKey, taskCompletionSource);
            this.zap(zah2);
        }
        Object object = new ConnectionResult(4);
        this.zaC((ConnectionResult)object);
        if (this.zac.isConnected()) {
            object = this.zac;
            zabp zabp2 = new zabp(this);
            object.onUserSignOut(zabp2);
            return;
        }
    }

    @WorkerThread
    private final void zaK() {
        if (this.zaj) {
            GoogleApiManager.zaf(this.zaa).removeMessages(11, this.zad);
            GoogleApiManager.zaf(this.zaa).removeMessages(9, this.zad);
            this.zaj = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zaw() {
        Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
        if (!this.zaj) {
            return;
        }
        this.zaK();
        Object object = this.zaa;
        object = GoogleApiManager.zag((GoogleApiManager)object).isGooglePlayServicesAvailable(GoogleApiManager.zae((GoogleApiManager)object)) == 18 ? new Status(21, "Connection timed out waiting for Google Play services update to complete.") : new Status(22, "API failed to connect while resuming due to an unknown error.");
        this.zaD((Status)object);
        this.zac.disconnect("Timing out connection while resuming.");
    }

    static /* bridge */ /* synthetic */ boolean zax(zabq zabq2, boolean bl) {
        return zabq2.zaN(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final boolean zaL(zai object) {
        if (!(object instanceof zac)) {
            ((zabq)object2).zaJ((zai)object);
            return true;
        }
        zac zac2 = (zac)object;
        Feature feature = ((zabq)object2).zaB(zac2.zab((zabq<?>)object2));
        if (feature == null) {
            ((zabq)object2).zaJ((zai)object);
            return true;
        }
        object = ((zabq)object2).zac.getClass().getName();
        String string2 = feature.getName();
        long l = feature.getVersion();
        String string3 = String.valueOf(object);
        int n = string3.length();
        String string4 = String.valueOf(string2);
        int n2 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n + 77 + n2);
        stringBuilder.append((String)object);
        stringBuilder.append(" could not execute call because it requires feature (");
        stringBuilder.append(string2);
        stringBuilder.append(", ");
        stringBuilder.append(l);
        stringBuilder.append(").");
        Log.w("GoogleApiManager", stringBuilder.toString());
        if (GoogleApiManager.zaE(((zabq)object2).zaa) && zac2.zaa((zabq<?>)object2)) {
            object = new zabs(((zabq)object2).zad, feature, null);
            int n3 = ((zabq)object2).zak.indexOf(object);
            if (n3 >= 0) {
                object = ((zabq)object2).zak.get(n3);
                GoogleApiManager.zaf(((zabq)object2).zaa).removeMessages(15, object);
                GoogleApiManager googleApiManager = ((zabq)object2).zaa;
                GoogleApiManager.zaf(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zaf(googleApiManager), (int)15, (Object)object), GoogleApiManager.zab(((zabq)object2).zaa));
                return false;
            }
            ((zabq)object2).zak.add((zabs)object);
            GoogleApiManager googleApiManager = ((zabq)object2).zaa;
            GoogleApiManager.zaf(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zaf(googleApiManager), (int)15, (Object)object), GoogleApiManager.zab(((zabq)object2).zaa));
            googleApiManager = ((zabq)object2).zaa;
            GoogleApiManager.zaf(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zaf(googleApiManager), (int)16, (Object)object), GoogleApiManager.zac(((zabq)object2).zaa));
            object = new ConnectionResult(2, null);
            if (super.zaM((ConnectionResult)object)) return false;
            ((zabq)object2).zaa.zaG((ConnectionResult)object, ((zabq)object2).zah);
            return false;
        }
        Object object2 = new UnsupportedApiCallException(feature);
        zac2.zae((Exception)object2);
        return true;
    }

    final boolean zay() {
        return this.zac.isConnected();
    }

    public final boolean zaz() {
        return this.zac.requiresSignIn();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final boolean zaM(@NonNull ConnectionResult connectionResult) {
        Object object = GoogleApiManager.zas();
        synchronized (object) {
            GoogleApiManager googleApiManager = this.zaa;
            zaae zaae2 = GoogleApiManager.zaj(googleApiManager);
            if (zaae2 == null) return false;
            boolean bl = GoogleApiManager.zau(googleApiManager).contains(this.zad);
            if (!bl) return false;
            GoogleApiManager.zaj(this.zaa).zah(connectionResult, this.zah);
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final boolean zaA() {
        return this.zaN(true);
    }

    @WorkerThread
    private final boolean zaN(boolean bl) {
        Preconditions.checkHandlerThread(GoogleApiManager.zaf(this.zaa));
        if (this.zac.isConnected() && this.zag.size() == 0) {
            if (this.zae.zag()) {
                if (bl) {
                    this.zaI();
                }
                return false;
            }
            this.zac.disconnect("Timing out service connection.");
            return true;
        }
        return false;
    }
}

