/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.converter.zaa;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.common.server.response.zaj;
import com.google.android.gms.common.server.response.zan;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.common.util.MapUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@ShowFirstParty
@KeepForSdk
public abstract class FastJsonResponse {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @Nullable
    protected Object getFieldValue(@NonNull Field field) {
        String string2;
        char c;
        RuntimeException runtimeException;
        String string3 = field.zae;
        if (((Field)((Object)runtimeException)).zag == null) {
            return ((FastJsonResponse)this).getValueObject(string3);
        }
        boolean bl = ((FastJsonResponse)this).getValueObject(string3) == null;
        Object object = new Object[]{((Field)((Object)runtimeException)).zae};
        Preconditions.checkState(bl, "Concrete field shouldn't be value object: %s", (Object[])object);
        boolean cfr_ignored_0 = ((Field)((Object)runtimeException)).zad;
        try {
            c = Character.toUpperCase(string3.charAt(0));
            string2 = string3.substring(1);
            int n = String.valueOf(string2).length();
        }
        catch (Exception exception) {
            runtimeException = new RuntimeException(exception);
            throw runtimeException;
        }
        {
            object = new StringBuilder(n += 4);
            ((StringBuilder)object).append("get");
            ((StringBuilder)object).append(c);
            ((StringBuilder)object).append(string2);
            return this.getClass().getMethod(((StringBuilder)object).toString(), new Class[0]).invoke(this, new Object[0]);
        }
    }

    @KeepForSdk
    @Nullable
    protected abstract Object getValueObject(@NonNull String var1);

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public String toString() {
        Map<String, Field<?, ?>> map = this.getFieldMappings();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.isFieldSet(field)) continue;
            Object object = FastJsonResponse.zaD(field, this.getFieldValue(field));
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"");
            stringBuilder.append(string2);
            stringBuilder.append("\":");
            if (object == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zac) {
                default: {
                    if (field.zab) {
                        object = (ArrayList)object;
                        stringBuilder.append("[");
                        int n = ((ArrayList)object).size();
                        for (int i = 0; i < n; ++i) {
                            Object e;
                            if (i > 0) {
                                stringBuilder.append(",");
                            }
                            if ((e = ((ArrayList)object).get(i)) == null) continue;
                            FastJsonResponse.zaF(stringBuilder, field, e);
                        }
                        stringBuilder.append("]");
                        continue block5;
                    }
                    FastJsonResponse.zaF(stringBuilder, field, object);
                    continue block5;
                }
                case 8: {
                    stringBuilder.append("\"");
                    stringBuilder.append(Base64Utils.encode((byte[])object));
                    stringBuilder.append("\"");
                    continue block5;
                }
                case 10: {
                    MapUtils.writeStringMapToJson(stringBuilder, (HashMap)object);
                    continue block5;
                }
                case 9: 
            }
            stringBuilder.append("\"");
            stringBuilder.append(Base64Utils.encodeUrlSafe((byte[])object));
            stringBuilder.append("\"");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        stringBuilder.append("{}");
        return stringBuilder.toString();
    }

    @KeepForSdk
    @NonNull
    public abstract Map<String, Field<?, ?>> getFieldMappings();

    @KeepForSdk
    public <T extends FastJsonResponse> void addConcreteTypeArrayInternal(@NonNull Field field, @NonNull String string2, @Nullable ArrayList<T> arrayList) {
        Object object = new UnsupportedOperationException("Concrete type array not supported");
        throw object;
    }

    @KeepForSdk
    public <T extends FastJsonResponse> void addConcreteTypeInternal(@NonNull Field field, @NonNull String string2, @NonNull T t) {
        Object object = new UnsupportedOperationException("Concrete type not supported");
        throw object;
    }

    @KeepForSdk
    protected void setBooleanInternal(@NonNull Field<?, ?> field, @NonNull String string2, boolean bl) {
        Object object = new UnsupportedOperationException("Boolean not supported");
        throw object;
    }

    @KeepForSdk
    protected void setDecodedBytesInternal(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable byte[] byArray) {
        Object object = new UnsupportedOperationException("byte[] not supported");
        throw object;
    }

    @KeepForSdk
    protected void setIntegerInternal(@NonNull Field<?, ?> field, @NonNull String string2, int n) {
        Object object = new UnsupportedOperationException("Integer not supported");
        throw object;
    }

    @KeepForSdk
    protected void setLongInternal(@NonNull Field<?, ?> field, @NonNull String string2, long l) {
        Object object = new UnsupportedOperationException("Long not supported");
        throw object;
    }

    @KeepForSdk
    protected void setStringInternal(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable String string3) {
        Object object = new UnsupportedOperationException("String not supported");
        throw object;
    }

    @KeepForSdk
    protected void setStringMapInternal(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable Map<String, String> map) {
        Object object = new UnsupportedOperationException("String map not supported");
        throw object;
    }

    @KeepForSdk
    protected void setStringsInternal(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable ArrayList<String> arrayList) {
        Object object = new UnsupportedOperationException("String list not supported");
        throw object;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected boolean isFieldSet(@NonNull Field field) {
        void var1_1;
        if (field.zac == 11) {
            Object object;
            if (var1_1.zad) {
                String cfr_ignored_0 = var1_1.zae;
                object = new UnsupportedOperationException("Concrete type arrays not supported");
                throw object;
            }
            String cfr_ignored_1 = var1_1.zae;
            object = new UnsupportedOperationException("Concrete types not supported");
            throw object;
        }
        return ((FastJsonResponse)object).isPrimitiveFieldSet(var1_1.zae);
    }

    @KeepForSdk
    protected abstract boolean isPrimitiveFieldSet(@NonNull String var1);

    public final <O> void zaa(@NonNull Field<BigDecimal, O> field, @Nullable BigDecimal bigDecimal) {
        if (((Field)field).zak != null) {
            this.zaE(field, bigDecimal);
            return;
        }
        this.zab(field, field.zae, bigDecimal);
    }

    protected void zab(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable BigDecimal bigDecimal) {
        Object object = new UnsupportedOperationException("BigDecimal not supported");
        throw object;
    }

    public final <O> void zac(@NonNull Field<ArrayList<BigDecimal>, O> field, @Nullable ArrayList<BigDecimal> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zad(field, field.zae, arrayList);
    }

    protected void zad(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable ArrayList<BigDecimal> arrayList) {
        Object object = new UnsupportedOperationException("BigDecimal list not supported");
        throw object;
    }

    public final <O> void zae(@NonNull Field<BigInteger, O> field, @Nullable BigInteger bigInteger) {
        if (((Field)field).zak != null) {
            this.zaE(field, bigInteger);
            return;
        }
        this.zaf(field, field.zae, bigInteger);
    }

    protected void zaf(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable BigInteger bigInteger) {
        Object object = new UnsupportedOperationException("BigInteger not supported");
        throw object;
    }

    public final <O> void zag(@NonNull Field<ArrayList<BigInteger>, O> field, @Nullable ArrayList<BigInteger> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zah(field, field.zae, arrayList);
    }

    protected void zah(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable ArrayList<BigInteger> arrayList) {
        Object object = new UnsupportedOperationException("BigInteger list not supported");
        throw object;
    }

    public final <O> void zai(@NonNull Field<Boolean, O> field, boolean bl) {
        if (((Field)field).zak != null) {
            this.zaE(field, bl);
            return;
        }
        this.setBooleanInternal(field, field.zae, bl);
    }

    public final <O> void zaj(@NonNull Field<ArrayList<Boolean>, O> field, @Nullable ArrayList<Boolean> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zak(field, field.zae, arrayList);
    }

    protected void zak(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable ArrayList<Boolean> arrayList) {
        Object object = new UnsupportedOperationException("Boolean list not supported");
        throw object;
    }

    private final <I, O> void zaE(Field<I, O> object, @Nullable I object2) {
        String string2 = ((Field)object).zae;
        object2 = ((Field)object).zae(object2);
        int n = ((Field)object).zac;
        switch (n) {
            case 8: 
            case 9: {
                if (object2 != null) {
                    ((FastJsonResponse)object3).setDecodedBytesInternal((Field<?, ?>)object, string2, (byte[])object2);
                    return;
                }
                FastJsonResponse.zaG(string2);
                return;
            }
            case 7: {
                ((FastJsonResponse)object3).setStringInternal((Field<?, ?>)object, string2, (String)object2);
                return;
            }
            case 6: {
                if (object2 != null) {
                    ((FastJsonResponse)object3).setBooleanInternal((Field<?, ?>)object, string2, (Boolean)object2);
                    return;
                }
                FastJsonResponse.zaG(string2);
                return;
            }
            case 5: {
                ((FastJsonResponse)object3).zab((Field<?, ?>)object, string2, (BigDecimal)object2);
                return;
            }
            case 2: {
                if (object2 != null) {
                    ((FastJsonResponse)object3).setLongInternal((Field<?, ?>)object, string2, (Long)object2);
                    return;
                }
                FastJsonResponse.zaG(string2);
                return;
            }
            case 4: {
                if (object2 != null) {
                    ((FastJsonResponse)object3).zan((Field<?, ?>)object, string2, (Double)object2);
                    return;
                }
                FastJsonResponse.zaG(string2);
                return;
            }
            case 1: {
                ((FastJsonResponse)object3).zaf((Field<?, ?>)object, string2, (BigInteger)object2);
                return;
            }
            case 0: {
                if (object2 == null) break;
                ((FastJsonResponse)object3).setIntegerInternal((Field<?, ?>)object, string2, (Integer)object2);
                return;
            }
            default: {
                object = new StringBuilder(44);
                ((StringBuilder)object).append("Unsupported type for conversion: ");
                ((StringBuilder)object).append(n);
                Object object3 = new IllegalStateException(((StringBuilder)object).toString());
                throw object3;
            }
        }
        FastJsonResponse.zaG(string2);
    }

    public final <O> void zal(@NonNull Field<byte[], O> field, @Nullable byte[] byArray) {
        if (((Field)field).zak != null) {
            this.zaE(field, byArray);
            return;
        }
        this.setDecodedBytesInternal(field, field.zae, byArray);
    }

    public final <O> void zam(@NonNull Field<Double, O> field, double d) {
        if (((Field)field).zak != null) {
            this.zaE(field, d);
            return;
        }
        this.zan(field, field.zae, d);
    }

    protected void zan(@NonNull Field<?, ?> field, @NonNull String string2, double d) {
        Object object = new UnsupportedOperationException("Double not supported");
        throw object;
    }

    public final <O> void zao(@NonNull Field<ArrayList<Double>, O> field, @Nullable ArrayList<Double> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zap(field, field.zae, arrayList);
    }

    protected void zap(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable ArrayList<Double> arrayList) {
        Object object = new UnsupportedOperationException("Double list not supported");
        throw object;
    }

    public final <O> void zaq(@NonNull Field<Float, O> field, float f) {
        if (((Field)field).zak != null) {
            this.zaE(field, Float.valueOf(f));
            return;
        }
        this.zar(field, field.zae, f);
    }

    protected void zar(@NonNull Field<?, ?> field, @NonNull String string2, float f) {
        Object object = new UnsupportedOperationException("Float not supported");
        throw object;
    }

    public final <O> void zas(@NonNull Field<ArrayList<Float>, O> field, @Nullable ArrayList<Float> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zat(field, field.zae, arrayList);
    }

    protected void zat(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable ArrayList<Float> arrayList) {
        Object object = new UnsupportedOperationException("Float list not supported");
        throw object;
    }

    public final <O> void zau(@NonNull Field<Integer, O> field, int n) {
        if (((Field)field).zak != null) {
            this.zaE(field, n);
            return;
        }
        this.setIntegerInternal(field, field.zae, n);
    }

    public final <O> void zav(@NonNull Field<ArrayList<Integer>, O> field, @Nullable ArrayList<Integer> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zaw(field, field.zae, arrayList);
    }

    protected void zaw(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable ArrayList<Integer> arrayList) {
        Object object = new UnsupportedOperationException("Integer list not supported");
        throw object;
    }

    public final <O> void zax(@NonNull Field<Long, O> field, long l) {
        if (((Field)field).zak != null) {
            this.zaE(field, l);
            return;
        }
        this.setLongInternal(field, field.zae, l);
    }

    public final <O> void zay(@NonNull Field<ArrayList<Long>, O> field, @Nullable ArrayList<Long> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zaz(field, field.zae, arrayList);
    }

    protected void zaz(@NonNull Field<?, ?> field, @NonNull String string2, @Nullable ArrayList<Long> arrayList) {
        Object object = new UnsupportedOperationException("Long list not supported");
        throw object;
    }

    public final <O> void zaA(@NonNull Field<String, O> field, @Nullable String string2) {
        if (((Field)field).zak != null) {
            this.zaE(field, string2);
            return;
        }
        this.setStringInternal(field, field.zae, string2);
    }

    public final <O> void zaB(@NonNull Field<Map<String, String>, O> field, @Nullable Map<String, String> map) {
        if (((Field)field).zak != null) {
            this.zaE(field, map);
            return;
        }
        this.setStringMapInternal(field, field.zae, map);
    }

    public final <O> void zaC(@NonNull Field<ArrayList<String>, O> field, @Nullable ArrayList<String> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.setStringsInternal(field, field.zae, arrayList);
    }

    private static final void zaF(StringBuilder stringBuilder, Field object, Object object2) {
        int n = ((Field)object).zaa;
        if (n != 11) {
            if (n == 7) {
                stringBuilder.append("\"");
                stringBuilder.append(JsonUtils.escapeString((String)object2));
                stringBuilder.append("\"");
                return;
            }
            stringBuilder.append(object2);
            return;
        }
        object = ((Field)object).zag;
        Preconditions.checkNotNull(object);
        stringBuilder.append(((FastJsonResponse)((Class)object).cast(object2)).toString());
    }

    @NonNull
    protected static final <O, I> I zaD(@NonNull Field<I, O> field, @Nullable Object object) {
        if (((Field)field).zak != null) {
            return field.zaf(object);
        }
        return (I)object;
    }

    private static final <O> void zaG(String string2) {
        if (Log.isLoggable("FastJsonResponse", 6)) {
            String string3 = String.valueOf(string2);
            int n = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 58);
            stringBuilder.append("Output field (");
            stringBuilder.append(string2);
            stringBuilder.append(") has a null value, but expected a primitive");
            Log.e("FastJsonResponse", stringBuilder.toString());
            return;
        }
    }

    @ShowFirstParty
    public static interface FieldConverter<I, O> {
        public int zaa();

        public int zab();

        @Nullable
        public O zac(@NonNull I var1);

        @NonNull
        public I zad(@NonNull O var1);
    }

    @VisibleForTesting
    @ShowFirstParty
    @SafeParcelable.Class(creator="FieldCreator")
    @KeepForSdk
    public static class Field<I, O>
    extends AbstractSafeParcelable {
        public static final zaj CREATOR;
        @SafeParcelable.VersionField(id=1, getter="getVersionCode")
        private final int zai;
        @SafeParcelable.Field(id=2, getter="getTypeIn")
        protected final int zaa;
        @SafeParcelable.Field(id=3, getter="isTypeInArray")
        protected final boolean zab;
        @SafeParcelable.Field(id=4, getter="getTypeOut")
        protected final int zac;
        @SafeParcelable.Field(id=5, getter="isTypeOutArray")
        protected final boolean zad;
        @SafeParcelable.Field(id=6, getter="getOutputFieldName")
        @NonNull
        protected final String zae;
        @SafeParcelable.Field(id=7, getter="getSafeParcelableFieldId")
        protected final int zaf;
        @Nullable
        protected final Class<? extends FastJsonResponse> zag;
        @SafeParcelable.Field(id=8, getter="getConcreteTypeName")
        @Nullable
        protected final String zah;
        private zan zaj;
        @SafeParcelable.Field(id=9, getter="getWrappedConverter", type="com.google.android.gms.common.server.converter.ConverterWrapper")
        @Nullable
        private FieldConverter<I, O> zak;

        @KeepForSdk
        public int getSafeParcelableFieldId() {
            return this.zaf;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @KeepForSdk
        @NonNull
        public static Field<byte[], byte[]> forBase64(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            Field<byte[], byte[]> field = new Field<byte[], byte[]>(8, false, 8, false, string2, (int)var1_1, null, null);
            return field;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<Boolean, Boolean> forBoolean(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            Field<Boolean, Boolean> field = new Field<Boolean, Boolean>(6, false, 6, false, string2, (int)var1_1, null, null);
            return field;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static <T extends FastJsonResponse> Field<T, T> forConcreteType(@NonNull String fieldName, int safeParcelableId, @NonNull Class<T> type) {
            void var2_2;
            void var1_1;
            String string2;
            Field field = new Field(11, false, 11, false, string2, (int)var1_1, (Class<? extends FastJsonResponse>)var2_2, null);
            return field;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> forConcreteTypeArray(@NonNull String fieldName, int safeParcelableId, @NonNull Class<T> type) {
            void var2_2;
            void var1_1;
            String string2;
            Field<ArrayList<T>, ArrayList<T>> field = new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, (int)var1_1, (Class<? extends FastJsonResponse>)var2_2, null);
            return field;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<Double, Double> forDouble(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            Field<Double, Double> field = new Field<Double, Double>(4, false, 4, false, string2, (int)var1_1, null, null);
            return field;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<Float, Float> forFloat(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            Field<Float, Float> field = new Field<Float, Float>(3, false, 3, false, string2, (int)var1_1, null, null);
            return field;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @KeepForSdk
        @NonNull
        public static Field<Integer, Integer> forInteger(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            Field<Integer, Integer> field = new Field<Integer, Integer>(0, false, 0, false, string2, (int)var1_1, null, null);
            return field;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<Long, Long> forLong(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            Field<Long, Long> field = new Field<Long, Long>(2, false, 2, false, string2, (int)var1_1, null, null);
            return field;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<String, String> forString(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            Field<String, String> field = new Field<String, String>(7, false, 7, false, string2, (int)var1_1, null, null);
            return field;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<HashMap<String, String>, HashMap<String, String>> forStringMap(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            Field<HashMap<String, String>, HashMap<String, String>> field = new Field<HashMap<String, String>, HashMap<String, String>>(10, false, 10, false, string2, (int)var1_1, null, null);
            return field;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field<ArrayList<String>, ArrayList<String>> forStrings(@NonNull String outputFieldName, int safeParcelableId) {
            void var1_1;
            String string2;
            Field<ArrayList<String>, ArrayList<String>> field = new Field<ArrayList<String>, ArrayList<String>>(7, true, 7, true, string2, (int)var1_1, null, null);
            return field;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public static Field withConverter(@NonNull String outputFieldName, int safeParcelableId, @NonNull FieldConverter<?, ?> converter, boolean inputArrayType) {
            void var1_1;
            String string2;
            void var3_3;
            void var2_2;
            var2_2.zaa();
            var2_2.zab();
            Field field = new Field(7, (boolean)var3_3, 0, false, string2, (int)var1_1, (Class<? extends FastJsonResponse>)((Class<FastJsonResponse>)null), var2_2);
            return field;
        }

        @NonNull
        public final String toString() {
            Objects.ToStringHelper toStringHelper = Objects.toStringHelper(this).add("versionCode", ((Field)this).zai).add("typeIn", ((Field)this).zaa).add("typeInArray", ((Field)this).zab).add("typeOut", ((Field)this).zac).add("typeOutArray", ((Field)this).zad).add("outputFieldName", ((Field)this).zae).add("safeParcelFieldId", ((Field)this).zaf).add("concreteTypeName", ((Field)this).zag());
            Class<? extends FastJsonResponse> clazz = ((Field)this).zag;
            if (clazz != null) {
                toStringHelper.add("concreteType.class", clazz.getCanonicalName());
            }
            if ((this = ((Field)this).zak) != null) {
                toStringHelper.add("converterName", this.getClass().getCanonicalName());
            }
            return toStringHelper.toString();
        }

        static {
            zaj zaj2;
            CREATOR = zaj2 = new zaj();
        }

        /*
         * Enabled aggressive block sorting
         */
        protected Field(int n, boolean bl, int n2, boolean bl2, @NonNull String string2, int n3, @Nullable Class<? extends FastJsonResponse> clazz, @Nullable FieldConverter<I, O> fieldConverter) {
            this.zai = 1;
            this.zaa = n;
            this.zab = bl;
            this.zac = n2;
            this.zad = bl2;
            this.zae = string2;
            this.zaf = n3;
            this.zag = clazz;
            this.zah = clazz == null ? null : clazz.getCanonicalName();
            this.zak = fieldConverter;
        }

        @Override
        public final void writeToParcel(@NonNull Parcel parcel, int n) {
            int n2 = SafeParcelWriter.beginObjectHeader(parcel);
            SafeParcelWriter.writeInt(parcel, 1, this.zai);
            SafeParcelWriter.writeInt(parcel, 2, this.zaa);
            SafeParcelWriter.writeBoolean(parcel, 3, this.zab);
            SafeParcelWriter.writeInt(parcel, 4, this.zac);
            SafeParcelWriter.writeBoolean(parcel, 5, this.zad);
            SafeParcelWriter.writeString(parcel, 6, this.zae, false);
            SafeParcelWriter.writeInt(parcel, 7, this.getSafeParcelableFieldId());
            SafeParcelWriter.writeString(parcel, 8, this.zag(), false);
            SafeParcelWriter.writeParcelable(parcel, 9, this.zaa(), n, false);
            SafeParcelWriter.finishObjectHeader(parcel, n2);
        }

        @Nullable
        final zaa zaa() {
            FieldConverter<I, O> fieldConverter = ((Field)((Object)fieldConverter)).zak;
            if (fieldConverter == null) {
                return null;
            }
            return com.google.android.gms.common.server.converter.zaa.zaa(fieldConverter);
        }

        @NonNull
        public final Field<I, O> zab() {
            Field<I, O> field = new Field<I, O>(this.zai, this.zaa, this.zab, this.zac, this.zad, this.zae, this.zaf, this.zah, this.zaa());
            return field;
        }

        @NonNull
        public final FastJsonResponse zad() throws InstantiationException, IllegalAccessException {
            Preconditions.checkNotNull(this.zag);
            Object object = this.zag;
            if (object == SafeParcelResponse.class) {
                Preconditions.checkNotNull(this.zah);
                Preconditions.checkNotNull(this.zaj, "The field mapping dictionary must be set if the concrete type is a SafeParcelResponse object.");
                object = new SafeParcelResponse(this.zaj, this.zah);
                return object;
            }
            return ((Class)object).newInstance();
        }

        @NonNull
        public final O zae(@Nullable I i) {
            Preconditions.checkNotNull(this.zak);
            return Preconditions.checkNotNull(this.zak.zac(i));
        }

        @NonNull
        public final I zaf(@NonNull O o) {
            Preconditions.checkNotNull(this.zak);
            return this.zak.zad(o);
        }

        @Nullable
        final String zag() {
            String string2 = ((Field)((Object)string2)).zah;
            if (string2 == null) {
                return null;
            }
            return string2;
        }

        @NonNull
        public final Map<String, Field<?, ?>> zah() {
            Preconditions.checkNotNull(this.zah);
            Preconditions.checkNotNull(this.zaj);
            return Preconditions.checkNotNull(this.zaj.zab(this.zah));
        }

        /*
         * Enabled aggressive block sorting
         */
        @SafeParcelable.Constructor
        Field(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=4) int n3, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) String string2, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) @Nullable String string3, @SafeParcelable.Param(id=9) @Nullable zaa zaa2) {
            this.zai = n;
            this.zaa = n2;
            this.zab = bl;
            this.zac = n3;
            this.zad = bl2;
            this.zae = string2;
            this.zaf = n4;
            if (string3 == null) {
                this.zag = null;
                this.zah = null;
            } else {
                this.zag = SafeParcelResponse.class;
                this.zah = string3;
            }
            if (zaa2 == null) {
                this.zak = null;
                return;
            }
            this.zak = zaa2.zab();
        }

        public final void zai(zan zan2) {
            this.zaj = zan2;
        }

        public final boolean zaj() {
            return this.zak != null;
        }
    }
}

