/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.database.Cursor;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.Timestamp;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.proto.MaybeDocument;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.BackgroundQueue;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Util;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

final class SQLiteRemoteDocumentCache
implements RemoteDocumentCache {
    @VisibleForTesting
    static final int BINDS_PER_STATEMENT = 9;
    private final SQLitePersistence db;
    private final LocalSerializer serializer;
    private IndexManager indexManager;

    SQLiteRemoteDocumentCache(SQLitePersistence persistence, LocalSerializer serializer2) {
        this.db = persistence;
        this.serializer = serializer2;
    }

    @Override
    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    @Override
    public void add(MutableDocument document, SnapshotVersion readTime) {
        Assert.hardAssert(!readTime.equals(SnapshotVersion.NONE), "Cannot add document to the RemoteDocumentCache with a read time of zero", new Object[0]);
        DocumentKey documentKey = document.getKey();
        Timestamp timestamp = readTime.getTimestamp();
        MaybeDocument message = this.serializer.encodeMaybeDocument(document);
        this.db.execute("INSERT OR REPLACE INTO remote_documents (path, path_length, read_time_seconds, read_time_nanos, contents) VALUES (?, ?, ?, ?, ?)", EncodedPath.encode(documentKey.getPath()), documentKey.getPath().length(), timestamp.getSeconds(), timestamp.getNanoseconds(), message.toByteArray());
        this.indexManager.addToCollectionParentIndex(document.getKey().getCollectionPath());
    }

    @Override
    public void removeAll(Collection<DocumentKey> keys) {
        if (keys.isEmpty()) {
            return;
        }
        ArrayList<Object> encodedPaths = new ArrayList<Object>();
        ImmutableSortedMap<DocumentKey, Document> deletedDocs = DocumentCollections.emptyDocumentMap();
        for (DocumentKey key : keys) {
            encodedPaths.add(EncodedPath.encode(key.getPath()));
            deletedDocs = deletedDocs.insert(key, MutableDocument.newNoDocument(key, SnapshotVersion.NONE));
        }
        SQLitePersistence.LongQuery longQuery = new SQLitePersistence.LongQuery(this.db, "DELETE FROM remote_documents WHERE path IN (", encodedPaths, ")");
        while (longQuery.hasMoreSubqueries()) {
            longQuery.executeNextSubquery();
        }
        this.indexManager.updateIndexEntries(deletedDocs);
    }

    @Override
    public MutableDocument get(DocumentKey documentKey) {
        return this.getAll(Collections.singletonList(documentKey)).get(documentKey);
    }

    @Override
    public Map<DocumentKey, MutableDocument> getAll(Iterable<DocumentKey> documentKeys) {
        HashMap<DocumentKey, MutableDocument> results = new HashMap<DocumentKey, MutableDocument>();
        ArrayList<Object> bindVars = new ArrayList<Object>();
        for (DocumentKey key : documentKeys) {
            bindVars.add(EncodedPath.encode(key.getPath()));
            results.put(key, MutableDocument.newInvalidDocument(key));
        }
        SQLitePersistence.LongQuery longQuery = new SQLitePersistence.LongQuery(this.db, "SELECT contents, read_time_seconds, read_time_nanos FROM remote_documents WHERE path IN (", bindVars, ") ORDER BY path");
        BackgroundQueue backgroundQueue = new BackgroundQueue();
        while (longQuery.hasMoreSubqueries()) {
            longQuery.performNextSubquery().forEach(row -> this.processRowInBackground(backgroundQueue, (Map<DocumentKey, MutableDocument>)results, (Cursor)row));
        }
        backgroundQueue.drain();
        return results;
    }

    @Override
    public Map<DocumentKey, MutableDocument> getAll(String collectionGroup, FieldIndex.IndexOffset offset, int limit) {
        List<ResourcePath> collectionParents = this.indexManager.getCollectionParents(collectionGroup);
        ArrayList<ResourcePath> collections = new ArrayList<ResourcePath>(collectionParents.size());
        for (ResourcePath collectionParent : collectionParents) {
            collections.add((ResourcePath)((Object)collectionParent.append(collectionGroup)));
        }
        if (collections.isEmpty()) {
            return Collections.emptyMap();
        }
        if (9 * collections.size() < 900) {
            return this.getAll(collections, offset, limit);
        }
        HashMap<DocumentKey, MutableDocument> results = new HashMap<DocumentKey, MutableDocument>();
        int pageSize = 100;
        for (int i = 0; i < collections.size(); i += pageSize) {
            results.putAll(this.getAll(collections.subList(i, Math.min(collections.size(), i + pageSize)), offset, limit));
        }
        return Util.firstNEntries(results, limit, FieldIndex.IndexOffset.DOCUMENT_COMPARATOR);
    }

    private Map<DocumentKey, MutableDocument> getAll(List<ResourcePath> collections, FieldIndex.IndexOffset offset, int count) {
        Timestamp readTime = offset.getReadTime().getTimestamp();
        DocumentKey documentKey = offset.getDocumentKey();
        StringBuilder sql = Util.repeatSequence("SELECT contents, read_time_seconds, read_time_nanos, path FROM remote_documents WHERE path >= ? AND path < ? AND path_length = ? AND (read_time_seconds > ? OR ( read_time_seconds = ? AND read_time_nanos > ?) OR ( read_time_seconds = ? AND read_time_nanos = ? and path > ?)) ", collections.size(), " UNION ");
        sql.append("ORDER BY read_time_seconds, read_time_nanos, path LIMIT ?");
        Object[] bindVars = new Object[9 * collections.size() + 1];
        int i = 0;
        for (ResourcePath collection : collections) {
            String prefixPath = EncodedPath.encode(collection);
            bindVars[i++] = prefixPath;
            bindVars[i++] = EncodedPath.prefixSuccessor(prefixPath);
            bindVars[i++] = collection.length() + 1;
            bindVars[i++] = readTime.getSeconds();
            bindVars[i++] = readTime.getSeconds();
            bindVars[i++] = readTime.getNanoseconds();
            bindVars[i++] = readTime.getSeconds();
            bindVars[i++] = readTime.getNanoseconds();
            bindVars[i++] = EncodedPath.encode(documentKey.getPath());
        }
        bindVars[i] = count;
        BackgroundQueue backgroundQueue = new BackgroundQueue();
        HashMap<DocumentKey, MutableDocument> results = new HashMap<DocumentKey, MutableDocument>();
        this.db.query(sql.toString()).binding(bindVars).forEach(row -> this.processRowInBackground(backgroundQueue, (Map<DocumentKey, MutableDocument>)results, (Cursor)row));
        backgroundQueue.drain();
        return results;
    }

    private void processRowInBackground(BackgroundQueue backgroundQueue, Map<DocumentKey, MutableDocument> results, Cursor row) {
        byte[] rawDocument = row.getBlob(0);
        int readTimeSeconds = row.getInt(1);
        int readTimeNanos = row.getInt(2);
        Executor executor = row.isLast() ? Executors.DIRECT_EXECUTOR : backgroundQueue;
        executor.execute(() -> {
            MutableDocument document = this.decodeMaybeDocument(rawDocument, readTimeSeconds, readTimeNanos);
            Map map = results;
            synchronized (map) {
                results.put(document.getKey(), document);
            }
        });
    }

    @Override
    public Map<DocumentKey, MutableDocument> getAll(ResourcePath collection, FieldIndex.IndexOffset offset) {
        return this.getAll(Collections.singletonList(collection), offset, Integer.MAX_VALUE);
    }

    private MutableDocument decodeMaybeDocument(byte[] bytes, int readTimeSeconds, int readTimeNanos) {
        try {
            return this.serializer.decodeMaybeDocument(MaybeDocument.parseFrom(bytes)).setReadTime(new SnapshotVersion(new Timestamp(readTimeSeconds, readTimeNanos)));
        }
        catch (InvalidProtocolBufferException e) {
            throw Assert.fail("MaybeDocument failed to parse: %s", new Object[]{e});
        }
    }
}

