/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import com.google.firebase.iid.zzai;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzas;
import com.google.firebase.iid.zzau;
import com.google.firebase.iid.zzax;
import java.io.IOException;

final class zzav
implements Runnable {
    private final long zza;
    private final PowerManager.WakeLock zzb;
    private final FirebaseInstanceId zzc;
    private final zzax zzd;

    @VisibleForTesting
    zzav(FirebaseInstanceId firebaseInstanceId, zzai zzai2, zzax zzax2, long l) {
        this.zzc = firebaseInstanceId;
        this.zzd = zzax2;
        this.zza = l;
        PowerManager powerManager = (PowerManager)this.zza().getSystemService("power");
        this.zzb = powerManager.newWakeLock(1, "fiid-sync");
        this.zzb.setReferenceCounted(false);
    }

    @Override
    @SuppressLint(value={"Wakelock"})
    public final void run() {
        block13: {
            if (zzaq.zza().zza(this.zza())) {
                this.zzb.acquire();
            }
            try {
                this.zzc.zza(true);
                if (!this.zzc.zzf()) {
                    this.zzc.zza(false);
                    return;
                }
                if (zzaq.zza().zzb(this.zza()) && !this.zzb()) {
                    new zzau(this).zza();
                    return;
                }
                if (this.zzc() && this.zzd.zza(this.zzc)) {
                    this.zzc.zza(false);
                } else {
                    this.zzc.zza(this.zza);
                }
                if (zzaq.zza().zza(this.zza())) {
                    this.zzb.release();
                    return;
                }
            }
            catch (IOException iOException) {
                String string2 = iOException.getMessage();
                Log.e("FirebaseInstanceId", new StringBuilder(93 + String.valueOf(string2).length()).append("Topic sync or token retrieval failed on hard failure exceptions: ").append(string2).append(". Won't retry the operation.").toString());
                this.zzc.zza(false);
                return;
            }
            finally {
                if (!zzaq.zza().zza(this.zza())) break block13;
                this.zzb.release();
            }
        }
    }

    @VisibleForTesting
    private final boolean zzc() throws IOException {
        zzas zzas2 = this.zzc.zzb();
        if (!this.zzc.zza(zzas2)) {
            return true;
        }
        try {
            String string2 = this.zzc.zzc();
            if (string2 == null) {
                Log.e("FirebaseInstanceId", "Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable("FirebaseInstanceId", 3)) {
                Log.d("FirebaseInstanceId", "Token successfully retrieved");
            }
            if (zzas2 == null || zzas2 != null && !string2.equals(zzas2.zza)) {
                String string3 = string2;
                zzav zzav2 = this;
                if ("[DEFAULT]".equals(zzav2.zzc.zza().getName())) {
                    if (Log.isLoggable("FirebaseInstanceId", 3)) {
                        String string4 = String.valueOf(zzav2.zzc.zza().getName());
                        Log.d("FirebaseInstanceId", string4.length() != 0 ? "Invoking onNewToken for app: ".concat(string4) : new String("Invoking onNewToken for app: "));
                    }
                    Intent intent = new Intent("com.google.firebase.messaging.NEW_TOKEN");
                    intent.putExtra("token", string3);
                    Intent intent2 = intent;
                    Context context = zzav2.zza();
                    Intent intent3 = intent2;
                    String string5 = "com.google.firebase.MESSAGING_EVENT";
                    Context context2 = context;
                    Intent intent4 = new Intent(context2, FirebaseInstanceIdReceiver.class);
                    intent4.setAction(string5);
                    intent4.putExtra("wrapped_intent", (Parcelable)((Object)intent3));
                    context.sendBroadcast(intent4);
                }
            }
            return true;
        }
        catch (IOException iOException) {
            if ("SERVICE_NOT_AVAILABLE".equals(iOException.getMessage()) || "INTERNAL_SERVER_ERROR".equals(iOException.getMessage())) {
                Log.w("FirebaseInstanceId", "Token retrieval failed without exception message. Will retry token retrieval");
                return false;
            }
            if (iOException.getMessage() == null) {
                String string6 = iOException.getMessage();
                Log.w("FirebaseInstanceId", new StringBuilder(52 + String.valueOf(string6).length()).append("Token retrieval failed: ").append(string6).append(". Will retry token retrieval").toString());
                return false;
            }
            throw iOException;
        }
        catch (SecurityException securityException) {
            Log.w("FirebaseInstanceId", "Token retrieval failed with SecurityException. Will retry token retrieval");
            return false;
        }
    }

    final Context zza() {
        return this.zzc.zza().getApplicationContext();
    }

    final boolean zzb() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zza().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

