/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.zzi;
import com.google.android.gms.common.zzj;
import com.google.android.gms.common.zzl;
import com.google.android.gms.common.zzm;
import com.google.android.gms.common.zzw;
import javax.annotation.Nullable;

@ShowFirstParty
@KeepForSdk
public class GoogleSignatureVerifier {
    @Nullable
    private static GoogleSignatureVerifier zza;
    private final Context zzb;
    private volatile String zzc;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static GoogleSignatureVerifier getInstance(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        Class<GoogleSignatureVerifier> clazz = GoogleSignatureVerifier.class;
        synchronized (clazz) {
            Context context2;
            GoogleSignatureVerifier googleSignatureVerifier = zza;
            if (googleSignatureVerifier != null) return zza;
            zzm.zzd(context2);
            zza = googleSignatureVerifier = new GoogleSignatureVerifier(context2);
            return zza;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public GoogleSignatureVerifier(@NonNull Context context) {
        this.zzb = context.getApplicationContext();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean isGooglePublicSignedPackage(@NonNull PackageInfo packageInfo) {
        void var1_1;
        if (packageInfo == null) {
            return false;
        }
        if (GoogleSignatureVerifier.zzb((PackageInfo)var1_1, false)) {
            return true;
        }
        if (GoogleSignatureVerifier.zzb((PackageInfo)var1_1, true)) {
            if (GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzb)) {
                return true;
            }
            Log.w("GoogleSignatureVerifier", "Test-keys aren't accepted on this build.");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isPackageGoogleSigned(@NonNull String callingPackage) {
        void var1_1;
        zzw this_ = ((GoogleSignatureVerifier)((Object)this_)).zzc((String)var1_1, false, false);
        this_.zze();
        return this_.zza;
    }

    /*
     * Unable to fully structure code
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isUidGoogleSigned(int uid) {
        var3_3 = this.zzb.getPackageManager().getPackagesForUid((int)var1_1);
        if (var3_3 == null || (var4_4 = var3_3.length) == 0) {
            this = zzw.zzc("no pkgs");
lbl4:
            // 3 sources

            while (true) {
                this.zze();
                return this.zza;
            }
        }
        var1_2 = null;
        for (var2_5 = 0; var2_5 < var4_4; ++var2_5) {
            var1_2 = super.zzc(var3_3[var2_5], false, false);
            if (!var1_2.zza) continue;
            this = var1_2;
            ** GOTO lbl4
        }
        Preconditions.checkNotNull(var1_2);
        this = var1_2;
        ** while (true)
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"PackageManagerGetSignatures"})
    private final zzw zzc(String string2, boolean bl, boolean bl2) {
        Object object;
        if (string2 == null) {
            return zzw.zzc("null pkg");
        }
        if (string2.equals(((GoogleSignatureVerifier)object2).zzc)) return zzw.zzb();
        if (zzm.zze()) {
            object = zzm.zzb(string2, GooglePlayServicesUtilLight.honorsDebugCertificates(((GoogleSignatureVerifier)object2).zzb), false, false);
        } else {
            object = ((GoogleSignatureVerifier)object2).zzb.getPackageManager().getPackageInfo(string2, 64);
            bl2 = GooglePlayServicesUtilLight.honorsDebugCertificates(((GoogleSignatureVerifier)object2).zzb);
            if (object == null) {
                object = zzw.zzc("null pkg");
            } else if (((PackageInfo)object).signatures == null || ((PackageInfo)object).signatures.length != 1) {
                object = zzw.zzc("single cert required");
            } else {
                zzj zzj2 = new zzj(((PackageInfo)object).signatures[0].toByteArray());
                String string3 = ((PackageInfo)object).packageName;
                zzw zzw2 = zzm.zza(string3, zzj2, bl2, false);
                object = zzw2.zza ? (((PackageInfo)object).applicationInfo != null ? ((((PackageInfo)object).applicationInfo.flags & 2) != 0 ? (zzm.zza((String)string3, (zzi)zzj2, (boolean)false, (boolean)true).zza ? zzw.zzc("debuggable release cert app rejected") : zzw2) : zzw2) : zzw2) : zzw2;
            }
        }
        if (!((zzw)object).zza) return object;
        ((GoogleSignatureVerifier)object2).zzc = string2;
        return object;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Object object2 = "no pkg ";
            if (string2.length() != 0) {
                object2 = ((String)object2).concat(string2);
                return zzw.zzd((String)object2, nameNotFoundException);
            }
            string2 = new String((String)object2);
            object2 = string2;
            return zzw.zzd((String)object2, nameNotFoundException);
        }
    }

    @Nullable
    static final zzi zza(PackageInfo packageInfo, zzi ... zziArray) {
        if (packageInfo.signatures == null) {
            return null;
        }
        if (packageInfo.signatures.length != 1) {
            Log.w("GoogleSignatureVerifier", "Package has more than one signature.");
            return null;
        }
        zzj zzj2 = new zzj(packageInfo.signatures[0].toByteArray());
        for (int i = 0; i < zziArray.length; ++i) {
            if (!zziArray[i].equals(zzj2)) continue;
            return zziArray[i];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzb(@NonNull PackageInfo object, boolean bl) {
        if (object != null && ((PackageInfo)object).signatures != null) {
            if (bl) {
                object = GoogleSignatureVerifier.zza((PackageInfo)object, zzl.zza);
            } else {
                zzi[] zziArray = new zzi[]{zzl.zza[0]};
                object = GoogleSignatureVerifier.zza((PackageInfo)object, zziArray);
            }
            if (object != null) {
                return true;
            }
        }
        return false;
    }
}

