/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.zzb;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

@KeepForSdk
public final class Preconditions {
    @KeepForSdk
    public static int checkNotZero(int value) {
        int n;
        if (value == 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Given Integer is zero");
            throw illegalArgumentException;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static int checkNotZero(int value, @NonNull Object errorMessage) {
        int n;
        if (value == 0) {
            void var1_2;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.valueOf(var1_2));
            throw illegalArgumentException;
        }
        return n;
    }

    @KeepForSdk
    public static long checkNotZero(long value) {
        long l;
        if (value == 0L) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Given Long is zero");
            throw illegalArgumentException;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static long checkNotZero(long value, @NonNull Object errorMessage) {
        long l;
        if (value == 0L) {
            void var2_1;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.valueOf(var2_1));
            throw illegalArgumentException;
        }
        return l;
    }

    @EnsuresNonNull(value={"#1"})
    @KeepForSdk
    @NonNull
    public static <T> T checkNotNull(@Nullable T reference) {
        Object object;
        if (reference == null) {
            object = new Object("null reference");
            throw object;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @EnsuresNonNull(value={"#1"})
    @KeepForSdk
    @NonNull
    public static <T> T checkNotNull(@NonNull T reference, @NonNull Object errorMessage) {
        Object object;
        if (reference == null) {
            void var1_1;
            object = new Object(String.valueOf(var1_1));
            throw object;
        }
        return object;
    }

    @EnsuresNonNull(value={"#1"})
    @KeepForSdk
    @NonNull
    public static String checkNotEmpty(@Nullable String string2) {
        Object object;
        if (TextUtils.isEmpty(string2)) {
            object = new IllegalArgumentException("Given String is empty or null");
            throw object;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @EnsuresNonNull(value={"#1"})
    @KeepForSdk
    @NonNull
    public static String checkNotEmpty(@Nullable String string2, @NonNull Object errorMessage) {
        Object object;
        if (TextUtils.isEmpty(string2)) {
            void var1_1;
            object = new IllegalArgumentException(String.valueOf(var1_1));
            throw object;
        }
        return object;
    }

    private Preconditions() {
        Object object = new AssertionError((Object)"Uninstantiable");
        throw object;
    }

    @KeepForSdk
    public static void checkArgument(boolean expression) {
        if (!expression) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            throw illegalArgumentException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkArgument(boolean expression, @NonNull Object errorMessage) {
        if (!expression) {
            void var1_2;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.valueOf(var1_2));
            throw illegalArgumentException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkArgument(boolean expression, @NonNull String errorMessage, Object ... errorMessageArgs) {
        if (!expression) {
            void var2_3;
            void var1_2;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format((String)var1_2, (Object[])var2_3));
            throw illegalArgumentException;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static void checkHandlerThread(@NonNull Handler handler) {
        String string2;
        Object object = Looper.myLooper();
        if (object == string2.getLooper()) {
            return;
        }
        object = object != null ? object.getThread().getName() : "null current looper";
        string2 = string2.getLooper().getThread().getName();
        String string3 = String.valueOf(string2);
        int n = string3.length();
        String string4 = String.valueOf(object);
        int n2 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n + 36 + n2);
        stringBuilder.append("Must be called on ");
        stringBuilder.append(string2);
        stringBuilder.append(" thread, but got ");
        stringBuilder.append((String)object);
        stringBuilder.append(".");
        IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
        throw illegalStateException;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkHandlerThread(@NonNull Handler handler, @NonNull String errorMessage) {
        Object object;
        if (Looper.myLooper() != object.getLooper()) {
            void var1_1;
            object = new IllegalStateException((String)var1_1);
            throw object;
        }
    }

    @KeepForSdk
    public static void checkMainThread(@NonNull String errorMessage) {
        if (!zzb.zza()) {
            String string2;
            IllegalStateException illegalStateException = new IllegalStateException(string2);
            throw illegalStateException;
        }
    }

    @KeepForSdk
    public static void checkNotMainThread() {
        Preconditions.checkNotMainThread("Must not be called on the main application thread");
    }

    @KeepForSdk
    public static void checkNotMainThread(@NonNull String errorMessage) {
        if (zzb.zza()) {
            String string2;
            IllegalStateException illegalStateException = new IllegalStateException(string2);
            throw illegalStateException;
        }
    }

    @KeepForSdk
    public static void checkState(boolean expression) {
        if (!expression) {
            IllegalStateException illegalStateException = new IllegalStateException();
            throw illegalStateException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkState(boolean expression, @NonNull Object errorMessage) {
        if (!expression) {
            void var1_2;
            IllegalStateException illegalStateException = new IllegalStateException(String.valueOf(var1_2));
            throw illegalStateException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkState(boolean expression, @NonNull String errorMessage, Object ... errorMessageArgs) {
        if (!expression) {
            void var2_3;
            void var1_2;
            IllegalStateException illegalStateException = new IllegalStateException(String.format((String)var1_2, (Object[])var2_3));
            throw illegalStateException;
        }
    }
}

