/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import android.content.Context;
import android.os.Build;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.remote.FirestoreChannel;
import com.google.firebase.firestore.remote.GrpcMetadataProvider;
import com.google.firebase.firestore.remote.RemoteSerializer;
import com.google.firebase.firestore.remote.WatchStream;
import com.google.firebase.firestore.remote.WriteStream;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Util;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.FirestoreGrpc;
import com.google.firestore.v1.WriteResult;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;

public class Datastore {
    static final String SSL_DEPENDENCY_ERROR_MESSAGE = "The Cloud Firestore client failed to establish a secure connection. This is likely a problem with your app, rather than with Cloud Firestore itself. See https://bit.ly/2XFpdma for instructions on how to enable TLS on Android 4.x devices.";
    static final Set<String> WHITE_LISTED_HEADERS = new HashSet<String>(Arrays.asList("date", "x-google-backends", "x-google-netmon-label", "x-google-service", "x-google-gfe-request-trace"));
    private final DatabaseInfo databaseInfo;
    private final RemoteSerializer serializer;
    private final AsyncQueue workerQueue;
    private final FirestoreChannel channel;

    public Datastore(DatabaseInfo databaseInfo, AsyncQueue workerQueue, CredentialsProvider<User> authProvider, CredentialsProvider<String> appCheckProvider, Context context, @Nullable GrpcMetadataProvider metadataProvider) {
        this.databaseInfo = databaseInfo;
        this.workerQueue = workerQueue;
        this.serializer = new RemoteSerializer(databaseInfo.getDatabaseId());
        this.channel = this.initializeChannel(databaseInfo, workerQueue, authProvider, appCheckProvider, context, metadataProvider);
    }

    FirestoreChannel initializeChannel(DatabaseInfo databaseInfo, AsyncQueue workerQueue, CredentialsProvider<User> authProvider, CredentialsProvider<String> appCheckProvider, Context context, @Nullable GrpcMetadataProvider metadataProvider) {
        return new FirestoreChannel(workerQueue, context, authProvider, appCheckProvider, databaseInfo, metadataProvider);
    }

    void shutdown() {
        this.channel.shutdown();
    }

    AsyncQueue getWorkerQueue() {
        return this.workerQueue;
    }

    DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    WatchStream createWatchStream(WatchStream.Callback listener) {
        return new WatchStream(this.channel, this.workerQueue, this.serializer, listener);
    }

    WriteStream createWriteStream(WriteStream.Callback listener) {
        return new WriteStream(this.channel, this.workerQueue, this.serializer, listener);
    }

    public Task<List<MutationResult>> commit(List<Mutation> mutations) {
        CommitRequest.Builder builder = CommitRequest.newBuilder();
        builder.setDatabase(this.serializer.databaseName());
        for (Mutation mutation : mutations) {
            builder.addWrites(this.serializer.encodeMutation(mutation));
        }
        return this.channel.runRpc(FirestoreGrpc.getCommitMethod(), (CommitRequest)builder.build()).continueWith(this.workerQueue.getExecutor(), task -> {
            if (!task.isSuccessful()) {
                if (task.getException() instanceof FirebaseFirestoreException && ((FirebaseFirestoreException)task.getException()).getCode() == FirebaseFirestoreException.Code.UNAUTHENTICATED) {
                    this.channel.invalidateToken();
                }
                throw task.getException();
            }
            CommitResponse response = (CommitResponse)task.getResult();
            SnapshotVersion commitVersion = this.serializer.decodeVersion(response.getCommitTime());
            int count = response.getWriteResultsCount();
            ArrayList<MutationResult> results = new ArrayList<MutationResult>(count);
            for (int i = 0; i < count; ++i) {
                WriteResult result = response.getWriteResults(i);
                results.add(this.serializer.decodeMutationResult(result, commitVersion));
            }
            return results;
        });
    }

    public Task<List<MutableDocument>> lookup(final List<DocumentKey> keys) {
        BatchGetDocumentsRequest.Builder builder = BatchGetDocumentsRequest.newBuilder();
        builder.setDatabase(this.serializer.databaseName());
        for (DocumentKey key : keys) {
            builder.addDocuments(this.serializer.encodeKey(key));
        }
        final ArrayList responses = new ArrayList();
        final TaskCompletionSource completionSource = new TaskCompletionSource();
        this.channel.runStreamingResponseRpc(FirestoreGrpc.getBatchGetDocumentsMethod(), (BatchGetDocumentsRequest)builder.build(), new FirestoreChannel.StreamingListener<BatchGetDocumentsResponse>(){

            @Override
            public void onMessage(BatchGetDocumentsResponse message) {
                responses.add(message);
                if (responses.size() == keys.size()) {
                    HashMap<DocumentKey, MutableDocument> resultMap = new HashMap<DocumentKey, MutableDocument>();
                    for (BatchGetDocumentsResponse response : responses) {
                        MutableDocument doc = Datastore.this.serializer.decodeMaybeDocument(response);
                        resultMap.put(doc.getKey(), doc);
                    }
                    ArrayList<MutableDocument> results = new ArrayList<MutableDocument>();
                    for (DocumentKey key : keys) {
                        results.add((MutableDocument)resultMap.get(key));
                    }
                    completionSource.trySetResult(results);
                }
            }

            @Override
            public void onClose(Status status) {
                if (status.isOk()) {
                    completionSource.trySetResult(Collections.emptyList());
                } else {
                    FirebaseFirestoreException exception = Util.exceptionFromStatus(status);
                    if (exception.getCode() == FirebaseFirestoreException.Code.UNAUTHENTICATED) {
                        Datastore.this.channel.invalidateToken();
                    }
                    completionSource.trySetException(exception);
                }
            }
        });
        return completionSource.getTask();
    }

    public static boolean isPermanentError(Status status) {
        return Datastore.isPermanentError(FirebaseFirestoreException.Code.fromValue(status.getCode().value()));
    }

    public static boolean isPermanentError(FirebaseFirestoreException.Code code) {
        switch (code) {
            case OK: {
                throw new IllegalArgumentException("Treated status OK as error");
            }
            case CANCELLED: 
            case UNKNOWN: 
            case DEADLINE_EXCEEDED: 
            case RESOURCE_EXHAUSTED: 
            case INTERNAL: 
            case UNAVAILABLE: 
            case UNAUTHENTICATED: {
                return false;
            }
            case INVALID_ARGUMENT: 
            case NOT_FOUND: 
            case ALREADY_EXISTS: 
            case PERMISSION_DENIED: 
            case FAILED_PRECONDITION: 
            case ABORTED: 
            case OUT_OF_RANGE: 
            case UNIMPLEMENTED: 
            case DATA_LOSS: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown gRPC status code: " + (Object)((Object)code));
    }

    public static boolean isMissingSslCiphers(Status status) {
        Status.Code code = status.getCode();
        Throwable t = status.getCause();
        boolean hasCipherError = false;
        if (t instanceof SSLHandshakeException && t.getMessage().contains("no ciphers available")) {
            hasCipherError = true;
        }
        return Build.VERSION.SDK_INT < 21 && code.equals((Object)Status.Code.UNAVAILABLE) && hasCipherError;
    }

    public static boolean isPermanentWriteError(Status status) {
        return Datastore.isPermanentError(status) && !status.getCode().equals((Object)Status.Code.ABORTED);
    }
}

