/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.firebase.functions.FirebaseFunctions;
import com.google.firebase.functions.HttpsCallOptions;
import com.google.firebase.functions.HttpsCallableResult;
import java.net.URL;
import java.util.concurrent.TimeUnit;

public class HttpsCallableReference {
    private final FirebaseFunctions functionsClient;
    private final String name;
    private final URL url;
    HttpsCallOptions options = new HttpsCallOptions();

    HttpsCallableReference(FirebaseFunctions functionsClient, String name) {
        this.functionsClient = functionsClient;
        this.name = name;
        this.url = null;
    }

    HttpsCallableReference(FirebaseFunctions functionsClient, URL url) {
        this.functionsClient = functionsClient;
        this.name = null;
        this.url = url;
    }

    @NonNull
    public Task<HttpsCallableResult> call(@Nullable Object data) {
        if (this.name != null) {
            return this.functionsClient.call(this.name, data, this.options);
        }
        return this.functionsClient.call(this.url, data, this.options);
    }

    @NonNull
    public Task<HttpsCallableResult> call() {
        if (this.name != null) {
            return this.functionsClient.call(this.name, null, this.options);
        }
        return this.functionsClient.call(this.url, null, this.options);
    }

    public void setTimeout(long timeout, @NonNull TimeUnit units) {
        this.options.setTimeout(timeout, units);
    }

    public long getTimeout() {
        return this.options.getTimeout();
    }

    @NonNull
    public HttpsCallableReference withTimeout(long timeout, @NonNull TimeUnit units) {
        HttpsCallableReference other = new HttpsCallableReference(this.functionsClient, this.name);
        other.setTimeout(timeout, units);
        return other;
    }
}

