/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import androidx.core.content.ContextCompat;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzas;
import com.google.firebase.iid.zzq;
import com.google.firebase.iid.zzs;
import com.google.firebase.iid.zzt;
import java.io.File;
import java.io.IOException;
import java.util.Map;

final class zzat {
    private final SharedPreferences zza;
    private final Context zzb;
    private final zzq zzc;
    @GuardedBy(value="this")
    private final Map<String, zzs> zzd;

    public zzat(Context context) {
        this(context, new zzq());
    }

    private zzat(Context context, zzq zzq2) {
        block4: {
            this.zzd = new ArrayMap();
            this.zzb = context;
            this.zza = context.getSharedPreferences("com.google.android.gms.appid", 0);
            this.zzc = zzq2;
            String string = "com.google.android.gms.appid-no-backup";
            zzat zzat2 = this;
            File file = ContextCompat.getNoBackupFilesDir(zzat2.zzb);
            File file2 = new File(file, string);
            if (!file2.exists()) {
                try {
                    if (file2.createNewFile() && !zzat2.zzc()) {
                        Log.i("FirebaseInstanceId", "App restored, clearing state");
                        zzat2.zzb();
                        FirebaseInstanceId.getInstance().zze();
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable("FirebaseInstanceId", 3)) break block4;
                    String string2 = String.valueOf(iOException.getMessage());
                    Log.d("FirebaseInstanceId", string2.length() != 0 ? "Error creating file in no backup dir: ".concat(string2) : new String("Error creating file in no backup dir: "));
                }
            }
        }
    }

    public final synchronized String zza() {
        return this.zza.getString("topic_operation_queue", "");
    }

    public final synchronized void zza(String string) {
        this.zza.edit().putString("topic_operation_queue", string).apply();
    }

    private final synchronized boolean zzc() {
        return this.zza.getAll().isEmpty();
    }

    private static String zzc(String string, String string2, String string3) {
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("|T|").append(string2).append("|").append(string3).toString();
    }

    static String zza(String string, String string2) {
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("|S|").append(string2).toString();
    }

    public final synchronized void zzb() {
        this.zzd.clear();
        zzq.zza(this.zzb);
        this.zza.edit().clear().commit();
    }

    public final synchronized zzas zza(String string, String string2, String string3) {
        return zzas.zza(this.zza.getString(zzat.zzc(string, string2, string3), null));
    }

    public final synchronized void zza(String string, String string2, String string3, String string4, String string5) {
        String string6 = zzas.zza(string4, string5, System.currentTimeMillis());
        if (string6 == null) {
            return;
        }
        SharedPreferences.Editor editor = this.zza.edit();
        editor.putString(zzat.zzc(string, string2, string3), string6);
        editor.commit();
    }

    public final synchronized void zzb(String string, String string2, String string3) {
        String string4 = zzat.zzc(string, string2, string3);
        SharedPreferences.Editor editor = this.zza.edit();
        editor.remove(string4);
        editor.commit();
    }

    public final synchronized zzs zzb(String string) {
        zzs zzs2 = this.zzd.get(string);
        if (zzs2 != null) {
            return zzs2;
        }
        try {
            zzs2 = this.zzc.zza(this.zzb, string);
        }
        catch (zzt zzt2) {
            Log.w("FirebaseInstanceId", "Stored data is corrupt, generating new identity");
            FirebaseInstanceId.getInstance().zze();
            zzs2 = this.zzc.zzb(this.zzb, string);
        }
        this.zzd.put(string, zzs2);
        return zzs2;
    }

    public final synchronized void zzc(String string) {
        String string2 = String.valueOf(string).concat("|T|");
        zzat zzat2 = this;
        SharedPreferences.Editor editor = zzat2.zza.edit();
        for (String string3 : zzat2.zza.getAll().keySet()) {
            if (!string3.startsWith(string2)) continue;
            editor.remove(string3);
        }
        editor.commit();
    }
}

