/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.FragmentManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.base.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zabw;
import com.google.android.gms.common.api.internal.zabx;
import com.google.android.gms.common.api.internal.zacc;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.zag;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.common.zaa;
import com.google.android.gms.common.zab;
import com.google.android.gms.common.zac;
import com.google.android.gms.internal.base.zad;
import com.google.android.gms.internal.base.zae;
import com.google.android.gms.internal.base.zao;
import com.google.android.gms.internal.base.zap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.errorprone.annotations.RestrictedInheritance;
import java.util.ArrayList;
import java.util.Arrays;

@RestrictedInheritance(explanation="Sub classing of GMS Core's APIs are restricted to GMS Core client libs and testing fakes.", link="go/gmscore-restrictedinheritance", allowedOnPath=".*java.*/com/google/android/gms.*", allowlistAnnotations={zad.class, zae.class})
public class GoogleApiAvailability
extends GoogleApiAvailabilityLight {
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @NonNull
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    private static final Object zaa;
    private static final GoogleApiAvailability zab;
    @GuardedBy(value="mLock")
    private String zac;

    /*
     * WARNING - void declaration
     */
    @Override
    @ShowFirstParty
    @KeepForSdk
    public int getClientVersion(@NonNull Context context) {
        void var1_1;
        return super.getClientVersion((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @HideFirstParty
    public int isGooglePlayServicesAvailable(@NonNull Context context) {
        void var1_1;
        return super.isGooglePlayServicesAvailable((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ShowFirstParty
    @KeepForSdk
    public int isGooglePlayServicesAvailable(@NonNull Context context, int minApkVersion) {
        void var2_2;
        void var1_1;
        return super.isGooglePlayServicesAvailable((Context)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Dialog getErrorDialog(@NonNull Activity activity, int errorCode, int requestCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getErrorDialog((Activity)var1_1, (int)var2_2, (int)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Dialog getErrorDialog(@NonNull Fragment fragment, int errorCode, int requestCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getErrorDialog((Fragment)var1_1, (int)var2_2, (int)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Dialog getErrorDialog(@NonNull Activity activity, int errorCode, int requestCode, @Nullable DialogInterface.OnCancelListener cancelListener) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return this.zaa((Context)var1_1, (int)var2_2, zag.zab((Activity)var1_1, this.getErrorResolutionIntent((Context)var1_1, (int)var2_2, "d"), (int)var3_3), (DialogInterface.OnCancelListener)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Dialog getErrorDialog(@NonNull Fragment fragment, int errorCode, int requestCode, @Nullable DialogInterface.OnCancelListener cancelListener) {
        void var4_4;
        void var3_3;
        void var1_1;
        void var2_2;
        Object object = fragment.requireContext();
        object = this.getErrorResolutionIntent((Context)object, (int)var2_2, "d");
        return this.zaa(var1_1.requireContext(), (int)var2_2, zag.zac((Fragment)var1_1, (Intent)object, (int)var3_3), (DialogInterface.OnCancelListener)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(@NonNull Context context, @NonNull ConnectionResult result) {
        void var1_1;
        void var2_2;
        if (result.hasResolution()) {
            return var2_2.getResolution();
        }
        return this.getErrorResolutionPendingIntent((Context)var1_1, var2_2.getErrorCode(), 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(@NonNull Context context, int errorCode, int requestCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return super.getErrorResolutionPendingIntent((Context)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(@Nullable Context context, int errorCode, @Nullable String trackingSource) {
        void var3_3;
        void var2_2;
        void var1_1;
        return super.getErrorResolutionIntent((Context)var1_1, (int)var2_2, (String)var3_3);
    }

    @NonNull
    public static GoogleApiAvailability getInstance() {
        return zab;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> checkApiAvailability(@NonNull GoogleApi<?> api, GoogleApi<?> ... apis) {
        void var2_2;
        return GoogleApiAvailability.zai(api, (HasApiKey[])var2_2).onSuccessTask(com.google.android.gms.common.zab.zaa);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> checkApiAvailability(@NonNull HasApiKey<?> api, HasApiKey<?> ... apis) {
        void var2_2;
        return GoogleApiAvailability.zai(api, (HasApiKey[])var2_2).onSuccessTask(com.google.android.gms.common.zaa.zaa);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @MainThread
    @NonNull
    public Task<Void> makeGooglePlayServicesAvailable(@NonNull Activity activity) {
        zacc zacc2;
        int n = GOOGLE_PLAY_SERVICES_VERSION_CODE;
        Preconditions.checkMainThread("makeGooglePlayServicesAvailable must be called from the main thread");
        int n2 = this.isGooglePlayServicesAvailable((Context)((Object)zacc2), n);
        if (n2 == 0) {
            return Tasks.forResult(null);
        }
        zacc2 = zacc.zaa((Activity)((Object)zacc2));
        ConnectionResult connectionResult = new ConnectionResult(n2, null);
        zacc2.zah(connectionResult, 0);
        return zacc2.zad();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NonNull
    public final String getErrorString(int errorCode) {
        void var1_1;
        return super.getErrorString((int)var1_1);
    }

    static {
        Object object;
        zaa = object = new Object();
        zab = object = new GoogleApiAvailability();
        GOOGLE_PLAY_SERVICES_VERSION_CODE = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=26)
    public void setDefaultNotificationChannelId(@NonNull Context context, @NonNull String notificationChannelId) {
        void var2_3;
        Object object;
        if (PlatformVersion.isAtLeastO()) {
            Preconditions.checkNotNull(((NotificationManager)Preconditions.checkNotNull(((Context)object).getSystemService("notification"))).getNotificationChannel((String)var2_3));
        }
        object = zaa;
        synchronized (object) {
            this.zac = var2_3;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void showErrorNotification(@NonNull Context context, int errorCode) {
        void var2_2;
        void var1_1;
        this.zae((Context)var1_1, (int)var2_2, null, this.getErrorResolutionPendingIntent((Context)var1_1, (int)var2_2, 0, "n"));
    }

    /*
     * WARNING - void declaration
     */
    public void showErrorNotification(@NonNull Context context, @NonNull ConnectionResult result) {
        void var2_2;
        void var1_1;
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent((Context)var1_1, (ConnectionResult)var2_2);
        this.zae((Context)var1_1, var2_2.getErrorCode(), null, pendingIntent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isUserResolvableError(int errorCode) {
        void var1_1;
        return super.isUserResolvableError((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean showErrorDialogFragment(@NonNull Activity activity, int errorCode, int requestCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.showErrorDialogFragment((Activity)var1_1, (int)var2_2, (int)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean showErrorDialogFragment(@NonNull Activity activity, int errorCode, int requestCode, @Nullable DialogInterface.OnCancelListener cancelListener) {
        void var4_5;
        void var3_4;
        void var2_2;
        void var1_1;
        Dialog dialog = this.getErrorDialog((Activity)var1_1, (int)var2_2, (int)var3_4, (DialogInterface.OnCancelListener)var4_5);
        if (dialog == null) {
            return false;
        }
        this.zad((Activity)var1_1, dialog, "GooglePlayServicesErrorDialog", (DialogInterface.OnCancelListener)var4_5);
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    final Dialog zaa(@NonNull Context object, int n, zag zag2, @Nullable DialogInterface.OnCancelListener object2) {
        String string2;
        String string3;
        void var2_5;
        if (var2_5 == false) {
            return null;
        }
        GoogleApiAvailability googleApiAvailability = new TypedValue();
        object.getTheme().resolveAttribute(16843529, (TypedValue)googleApiAvailability, true);
        googleApiAvailability = "Theme.Dialog.Alert".equals(((Context)object).getResources().getResourceEntryName(((TypedValue)googleApiAvailability).resourceId)) ? new AlertDialog.Builder((Context)object, 5) : null;
        if (googleApiAvailability == null) {
            googleApiAvailability = new AlertDialog.Builder((Context)object);
        }
        googleApiAvailability.setMessage(com.google.android.gms.common.internal.zac.zad((Context)object, (int)var2_5));
        if (string3 != null) {
            googleApiAvailability.setOnCancelListener((DialogInterface.OnCancelListener)((Object)string3));
        }
        if ((string3 = com.google.android.gms.common.internal.zac.zac((Context)object, (int)var2_5)) != null) {
            void var3_7;
            googleApiAvailability.setPositiveButton(string3, (DialogInterface.OnClickListener)var3_7);
        }
        if ((string2 = com.google.android.gms.common.internal.zac.zag((Context)object, (int)var2_5)) != null) {
            googleApiAvailability.setTitle(string2);
        }
        Object[] objectArray = new Object[]{(int)var2_5};
        String string4 = String.format("Creating dialog for Google Play services availability issue. ConnectionResult=%s", objectArray);
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
        Log.w("GoogleApiAvailability", string4, illegalArgumentException);
        return googleApiAvailability.create();
    }

    @NonNull
    public final Dialog zab(@NonNull Activity activity, @NonNull DialogInterface.OnCancelListener onCancelListener) {
        Object object = new ProgressBar((Context)activity, null, 16842874);
        object.setIndeterminate(true);
        object.setVisibility(0);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setView((View)object);
        builder.setMessage((CharSequence)com.google.android.gms.common.internal.zac.zad(activity, 18));
        builder.setPositiveButton((CharSequence)"", null);
        object = builder.create();
        this.zad(activity, (Dialog)object, "GooglePlayServicesUpdatingDialog", onCancelListener);
        return object;
    }

    @Nullable
    public final zabx zac(Context context, zabw zabw2) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        zabx zabx2 = new zabx(zabw2);
        zao.zaa(context, zabx2, intentFilter);
        zabx2.zaa(context);
        if (!this.isUninstalledAppPossiblyUpdating(context, GOOGLE_PLAY_SERVICES_PACKAGE)) {
            zabw2.zaa();
            zabx2.zab();
            return null;
        }
        return zabx2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zad(Activity activity, Dialog dialog, String string2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        block2: {
            try {
                boolean bl = activity instanceof FragmentActivity;
                if (!bl) break block2;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                break block2;
            }
            Object object = (FragmentActivity)activity;
            object = ((FragmentActivity)object).getSupportFragmentManager();
            SupportErrorDialogFragment.newInstance(dialog, onCancelListener).show((androidx.fragment.app.FragmentManager)object, string2);
            return;
        }
        FragmentManager fragmentManager = activity.getFragmentManager();
        ErrorDialogFragment.newInstance(dialog, onCancelListener).show(fragmentManager, string2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @TargetApi(value=20)
    final void zae(Context object, int n, @Nullable String object2, @Nullable PendingIntent object3) {
        int n2;
        object2 = new Object[]{n, null};
        object2 = String.format("GMS core API Availability. ConnectionResult=%s, tag=%s", (Object[])object2);
        Object object4 = new IllegalArgumentException();
        Log.w("GoogleApiAvailability", (String)object2, (Throwable)object4);
        if (n == 18) {
            ((GoogleApiAvailability)object6).zaf((Context)object);
            return;
        }
        if (object3 == null) {
            if (n != 6) return;
            Log.w("GoogleApiAvailability", "Missing resolution for ConnectionResult.RESOLUTION_REQUIRED. Call GoogleApiAvailability#showErrorNotification(Context, ConnectionResult) instead.");
            return;
        }
        object2 = com.google.android.gms.common.internal.zac.zaf((Context)object, n);
        object4 = com.google.android.gms.common.internal.zac.zae((Context)object, n);
        Resources resources = ((Context)object).getResources();
        NotificationManager notificationManager = (NotificationManager)Preconditions.checkNotNull(((Context)object).getSystemService("notification"));
        Object object5 = new NotificationCompat.Builder((Context)object);
        object5 = ((NotificationCompat.Builder)object5).setLocalOnly(true);
        object5 = ((NotificationCompat.Builder)object5).setAutoCancel(true);
        object2 = ((NotificationCompat.Builder)object5).setContentTitle((CharSequence)object2);
        object5 = new NotificationCompat.BigTextStyle();
        object2 = ((NotificationCompat.Builder)object2).setStyle(((NotificationCompat.BigTextStyle)object5).bigText((CharSequence)object4));
        if (DeviceProperties.isWearable((Context)object)) {
            Preconditions.checkState(PlatformVersion.isAtLeastKitKatWatch());
            ((NotificationCompat.Builder)object2).setSmallIcon(((Context)object).getApplicationInfo().icon).setPriority(2);
            if (DeviceProperties.isWearableWithoutPlayStore((Context)object)) {
                ((NotificationCompat.Builder)object2).addAction(R.drawable.common_full_open_on_phone, resources.getString(R.string.common_open_on_phone), (PendingIntent)object3);
            } else {
                ((NotificationCompat.Builder)object2).setContentIntent((PendingIntent)object3);
            }
        } else {
            ((NotificationCompat.Builder)object2).setSmallIcon(17301642).setTicker(resources.getString(R.string.common_google_play_services_notification_ticker)).setWhen(System.currentTimeMillis()).setContentIntent((PendingIntent)object3).setContentText((CharSequence)object4);
        }
        if (PlatformVersion.isAtLeastO()) {
            block18: {
                Preconditions.checkState(PlatformVersion.isAtLeastO());
                object3 = zaa;
                // MONITORENTER : object3
                Object object6 = ((GoogleApiAvailability)object6).zac;
                // MONITOREXIT : object3
                if (object6 != null) break block18;
                object6 = "com.google.android.gms.availability";
                object3 = notificationManager.getNotificationChannel((String)object6);
                object = com.google.android.gms.common.internal.zac.zab((Context)object);
                if (object3 == null) {
                    object3 = new NotificationChannel((String)object6, (CharSequence)object, 4);
                    notificationManager.createNotificationChannel((NotificationChannel)object3);
                } else if (!((String)object).contentEquals(object3.getName())) {
                    object3.setName((CharSequence)object);
                    notificationManager.createNotificationChannel((NotificationChannel)object3);
                }
            }
            ((NotificationCompat.Builder)object2).setChannelId((String)object6);
        }
        object = ((NotificationCompat.Builder)object2).build();
        switch (n) {
            default: {
                n2 = 39789;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                GooglePlayServicesUtilLight.sCanceledAvailabilityNotification.set(false);
                n2 = 10436;
            }
        }
        notificationManager.notify(n2, (Notification)object);
        return;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object3
                throw throwable;
            }
        }
    }

    final void zaf(Context context) {
        zac zac2 = new zac(this, context);
        zac2.sendEmptyMessageDelayed(1, 120000L);
    }

    public final boolean zag(@NonNull Activity activity, @NonNull LifecycleFragment object, int n, int n2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        if ((object = this.zaa(activity, n, zag.zad((LifecycleFragment)object, this.getErrorResolutionIntent(activity, n, "d"), 2), onCancelListener)) == null) {
            return false;
        }
        this.zad(activity, (Dialog)object, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public final boolean zah(@NonNull Context context, @NonNull ConnectionResult connectionResult, int n) {
        if (InstantApps.isInstantApp(context)) {
            return false;
        }
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            this.zae(context, connectionResult.getErrorCode(), null, PendingIntent.getActivity((Context)context, (int)0, (Intent)GoogleApiActivity.zaa(context, pendingIntent, n, true), (int)(zap.zaa | 0x8000000)));
            return true;
        }
        return false;
    }

    @NonNull
    public static final Task zai(@NonNull HasApiKey hasApiKey, HasApiKey ... hasApiKeyArray) {
        Preconditions.checkNotNull(hasApiKey, "Requested API must not be null.");
        int n = hasApiKeyArray.length;
        for (int i = 0; i < n; ++i) {
            Preconditions.checkNotNull(hasApiKeyArray[i], "Requested API must not be null.");
        }
        ArrayList<HasApiKey> arrayList = new ArrayList<HasApiKey>(hasApiKeyArray.length + 1);
        arrayList.add(hasApiKey);
        arrayList.addAll(Arrays.asList(hasApiKeyArray));
        return GoogleApiManager.zal().zao(arrayList);
    }
}

