/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.view.filter;

import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.core.view.Change;
import com.google.firebase.database.core.view.filter.ChildChangeAccumulator;
import com.google.firebase.database.core.view.filter.NodeFilter;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.Index;
import com.google.firebase.database.snapshot.IndexedNode;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;

public class IndexedFilter
implements NodeFilter {
    private final Index index;

    public IndexedFilter(Index index) {
        this.index = index;
    }

    @Override
    public IndexedNode updateChild(IndexedNode indexedNode, ChildKey key, Node newChild, Path affectedPath, NodeFilter.CompleteChildSource source, ChildChangeAccumulator optChangeAccumulator) {
        Utilities.hardAssert(indexedNode.hasIndex(this.index), "The index must match the filter");
        Node snap = indexedNode.getNode();
        Node oldChild = snap.getImmediateChild(key);
        if (oldChild.getChild(affectedPath).equals(newChild.getChild(affectedPath)) && oldChild.isEmpty() == newChild.isEmpty()) {
            return indexedNode;
        }
        if (optChangeAccumulator != null) {
            if (newChild.isEmpty()) {
                if (snap.hasChild(key)) {
                    optChangeAccumulator.trackChildChange(Change.childRemovedChange(key, oldChild));
                } else {
                    Utilities.hardAssert(snap.isLeafNode(), "A child remove without an old child only makes sense on a leaf node");
                }
            } else if (oldChild.isEmpty()) {
                optChangeAccumulator.trackChildChange(Change.childAddedChange(key, newChild));
            } else {
                optChangeAccumulator.trackChildChange(Change.childChangedChange(key, newChild, oldChild));
            }
        }
        if (snap.isLeafNode() && newChild.isEmpty()) {
            return indexedNode;
        }
        return indexedNode.updateChild(key, newChild);
    }

    @Override
    public IndexedNode updateFullNode(IndexedNode oldSnap, IndexedNode newSnap, ChildChangeAccumulator optChangeAccumulator) {
        Utilities.hardAssert(newSnap.hasIndex(this.index), "Can't use IndexedNode that doesn't have filter's index");
        if (optChangeAccumulator != null) {
            for (NamedNode child : oldSnap.getNode()) {
                if (newSnap.getNode().hasChild(child.getName())) continue;
                optChangeAccumulator.trackChildChange(Change.childRemovedChange(child.getName(), child.getNode()));
            }
            if (!newSnap.getNode().isLeafNode()) {
                for (NamedNode child : newSnap.getNode()) {
                    if (oldSnap.getNode().hasChild(child.getName())) {
                        Node oldChild = oldSnap.getNode().getImmediateChild(child.getName());
                        if (oldChild.equals(child.getNode())) continue;
                        optChangeAccumulator.trackChildChange(Change.childChangedChange(child.getName(), child.getNode(), oldChild));
                        continue;
                    }
                    optChangeAccumulator.trackChildChange(Change.childAddedChange(child.getName(), child.getNode()));
                }
            }
        }
        return newSnap;
    }

    @Override
    public IndexedNode updatePriority(IndexedNode oldSnap, Node newPriority) {
        if (oldSnap.getNode().isEmpty()) {
            return oldSnap;
        }
        return oldSnap.updatePriority(newPriority);
    }

    @Override
    public NodeFilter getIndexedFilter() {
        return this;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public boolean filtersNodes() {
        return false;
    }
}

