/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class TargetIndexMatcher {
    private final String collectionId;
    private final SortedSet<FieldFilter> inequalityFilters;
    private final List<FieldFilter> equalityFilters;
    private final List<OrderBy> orderBys;

    public TargetIndexMatcher(Target target) {
        this.collectionId = target.getCollectionGroup() != null ? target.getCollectionGroup() : target.getPath().getLastSegment();
        this.orderBys = target.getOrderBy();
        this.inequalityFilters = new TreeSet<FieldFilter>((lhs, rhs) -> lhs.getField().compareTo(rhs.getField()));
        this.equalityFilters = new ArrayList<FieldFilter>();
        for (Filter filter : target.getFilters()) {
            FieldFilter fieldFilter = (FieldFilter)filter;
            if (fieldFilter.isInequality()) {
                this.inequalityFilters.add(fieldFilter);
                continue;
            }
            this.equalityFilters.add(fieldFilter);
        }
    }

    public boolean hasMultipleInequality() {
        return this.inequalityFilters.size() > 1;
    }

    public boolean servedByIndex(FieldIndex index) {
        int segmentIndex;
        Assert.hardAssert(index.getCollectionGroup().equals(this.collectionId), "Collection IDs do not match", new Object[0]);
        if (this.hasMultipleInequality()) {
            return false;
        }
        FieldIndex.Segment arraySegment = index.getArraySegment();
        if (arraySegment != null && !this.hasMatchingEqualityFilter(arraySegment)) {
            return false;
        }
        Iterator<OrderBy> orderBys = this.orderBys.iterator();
        List<FieldIndex.Segment> segments = index.getDirectionalSegments();
        HashSet<String> equalitySegments = new HashSet<String>();
        for (segmentIndex = 0; segmentIndex < segments.size() && this.hasMatchingEqualityFilter(segments.get(segmentIndex)); ++segmentIndex) {
            equalitySegments.add(segments.get(segmentIndex).getFieldPath().canonicalString());
        }
        if (segmentIndex == segments.size()) {
            return true;
        }
        if (this.inequalityFilters.size() > 0) {
            FieldIndex.Segment segment;
            FieldFilter inequalityFilter = this.inequalityFilters.first();
            if (!(equalitySegments.contains(inequalityFilter.getField().canonicalString()) || this.matchesFilter(inequalityFilter, segment = segments.get(segmentIndex)) && this.matchesOrderBy(orderBys.next(), segment))) {
                return false;
            }
            ++segmentIndex;
        }
        while (segmentIndex < segments.size()) {
            FieldIndex.Segment segment = segments.get(segmentIndex);
            if (!orderBys.hasNext() || !this.matchesOrderBy(orderBys.next(), segment)) {
                return false;
            }
            ++segmentIndex;
        }
        return true;
    }

    @Nullable
    public FieldIndex buildTargetIndex() {
        if (this.hasMultipleInequality()) {
            return null;
        }
        HashSet<FieldPath> uniqueFields = new HashSet<FieldPath>();
        ArrayList<FieldIndex.Segment> segments = new ArrayList<FieldIndex.Segment>();
        for (FieldFilter filter : this.equalityFilters) {
            boolean isArrayOperator;
            if (filter.getField().isKeyField()) continue;
            boolean bl = isArrayOperator = filter.getOperator().equals((Object)FieldFilter.Operator.ARRAY_CONTAINS) || filter.getOperator().equals((Object)FieldFilter.Operator.ARRAY_CONTAINS_ANY);
            if (isArrayOperator) {
                segments.add(FieldIndex.Segment.create(filter.getField(), FieldIndex.Segment.Kind.CONTAINS));
                continue;
            }
            if (uniqueFields.contains(filter.getField())) continue;
            uniqueFields.add(filter.getField());
            segments.add(FieldIndex.Segment.create(filter.getField(), FieldIndex.Segment.Kind.ASCENDING));
        }
        for (OrderBy orderBy : this.orderBys) {
            if (orderBy.getField().isKeyField() || uniqueFields.contains(orderBy.getField())) continue;
            uniqueFields.add(orderBy.getField());
            segments.add(FieldIndex.Segment.create(orderBy.getField(), orderBy.getDirection() == OrderBy.Direction.ASCENDING ? FieldIndex.Segment.Kind.ASCENDING : FieldIndex.Segment.Kind.DESCENDING));
        }
        return FieldIndex.create(-1, this.collectionId, segments, FieldIndex.INITIAL_STATE);
    }

    private boolean hasMatchingEqualityFilter(FieldIndex.Segment segment) {
        for (FieldFilter filter : this.equalityFilters) {
            if (!this.matchesFilter(filter, segment)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesFilter(@Nullable FieldFilter filter, FieldIndex.Segment segment) {
        if (filter == null || !filter.getField().equals(segment.getFieldPath())) {
            return false;
        }
        boolean isArrayOperator = filter.getOperator().equals((Object)FieldFilter.Operator.ARRAY_CONTAINS) || filter.getOperator().equals((Object)FieldFilter.Operator.ARRAY_CONTAINS_ANY);
        return segment.getKind().equals((Object)FieldIndex.Segment.Kind.CONTAINS) == isArrayOperator;
    }

    private boolean matchesOrderBy(OrderBy orderBy, FieldIndex.Segment segment) {
        if (!orderBy.getField().equals(segment.getFieldPath())) {
            return false;
        }
        return segment.getKind().equals((Object)FieldIndex.Segment.Kind.ASCENDING) && orderBy.getDirection().equals((Object)OrderBy.Direction.ASCENDING) || segment.getKind().equals((Object)FieldIndex.Segment.Kind.DESCENDING) && orderBy.getDirection().equals((Object)OrderBy.Direction.DESCENDING);
    }
}

