/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.os.Looper;
import android.os.PowerManager;
import android.os.UserManager;
import com.google.firebase.FirebasePlatform;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 52\u00020\u0001:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\"J\u0016\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.J\u0016\u0010/\u001a\u0002002\u0006\u0010*\u001a\u00020\"2\u0006\u00101\u001a\u00020.J\u0012\u00102\u001a\u00020\u00012\n\u00103\u001a\u0006\u0012\u0002\b\u000304J\u000e\u00102\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\"R\u0011\u0010\u0003\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00066"}, d2={"Landroid/content/Context;", "", "()V", "applicationContext", "getApplicationContext", "()Landroid/content/Context;", "applicationInfo", "Landroid/content/pm/ApplicationInfo;", "getApplicationInfo", "()Landroid/content/pm/ApplicationInfo;", "classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "()Ljava/lang/ClassLoader;", "contentResolver", "Landroid/content/ContentResolver;", "getContentResolver", "()Landroid/content/ContentResolver;", "isDeviceProtectedStorage", "", "()Z", "mainLooper", "Landroid/os/Looper;", "getMainLooper", "()Landroid/os/Looper;", "noBackupFilesDir", "Ljava/io/File;", "getNoBackupFilesDir", "()Ljava/io/File;", "packageManager", "Landroid/content/pm/PackageManager;", "getPackageManager", "()Landroid/content/pm/PackageManager;", "packageName", "", "getPackageName", "()Ljava/lang/String;", "resources", "Landroid/content/res/Resources;", "getResources", "()Landroid/content/res/Resources;", "getDatabasePath", "name", "getDir", "path", "flags", "", "getSharedPreferences", "Landroid/content/SharedPreferences;", "mode", "getSystemService", "clazz", "Ljava/lang/Class;", "Companion", "firebase-java-sdk"})
public class Context {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationInfo applicationInfo = new ApplicationInfo();
    @NotNull
    private static final String CONNECTIVITY_SERVICE = "connectivity";

    @NotNull
    public final Context getApplicationContext() {
        return this;
    }

    @NotNull
    public final Looper getMainLooper() {
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"getMainLooper(...)");
        return looper;
    }

    @NotNull
    public final String getPackageName() {
        return "app.teamhub.TeamHub";
    }

    @NotNull
    public final Resources getResources() {
        return new Resources();
    }

    @NotNull
    public final PackageManager getPackageManager() {
        return new PackageManager();
    }

    public final boolean isDeviceProtectedStorage() {
        return false;
    }

    @NotNull
    public final File getNoBackupFilesDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    @NotNull
    public final ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getSystemClassLoader(...)");
        return classLoader;
    }

    @NotNull
    public final ContentResolver getContentResolver() {
        return new ContentResolver();
    }

    @NotNull
    public final ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @NotNull
    public final SharedPreferences getSharedPreferences(@NotNull String name, int mode) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new SharedPreferences(){

            public boolean contains(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                switch (key) {
                    case "firebase_data_collection_default_enabled": {
                        return false;
                    }
                    case "auto_init": {
                        return false;
                    }
                    case "firebase_messaging_auto_init_enabled": {
                        return false;
                    }
                    case "fire-fst": {
                        return false;
                    }
                    case "fire-global": {
                        CharSequence charSequence = FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().retrieve(key);
                        return !(charSequence == null || charSequence.length() == 0);
                    }
                }
                throw new IllegalArgumentException(key);
            }

            @Nullable
            public String getString(@NotNull String key, @Nullable String defaultValue) {
                String string;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                if (Intrinsics.areEqual((Object)key, (Object)"last-used-date")) {
                    string = FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().retrieve(key);
                    if (string == null) {
                        string = defaultValue;
                    }
                } else if (StringsKt.contains$default((CharSequence)key, (CharSequence)"|T|", (boolean)false, (int)2, null)) {
                    string = null;
                } else if (StringsKt.startsWith$default((String)key, (String)"com.google.firebase.auth.FIREBASE_USER", (boolean)false, (int)2, null)) {
                    string = FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().retrieve(key);
                    if (string == null) {
                        string = defaultValue;
                    }
                } else {
                    throw new IllegalArgumentException(key);
                }
                return string;
            }

            public long getLong(@Nullable String key, long defaultValue) {
                if (Intrinsics.areEqual((Object)key, (Object)"fire-global")) {
                    String string = FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().retrieve(key);
                    return string != null ? Long.parseLong(string) : defaultValue;
                }
                throw new IllegalArgumentException(key);
            }

            @NotNull
            public Map<String, String> getAll() {
                return MapsKt.emptyMap();
            }

            @NotNull
            public SharedPreferences.Editor edit() {
                return new SharedPreferences.Editor(){

                    @NotNull
                    public SharedPreferences.Editor putLong(@Nullable String key, long value) {
                        if (!Intrinsics.areEqual((Object)key, (Object)"fire-global")) {
                            throw new IllegalArgumentException(key);
                        }
                        FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().store(key, String.valueOf(value));
                        return this;
                    }

                    @NotNull
                    public SharedPreferences.Editor putString(@Nullable String key, @Nullable String value) {
                        if (Intrinsics.areEqual((Object)key, (Object)"last-used-date")) {
                            FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().store(key, String.valueOf(value));
                        } else {
                            String string = key;
                            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"com.google.firebase.auth.FIREBASE_USER", (boolean)false, (int)2, null) : false;
                            if (bl) {
                                FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().store(key, String.valueOf(value));
                            } else {
                                throw new IllegalArgumentException(key);
                            }
                        }
                        return this;
                    }

                    public boolean commit() {
                        return true;
                    }

                    public void apply() {
                    }
                };
            }
        };
    }

    @NotNull
    public final Object getSystemService(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name;
        if (Intrinsics.areEqual((Object)string, (Object)"power")) {
            return new PowerManager();
        }
        if (Intrinsics.areEqual((Object)string, (Object)CONNECTIVITY_SERVICE)) {
            return ConnectivityManager.Companion.getInstance();
        }
        throw new IllegalArgumentException(name);
    }

    @NotNull
    public final Object getSystemService(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (Intrinsics.areEqual(clazz, UserManager.class)) {
            return new UserManager();
        }
        throw new IllegalArgumentException(clazz.toString());
    }

    @NotNull
    public final File getDir(@NotNull String path, int flags2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new File(System.getProperty("java.io.tmpdir"));
    }

    @NotNull
    public final File getDatabasePath(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().getDatabasePath(name);
    }

    @NotNull
    public static final String getCONNECTIVITY_SERVICE() {
        return Companion.getCONNECTIVITY_SERVICE();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroid/content/Context$Companion;", "", "()V", "CONNECTIVITY_SERVICE", "", "getCONNECTIVITY_SERVICE$annotations", "getCONNECTIVITY_SERVICE", "()Ljava/lang/String;", "firebase-java-sdk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCONNECTIVITY_SERVICE() {
            return CONNECTIVITY_SERVICE;
        }

        @JvmStatic
        public static /* synthetic */ void getCONNECTIVITY_SERVICE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

