/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.PackageVerificationResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.zzac;
import com.google.android.gms.common.zzad;
import com.google.android.gms.common.zzae;
import com.google.android.gms.common.zzn;
import com.google.android.gms.common.zzx;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.RestrictedInheritance;

@CheckReturnValue
@RestrictedInheritance(explanation="Sub classing of GMS Core's APIs are restricted to testing fakes.", link="go/gmscore-restrictedinheritance", allowedOnPath=".*javatests.*/com/google/android/gms/common/.*")
@ShowFirstParty
@KeepForSdk
public class PackageSignatureVerifier {
    @Nullable
    private static zzad zza;
    private volatile zzac zzb;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public PackageVerificationResult queryPackageSignatureVerified(@NonNull Context context, @NonNull String callingPackage) {
        void var2_2;
        boolean bl = GooglePlayServicesUtilLight.honorsDebugCertificates(context);
        PackageSignatureVerifier.zza();
        if (!zzn.zzf()) {
            Object object = new zzae();
            throw object;
        }
        String string2 = true != bl ? "-0" : "-1";
        string2 = String.valueOf(var2_2).concat(string2);
        if (((PackageSignatureVerifier)object).zzb != null && zzac.zzb(((PackageSignatureVerifier)object).zzb).equals(string2)) {
            return zzac.zza(((PackageSignatureVerifier)object).zzb);
        }
        PackageSignatureVerifier.zza();
        zzx zzx2 = zzn.zzc((String)var2_2, bl, false, false);
        if (zzx2.zza) {
            zzac zzac2;
            ((PackageSignatureVerifier)object).zzb = zzac2 = new zzac(string2, PackageVerificationResult.zzd((String)var2_2, zzx2.zzd));
            return zzac.zza(((PackageSignatureVerifier)object).zzb);
        }
        Preconditions.checkNotNull(zzx2.zzb);
        return PackageVerificationResult.zza((String)var2_2, zzx2.zzb, zzx2.zzc);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public PackageVerificationResult queryPackageSignatureVerifiedWithRetry(@NonNull Context context, @NonNull String callingPackage) {
        void var2_2;
        void var1_1;
        try {
            PackageVerificationResult packageVerificationResult = ((PackageSignatureVerifier)this).queryPackageSignatureVerified((Context)var1_1, (String)var2_2);
            packageVerificationResult.zzb();
            return packageVerificationResult;
        }
        catch (SecurityException securityException) {
            if (!((PackageVerificationResult)(this = ((PackageSignatureVerifier)this).queryPackageSignatureVerified((Context)var1_1, (String)var2_2))).zzc()) return this;
            Log.e("PkgSignatureVerifier", "Got flaky result during package signature verification", securityException);
            return this;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static zzad zza() {
        Class<zzad> clazz = zzad.class;
        synchronized (clazz) {
            zzad zzad2 = zza;
            if (zzad2 != null) return zza;
            zza = zzad2 = new zzad();
            return zza;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

