/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.index;

import com.google.firebase.firestore.index.DirectionalIndexByteEncoder;
import com.google.firebase.firestore.index.OrderedCodeWriter;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.protobuf.ByteString;

public class IndexByteEncoder {
    private final OrderedCodeWriter orderedCode = new OrderedCodeWriter();
    private final AscendingIndexByteEncoder ascending = new AscendingIndexByteEncoder();
    private final DescendingIndexByteEncoder descending = new DescendingIndexByteEncoder();

    public void seed(byte[] encodedBytes) {
        this.orderedCode.seed(encodedBytes);
    }

    public DirectionalIndexByteEncoder forKind(FieldIndex.Segment.Kind kind) {
        if (kind.equals((Object)FieldIndex.Segment.Kind.DESCENDING)) {
            return this.descending;
        }
        return this.ascending;
    }

    public byte[] getEncodedBytes() {
        return this.orderedCode.encodedBytes();
    }

    public void reset() {
        this.orderedCode.reset();
    }

    class DescendingIndexByteEncoder
    extends DirectionalIndexByteEncoder {
        DescendingIndexByteEncoder() {
        }

        @Override
        public void writeBytes(ByteString val) {
            IndexByteEncoder.this.orderedCode.writeBytesDescending(val);
        }

        @Override
        public void writeString(String val) {
            IndexByteEncoder.this.orderedCode.writeUtf8Descending(val);
        }

        @Override
        public void writeLong(long val) {
            IndexByteEncoder.this.orderedCode.writeSignedLongDescending(val);
        }

        @Override
        public void writeDouble(double val) {
            IndexByteEncoder.this.orderedCode.writeDoubleDescending(val);
        }

        @Override
        public void writeInfinity() {
            IndexByteEncoder.this.orderedCode.writeInfinityDescending();
        }
    }

    class AscendingIndexByteEncoder
    extends DirectionalIndexByteEncoder {
        AscendingIndexByteEncoder() {
        }

        @Override
        public void writeBytes(ByteString val) {
            IndexByteEncoder.this.orderedCode.writeBytesAscending(val);
        }

        @Override
        public void writeString(String val) {
            IndexByteEncoder.this.orderedCode.writeUtf8Ascending(val);
        }

        @Override
        public void writeLong(long val) {
            IndexByteEncoder.this.orderedCode.writeSignedLongAscending(val);
        }

        @Override
        public void writeDouble(double val) {
            IndexByteEncoder.this.orderedCode.writeDoubleAscending(val);
        }

        @Override
        public void writeInfinity() {
            IndexByteEncoder.this.orderedCode.writeInfinityAscending();
        }
    }
}

