/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.fonts.Font;
import android.graphics.fonts.FontFamily;
import android.graphics.fonts.FontStyle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.graphics.TypefaceCompatBaseImpl;
import androidx.core.provider.FontsContractCompat;
import java.io.IOException;
import java.io.InputStream;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=29)
public class TypefaceCompatApi29Impl
extends TypefaceCompatBaseImpl {
    @Override
    protected FontsContractCompat.FontInfo findBestInfo(FontsContractCompat.FontInfo[] fonts, int style) {
        throw new RuntimeException("Do not use this function in API 29 or later.");
    }

    @Override
    protected Typeface createFromInputStream(Context context, InputStream is) {
        throw new RuntimeException("Do not use this function in API 29 or later.");
    }

    @Override
    @Nullable
    public Typeface createFromFontInfo(Context context, @Nullable CancellationSignal cancellationSignal, @NonNull FontsContractCompat.FontInfo[] fonts, int style) {
        FontFamily.Builder familyBuilder = null;
        ContentResolver resolver = context.getContentResolver();
        for (FontsContractCompat.FontInfo font : fonts) {
            try (ParcelFileDescriptor pfd = resolver.openFileDescriptor(font.getUri(), "r", cancellationSignal);){
                if (pfd == null) continue;
                Font platformFont = new Font.Builder(pfd).setWeight(font.getWeight()).setSlant(font.isItalic() ? 1 : 0).setTtcIndex(font.getTtcIndex()).build();
                if (familyBuilder == null) {
                    familyBuilder = new FontFamily.Builder(platformFont);
                    continue;
                }
                familyBuilder.addFont(platformFont);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (familyBuilder == null) {
            return null;
        }
        FontStyle defaultStyle = new FontStyle((style & 1) != 0 ? 700 : 400, (style & 2) != 0 ? 1 : 0);
        return new Typeface.CustomFallbackBuilder(familyBuilder.build()).setStyle(defaultStyle).build();
    }

    @Override
    @Nullable
    public Typeface createFromFontFamilyFilesResourceEntry(Context context, FontResourcesParserCompat.FontFamilyFilesResourceEntry familyEntry, Resources resources, int style) {
        FontFamily.Builder familyBuilder = null;
        for (FontResourcesParserCompat.FontFileResourceEntry entry : familyEntry.getEntries()) {
            try {
                Font platformFont = new Font.Builder(resources, entry.getResourceId()).setWeight(entry.getWeight()).setSlant(entry.isItalic() ? 1 : 0).setTtcIndex(entry.getTtcIndex()).setFontVariationSettings(entry.getVariationSettings()).build();
                if (familyBuilder == null) {
                    familyBuilder = new FontFamily.Builder(platformFont);
                    continue;
                }
                familyBuilder.addFont(platformFont);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (familyBuilder == null) {
            return null;
        }
        FontStyle defaultStyle = new FontStyle((style & 1) != 0 ? 700 : 400, (style & 2) != 0 ? 1 : 0);
        return new Typeface.CustomFallbackBuilder(familyBuilder.build()).setStyle(defaultStyle).build();
    }

    @Override
    @Nullable
    public Typeface createFromResourcesFontFile(Context context, Resources resources, int id2, String path, int style) {
        FontFamily family = null;
        try {
            family = new FontFamily.Builder(new Font.Builder(resources, id2).build()).build();
        }
        catch (IOException e) {
            return null;
        }
        FontStyle defaultStyle = new FontStyle((style & 1) != 0 ? 700 : 400, (style & 2) != 0 ? 1 : 0);
        return new Typeface.CustomFallbackBuilder(family).setStyle(defaultStyle).build();
    }
}

