/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.os.Build;
import android.view.View;
import android.widget.ListView;
import androidx.annotation.NonNull;

public final class ListViewCompat {
    public static void scrollListBy(@NonNull ListView listView, int y) {
        if (Build.VERSION.SDK_INT >= 19) {
            listView.scrollListBy(y);
        } else {
            int firstPosition = listView.getFirstVisiblePosition();
            if (firstPosition == -1) {
                return;
            }
            View firstView = listView.getChildAt(0);
            if (firstView == null) {
                return;
            }
            int newTop = firstView.getTop() - y;
            listView.setSelectionFromTop(firstPosition, newTop);
        }
    }

    public static boolean canScrollList(@NonNull ListView listView, int direction) {
        if (Build.VERSION.SDK_INT >= 19) {
            return listView.canScrollList(direction);
        }
        int childCount = listView.getChildCount();
        if (childCount == 0) {
            return false;
        }
        int firstPosition = listView.getFirstVisiblePosition();
        if (direction > 0) {
            int lastBottom = listView.getChildAt(childCount - 1).getBottom();
            int lastPosition = firstPosition + childCount;
            return lastPosition < listView.getCount() || lastBottom > listView.getHeight() - listView.getListPaddingBottom();
        }
        int firstTop = listView.getChildAt(0).getTop();
        return firstPosition > 0 || firstTop < listView.getListPaddingTop();
    }

    private ListViewCompat() {
    }
}

