/*
 * Decompiled with CFR 0.152.
 */
package androidx.loader.app;

import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.loader.app.LoaderManagerImpl;
import androidx.loader.content.Loader;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public abstract class LoaderManager {
    @NonNull
    public static <T extends LifecycleOwner & ViewModelStoreOwner> LoaderManager getInstance(@NonNull T owner) {
        return new LoaderManagerImpl(owner, ((ViewModelStoreOwner)owner).getViewModelStore());
    }

    @MainThread
    @NonNull
    public abstract <D> Loader<D> initLoader(int var1, @Nullable Bundle var2, @NonNull LoaderCallbacks<D> var3);

    @MainThread
    @NonNull
    public abstract <D> Loader<D> restartLoader(int var1, @Nullable Bundle var2, @NonNull LoaderCallbacks<D> var3);

    @MainThread
    public abstract void destroyLoader(int var1);

    @Nullable
    public abstract <D> Loader<D> getLoader(int var1);

    public abstract void markForRedelivery();

    @Deprecated
    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public static void enableDebugLogging(boolean enabled) {
        LoaderManagerImpl.DEBUG = enabled;
    }

    public boolean hasRunningLoaders() {
        return false;
    }

    public static interface LoaderCallbacks<D> {
        @MainThread
        @NonNull
        public Loader<D> onCreateLoader(int var1, @Nullable Bundle var2);

        @MainThread
        public void onLoadFinished(@NonNull Loader<D> var1, D var2);

        @MainThread
        public void onLoaderReset(@NonNull Loader<D> var1);
    }
}

