/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.firebase.firestore.FieldPath;
import java.util.Objects;

public abstract class AggregateField {
    @Nullable
    private final FieldPath fieldPath;
    @NonNull
    private final String operator;
    @NonNull
    private final String alias;

    private AggregateField(@Nullable FieldPath fieldPath, @NonNull String operator) {
        this.fieldPath = fieldPath;
        this.operator = operator;
        this.alias = operator + (fieldPath == null ? "" : "_" + fieldPath);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public String getFieldPath() {
        return this.fieldPath == null ? "" : this.fieldPath.toString();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public String getAlias() {
        return this.alias;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public String getOperator() {
        return this.operator;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggregateField)) {
            return false;
        }
        AggregateField otherAggregateField = (AggregateField)other;
        if (this.fieldPath == null || otherAggregateField.fieldPath == null) {
            return this.fieldPath == null && otherAggregateField.fieldPath == null;
        }
        return this.operator.equals(otherAggregateField.getOperator()) && this.getFieldPath().equals(otherAggregateField.getFieldPath());
    }

    public int hashCode() {
        return Objects.hash(this.getOperator(), this.getFieldPath());
    }

    @NonNull
    public static CountAggregateField count() {
        return new CountAggregateField();
    }

    @NonNull
    public static SumAggregateField sum(@NonNull String field) {
        return new SumAggregateField(FieldPath.fromDotSeparatedPath(field));
    }

    @NonNull
    public static SumAggregateField sum(@NonNull FieldPath fieldPath) {
        return new SumAggregateField(fieldPath);
    }

    @NonNull
    public static AverageAggregateField average(@NonNull String field) {
        return new AverageAggregateField(FieldPath.fromDotSeparatedPath(field));
    }

    @NonNull
    public static AverageAggregateField average(@NonNull FieldPath fieldPath) {
        return new AverageAggregateField(fieldPath);
    }

    public static class AverageAggregateField
    extends AggregateField {
        private AverageAggregateField(@NonNull FieldPath fieldPath) {
            super(fieldPath, "average");
        }
    }

    public static class SumAggregateField
    extends AggregateField {
        private SumAggregateField(@NonNull FieldPath fieldPath) {
            super(fieldPath, "sum");
        }
    }

    public static class CountAggregateField
    extends AggregateField {
        private CountAggregateField() {
            super(null, "count");
        }
    }
}

