/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Value;
import java.util.List;

public final class Bound {
    private final boolean inclusive;
    private final List<Value> position;

    public Bound(List<Value> position, boolean inclusive) {
        this.position = position;
        this.inclusive = inclusive;
    }

    public List<Value> getPosition() {
        return this.position;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public String positionString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Value indexComponent : this.position) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append(Values.canonicalId(indexComponent));
        }
        return builder.toString();
    }

    public boolean sortsBeforeDocument(List<OrderBy> orderBy, Document document) {
        int comparison = this.compareToDocument(orderBy, document);
        return this.inclusive ? comparison <= 0 : comparison < 0;
    }

    public boolean sortsAfterDocument(List<OrderBy> orderBy, Document document) {
        int comparison = this.compareToDocument(orderBy, document);
        return this.inclusive ? comparison >= 0 : comparison > 0;
    }

    private int compareToDocument(List<OrderBy> orderBy, Document document) {
        Assert.hardAssert(this.position.size() <= orderBy.size(), "Bound has more components than query's orderBy", new Object[0]);
        int comparison = 0;
        for (int i = 0; i < this.position.size(); ++i) {
            OrderBy orderByComponent = orderBy.get(i);
            Value component = this.position.get(i);
            if (orderByComponent.field.equals(FieldPath.KEY_PATH)) {
                Assert.hardAssert(Values.isReferenceValue(component), "Bound has a non-key value where the key path is being used %s", component);
                comparison = DocumentKey.fromName(component.getReferenceValue()).compareTo(document.getKey());
            } else {
                Value docValue = document.getField(orderByComponent.getField());
                Assert.hardAssert(docValue != null, "Field should exist since document matched the orderBy already.", new Object[0]);
                comparison = Values.compare(component, docValue);
            }
            if (orderByComponent.getDirection().equals((Object)OrderBy.Direction.DESCENDING)) {
                comparison *= -1;
            }
            if (comparison != 0) break;
        }
        return comparison;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bound bound = (Bound)o;
        return this.inclusive == bound.inclusive && this.position.equals(bound.position);
    }

    public int hashCode() {
        int result = this.inclusive ? 1 : 0;
        result = 31 * result + this.position.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Bound(inclusive=");
        builder.append(this.inclusive);
        builder.append(", position=");
        for (int i = 0; i < this.position.size(); ++i) {
            if (i > 0) {
                builder.append(" and ");
            }
            builder.append(Values.canonicalId(this.position.get(i)));
        }
        builder.append(")");
        return builder.toString();
    }
}

