/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import android.database.CursorWindow;
import android.database.sqlite.SQLiteCustomFunction;
import java.text.Collator;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sqlite.Collation;
import org.sqlite.Function;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteOpenMode;
import org.sqlite.core.NativeDB;
import org.sqlite.core.NativeKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\b\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\n\u001a&\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0005\u001a\u001e\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a&\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a6\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0016\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010 \u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010!\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010#\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010$\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0006\u0010%\u001a\u00020\u001c\u001a\u0016\u0010&\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a.\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u001c\u001a\u0016\u0010-\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u000e\u001a\u0016\u0010/\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00100\u001a\u000201\u001a\u0016\u00102\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u000e\u001a\u0016\u00104\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u001c\u001a\u0016\u00106\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a&\u00107\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u00069"}, d2={"BindBlob", "", "connectionPtr", "Lorg/sqlite/core/NativeDB;", "statementPtr", "", "index", "value", "", "BindDouble", "", "BindLong", "BindNull", "BindString", "", "Cancel", "", "Close", "", "Execute", "ExecuteForBlobFileDescriptor", "ExecuteForChangedRowCount", "ExecuteForCursorWindow", "win", "Landroid/database/CursorWindow;", "startPos", "iRowRequired", "countAllRows", "", "ExecuteForLastInsertedRowId", "ExecuteForLong", "ExecuteForString", "FinalizeStatement", "GetColumnCount", "GetColumnName", "GetDbLookaside", "GetParameterCount", "HasCodec", "IsReadOnly", "Open", "path", "openFlags", "label", "enableTrace", "enableProfile", "PrepareStatement", "sql", "RegisterCustomFunction", "function", "Landroid/database/sqlite/SQLiteCustomFunction;", "RegisterLocalizedCollators", "locale", "ResetCancel", "cancelable", "ResetStatementAndClearBindings", "copyRowToWindow", "iRow", "firebase-java-sdk"})
@SourceDebugExtension(value={"SMAP\nnative.kt\nKotlin\n*S Kotlin\n*F\n+ 1 native.kt\norg/sqlite/core/NativeKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,201:1\n2206#2,7:202\n*S KotlinDebug\n*F\n+ 1 native.kt\norg/sqlite/core/NativeKt\n*L\n30#1:202,7\n*E\n"})
public final class NativeKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final NativeDB Open(@NotNull String path, int openFlags, @NotNull String label, boolean enableTrace, boolean enableProfile) {
        void $this$reduce$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        NativeDB.load();
        NativeDB db = new NativeDB(null, path, new SQLiteConfig());
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(0, 31))), (Function1)Open.flags.1.INSTANCE), (Function1)((Function1)new Function1<Integer, Boolean>(openFlags){
            final /* synthetic */ int $openFlags;
            {
                this.$openFlags = $openFlags;
                super(1);
            }

            @NotNull
            public final Boolean invoke(int it) {
                return (it & this.$openFlags) > 0;
            }
        })), (Function1)((Function1)new Function1<Integer, Integer>(db){
            final /* synthetic */ NativeDB $db;
            {
                this.$db = $db;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                return switch (it) {
                    case 0x10000000 -> SQLiteOpenMode.READWRITE.flag | SQLiteOpenMode.CREATE.flag;
                    case 1 -> {
                        this.$db.getConfig().setExplicitReadOnly(true);
                        yield SQLiteOpenMode.READONLY.flag;
                    }
                    case 0 -> SQLiteOpenMode.READWRITE.flag;
                    default -> {
                        String v1 = Integer.toString(it, CharsKt.checkRadix((int)16));
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toString(...)");
                        String var2_2 = "Unknown openFlag " + v1;
                        throw new NotImplementedError("An operation is not implemented: " + var2_2);
                    }
                };
            }
        }));
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void flag;
            int n = ((Number)iterator$iv.next()).intValue();
            int acc = ((Number)accumulator$iv).intValue();
            boolean bl = false;
            accumulator$iv = acc | flag;
        }
        int flags2 = ((Number)accumulator$iv).intValue();
        db.open(path, flags2);
        return db;
    }

    public static final void Close(@NotNull NativeDB connectionPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        connectionPtr._close();
    }

    public static final void RegisterCustomFunction(@NotNull NativeDB connectionPtr, @NotNull SQLiteCustomFunction function) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Function callback2 = new Function(){

            protected void xFunc() {
                Object[] args = new String[this.args()];
                Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((Object[])args);
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    args[it] = this.value_text(it);
                }
            }
        };
        connectionPtr.create_function(function.name, callback2, function.numArgs, 0);
    }

    public static final void RegisterLocalizedCollators(@NotNull NativeDB connectionPtr, @NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Collator collator = Collator.getInstance(Locale.forLanguageTag(locale));
        connectionPtr.create_collation(locale, new Collation(collator){
            final /* synthetic */ Collator $collator;
            {
                this.$collator = $collator;
            }

            protected int xCompare(@Nullable String str1, @Nullable String str2) {
                return this.$collator.compare(str1, str2);
            }
        });
    }

    public static final long PrepareStatement(@NotNull NativeDB connectionPtr, @NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return connectionPtr.prepare_utf8(NativeDB.stringToUtf8ByteArray((String)sql));
    }

    public static final int FinalizeStatement(@NotNull NativeDB connectionPtr, long statementPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        return connectionPtr.finalize(statementPtr);
    }

    public static final int GetParameterCount(@NotNull NativeDB connectionPtr, long statementPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        return connectionPtr.bind_parameter_count(statementPtr);
    }

    public static final boolean IsReadOnly(@NotNull NativeDB connectionPtr, long statementPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        return connectionPtr.getConfig().isExplicitReadOnly();
    }

    public static final int GetColumnCount(@NotNull NativeDB connectionPtr, long statementPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        return connectionPtr.column_count(statementPtr);
    }

    @Nullable
    public static final String GetColumnName(@NotNull NativeDB connectionPtr, long statementPtr, int index) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        return connectionPtr.column_name(statementPtr, index);
    }

    public static final int BindNull(@NotNull NativeDB connectionPtr, long statementPtr, int index) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        return connectionPtr.bind_null(statementPtr, index);
    }

    public static final int BindLong(@NotNull NativeDB connectionPtr, long statementPtr, int index, long value) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        return connectionPtr.bind_long(statementPtr, index, value);
    }

    public static final int BindDouble(@NotNull NativeDB connectionPtr, long statementPtr, int index, double value) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        return connectionPtr.bind_double(statementPtr, index, value);
    }

    public static final int BindString(@NotNull NativeDB connectionPtr, long statementPtr, int index, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return connectionPtr.bind_text(statementPtr, index, value);
    }

    public static final int BindBlob(@NotNull NativeDB connectionPtr, long statementPtr, int index, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return connectionPtr.bind_blob(statementPtr, index, value);
    }

    public static final void ResetStatementAndClearBindings(@NotNull NativeDB connectionPtr, long statementPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        connectionPtr.reset(statementPtr);
        connectionPtr.clear_bindings(statementPtr);
    }

    public static final int Execute(@NotNull NativeDB connectionPtr, long statementPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        return connectionPtr.step(statementPtr);
    }

    public static final long ExecuteForLong(@NotNull NativeDB connectionPtr, long statementPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        connectionPtr.step(statementPtr);
        return connectionPtr.column_long(statementPtr, 0);
    }

    @Nullable
    public static final String ExecuteForString(@NotNull NativeDB connectionPtr, long statementPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        connectionPtr.step(statementPtr);
        return connectionPtr.column_text(statementPtr, 0);
    }

    public static final int GetDbLookaside(@NotNull NativeDB connectionPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        return 0;
    }

    @NotNull
    public static final Void Cancel(@NotNull NativeDB connectionPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public static final Void ResetCancel(@NotNull NativeDB connectionPtr, boolean cancelable) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        throw new NotImplementedError(null, 1, null);
    }

    public static final boolean HasCodec() {
        return false;
    }

    public static final int ExecuteForBlobFileDescriptor(@NotNull NativeDB connectionPtr, long statementPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        throw new NotImplementedError(null, 1, null);
    }

    public static final int ExecuteForChangedRowCount(@NotNull NativeDB connectionPtr, long statementPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        connectionPtr.step(statementPtr);
        return (int)connectionPtr.changes();
    }

    public static final long ExecuteForLastInsertedRowId(@NotNull NativeDB connectionPtr, long statementPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        connectionPtr.step(statementPtr);
        return connectionPtr.column_long(statementPtr, 0);
    }

    public static final long ExecuteForCursorWindow(@NotNull NativeDB connectionPtr, long statementPtr, @NotNull CursorWindow win, int startPos, int iRowRequired, boolean countAllRows) {
        int rc;
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        Intrinsics.checkNotNullParameter((Object)win, (String)"win");
        if (!win.setNumColumns(connectionPtr.column_count(statementPtr))) {
            return 0L;
        }
        int nRow = 0;
        int iStart = startPos;
        boolean bOk = true;
        while (connectionPtr.step(statementPtr) == 100) {
            if (nRow >= iStart && bOk && !(bOk = NativeKt.copyRowToWindow(connectionPtr, win, nRow - iStart, statementPtr))) {
                if (nRow <= iRowRequired) {
                    bOk = win.setNumColumns(connectionPtr.column_count(statementPtr));
                    if (!bOk) {
                        connectionPtr.reset(statementPtr);
                        return 0L;
                    }
                    iStart = nRow;
                    bOk = NativeKt.copyRowToWindow(connectionPtr, win, nRow - iStart, statementPtr);
                }
                if (!bOk && !countAllRows) break;
            }
            ++nRow;
        }
        if ((rc = connectionPtr.reset(statementPtr)) != 0) {
            NativeDB.throwex((int)rc, (String)connectionPtr.errmsg());
            return 0L;
        }
        return (long)iStart << 32 | (long)nRow;
    }

    public static final boolean copyRowToWindow(@NotNull NativeDB connectionPtr, @NotNull CursorWindow win, int iRow, long statementPtr) {
        Intrinsics.checkNotNullParameter((Object)connectionPtr, (String)"connectionPtr");
        Intrinsics.checkNotNullParameter((Object)win, (String)"win");
        int nCol = connectionPtr.column_count(statementPtr);
        boolean i = false;
        boolean bOk = false;
        bOk = win.allocRow();
        for (int i2 = 0; i2 < nCol; ++i2) {
            int type = connectionPtr.column_type(statementPtr, i2);
            switch (type) {
                case 5: {
                    win.putNull(iRow, i2);
                    break;
                }
                case 1: {
                    win.putLong(connectionPtr.column_long(statementPtr, i2), iRow, i2);
                    break;
                }
                case 2: {
                    win.putDouble(connectionPtr.column_double(statementPtr, i2), iRow, i2);
                    break;
                }
                case 3: {
                    win.putString(connectionPtr.column_text(statementPtr, i2), iRow, i2);
                    break;
                }
                case 4: {
                    win.putBlob(connectionPtr.column_blob(statementPtr, i2), iRow, i2);
                    break;
                }
                default: {
                    String string = "Unknown column type: " + type;
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
            }
            if (bOk) continue;
            win.freeLastRow();
        }
        return bOk;
    }
}

