/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.LocalCacheSettings;
import com.google.firebase.firestore.MemoryEagerGcSettings;
import com.google.firebase.firestore.MemoryGarbageCollectorSettings;

public final class MemoryCacheSettings
implements LocalCacheSettings {
    private MemoryGarbageCollectorSettings gcSettings;

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    private MemoryCacheSettings(MemoryGarbageCollectorSettings settings) {
        this.gcSettings = settings;
    }

    public int hashCode() {
        return this.gcSettings.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getGarbageCollectorSettings().equals(((MemoryCacheSettings)obj).getGarbageCollectorSettings());
    }

    public String toString() {
        return "MemoryCacheSettings{gcSettings=" + this.getGarbageCollectorSettings() + "}";
    }

    @NonNull
    public MemoryGarbageCollectorSettings getGarbageCollectorSettings() {
        return this.gcSettings;
    }

    public static class Builder {
        private MemoryGarbageCollectorSettings gcSettings = MemoryEagerGcSettings.newBuilder().build();

        private Builder() {
        }

        @NonNull
        public MemoryCacheSettings build() {
            return new MemoryCacheSettings(this.gcSettings);
        }

        @NonNull
        public Builder setGcSettings(@NonNull MemoryGarbageCollectorSettings gcSettings) {
            this.gcSettings = gcSettings;
            return this;
        }
    }
}

