/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import android.util.Log;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.appcheck.AppCheckTokenResult;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.functions.ContextProvider;
import com.google.firebase.functions.HttpsCallableContext;
import com.google.firebase.iid.internal.FirebaseInstanceIdInternal;
import com.google.firebase.inject.Deferred;
import com.google.firebase.inject.Provider;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class FirebaseContextProvider
implements ContextProvider {
    private final String TAG = "FirebaseContextProvider";
    private final Provider<InternalAuthProvider> tokenProvider;
    private final Provider<FirebaseInstanceIdInternal> instanceId;
    private final AtomicReference<InteropAppCheckTokenProvider> appCheckRef = new AtomicReference();
    private final Executor executor;

    @Inject
    FirebaseContextProvider(Provider<InternalAuthProvider> tokenProvider, Provider<FirebaseInstanceIdInternal> instanceId, Deferred<InteropAppCheckTokenProvider> appCheckDeferred, @Lightweight Executor executor) {
        this.tokenProvider = tokenProvider;
        this.instanceId = instanceId;
        this.executor = executor;
        appCheckDeferred.whenAvailable(p -> {
            InteropAppCheckTokenProvider appCheck = (InteropAppCheckTokenProvider)p.get();
            this.appCheckRef.set(appCheck);
            appCheck.addAppCheckTokenListener(unused -> {});
        });
    }

    @Override
    public Task<HttpsCallableContext> getContext(boolean limitedUseAppCheckToken) {
        Task<String> authToken = this.getAuthToken();
        Task<String> appCheckToken = this.getAppCheckToken(limitedUseAppCheckToken);
        return Tasks.whenAll(authToken, appCheckToken).onSuccessTask(this.executor, v -> Tasks.forResult(new HttpsCallableContext((String)authToken.getResult(), this.instanceId.get().getToken(), (String)appCheckToken.getResult())));
    }

    private Task<String> getAuthToken() {
        InternalAuthProvider auth = this.tokenProvider.get();
        if (auth == null) {
            return Tasks.forResult(null);
        }
        return auth.getAccessToken(false).continueWith(this.executor, task -> {
            String authToken = null;
            if (!task.isSuccessful()) {
                Exception exception = task.getException();
                if (!(exception instanceof FirebaseNoSignedInUserException)) {
                    throw exception;
                }
            } else {
                authToken = ((GetTokenResult)task.getResult()).getToken();
            }
            return authToken;
        });
    }

    private Task<String> getAppCheckToken(boolean limitedUseAppCheckToken) {
        InteropAppCheckTokenProvider appCheck = this.appCheckRef.get();
        if (appCheck == null) {
            return Tasks.forResult(null);
        }
        Task<AppCheckTokenResult> tokenTask = limitedUseAppCheckToken ? appCheck.getLimitedUseToken() : appCheck.getToken(false);
        return tokenTask.onSuccessTask(this.executor, result -> {
            if (result.getError() != null) {
                Log.w("FirebaseContextProvider", "Error getting App Check token. Error: " + result.getError());
                return Tasks.forResult(null);
            }
            return Tasks.forResult(result.getToken());
        });
    }
}

