/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.logging;

import com.google.firebase.database.logging.Logger;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultLogger
implements Logger {
    private final Set<String> enabledComponents;
    private final Logger.Level minLevel;

    public DefaultLogger(Logger.Level level, List<String> enabledComponents) {
        this.enabledComponents = enabledComponents != null ? new HashSet<String>(enabledComponents) : null;
        this.minLevel = level;
    }

    @Override
    public Logger.Level getLogLevel() {
        return this.minLevel;
    }

    @Override
    public void onLogMessage(Logger.Level level, String tag, String message, long msTimestamp) {
        if (this.shouldLog(level, tag)) {
            String toLog = this.buildLogMessage(level, tag, message, msTimestamp);
            switch (level) {
                case ERROR: {
                    this.error(tag, toLog);
                    break;
                }
                case WARN: {
                    this.warn(tag, toLog);
                    break;
                }
                case INFO: {
                    this.info(tag, toLog);
                    break;
                }
                case DEBUG: {
                    this.debug(tag, toLog);
                    break;
                }
                default: {
                    throw new RuntimeException("Should not reach here!");
                }
            }
        }
    }

    protected String buildLogMessage(Logger.Level level, String tag, String message, long msTimestamp) {
        Date now = new Date(msTimestamp);
        return now.toString() + " [" + (Object)((Object)level) + "] " + tag + ": " + message;
    }

    protected void error(String tag, String toLog) {
        System.err.println(toLog);
    }

    protected void warn(String tag, String toLog) {
        System.out.println(toLog);
    }

    protected void info(String tag, String toLog) {
        System.out.println(toLog);
    }

    protected void debug(String tag, String toLog) {
        System.out.println(toLog);
    }

    protected boolean shouldLog(Logger.Level level, String tag) {
        return level.ordinal() >= this.minLevel.ordinal() && (this.enabledComponents == null || level.ordinal() > Logger.Level.DEBUG.ordinal() || this.enabledComponents.contains(tag));
    }
}

