/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.utilities;

import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.ValidationPath;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.NodeUtilities;
import com.google.firebase.database.snapshot.PriorityUtilities;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Validation {
    private static final Pattern INVALID_PATH_REGEX = Pattern.compile("[\\[\\]\\.#$]");
    private static final Pattern INVALID_KEY_REGEX = Pattern.compile("[\\[\\]\\.#\\$\\/\\u0000-\\u001F\\u007F]");

    private static boolean isValidPathString(String pathString) {
        return !INVALID_PATH_REGEX.matcher(pathString).find();
    }

    public static void validatePathString(String pathString) throws DatabaseException {
        if (!Validation.isValidPathString(pathString)) {
            throw new DatabaseException("Invalid Firebase Database path: " + pathString + ". Firebase Database paths must not contain '.', '#', '$', '[', or ']'");
        }
    }

    public static void validateRootPathString(String pathString) throws DatabaseException {
        if (pathString.startsWith(".info")) {
            Validation.validatePathString(pathString.substring(5));
        } else if (pathString.startsWith("/.info")) {
            Validation.validatePathString(pathString.substring(6));
        } else {
            Validation.validatePathString(pathString);
        }
    }

    private static boolean isWritableKey(String key) {
        return key != null && key.length() > 0 && (key.equals(".value") || key.equals(".priority") || !key.startsWith(".") && !INVALID_KEY_REGEX.matcher(key).find());
    }

    private static boolean isValidKey(String key) {
        return key.equals(".info") || !INVALID_KEY_REGEX.matcher(key).find() || key.equals(ChildKey.getMaxName().asString()) || key.equals(ChildKey.getMinName().asString());
    }

    public static void validateNullableKey(String key) throws DatabaseException {
        if (key != null && !Validation.isValidKey(key)) {
            throw new DatabaseException("Invalid key: " + key + ". Keys must not contain '/', '.', '#', '$', '[', or ']'");
        }
    }

    private static void validateDoubleValue(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new DatabaseException("Invalid value: Value cannot be NaN, Inf or -Inf.");
        }
    }

    private static boolean isWritablePath(Path path) {
        ChildKey front = path.getFront();
        return front == null || !front.asString().startsWith(".");
    }

    public static void validateWritableObject(Object object) {
        if (object instanceof Map) {
            Map map2 = (Map)object;
            if (map2.containsKey(".sv")) {
                return;
            }
            for (Map.Entry entry : map2.entrySet()) {
                Validation.validateWritableKey((String)entry.getKey());
                Validation.validateWritableObject(entry.getValue());
            }
        } else if (object instanceof List) {
            List list = (List)object;
            for (Object child : list) {
                Validation.validateWritableObject(child);
            }
        } else if (object instanceof Double || object instanceof Float) {
            Validation.validateDoubleValue((Double)object);
        }
    }

    public static void validateWritableKey(String key) throws DatabaseException {
        if (!Validation.isWritableKey(key)) {
            throw new DatabaseException("Invalid key: " + key + ". Keys must not contain '/', '.', '#', '$', '[', or ']'");
        }
    }

    public static void validateWritablePath(Path path) throws DatabaseException {
        if (!Validation.isWritablePath(path)) {
            throw new DatabaseException("Invalid write location: " + path.toString());
        }
    }

    public static Map<Path, Node> parseAndValidateUpdate(Path path, Map<String, Object> update) throws DatabaseException {
        TreeMap<Path, Node> parsedUpdate = new TreeMap<Path, Node>();
        for (Map.Entry<String, Object> entry : update.entrySet()) {
            String childName;
            Path updatePath = new Path(entry.getKey());
            Object newValue = entry.getValue();
            ValidationPath.validateWithObject(path.child(updatePath), newValue);
            String string2 = childName = !updatePath.isEmpty() ? updatePath.getBack().asString() : "";
            if (childName.equals(".sv") || childName.equals(".value")) {
                throw new DatabaseException("Path '" + updatePath + "' contains disallowed child name: " + childName);
            }
            Node parsedValue = childName.equals(".priority") ? PriorityUtilities.parsePriority(updatePath, newValue) : NodeUtilities.NodeFromJSON(newValue);
            Validation.validateWritableObject(newValue);
            parsedUpdate.put(updatePath, parsedValue);
        }
        Path prevPath = null;
        for (Path curPath : parsedUpdate.keySet()) {
            Utilities.hardAssert(prevPath == null || prevPath.compareTo(curPath) < 0);
            if (prevPath != null && prevPath.contains(curPath)) {
                throw new DatabaseException("Path '" + prevPath + "' is an ancestor of '" + curPath + "' in an update.");
            }
            prevPath = curPath;
        }
        return parsedUpdate;
    }
}

