/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0007H\u0003J*\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002J(\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0007J4\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J,\u0010\u001e\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroid/net/UriCodec;", "", "<init>", "()V", "INVALID_INPUT_CHARACTER", "", "hexCharToValue", "", "c", "unexpectedCharacterException", "Ljava/net/URISyntaxException;", "uri", "", "name", "unexpected", "index", "getNextCharacter", "end", "decode", "s", "convertPlus", "", "charset", "Ljava/nio/charset/Charset;", "throwOnFailure", "appendDecoded", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "flushDecodingByteAccumulator", "decoder", "Ljava/nio/charset/CharsetDecoder;", "byteBuffer", "Ljava/nio/ByteBuffer;", "firebase-java-sdk"})
public final class UriCodec {
    @NotNull
    public static final UriCodec INSTANCE = new UriCodec();
    private static final char INVALID_INPUT_CHARACTER = '\ufffd';

    private UriCodec() {
    }

    private final int hexCharToValue(char c) {
        int n;
        block1: {
            block0: {
                boolean bl = '0' <= c ? c < ':' : false;
                if (!bl) break block0;
                n = c - 48;
                break block1;
            }
            n = ('a' <= c ? c < 'g' : false) ? 10 + c - 97 : (('A' <= c ? c < 'G' : false) ? 10 + c - 65 : -1);
        }
        return n;
    }

    @JvmStatic
    private static final URISyntaxException unexpectedCharacterException(String uri, String name, char unexpected, int index) {
        String string = name;
        Object nameString = string == null ? "" : " in [" + string + "]";
        return new URISyntaxException(uri, "Unexpected character" + (String)nameString + ": " + unexpected, index);
    }

    private final char getNextCharacter(String uri, int index, int end, String name) throws URISyntaxException {
        if (index >= end) {
            String string = name;
            Object nameString = string == null ? "" : " in [" + string + "]";
            throw new URISyntaxException(uri, "Unexpected end of string" + (String)nameString, index);
        }
        return uri.charAt(index);
    }

    @JvmStatic
    @NotNull
    public static final String decode(@NotNull String s, boolean convertPlus, @NotNull Charset charset, boolean throwOnFailure) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        StringBuilder builder = new StringBuilder(s.length());
        INSTANCE.appendDecoded(builder, s, convertPlus, charset, throwOnFailure);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void appendDecoded(StringBuilder builder, String s, boolean convertPlus, Charset charset, boolean throwOnFailure) {
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).replaceWith("\ufffd").onUnmappableCharacter(CodingErrorAction.REPORT);
        ByteBuffer byteBuffer = ByteBuffer.allocate(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            ++i;
            switch (c) {
                case '%': {
                    byte hexValue = 0;
                    for (int j = 0; j < 2; ++j) {
                        try {
                            c = this.getNextCharacter(s, i, s.length(), null);
                        }
                        catch (URISyntaxException e) {
                            if (throwOnFailure) {
                                throw new IllegalArgumentException(e);
                            }
                            Intrinsics.checkNotNull((Object)decoder);
                            Intrinsics.checkNotNull((Object)byteBuffer);
                            this.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
                            builder.append('\ufffd');
                            return;
                        }
                        ++i;
                        int newDigit = this.hexCharToValue(c);
                        if (newDigit < 0) {
                            if (throwOnFailure) {
                                throw new IllegalArgumentException(UriCodec.unexpectedCharacterException(s, null, c, i - 1));
                            }
                            Intrinsics.checkNotNull((Object)decoder);
                            Intrinsics.checkNotNull((Object)byteBuffer);
                            this.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
                            builder.append('\ufffd');
                            break;
                        }
                        hexValue = (byte)(hexValue * 16 + newDigit);
                    }
                    Comparable comparable = byteBuffer.put(hexValue);
                    break;
                }
                case '+': {
                    Intrinsics.checkNotNull((Object)decoder);
                    Intrinsics.checkNotNull((Object)byteBuffer);
                    this.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
                    Comparable comparable = builder.append(convertPlus ? (char)' ' : '+');
                    break;
                }
                default: {
                    Intrinsics.checkNotNull((Object)decoder);
                    Intrinsics.checkNotNull((Object)byteBuffer);
                    this.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
                    Comparable comparable = builder.append(c);
                }
            }
        }
        Intrinsics.checkNotNull((Object)decoder);
        Intrinsics.checkNotNull((Object)byteBuffer);
        this.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushDecodingByteAccumulator(StringBuilder builder, CharsetDecoder decoder, ByteBuffer byteBuffer, boolean throwOnFailure) {
        if (byteBuffer.position() != 0) {
            byteBuffer.flip();
            try {
                builder.append(decoder.decode(byteBuffer));
            }
            catch (CharacterCodingException e) {
                if (throwOnFailure) {
                    throw new IllegalArgumentException(e);
                }
                builder.append('\ufffd');
            }
            finally {
                byteBuffer.flip();
                byteBuffer.limit(byteBuffer.capacity());
            }
        }
    }
}

