/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.firebase.concurrent.FirebaseExecutors;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class StorageTaskScheduler {
    public static StorageTaskScheduler sInstance = new StorageTaskScheduler();
    private static final int COMMAND_POOL_SIZE = 5;
    private static final int DOWNLOAD_POOL_SIZE = 3;
    private static final int UPLOAD_POOL_SIZE = 2;
    private static Executor COMMAND_POOL_EXECUTOR;
    private static Executor UPLOAD_QUEUE_EXECUTOR;
    private static Executor DOWNLOAD_QUEUE_EXECUTOR;
    private static Executor CALLBACK_QUEUE_EXECUTOR;
    private static Executor MAIN_THREAD_EXECUTOR;

    public static void initializeExecutors(@NonNull Executor firebaseExecutor, @NonNull Executor uiExecutor) {
        COMMAND_POOL_EXECUTOR = FirebaseExecutors.newLimitedConcurrencyExecutor(firebaseExecutor, 5);
        DOWNLOAD_QUEUE_EXECUTOR = FirebaseExecutors.newLimitedConcurrencyExecutor(firebaseExecutor, 3);
        UPLOAD_QUEUE_EXECUTOR = FirebaseExecutors.newLimitedConcurrencyExecutor(firebaseExecutor, 2);
        CALLBACK_QUEUE_EXECUTOR = FirebaseExecutors.newSequentialExecutor(firebaseExecutor);
        MAIN_THREAD_EXECUTOR = uiExecutor;
    }

    public static StorageTaskScheduler getInstance() {
        return sInstance;
    }

    public void scheduleCommand(Runnable task) {
        COMMAND_POOL_EXECUTOR.execute(task);
    }

    public void scheduleUpload(Runnable task) {
        UPLOAD_QUEUE_EXECUTOR.execute(task);
    }

    public Executor getMainThreadExecutor() {
        return MAIN_THREAD_EXECUTOR;
    }

    public void scheduleDownload(Runnable task) {
        DOWNLOAD_QUEUE_EXECUTOR.execute(task);
    }

    public void scheduleCallback(Runnable task) {
        CALLBACK_QUEUE_EXECUTOR.execute(task);
    }

    public Executor getCommandPoolExecutor() {
        return COMMAND_POOL_EXECUTOR;
    }
}

