/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.network;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.FirebaseApp;
import com.google.firebase.storage.internal.StorageReferenceUri;
import com.google.firebase.storage.network.NetworkRequest;
import java.util.HashMap;
import java.util.Map;

public class ListNetworkRequest
extends NetworkRequest {
    @Nullable
    private final Integer maxPageSize;
    @Nullable
    private final String nextPageToken;

    public ListNetworkRequest(@NonNull StorageReferenceUri storageReferenceUri, @NonNull FirebaseApp app, @Nullable Integer maxPageSize, @Nullable String nextPageToken) {
        super(storageReferenceUri, app);
        this.maxPageSize = maxPageSize;
        this.nextPageToken = nextPageToken;
    }

    @Override
    @NonNull
    protected String getAction() {
        return "GET";
    }

    @Override
    @NonNull
    public Uri getURL() {
        String bucketName = this.getStorageReferenceUri().getGsUri().getAuthority();
        return Uri.parse(this.getStorageReferenceUri().getHttpBaseUri() + "/b/" + bucketName + "/o");
    }

    @Override
    @NonNull
    protected Map<String, String> getQueryParameters() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String prefix = this.getPathWithoutBucket();
        if (!prefix.isEmpty()) {
            headers.put("prefix", prefix + "/");
        }
        headers.put("delimiter", "/");
        if (this.maxPageSize != null) {
            headers.put("maxResults", Integer.toString(this.maxPageSize));
        }
        if (!TextUtils.isEmpty(this.nextPageToken)) {
            headers.put("pageToken", this.nextPageToken);
        }
        return headers;
    }
}

