/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.os.Looper;
import android.os.PowerManager;
import android.os.UserManager;
import com.google.firebase.FirebasePlatform;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 62\u00020\u0001:\u00016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\fJ\u0012\u0010/\u001a\u00020\u00012\n\u00100\u001a\u0006\u0012\u0002\b\u000301J\u0016\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\f2\u0006\u00104\u001a\u00020.J\u000e\u00105\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00067"}, d2={"Landroid/content/Context;", "", "<init>", "()V", "applicationContext", "getApplicationContext", "()Landroid/content/Context;", "mainLooper", "Landroid/os/Looper;", "getMainLooper", "()Landroid/os/Looper;", "packageName", "", "getPackageName", "()Ljava/lang/String;", "resources", "Landroid/content/res/Resources;", "getResources", "()Landroid/content/res/Resources;", "packageManager", "Landroid/content/pm/PackageManager;", "getPackageManager", "()Landroid/content/pm/PackageManager;", "isDeviceProtectedStorage", "", "()Z", "noBackupFilesDir", "Ljava/io/File;", "getNoBackupFilesDir", "()Ljava/io/File;", "classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "()Ljava/lang/ClassLoader;", "contentResolver", "Landroid/content/ContentResolver;", "getContentResolver", "()Landroid/content/ContentResolver;", "applicationInfo", "Landroid/content/pm/ApplicationInfo;", "getApplicationInfo", "()Landroid/content/pm/ApplicationInfo;", "getSharedPreferences", "Landroid/content/SharedPreferences;", "name", "mode", "", "getSystemService", "clazz", "Ljava/lang/Class;", "getDir", "path", "flags", "getDatabasePath", "Companion", "firebase-java-sdk"})
public class Context {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationInfo applicationInfo = new ApplicationInfo();
    @NotNull
    private static final String CONNECTIVITY_SERVICE = "connectivity";

    @NotNull
    public final Context getApplicationContext() {
        return this;
    }

    @NotNull
    public final Looper getMainLooper() {
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"getMainLooper(...)");
        return looper;
    }

    @NotNull
    public final String getPackageName() {
        return "app.teamhub.TeamHub";
    }

    @NotNull
    public final Resources getResources() {
        return new Resources();
    }

    @NotNull
    public final PackageManager getPackageManager() {
        return new PackageManager();
    }

    public final boolean isDeviceProtectedStorage() {
        return false;
    }

    @NotNull
    public final File getNoBackupFilesDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    @NotNull
    public final ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getSystemClassLoader(...)");
        return classLoader;
    }

    @NotNull
    public final ContentResolver getContentResolver() {
        return new ContentResolver();
    }

    @NotNull
    public final ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @NotNull
    public final SharedPreferences getSharedPreferences(@NotNull String name, int mode) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new SharedPreferences(){

            public boolean contains(String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                switch (key) {
                    case "firebase_data_collection_default_enabled": {
                        return false;
                    }
                    case "auto_init": {
                        return false;
                    }
                    case "firebase_messaging_auto_init_enabled": {
                        return false;
                    }
                    case "fire-fst": {
                        return false;
                    }
                    case "fire-global": {
                        CharSequence charSequence = FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().retrieve(key);
                        return !(charSequence == null || charSequence.length() == 0);
                    }
                }
                throw new IllegalArgumentException(key);
            }

            public String getString(String key, String defaultValue) {
                String string;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                if (Intrinsics.areEqual((Object)key, (Object)"last-used-date")) {
                    string = FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().retrieve(key);
                    if (string == null) {
                        string = defaultValue;
                    }
                } else if (StringsKt.contains$default((CharSequence)key, (CharSequence)"|T|", (boolean)false, (int)2, null)) {
                    string = null;
                } else if (StringsKt.startsWith$default((String)key, (String)"com.google.firebase.auth.FIREBASE_USER", (boolean)false, (int)2, null)) {
                    string = FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().retrieve(key);
                    if (string == null) {
                        string = defaultValue;
                    }
                } else {
                    throw new IllegalArgumentException(key);
                }
                return string;
            }

            public long getLong(String key, long defaultValue) {
                if (Intrinsics.areEqual((Object)key, (Object)"fire-global")) {
                    String string = FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().retrieve(key);
                    return string != null ? Long.parseLong(string) : defaultValue;
                }
                throw new IllegalArgumentException(key);
            }

            public Map<String, String> getAll() {
                return MapsKt.emptyMap();
            }

            public SharedPreferences.Editor edit() {
                return new SharedPreferences.Editor(){

                    public SharedPreferences.Editor putLong(String key, long value) {
                        if (!Intrinsics.areEqual((Object)key, (Object)"fire-global")) {
                            throw new IllegalArgumentException(key);
                        }
                        FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().store(key, String.valueOf(value));
                        return this;
                    }

                    public SharedPreferences.Editor putString(String key, String value) {
                        if (Intrinsics.areEqual((Object)key, (Object)"last-used-date")) {
                            FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().store(key, String.valueOf(value));
                        } else {
                            String string = key;
                            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"com.google.firebase.auth.FIREBASE_USER", (boolean)false, (int)2, null) : false;
                            if (bl) {
                                FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().store(key, String.valueOf(value));
                            } else {
                                throw new IllegalArgumentException(key);
                            }
                        }
                        return this;
                    }

                    public boolean commit() {
                        return true;
                    }

                    public void apply() {
                    }
                };
            }
        };
    }

    @NotNull
    public final Object getSystemService(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name;
        if (Intrinsics.areEqual((Object)string, (Object)"power")) {
            return new PowerManager();
        }
        if (Intrinsics.areEqual((Object)string, (Object)CONNECTIVITY_SERVICE)) {
            return ConnectivityManager.Companion.getInstance();
        }
        throw new IllegalArgumentException(name);
    }

    @NotNull
    public final Object getSystemService(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (Intrinsics.areEqual(clazz, UserManager.class)) {
            return new UserManager();
        }
        throw new IllegalArgumentException(clazz.toString());
    }

    @NotNull
    public final File getDir(@NotNull String path, int flags) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new File(System.getProperty("java.io.tmpdir"));
    }

    @NotNull
    public final File getDatabasePath(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().getDatabasePath(name);
    }

    @NotNull
    public static final String getCONNECTIVITY_SERVICE() {
        return Companion.getCONNECTIVITY_SERVICE();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroid/content/Context$Companion;", "", "<init>", "()V", "CONNECTIVITY_SERVICE", "", "getCONNECTIVITY_SERVICE$annotations", "getCONNECTIVITY_SERVICE", "()Ljava/lang/String;", "firebase-java-sdk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCONNECTIVITY_SERVICE() {
            return CONNECTIVITY_SERVICE;
        }

        @JvmStatic
        public static /* synthetic */ void getCONNECTIVITY_SERVICE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

