/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteException;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CursorWindow
extends SQLiteClosable {
    private final List<Row> rows;
    private int numColumns;
    private static final String STATS_TAG = "CursorWindowStats";
    private static int sCursorWindowSize = -1;
    private int mStartPos;
    private final String mName;

    public CursorWindow(String name) {
        this(name, CursorWindow.getCursorWindowSize());
    }

    public CursorWindow(String name, long windowSizeBytes) {
        if (windowSizeBytes < 0L) {
            throw new IllegalArgumentException("Window size cannot be less than 0");
        }
        this.mStartPos = 0;
        this.mName = name != null && !name.isEmpty() ? name : "<unnamed>";
        this.rows = new ArrayList<Row>();
    }

    @Deprecated
    public CursorWindow(boolean localWindow) {
        this(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private void dispose() {
        this.rows.clear();
    }

    public String getName() {
        return this.mName;
    }

    public void clear() {
        this.rows.clear();
    }

    public int getStartPosition() {
        return this.mStartPos;
    }

    public void setStartPosition(int pos) {
        this.mStartPos = pos;
    }

    public int getNumRows() {
        return this.rows.size();
    }

    public boolean setNumColumns(int columnNum) {
        this.numColumns = columnNum;
        return true;
    }

    public boolean allocRow() {
        this.rows.add(new Row(this.numColumns));
        return true;
    }

    public void freeLastRow() {
        this.rows.remove(this.rows.size() - 1);
    }

    @Deprecated
    public boolean isNull(int row, int column) {
        return this.getType(row, column) == 0;
    }

    @Deprecated
    public boolean isBlob(int row, int column) {
        int type = this.getType(row, column);
        return type == 4 || type == 0;
    }

    @Deprecated
    public boolean isLong(int row, int column) {
        return this.getType(row, column) == 1;
    }

    @Deprecated
    public boolean isFloat(int row, int column) {
        return this.getType(row, column) == 2;
    }

    @Deprecated
    public boolean isString(int row, int column) {
        int type = this.getType(row, column);
        return type == 3 || type == 0;
    }

    private Value value(int rowN, int colN) {
        Row row = this.rows.get(rowN);
        if (row == null) {
            throw new IllegalArgumentException("Bad row number: " + rowN + ", count: " + this.rows.size());
        }
        return row.get(colN);
    }

    private boolean putValue(Value value, int rowN, int colN) {
        return this.rows.get(rowN).set(colN, value);
    }

    public int getType(int row, int column) {
        return this.value((int)(row - this.mStartPos), (int)column).type;
    }

    public byte[] getBlob(int row, int column) {
        Value value = this.value(row - this.mStartPos, column);
        switch (value.type) {
            case 0: {
                return null;
            }
            case 4: {
                byte[] blob = (byte[])value.value;
                return blob == null ? new byte[]{} : blob;
            }
            case 3: {
                byte[] stringBytes = ((String)value.value).getBytes(StandardCharsets.UTF_8);
                return Arrays.copyOf(stringBytes, stringBytes.length + 1);
            }
        }
        throw new SQLiteException("Getting blob when column is non-blob. Row " + row + ", col " + column);
    }

    public String getString(int row, int column) {
        Value val = this.value(row - this.mStartPos, column);
        if (val.type == 4) {
            throw new SQLiteException("Getting string when column is blob. Row " + row + ", col " + column);
        }
        Object value = val.value;
        return value == null ? null : String.valueOf(value);
    }

    private Number getNumber(int row, int column) {
        Value value = this.value(row, column);
        switch (value.type) {
            case 0: 
            case 5: {
                return 0;
            }
            case 1: 
            case 2: {
                return (Number)value.value;
            }
            case 3: {
                try {
                    return Double.parseDouble((String)value.value);
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
            case 4: {
                throw new SQLiteException("could not convert " + String.valueOf(value));
            }
        }
        throw new SQLiteException("unknown type: " + value.type);
    }

    public long getLong(int row, int column) {
        return this.getNumber(row - this.mStartPos, column).longValue();
    }

    public double getDouble(int row, int column) {
        return this.getNumber(row - this.mStartPos, column).doubleValue();
    }

    public short getShort(int row, int column) {
        return (short)this.getLong(row, column);
    }

    public int getInt(int row, int column) {
        return (int)this.getLong(row, column);
    }

    public float getFloat(int row, int column) {
        return (float)this.getDouble(row, column);
    }

    public boolean putBlob(byte[] value, int row, int column) {
        Preconditions.checkNotNull((Object)value);
        return this.putValue(new Value(value, 4), row, column);
    }

    public boolean putString(String value, int row, int column) {
        Preconditions.checkNotNull((Object)value);
        return this.putValue(new Value(value, 3), row, column);
    }

    public boolean putLong(long value, int row, int column) {
        return this.putValue(new Value(value, 1), row, column);
    }

    public boolean putDouble(double value, int row, int column) {
        return this.putValue(new Value(value, 2), row, column);
    }

    public boolean putNull(int row, int column) {
        return this.putValue(new Value(null, 0), row, column);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    protected void onAllReferencesReleased() {
        this.dispose();
    }

    private static int getCursorWindowSize() {
        if (sCursorWindowSize < 0) {
            sCursorWindowSize = 2072576;
        }
        return sCursorWindowSize;
    }

    public String toString() {
        return this.getName();
    }

    private static class Row {
        private final List<Value> values;

        public Row(int length) {
            this.values = new ArrayList<Value>(length);
            for (int i = 0; i < length; ++i) {
                this.values.add(new Value(null, 0));
            }
        }

        public Value get(int n) {
            return this.values.get(n);
        }

        public boolean set(int colN, Value value) {
            this.values.set(colN, value);
            return true;
        }
    }

    private static class Value {
        private final Object value;
        private final int type;

        public Value(Object value, int type) {
            this.value = value;
            this.type = type;
        }
    }
}

