/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.AbstractWindowedCursor;
import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQuery;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public class SQLiteCursor
extends AbstractWindowedCursor {
    static final String TAG = "SQLiteCursor";
    static final int NO_COUNT = -1;
    private final String mEditTable;
    private final String[] mColumns;
    private final SQLiteQuery mQuery;
    private final SQLiteCursorDriver mDriver;
    private int mCount = -1;
    private int mCursorWindowCapacity;
    private Map<String, Integer> mColumnNameMap;

    @Deprecated
    public SQLiteCursor(SQLiteDatabase db, SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        this(driver, editTable, query);
    }

    public SQLiteCursor(SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("query object cannot be null");
        }
        this.mDriver = driver;
        this.mEditTable = editTable;
        this.mColumnNameMap = null;
        this.mQuery = query;
        this.mColumns = query.getColumnNames();
    }

    public SQLiteDatabase getDatabase() {
        return this.mQuery.getDatabase();
    }

    @Override
    public boolean onMove(int oldPosition, int newPosition) {
        if (this.mWindow == null || newPosition < this.mWindow.getStartPosition() || newPosition >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
            this.fillWindow(newPosition);
        }
        return true;
    }

    @Override
    public int getCount() {
        if (this.mCount == -1) {
            this.fillWindow(0);
        }
        return this.mCount;
    }

    private void awc_clearOrCreateWindow(String name) {
        CursorWindow win = this.getWindow();
        if (win == null) {
            win = new CursorWindow(name);
            this.setWindow(win);
        } else {
            win.clear();
        }
    }

    private void awc_closeWindow() {
        this.setWindow(null);
    }

    private void fillWindow(int requiredPos) {
        this.awc_clearOrCreateWindow(this.getDatabase().getPath());
        try {
            if (this.mCount == -1) {
                int startPos = DatabaseUtils.cursorPickFillWindowStartPosition(requiredPos, 0);
                this.mCount = this.mQuery.fillWindow(this.mWindow, startPos, requiredPos, true);
                this.mCursorWindowCapacity = this.mWindow.getNumRows();
                if (Log.isLoggable(TAG, 3)) {
                    Log.d(TAG, "received count(*) from native_fill_window: " + this.mCount);
                }
            } else {
                int startPos = DatabaseUtils.cursorPickFillWindowStartPosition(requiredPos, this.mCursorWindowCapacity);
                this.mQuery.fillWindow(this.mWindow, startPos, requiredPos, false);
            }
        }
        catch (RuntimeException ex) {
            this.awc_closeWindow();
            throw ex;
        }
    }

    @Override
    public int getColumnIndex(String columnName) {
        Integer i;
        int periodIndex;
        if (this.mColumnNameMap == null) {
            String[] columns = this.mColumns;
            int columnCount = columns.length;
            HashMap<String, Integer> map2 = new HashMap<String, Integer>(columnCount, 1.0f);
            for (int i2 = 0; i2 < columnCount; ++i2) {
                map2.put(columns[i2], i2);
            }
            this.mColumnNameMap = map2;
        }
        if ((periodIndex = columnName.lastIndexOf(46)) != -1) {
            Exception e = new Exception();
            Log.e(TAG, "requesting column name with table name -- " + columnName, e);
            columnName = columnName.substring(periodIndex + 1);
        }
        if ((i = this.mColumnNameMap.get(columnName)) != null) {
            return i;
        }
        return -1;
    }

    @Override
    public String[] getColumnNames() {
        return this.mColumns;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.mDriver.cursorDeactivated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            this.mQuery.close();
            this.mDriver.cursorClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requery() {
        if (this.isClosed()) {
            return false;
        }
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            if (!this.mQuery.getDatabase().isOpen()) {
                return false;
            }
            if (this.mWindow != null) {
                this.mWindow.clear();
            }
            this.mPos = -1;
            this.mCount = -1;
            this.mDriver.cursorRequeried(this);
        }
        try {
            return super.requery();
        }
        catch (IllegalStateException e) {
            Log.w(TAG, "requery() failed " + e.getMessage(), e);
            return false;
        }
    }

    @Override
    public void setWindow(CursorWindow window) {
        super.setWindow(window);
        this.mCount = -1;
    }

    public void setSelectionArguments(String[] selectionArgs) {
        this.mDriver.setBindArguments(selectionArgs);
    }

    @Override
    protected void finalize() {
        try {
            if (this.mWindow != null) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

