/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.UriCodec;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.RandomAccess;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u001a\b&\u0018\u0000 V2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\fKLMNOPQRSTUVB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u00103\u001a\u00020\u00062\b\u00104\u001a\u0004\u0018\u000105H\u0096\u0002J\b\u00106\u001a\u00020\u001eH\u0016J\u0011\u00107\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u0000H\u0096\u0002J\b\u00108\u001a\u00020\fH&J\b\u00109\u001a\u00020\fH\u0007J\b\u0010:\u001a\u00020;H&J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\f0.2\b\u0010A\u001a\u0004\u0018\u00010\fJ\u0012\u0010B\u001a\u0004\u0018\u00010\f2\b\u0010A\u001a\u0004\u0018\u00010\fJ\u0016\u0010C\u001a\u00020\u00062\u0006\u0010A\u001a\u00020\f2\u0006\u0010D\u001a\u00020\u0006J\u0006\u0010E\u001a\u00020\u0000J\u000e\u0010I\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\u0000R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u0012\u0010\t\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u0014\u0010\u0017\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0014\u0010\u0019\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000eR\u0014\u0010\u001b\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000eR\u0012\u0010\u001d\u001a\u00020\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000eR\u0014\u0010#\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000eR\u0014\u0010%\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000eR\u0014\u0010'\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000eR\u0014\u0010)\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000eR\u0014\u0010+\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000eR\u0018\u0010-\u001a\b\u0012\u0004\u0012\u00020\f0.X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u000eR\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00020\f0=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0011\u0010F\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\u00a8\u0006W"}, d2={"Landroid/net/Uri;", "Landroid/os/Parcelable;", "", "<init>", "()V", "isHierarchical", "", "()Z", "isOpaque", "isRelative", "isAbsolute", "scheme", "", "getScheme", "()Ljava/lang/String;", "schemeSpecificPart", "getSchemeSpecificPart", "encodedSchemeSpecificPart", "getEncodedSchemeSpecificPart", "authority", "getAuthority", "encodedAuthority", "getEncodedAuthority", "userInfo", "getUserInfo", "encodedUserInfo", "getEncodedUserInfo", "host", "getHost", "port", "", "getPort", "()I", "path", "getPath", "encodedPath", "getEncodedPath", "query", "getQuery", "encodedQuery", "getEncodedQuery", "fragment", "getFragment", "encodedFragment", "getEncodedFragment", "pathSegments", "", "getPathSegments", "()Ljava/util/List;", "lastPathSegment", "getLastPathSegment", "equals", "other", "", "hashCode", "compareTo", "toString", "toSafeString", "buildUpon", "Landroid/net/Uri$Builder;", "queryParameterNames", "", "getQueryParameterNames", "()Ljava/util/Set;", "getQueryParameters", "key", "getQueryParameter", "getBooleanQueryParameter", "defaultValue", "normalizeScheme", "canonicalUri", "getCanonicalUri", "()Landroid/net/Uri;", "isPathPrefixMatch", "prefix", "NotCachedHolder", "StringUri", "OpaqueUri", "PathSegments", "PathSegmentsBuilder", "AbstractHierarchicalUri", "HierarchicalUri", "Builder", "AbstractPart", "Part", "PathPart", "Companion", "firebase-java-sdk"})
public abstract class Uri
implements Parcelable,
Comparable<Uri> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LOG;
    @NotNull
    private static final Uri EMPTY;
    private static final int NOT_FOUND = -1;
    private static final int NOT_CALCULATED = -2;
    @NotNull
    private static final String NOT_HIERARCHICAL = "This isn't a hierarchical URI.";
    @NotNull
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final int NULL_TYPE_ID = 0;
    @NotNull
    private static final Parcelable.Creator<Uri> CREATOR;
    @NotNull
    private static final char[] HEX_DIGITS;

    private Uri() {
    }

    public abstract boolean isHierarchical();

    public final boolean isOpaque() {
        return !this.isHierarchical();
    }

    public abstract boolean isRelative();

    public final boolean isAbsolute() {
        return !this.isRelative();
    }

    @Nullable
    public abstract String getScheme();

    @Nullable
    public abstract String getSchemeSpecificPart();

    @Nullable
    public abstract String getEncodedSchemeSpecificPart();

    @Nullable
    public abstract String getAuthority();

    @Nullable
    public abstract String getEncodedAuthority();

    @Nullable
    public abstract String getUserInfo();

    @Nullable
    public abstract String getEncodedUserInfo();

    @Nullable
    public abstract String getHost();

    public abstract int getPort();

    @Nullable
    public abstract String getPath();

    @Nullable
    public abstract String getEncodedPath();

    @Nullable
    public abstract String getQuery();

    @Nullable
    public abstract String getEncodedQuery();

    @Nullable
    public abstract String getFragment();

    @Nullable
    public abstract String getEncodedFragment();

    @NotNull
    public abstract List<String> getPathSegments();

    @Nullable
    public abstract String getLastPathSegment();

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Uri)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.toString(), (Object)((Uri)other).toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(@NotNull Uri other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toString().compareTo(other.toString());
    }

    @NotNull
    public abstract String toString();

    @SystemApi
    @NotNull
    public final String toSafeString() {
        String scheme = this.getScheme();
        String ssp = this.getSchemeSpecificPart();
        StringBuilder builder = new StringBuilder(64);
        if (scheme != null) {
            builder.append(scheme);
            builder.append(":");
            if (StringsKt.equals((String)scheme, (String)"tel", (boolean)true) || StringsKt.equals((String)scheme, (String)"sip", (boolean)true) || StringsKt.equals((String)scheme, (String)"sms", (boolean)true) || StringsKt.equals((String)scheme, (String)"smsto", (boolean)true) || StringsKt.equals((String)scheme, (String)"mailto", (boolean)true) || StringsKt.equals((String)scheme, (String)"nfc", (boolean)true)) {
                if (ssp != null) {
                    block3: for (int i = 0; i < ((CharSequence)ssp).length(); ++i) {
                        char element;
                        char c = element = ((CharSequence)ssp).charAt(i);
                        switch (c) {
                            case '-': 
                            case '.': 
                            case '@': {
                                StringBuilder stringBuilder = builder.append(c);
                                continue block3;
                            }
                            default: {
                                StringBuilder stringBuilder = builder.append('x');
                            }
                        }
                    }
                }
            } else {
                String host = this.getHost();
                int port = this.getPort();
                String path = this.getPath();
                String authority = this.getAuthority();
                if (authority != null) {
                    builder.append("//");
                }
                if (host != null) {
                    builder.append(host);
                }
                if (port != -1) {
                    builder.append(":").append(port);
                }
                if (authority != null || path != null) {
                    builder.append("/...");
                }
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public abstract Builder buildUpon();

    @NotNull
    public final Set<String> getQueryParameterNames() {
        int end;
        if (this.isOpaque()) {
            throw new UnsupportedOperationException(NOT_HIERARCHICAL);
        }
        String string = this.getEncodedQuery();
        if (string == null) {
            return SetsKt.emptySet();
        }
        String query = string;
        Set names = new LinkedHashSet();
        int start = 0;
        do {
            String name;
            int next;
            end = (next = StringsKt.indexOf$default((CharSequence)query, (char)'&', (int)start, (boolean)false, (int)4, null)) == -1 ? query.length() : next;
            int separator = StringsKt.indexOf$default((CharSequence)query, (char)'=', (int)start, (boolean)false, (int)4, null);
            if (separator > end || separator == -1) {
                separator = end;
            }
            Intrinsics.checkNotNullExpressionValue((Object)query.substring(start, separator), (String)"substring(...)");
            String string2 = Companion.decode(name);
            Intrinsics.checkNotNull((Object)string2);
            names.add(string2);
        } while ((start = end + 1) < query.length());
        Set<String> set = Collections.unmodifiableSet(names);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
        return set;
    }

    @NotNull
    public final List<String> getQueryParameters(@Nullable String key) {
        if (this.isOpaque()) {
            throw new UnsupportedOperationException(NOT_HIERARCHICAL);
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        String string = this.getEncodedQuery();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String query = string;
        String encodedKey = null;
        try {
            encodedKey = URLEncoder.encode(key, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        ArrayList<String> values = new ArrayList<String>();
        int start = 0;
        while (true) {
            int nextAmpersand;
            int end = (nextAmpersand = StringsKt.indexOf$default((CharSequence)query, (char)'&', (int)start, (boolean)false, (int)4, null)) != -1 ? nextAmpersand : query.length();
            int separator = StringsKt.indexOf$default((CharSequence)query, (char)'=', (int)start, (boolean)false, (int)4, null);
            if (separator > end || separator == -1) {
                separator = end;
            }
            if (separator - start == encodedKey.length() && StringsKt.regionMatches$default((String)query, (int)start, (String)encodedKey, (int)0, (int)encodedKey.length(), (boolean)false, (int)16, null)) {
                if (separator == end) {
                    v1 = values.add("");
                } else {
                    String string2 = query.substring(separator + 1, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String string3 = Companion.decode(string2);
                    Intrinsics.checkNotNull((Object)string3);
                    v1 = values.add(string3);
                }
            }
            if (nextAmpersand == -1) break;
            start = nextAmpersand + 1;
        }
        List<String> list = Collections.unmodifiableList((List)values);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    @Nullable
    public final String getQueryParameter(@Nullable String key) {
        if (this.isOpaque()) {
            throw new UnsupportedOperationException(NOT_HIERARCHICAL);
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        String string = this.getEncodedQuery();
        if (string == null) {
            return null;
        }
        String query = string;
        String encodedKey = Companion.encode(key, null);
        int length = query.length();
        int start = 0;
        while (true) {
            int nextAmpersand;
            int end = (nextAmpersand = StringsKt.indexOf$default((CharSequence)query, (char)'&', (int)start, (boolean)false, (int)4, null)) != -1 ? nextAmpersand : length;
            int separator = StringsKt.indexOf$default((CharSequence)query, (char)'=', (int)start, (boolean)false, (int)4, null);
            if (separator > end || separator == -1) {
                separator = end;
            }
            String string2 = encodedKey;
            Intrinsics.checkNotNull((Object)string2);
            if (separator - start == string2.length() && StringsKt.regionMatches$default((String)query, (int)start, (String)encodedKey, (int)0, (int)encodedKey.length(), (boolean)false, (int)16, null)) {
                if (separator == end) {
                    return "";
                }
                String string3 = query.substring(separator + 1, end);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String encodedValue = string3;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                return UriCodec.decode(encodedValue, true, charset, false);
            }
            if (nextAmpersand == -1) break;
            start = nextAmpersand + 1;
        }
        return null;
    }

    public final boolean getBooleanQueryParameter(@NotNull String key, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.getQueryParameter(key);
        if (string == null) {
            return defaultValue;
        }
        String flag = string;
        String string2 = flag.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        flag = string2;
        return !Intrinsics.areEqual((Object)"false", (Object)flag) && !Intrinsics.areEqual((Object)"0", (Object)flag);
    }

    @NotNull
    public final Uri normalizeScheme() {
        String string = this.getScheme();
        if (string == null) {
            return this;
        }
        String scheme = string;
        String string2 = scheme.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String lowerScheme = string2;
        if (Intrinsics.areEqual((Object)scheme, (Object)lowerScheme)) {
            return this;
        }
        return this.buildUpon().scheme(lowerScheme).build();
    }

    @NotNull
    public final Uri getCanonicalUri() {
        if (Intrinsics.areEqual((Object)"file", (Object)this.getScheme())) {
            String canonicalPath = null;
            try {
                String string = this.getPath();
                Intrinsics.checkNotNull((Object)string);
                canonicalPath = new File(string).getCanonicalPath();
            }
            catch (IOException e) {
                return this;
            }
            if (Environment.isExternalStorageEmulated()) {
                String string = Environment.getLegacyExternalStorageDirectory().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String legacyPath = string;
                if (StringsKt.startsWith$default((String)canonicalPath, (String)legacyPath, (boolean)false, (int)2, null)) {
                    String string2 = Environment.getExternalStorageDirectory().toString();
                    String string3 = canonicalPath.substring(legacyPath.length() + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    return Companion.fromFile(new File(string2, string3));
                }
            }
            return Companion.fromFile(new File(canonicalPath));
        }
        return this;
    }

    public final boolean isPathPrefixMatch(@NotNull Uri prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (!Intrinsics.areEqual((Object)this.getScheme(), (Object)prefix.getScheme())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getAuthority(), (Object)prefix.getAuthority())) {
            return false;
        }
        List<String> seg = this.getPathSegments();
        List<String> prefixSeg = prefix.getPathSegments();
        int prefixSize = prefixSeg.size();
        if (seg.size() < prefixSize) {
            return false;
        }
        for (int i = 0; i < prefixSize; ++i) {
            if (Intrinsics.areEqual((Object)seg.get(i), (Object)prefixSeg.get(i))) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    @NotNull
    public static final Uri parse(@NotNull String uriString) {
        return Companion.parse(uriString);
    }

    @JvmStatic
    @NotNull
    public static final Uri fromFile(@Nullable File file) {
        return Companion.fromFile(file);
    }

    @JvmStatic
    @NotNull
    public static final Uri fromParts(@Nullable String scheme, @Nullable String ssp, @Nullable String fragment) {
        return Companion.fromParts(scheme, ssp, fragment);
    }

    @NotNull
    public static final Parcelable.Creator<Uri> getCREATOR() {
        return Companion.getCREATOR();
    }

    @JvmStatic
    public static final void writeToParcel(@NotNull Parcel out, @Nullable Uri uri) {
        Companion.writeToParcel(out, uri);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String encode(@Nullable String s, @Nullable String allow) {
        return Companion.encode(s, allow);
    }

    @JvmStatic
    @Nullable
    public static final String encodeIfNotEncoded(@Nullable String value, @Nullable String allow) {
        return Companion.encodeIfNotEncoded(value, allow);
    }

    @JvmStatic
    private static final boolean isEncoded(String value, String allow) {
        return Uri.Companion.isEncoded(value, allow);
    }

    @JvmStatic
    @Nullable
    public static final String decode(@Nullable String s) {
        return Companion.decode(s);
    }

    @JvmStatic
    @Nullable
    public static final String decodeIfNeeded(@Nullable String value) {
        return Companion.decodeIfNeeded(value);
    }

    @JvmStatic
    @NotNull
    public static final Uri withAppendedPath(@NotNull Uri baseUri, @Nullable String pathSegment) {
        return Companion.withAppendedPath(baseUri, pathSegment);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String encode(@Nullable String s) {
        return Companion.encode(s);
    }

    public /* synthetic */ Uri(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        String string = Uri.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        LOG = string;
        EMPTY = new HierarchicalUri(null, Part.Companion.getNULL(), PathPart.Companion.getEMPTY(), Part.Companion.getNULL(), Part.Companion.getNULL());
        CREATOR = new Parcelable.Creator<Uri>(){

            public Uri createFromParcel(Parcel in) {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                int type = in.readInt();
                switch (type) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return StringUri.Companion.readFrom(in);
                    }
                    case 2: {
                        return OpaqueUri.Companion.readFrom(in);
                    }
                    case 3: {
                        return HierarchicalUri.Companion.readFrom(in);
                    }
                }
                throw new IllegalArgumentException("Unknown URI type: " + type);
            }

            public Uri[] newArray(int size) {
                return new Uri[size];
            }
        };
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        HEX_DIGITS = cArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\b\b\"\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u001d\u001a\u00020\u0018J\u0010\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00058VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0017\u001a\u00020\u00188VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Landroid/net/Uri$AbstractHierarchicalUri;", "Landroid/net/Uri;", "<init>", "()V", "lastPathSegment", "", "getLastPathSegment", "()Ljava/lang/String;", "_userInfoPart", "Landroid/net/Uri$Part;", "userInfoPart", "getUserInfoPart", "()Landroid/net/Uri$Part;", "encodedUserInfo", "getEncodedUserInfo", "parseUserInfo", "userInfo", "getUserInfo", "host", "getHost", "setHost", "(Ljava/lang/String;)V", "parseHost", "port", "", "getPort", "()I", "setPort", "(I)V", "parsePort", "findPortSeparator", "authority", "firebase-java-sdk"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$AbstractHierarchicalUri\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    private static abstract class AbstractHierarchicalUri
    extends Uri {
        @Nullable
        private Part _userInfoPart;
        @Nullable
        private volatile String host = "NOT CACHED";
        private volatile int port = -2;

        public AbstractHierarchicalUri() {
            super(null);
        }

        @Override
        @Nullable
        public String getLastPathSegment() {
            List<String> segments = this.getPathSegments();
            int size = segments.size();
            if (size == 0) {
                return null;
            }
            return segments.get(size - 1);
        }

        @NotNull
        public final Part getUserInfoPart() {
            Part part;
            if (this._userInfoPart == null) {
                Part part2;
                Part it = part2 = Part.Companion.fromEncoded(this.parseUserInfo());
                boolean bl = false;
                this._userInfoPart = it;
                part = part2;
            } else {
                Part part3 = this._userInfoPart;
                part = part3;
                Intrinsics.checkNotNull((Object)part3);
            }
            return part;
        }

        @Override
        @Nullable
        public String getEncodedUserInfo() {
            return this.getUserInfoPart().getEncoded();
        }

        @Nullable
        public final String parseUserInfo() {
            String string;
            String string2 = this.getEncodedAuthority();
            if (string2 == null) {
                return null;
            }
            String authority = string2;
            int end = StringsKt.lastIndexOf$default((CharSequence)authority, (char)'@', (int)0, (boolean)false, (int)6, null);
            if (end == -1) {
                string = null;
            } else {
                String string3 = authority.substring(0, end);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
            return string;
        }

        @Override
        @Nullable
        public String getUserInfo() {
            return this.getUserInfoPart().getDecoded();
        }

        @Override
        @Nullable
        public String getHost() {
            String string;
            boolean cached;
            boolean bl = cached = this.host != "NOT CACHED";
            if (cached) {
                string = this.host;
            } else {
                String string2;
                String it = string2 = this.parseHost();
                boolean bl2 = false;
                this.host = it;
                string = string2;
            }
            return string;
        }

        public void setHost(@Nullable String string) {
            this.host = string;
        }

        @Nullable
        public final String parseHost() {
            String string;
            String string2 = this.getEncodedAuthority();
            if (string2 == null) {
                return null;
            }
            String authority = string2;
            int userInfoSeparator = StringsKt.lastIndexOf$default((CharSequence)authority, (char)'@', (int)0, (boolean)false, (int)6, null);
            int portSeparator = this.findPortSeparator(authority);
            if (portSeparator == -1) {
                String string3 = authority.substring(userInfoSeparator + 1);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                String string4 = authority.substring(userInfoSeparator + 1, portSeparator);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            }
            String encodedHost = string;
            return Companion.decode(encodedHost);
        }

        @Override
        public int getPort() {
            int n;
            if (this.port == -2) {
                int n2;
                int it = n2 = this.parsePort();
                boolean bl = false;
                this.port = it;
                n = n2;
            } else {
                n = this.port;
            }
            return n;
        }

        public void setPort(int n) {
            this.port = n;
        }

        public final int parsePort() {
            String authority = this.getEncodedAuthority();
            int portSeparator = this.findPortSeparator(authority);
            if (portSeparator == -1) {
                return -1;
            }
            String string = authority;
            Intrinsics.checkNotNull((Object)string);
            String string2 = string.substring(portSeparator + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = Companion.decode(string2);
            Intrinsics.checkNotNull((Object)string3);
            String portString = string3;
            try {
                return Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                Log.w(LOG, "Error parsing port string.", e);
                return -1;
            }
        }

        public final int findPortSeparator(@Nullable String authority) {
            if (authority == null) {
                return -1;
            }
            for (int i = authority.length() - 1; -1 < i; --i) {
                char character = authority.charAt(i);
                if (':' == character) {
                    return i;
                }
                if (character >= '0' && character <= '9') continue;
                return -1;
            }
            return -1;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b&\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0011"}, d2={"Landroid/net/Uri$AbstractPart;", "", "encoded", "", "decoded", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "_encoded", "get_encoded", "()Ljava/lang/String;", "set_encoded", "(Ljava/lang/String;)V", "_decoded", "get_decoded", "set_decoded", "getEncoded", "getDecoded", "firebase-java-sdk"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$AbstractPart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    public static abstract class AbstractPart {
        @Nullable
        private volatile String _encoded;
        @Nullable
        private volatile String _decoded;

        public AbstractPart(@Nullable String encoded, @Nullable String decoded) {
            if (encoded != "NOT CACHED") {
                this._encoded = encoded;
                this._decoded = "NOT CACHED";
            } else if (decoded != "NOT CACHED") {
                this._encoded = "NOT CACHED";
                this._decoded = decoded;
            } else {
                throw new IllegalArgumentException("Neither encoded nor decoded");
            }
        }

        @Nullable
        protected final String get_encoded() {
            return this._encoded;
        }

        protected final void set_encoded(@Nullable String string) {
            this._encoded = string;
        }

        @Nullable
        protected final String get_decoded() {
            return this._decoded;
        }

        protected final void set_decoded(@Nullable String string) {
            this._decoded = string;
        }

        @Nullable
        public abstract String getEncoded();

        @Nullable
        public final String getDecoded() {
            String string;
            boolean hasDecoded;
            boolean bl = hasDecoded = this._decoded != "NOT CACHED";
            if (hasDecoded) {
                string = this._decoded;
            } else {
                String string2;
                String it = string2 = Companion.decode(this._encoded);
                boolean bl2 = false;
                this._decoded = it;
                string = string2;
            }
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\r\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u0015\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroid/net/Uri$Builder;", "", "<init>", "()V", "scheme", "", "opaquePart", "Landroid/net/Uri$Part;", "authority", "path", "Landroid/net/Uri$PathPart;", "query", "fragment", "encodedOpaquePart", "encodedAuthority", "encodedPath", "appendPath", "newSegment", "appendEncodedPath", "encodedQuery", "encodedFragment", "appendQueryParameter", "key", "value", "clearQuery", "build", "Landroid/net/Uri;", "hasSchemeOrAuthority", "", "toString", "firebase-java-sdk"})
    public static final class Builder {
        @Nullable
        private String scheme;
        @Nullable
        private Part opaquePart;
        @Nullable
        private Part authority;
        @Nullable
        private PathPart path;
        @Nullable
        private Part query;
        @Nullable
        private Part fragment;

        @NotNull
        public final Builder scheme(@Nullable String scheme) {
            if (scheme != null) {
                CharSequence charSequence = scheme;
                Regex regex = new Regex("://");
                String string = "";
                this.scheme = regex.replace(charSequence, string);
            } else {
                this.scheme = null;
            }
            return this;
        }

        @NotNull
        public final Builder opaquePart(@Nullable Part opaquePart) {
            this.opaquePart = opaquePart;
            return this;
        }

        @NotNull
        public final Builder opaquePart(@Nullable String opaquePart) {
            return this.opaquePart(Part.Companion.fromDecoded(opaquePart));
        }

        @NotNull
        public final Builder encodedOpaquePart(@Nullable String opaquePart) {
            return this.opaquePart(Part.Companion.fromEncoded(opaquePart));
        }

        @NotNull
        public final Builder authority(@Nullable Part authority) {
            this.opaquePart = null;
            this.authority = authority;
            return this;
        }

        @NotNull
        public final Builder authority(@Nullable String authority) {
            return this.authority(Part.Companion.fromDecoded(authority));
        }

        @NotNull
        public final Builder encodedAuthority(@Nullable String authority) {
            return this.authority(Part.Companion.fromEncoded(authority));
        }

        @NotNull
        public final Builder path(@Nullable PathPart path) {
            this.opaquePart = null;
            this.path = path;
            return this;
        }

        @NotNull
        public final Builder path(@Nullable String path) {
            return this.path(PathPart.Companion.fromDecoded(path));
        }

        @NotNull
        public final Builder encodedPath(@Nullable String path) {
            return this.path(PathPart.Companion.fromEncoded(path));
        }

        @NotNull
        public final Builder appendPath(@Nullable String newSegment) {
            return this.path(PathPart.Companion.appendDecodedSegment(this.path, newSegment));
        }

        @NotNull
        public final Builder appendEncodedPath(@Nullable String newSegment) {
            return this.path(PathPart.Companion.appendEncodedSegment(this.path, newSegment));
        }

        @NotNull
        public final Builder query(@Nullable Part query) {
            this.opaquePart = null;
            this.query = query;
            return this;
        }

        @NotNull
        public final Builder query(@Nullable String query) {
            return this.query(Part.Companion.fromDecoded(query));
        }

        @NotNull
        public final Builder encodedQuery(@Nullable String query) {
            return this.query(Part.Companion.fromEncoded(query));
        }

        @NotNull
        public final Builder fragment(@Nullable Part fragment) {
            this.fragment = fragment;
            return this;
        }

        @NotNull
        public final Builder fragment(@Nullable String fragment) {
            return this.fragment(Part.Companion.fromDecoded(fragment));
        }

        @NotNull
        public final Builder encodedFragment(@Nullable String fragment) {
            return this.fragment(Part.Companion.fromEncoded(fragment));
        }

        @NotNull
        public final Builder appendQueryParameter(@Nullable String key, @Nullable String value) {
            this.opaquePart = null;
            String encodedParameter = Companion.encode(key, null) + "=" + Companion.encode(value, null);
            if (this.query == null) {
                this.query = Part.Companion.fromEncoded(encodedParameter);
                return this;
            }
            Part part = this.query;
            Intrinsics.checkNotNull((Object)part);
            String oldQuery = part.getEncoded();
            CharSequence charSequence = oldQuery;
            this.query = charSequence == null || charSequence.length() == 0 ? Part.Companion.fromEncoded(encodedParameter) : Part.Companion.fromEncoded(oldQuery + "&" + encodedParameter);
            return this;
        }

        @NotNull
        public final Builder clearQuery() {
            return this.query((Part)null);
        }

        @NotNull
        public final Uri build() {
            if (this.opaquePart != null) {
                if (this.scheme == null) {
                    throw new UnsupportedOperationException("An opaque URI must have a scheme.");
                }
                Part part = this.opaquePart;
                Intrinsics.checkNotNull((Object)part);
                return new OpaqueUri(this.scheme, part, this.fragment);
            }
            PathPart path = this.path;
            if (path == null || path == PathPart.Companion.getNULL()) {
                path = PathPart.Companion.getEMPTY();
            } else if (this.hasSchemeOrAuthority()) {
                path = PathPart.Companion.makeAbsolute(path);
            }
            return new HierarchicalUri(this.scheme, this.authority, path, this.query, this.fragment);
        }

        private final boolean hasSchemeOrAuthority() {
            return this.scheme != null || this.authority != null && this.authority != Part.Companion.getNULL();
        }

        @NotNull
        public String toString() {
            return this.build().toString();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0012\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J&\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u0007J \u0010%\u001a\u0004\u0018\u00010\u00052\b\u0010&\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010'\u001a\u0004\u0018\u00010\u0005H\u0002J\u001e\u0010,\u001a\u0004\u0018\u00010\u00052\b\u0010-\u001a\u0004\u0018\u00010\u00052\b\u0010'\u001a\u0004\u0018\u00010\u0005H\u0007J\u001c\u0010.\u001a\u00020)2\b\u0010-\u001a\u0004\u0018\u00010\u00052\b\u0010'\u001a\u0004\u0018\u00010\u0005H\u0003J\u0014\u0010/\u001a\u0004\u0018\u00010\u00052\b\u0010&\u001a\u0004\u0018\u00010\u0005H\u0007J\u0014\u00100\u001a\u0004\u0018\u00010\u00052\b\u0010-\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00072\b\u00103\u001a\u0004\u0018\u00010\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001a8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0003\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Landroid/net/Uri$Companion;", "", "<init>", "()V", "LOG", "", "EMPTY", "Landroid/net/Uri;", "getEMPTY", "()Landroid/net/Uri;", "NOT_FOUND", "", "NOT_CALCULATED", "NOT_HIERARCHICAL", "DEFAULT_ENCODING", "parse", "uriString", "fromFile", "file", "Ljava/io/File;", "fromParts", "scheme", "ssp", "fragment", "NULL_TYPE_ID", "CREATOR", "Landroid/os/Parcelable$Creator;", "getCREATOR$annotations", "getCREATOR", "()Landroid/os/Parcelable$Creator;", "writeToParcel", "", "out", "Landroid/os/Parcel;", "uri", "HEX_DIGITS", "", "encode", "s", "allow", "isAllowed", "", "c", "", "encodeIfNotEncoded", "value", "isEncoded", "decode", "decodeIfNeeded", "withAppendedPath", "baseUri", "pathSegment", "firebase-java-sdk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Uri getEMPTY() {
            return EMPTY;
        }

        @JvmStatic
        @NotNull
        public final Uri parse(@NotNull String uriString) {
            Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
            return new StringUri(uriString);
        }

        @JvmStatic
        @NotNull
        public final Uri fromFile(@Nullable File file) {
            if (file == null) {
                throw new NullPointerException("file");
            }
            PathPart path = PathPart.Companion.fromDecoded(file.getAbsolutePath());
            return new HierarchicalUri("file", Part.Companion.getEMPTY(), path, Part.Companion.getNULL(), Part.Companion.getNULL());
        }

        @JvmStatic
        @NotNull
        public final Uri fromParts(@Nullable String scheme, @Nullable String ssp, @Nullable String fragment) {
            if (scheme == null) {
                throw new NullPointerException("scheme");
            }
            if (ssp == null) {
                throw new NullPointerException("ssp");
            }
            return new OpaqueUri(scheme, Part.Companion.fromDecoded(ssp), Part.Companion.fromDecoded(fragment));
        }

        @NotNull
        public final Parcelable.Creator<Uri> getCREATOR() {
            return CREATOR;
        }

        @JvmStatic
        public static /* synthetic */ void getCREATOR$annotations() {
        }

        @JvmStatic
        public final void writeToParcel(@NotNull Parcel out, @Nullable Uri uri) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            if (uri == null) {
                out.writeInt(0);
            } else {
                uri.writeToParcel(out, 0);
            }
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final String encode(@Nullable String s, @Nullable String allow) {
            if (s == null) {
                return null;
            }
            StringBuilder encoded = null;
            int oldLength = s.length();
            int current = 0;
            while (current < oldLength) {
                int nextAllowed;
                int nextToEncode;
                for (nextToEncode = current; nextToEncode < oldLength && this.isAllowed(s.charAt(nextToEncode), allow); ++nextToEncode) {
                }
                if (nextToEncode == oldLength) {
                    if (current == 0) {
                        return s;
                    }
                    StringBuilder stringBuilder = encoded;
                    Intrinsics.checkNotNull((Object)stringBuilder);
                    stringBuilder.append(s, current, oldLength);
                    return encoded.toString();
                }
                if (encoded == null) {
                    encoded = new StringBuilder();
                }
                if (nextToEncode > current) {
                    encoded.append(s, current, nextToEncode);
                }
                current = nextToEncode;
                for (nextAllowed = current + 1; nextAllowed < oldLength && !this.isAllowed(s.charAt(nextAllowed), allow); ++nextAllowed) {
                }
                Intrinsics.checkNotNullExpressionValue((Object)s.substring(current, nextAllowed), (String)"substring(...)");
                try {
                    byte[] bytes;
                    String toEncode;
                    Charset charset = Charset.forName(Uri.DEFAULT_ENCODING);
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)toEncode.getBytes(charset), (String)"getBytes(...)");
                    int bytesLength = bytes.length;
                    for (int i = 0; i < bytesLength; ++i) {
                        encoded.append('%');
                        encoded.append(HEX_DIGITS[(bytes[i] & 0xF0) >> 4]);
                        encoded.append(HEX_DIGITS[bytes[i] & 0xF]);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)e);
                }
                current = nextAllowed;
            }
            CharSequence charSequence = encoded;
            if (charSequence == null || (charSequence = charSequence.toString()) == null) {
                charSequence = s;
            }
            return charSequence;
        }

        public static /* synthetic */ String encode$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.encode(string, string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAllowed(char c, String allow) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if ('A' <= c) {
                if (c < '[') {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if ('a' <= c) {
                if (c < '{') {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if ('0' <= c) {
                if (c < ':') {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (StringsKt.indexOf$default((CharSequence)"_-!.~'()*", (char)c, (int)0, (boolean)false, (int)6, null) != -1) return true;
            if (allow == null) return false;
            if (StringsKt.indexOf$default((CharSequence)allow, (char)c, (int)0, (boolean)false, (int)6, null) == -1) return false;
            return true;
        }

        @JvmStatic
        @Nullable
        public final String encodeIfNotEncoded(@Nullable String value, @Nullable String allow) {
            if (value == null) {
                return null;
            }
            if (this.isEncoded(value, allow)) {
                return value;
            }
            return this.encode(value, allow);
        }

        @JvmStatic
        private final boolean isEncoded(String value, String allow) {
            if (value == null) {
                return true;
            }
            for (int i = 0; i < ((CharSequence)value).length(); ++i) {
                char c = ((CharSequence)value).charAt(i);
                if (this.isAllowed(c, allow) || c == '%') continue;
                return false;
            }
            return true;
        }

        @JvmStatic
        @Nullable
        public final String decode(@Nullable String s) {
            if (s == null) {
                return null;
            }
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            return UriCodec.decode(s, false, charset, false);
        }

        @JvmStatic
        @Nullable
        public final String decodeIfNeeded(@Nullable String value) {
            if (value == null) {
                return null;
            }
            if (StringsKt.contains$default((CharSequence)value, (CharSequence)"%", (boolean)false, (int)2, null)) {
                return this.decode(value);
            }
            return value;
        }

        @JvmStatic
        @NotNull
        public final Uri withAppendedPath(@NotNull Uri baseUri, @Nullable String pathSegment) {
            Intrinsics.checkNotNullParameter((Object)baseUri, (String)"baseUri");
            Builder builder = baseUri.buildUpon();
            builder = builder.appendEncodedPath(pathSegment);
            return builder.build();
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final String encode(@Nullable String s) {
            return android.net.Uri$Companion.encode$default(this, s, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 A2\u00020\u0001:\u0001AB7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0006\u0010'\u001a\u00020\u0003J\u0012\u0010(\u001a\u00020\u00172\n\u0010)\u001a\u00060*j\u0002`+J\b\u0010=\u001a\u00020\u0003H\u0016J\u0006\u0010>\u001a\u00020\u0003J\b\u0010?\u001a\u00020@H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001dR$\u0010 \u001a\u0004\u0018\u00010\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\rR\u0016\u0010%\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\rR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\rR\u0016\u0010-\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\rR\u0016\u0010/\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\rR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\rR\u0016\u0010\b\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\rR\u0016\u00103\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\rR\u0016\u0010\t\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\rR\u0016\u00106\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\rR\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020\u0003098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Landroid/net/Uri$HierarchicalUri;", "Landroid/net/Uri$AbstractHierarchicalUri;", "scheme", "", "authority", "Landroid/net/Uri$Part;", "path", "Landroid/net/Uri$PathPart;", "query", "fragment", "<init>", "(Ljava/lang/String;Landroid/net/Uri$Part;Landroid/net/Uri$PathPart;Landroid/net/Uri$Part;Landroid/net/Uri$Part;)V", "getScheme", "()Ljava/lang/String;", "_authority", "_path", "_query", "_fragment", "generatePath", "originalPath", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "isHierarchical", "", "()Z", "isRelative", "value", "ssp", "getSsp", "()Landroid/net/Uri$Part;", "encodedSchemeSpecificPart", "getEncodedSchemeSpecificPart", "schemeSpecificPart", "getSchemeSpecificPart", "makeSchemeSpecificPart", "appendSspTo", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getAuthority", "encodedAuthority", "getEncodedAuthority", "encodedPath", "getEncodedPath", "getPath", "getQuery", "encodedQuery", "getEncodedQuery", "getFragment", "encodedFragment", "getEncodedFragment", "pathSegments", "", "getPathSegments", "()Ljava/util/List;", "uriString", "toString", "makeUriString", "buildUpon", "Landroid/net/Uri$Builder;", "Companion", "firebase-java-sdk"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$HierarchicalUri\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    private static final class HierarchicalUri
    extends AbstractHierarchicalUri {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String scheme;
        @NotNull
        private final Part _authority;
        @NotNull
        private final PathPart _path;
        @NotNull
        private final Part _query;
        @NotNull
        private final Part _fragment;
        @Nullable
        private Part ssp;
        @NotNull
        private volatile String uriString;
        public static final int TYPE_ID = 3;

        public HierarchicalUri(@Nullable String scheme, @Nullable Part authority, @NotNull PathPart path, @Nullable Part query, @Nullable Part fragment) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.scheme = scheme;
            this._authority = Part.Companion.nonNull(authority);
            this._path = this.generatePath(path);
            this._query = Part.Companion.nonNull(query);
            this._fragment = Part.Companion.nonNull(fragment);
            this.uriString = "NOT CACHED";
        }

        @Override
        @Nullable
        public String getScheme() {
            return this.scheme;
        }

        @NotNull
        public final PathPart generatePath(@NotNull PathPart originalPath) {
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            boolean hasSchemeOrAuthority = this.getScheme() != null && this.getScheme().length() > 0 || !this._authority.isEmpty();
            return hasSchemeOrAuthority ? PathPart.Companion.makeAbsolute(originalPath) : originalPath;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            parcel.writeInt(3);
            parcel.writeString8(this.toString());
        }

        @Override
        public boolean isHierarchical() {
            return true;
        }

        @Override
        public boolean isRelative() {
            return this.getScheme() == null;
        }

        @Nullable
        public final Part getSsp() {
            Part part;
            if (this.ssp == null) {
                Part part2;
                Part it = part2 = Part.Companion.fromEncoded(this.makeSchemeSpecificPart());
                boolean bl = false;
                this.ssp = it;
                part = part2;
            } else {
                part = this.ssp;
            }
            return part;
        }

        @Override
        @Nullable
        public String getEncodedSchemeSpecificPart() {
            Part part = this.getSsp();
            Intrinsics.checkNotNull((Object)part);
            return part.getEncoded();
        }

        @Override
        @Nullable
        public String getSchemeSpecificPart() {
            Part part = this.getSsp();
            Intrinsics.checkNotNull((Object)part);
            return part.getDecoded();
        }

        @NotNull
        public final String makeSchemeSpecificPart() {
            StringBuilder builder = new StringBuilder();
            this.appendSspTo(builder);
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public final void appendSspTo(@NotNull StringBuilder builder) {
            String encodedPath;
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            String encodedAuthority = this._authority.getEncoded();
            if (encodedAuthority != null) {
                builder.append("//").append(encodedAuthority);
            }
            if ((encodedPath = this._path.getEncoded()) != null) {
                builder.append(encodedPath);
            }
            if (!this._query.isEmpty()) {
                builder.append('?').append(this._query.getEncoded());
            }
        }

        @Override
        @Nullable
        public String getAuthority() {
            return this._authority.getDecoded();
        }

        @Override
        @Nullable
        public String getEncodedAuthority() {
            return this._authority.getEncoded();
        }

        @Override
        @Nullable
        public String getEncodedPath() {
            return this._path.getEncoded();
        }

        @Override
        @Nullable
        public String getPath() {
            return this._path.getDecoded();
        }

        @Override
        @Nullable
        public String getQuery() {
            return this._query.getDecoded();
        }

        @Override
        @Nullable
        public String getEncodedQuery() {
            return this._query.getEncoded();
        }

        @Override
        @Nullable
        public String getFragment() {
            return this._fragment.getDecoded();
        }

        @Override
        @Nullable
        public String getEncodedFragment() {
            return this._fragment.getEncoded();
        }

        @Override
        @NotNull
        public List<String> getPathSegments() {
            return CollectionsKt.filterNotNull((Iterable)this._path.getPathSegments());
        }

        @Override
        @NotNull
        public String toString() {
            String string;
            boolean cached;
            boolean bl = cached = this.uriString != "NOT CACHED";
            if (cached) {
                string = this.uriString;
            } else {
                String string2;
                String it = string2 = this.makeUriString();
                boolean bl2 = false;
                this.uriString = it;
                string = string2;
            }
            return string;
        }

        @NotNull
        public final String makeUriString() {
            StringBuilder builder = new StringBuilder();
            if (this.getScheme() != null) {
                builder.append(this.getScheme()).append(':');
            }
            this.appendSspTo(builder);
            if (!this._fragment.isEmpty()) {
                builder.append('#').append(this._fragment.getEncoded());
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        @NotNull
        public Builder buildUpon() {
            return new Builder().scheme(this.getScheme()).authority(this._authority).path(this._path).query(this._query).fragment(this._fragment);
        }

        @JvmStatic
        @NotNull
        public static final Uri readFrom(@NotNull Parcel parcel) {
            return Companion.readFrom(parcel);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroid/net/Uri$HierarchicalUri$Companion;", "", "<init>", "()V", "TYPE_ID", "", "readFrom", "Landroid/net/Uri;", "parcel", "Landroid/os/Parcel;", "firebase-java-sdk"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Uri readFrom(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                StringUri stringUri = new StringUri(parcel.readString8());
                return new HierarchicalUri(stringUri.getScheme(), stringUri.getAuthorityPart(), stringUri.getPathPart(), stringUri.getQueryPart(), stringUri.getFragmentPart());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroid/net/Uri$NotCachedHolder;", "", "<init>", "()V", "NOT_CACHED", "", "firebase-java-sdk"})
    public static final class NotCachedHolder {
        @NotNull
        public static final NotCachedHolder INSTANCE = new NotCachedHolder();
        @NotNull
        public static final String NOT_CACHED = "NOT CACHED";

        private NotCachedHolder() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 =2\u00020\u0001:\u0001=B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010:\u001a\u00020\u0003H\u0016J\b\u0010;\u001a\u00020<H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\nR\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\nR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\nR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\nR\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\nR\u0016\u0010!\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\nR\u0016\u0010#\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\nR\u0016\u0010%\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\nR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\nR\u0016\u0010(\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\nR\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0016\u0010.\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\nR\u0016\u00100\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\nR\u0016\u00102\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\nR\u0016\u00104\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\nR\u0014\u00106\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u000e\u00109\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Landroid/net/Uri$OpaqueUri;", "Landroid/net/Uri;", "scheme", "", "ssp", "Landroid/net/Uri$Part;", "fragment", "<init>", "(Ljava/lang/String;Landroid/net/Uri$Part;Landroid/net/Uri$Part;)V", "getScheme", "()Ljava/lang/String;", "_fragment", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "isHierarchical", "", "()Z", "isRelative", "encodedSchemeSpecificPart", "getEncodedSchemeSpecificPart", "schemeSpecificPart", "getSchemeSpecificPart", "authority", "getAuthority", "encodedAuthority", "getEncodedAuthority", "path", "getPath", "encodedPath", "getEncodedPath", "query", "getQuery", "encodedQuery", "getEncodedQuery", "getFragment", "encodedFragment", "getEncodedFragment", "pathSegments", "", "getPathSegments", "()Ljava/util/List;", "lastPathSegment", "getLastPathSegment", "userInfo", "getUserInfo", "encodedUserInfo", "getEncodedUserInfo", "host", "getHost", "port", "getPort", "()I", "cachedString", "toString", "buildUpon", "Landroid/net/Uri$Builder;", "Companion", "firebase-java-sdk"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$OpaqueUri\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    private static final class OpaqueUri
    extends Uri {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String scheme;
        @NotNull
        private final Part ssp;
        @NotNull
        private final Part _fragment;
        @NotNull
        private volatile String cachedString;
        public static final int TYPE_ID = 2;

        public OpaqueUri(@Nullable String scheme, @NotNull Part ssp, @Nullable Part fragment) {
            Intrinsics.checkNotNullParameter((Object)ssp, (String)"ssp");
            super(null);
            this.scheme = scheme;
            this.ssp = ssp;
            Part part = fragment;
            if (part == null) {
                part = Part.Companion.getNULL();
            }
            this._fragment = part;
            this.cachedString = "NOT CACHED";
        }

        @Override
        @Nullable
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            parcel.writeInt(2);
            parcel.writeString8(this.toString());
        }

        @Override
        public boolean isHierarchical() {
            return false;
        }

        @Override
        public boolean isRelative() {
            return this.getScheme() == null;
        }

        @Override
        @Nullable
        public String getEncodedSchemeSpecificPart() {
            return this.ssp.getEncoded();
        }

        @Override
        @Nullable
        public String getSchemeSpecificPart() {
            return this.ssp.getDecoded();
        }

        @Override
        @Nullable
        public String getAuthority() {
            return null;
        }

        @Override
        @Nullable
        public String getEncodedAuthority() {
            return null;
        }

        @Override
        @Nullable
        public String getPath() {
            return null;
        }

        @Override
        @Nullable
        public String getEncodedPath() {
            return null;
        }

        @Override
        @Nullable
        public String getQuery() {
            return null;
        }

        @Override
        @Nullable
        public String getEncodedQuery() {
            return null;
        }

        @Override
        @Nullable
        public String getFragment() {
            return this._fragment.getDecoded();
        }

        @Override
        @Nullable
        public String getEncodedFragment() {
            return this._fragment.getEncoded();
        }

        @Override
        @NotNull
        public List<String> getPathSegments() {
            return CollectionsKt.emptyList();
        }

        @Override
        @Nullable
        public String getLastPathSegment() {
            return null;
        }

        @Override
        @Nullable
        public String getUserInfo() {
            return null;
        }

        @Override
        @Nullable
        public String getEncodedUserInfo() {
            return null;
        }

        @Override
        @Nullable
        public String getHost() {
            return null;
        }

        @Override
        public int getPort() {
            return -1;
        }

        @Override
        @NotNull
        public String toString() {
            String string;
            boolean cached;
            boolean bl = cached = this.cachedString != "NOT CACHED";
            if (cached) {
                return this.cachedString;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.getScheme()).append(':');
            sb.append(this.getEncodedSchemeSpecificPart());
            if (!this._fragment.isEmpty()) {
                sb.append('#').append(this._fragment.getEncoded());
            }
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String it = string = string2;
            boolean bl2 = false;
            this.cachedString = it;
            return string;
        }

        @Override
        @NotNull
        public Builder buildUpon() {
            return new Builder().scheme(this.getScheme()).opaquePart(this.ssp).fragment(this.getFragment());
        }

        @JvmStatic
        @NotNull
        public static final Uri readFrom(@NotNull Parcel parcel) {
            return Companion.readFrom(parcel);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroid/net/Uri$OpaqueUri$Companion;", "", "<init>", "()V", "TYPE_ID", "", "readFrom", "Landroid/net/Uri;", "parcel", "Landroid/os/Parcel;", "firebase-java-sdk"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Uri readFrom(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                StringUri stringUri = new StringUri(parcel.readString8());
                String string = stringUri.parseScheme();
                Part part = stringUri.getSsp();
                Intrinsics.checkNotNull((Object)part);
                return new OpaqueUri(string, part, stringUri.getFragmentPart());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u001d\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Landroid/net/Uri$Part;", "Landroid/net/Uri$AbstractPart;", "encoded", "", "decoded", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "isEmpty", "", "()Z", "getEncoded", "()Ljava/lang/String;", "EmptyPart", "Companion", "firebase-java-sdk"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$Part\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    public static class Part
    extends AbstractPart {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final Part NULL = new EmptyPart(null);
        @NotNull
        private static final Part EMPTY = new EmptyPart("");

        private Part(String encoded, String decoded) {
            super(encoded, decoded);
        }

        public boolean isEmpty() {
            return false;
        }

        @Override
        @Nullable
        public String getEncoded() {
            String string;
            boolean hasEncoded;
            boolean bl = hasEncoded = this.get_encoded() != "NOT CACHED";
            if (hasEncoded) {
                string = this.get_encoded();
            } else {
                String string2;
                String it = string2 = android.net.Uri$Companion.encode$default(Companion, this.get_decoded(), null, 2, null);
                boolean bl2 = false;
                this.set_encoded(it);
                string = string2;
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public static final Part nonNull(@Nullable Part part) {
            return Companion.nonNull(part);
        }

        @JvmStatic
        @NotNull
        public static final Part fromEncoded(@Nullable String encoded) {
            return Companion.fromEncoded(encoded);
        }

        @JvmStatic
        @NotNull
        public static final Part fromDecoded(@Nullable String decoded) {
            return Companion.fromDecoded(decoded);
        }

        @JvmStatic
        @NotNull
        public static final Part from(@Nullable String encoded, @Nullable String decoded) {
            return Companion.from(encoded, decoded);
        }

        public /* synthetic */ Part(String encoded, String decoded, DefaultConstructorMarker $constructor_marker) {
            this(encoded, decoded);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0007J\u001c\u0010\u0011\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0012"}, d2={"Landroid/net/Uri$Part$Companion;", "", "<init>", "()V", "NULL", "Landroid/net/Uri$Part;", "getNULL", "()Landroid/net/Uri$Part;", "EMPTY", "getEMPTY", "nonNull", "part", "fromEncoded", "encoded", "", "fromDecoded", "decoded", "from", "firebase-java-sdk"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Part getNULL() {
                return NULL;
            }

            @NotNull
            public final Part getEMPTY() {
                return EMPTY;
            }

            @JvmStatic
            @NotNull
            public final Part nonNull(@Nullable Part part) {
                Part part2 = part;
                if (part2 == null) {
                    part2 = this.getNULL();
                }
                return part2;
            }

            @JvmStatic
            @NotNull
            public final Part fromEncoded(@Nullable String encoded) {
                return this.from(encoded, "NOT CACHED");
            }

            @JvmStatic
            @NotNull
            public final Part fromDecoded(@Nullable String decoded) {
                return this.from("NOT CACHED", decoded);
            }

            @JvmStatic
            @NotNull
            public final Part from(@Nullable String encoded, @Nullable String decoded) {
                if (encoded == null) {
                    return this.getNULL();
                }
                if (((CharSequence)encoded).length() == 0) {
                    return this.getEMPTY();
                }
                if (decoded == null) {
                    return this.getNULL();
                }
                if (((CharSequence)decoded).length() == 0) {
                    return this.getEMPTY();
                }
                return new Part(encoded, decoded, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\t"}, d2={"Landroid/net/Uri$Part$EmptyPart;", "Landroid/net/Uri$Part;", "value", "", "<init>", "(Ljava/lang/String;)V", "isEmpty", "", "()Z", "firebase-java-sdk"})
        @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$Part$EmptyPart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
        private static final class EmptyPart
        extends Part {
            public EmptyPart(@Nullable String value) {
                super(value, value, null);
                CharSequence charSequence = value;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    boolean bl = false;
                    String string = "Expected empty value, got: " + value;
                    throw new IllegalArgumentException(string.toString());
                }
                this.set_decoded(value);
                this.set_encoded(this.get_decoded());
            }

            @Override
            public boolean isEmpty() {
                return true;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001d\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Landroid/net/Uri$PathPart;", "Landroid/net/Uri$AbstractPart;", "encoded", "", "decoded", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getEncoded", "()Ljava/lang/String;", "_pathSegments", "Landroid/net/Uri$PathSegments;", "pathSegments", "getPathSegments", "()Landroid/net/Uri$PathSegments;", "Companion", "firebase-java-sdk"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$PathPart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    public static final class PathPart
    extends AbstractPart {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private PathSegments _pathSegments;
        @NotNull
        private static final PathPart NULL = new PathPart(null, null);
        @NotNull
        private static final PathPart EMPTY = new PathPart("", "");

        private PathPart(String encoded, String decoded) {
            super(encoded, decoded);
        }

        @Override
        @Nullable
        public String getEncoded() {
            String string;
            boolean hasEncoded;
            boolean bl = hasEncoded = this.get_encoded() != "NOT CACHED";
            if (hasEncoded) {
                string = this.get_encoded();
            } else {
                String string2;
                String it = string2 = Companion.encode(this.get_decoded(), "/");
                boolean bl2 = false;
                this.set_encoded(it);
                string = string2;
            }
            return string;
        }

        @NotNull
        public final PathSegments getPathSegments() {
            PathSegments pathSegments;
            if (this._pathSegments != null) {
                PathSegments pathSegments2 = this._pathSegments;
                Intrinsics.checkNotNull((Object)pathSegments2);
                return pathSegments2;
            }
            String string = this.getEncoded();
            if (string == null) {
                PathSegments pathSegments3;
                PathSegments it = pathSegments3 = PathSegments.Companion.getEMPTY();
                boolean bl = false;
                this._pathSegments = it;
                return pathSegments3;
            }
            String path = string;
            PathSegmentsBuilder segmentBuilder = new PathSegmentsBuilder();
            int previous = 0;
            int current = 0;
            while (true) {
                int bl;
                int it = bl = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)previous, (boolean)false, (int)4, null);
                boolean bl2 = false;
                current = it;
                if (bl <= -1) break;
                if (previous < current) {
                    String string2 = path.substring(previous, current);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String decodedSegment = Companion.decode(string2);
                    segmentBuilder.add(decodedSegment);
                }
                previous = current + 1;
            }
            if (previous < path.length()) {
                String string3 = path.substring(previous);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                segmentBuilder.add(Companion.decode(string3));
            }
            PathSegments it = pathSegments = segmentBuilder.build();
            boolean bl = false;
            this._pathSegments = it;
            return pathSegments;
        }

        @JvmStatic
        @NotNull
        public static final PathPart appendEncodedSegment(@Nullable PathPart oldPart, @Nullable String newSegment) {
            return Companion.appendEncodedSegment(oldPart, newSegment);
        }

        @JvmStatic
        @NotNull
        public static final PathPart appendDecodedSegment(@Nullable PathPart oldPart, @Nullable String decoded) {
            return Companion.appendDecodedSegment(oldPart, decoded);
        }

        @JvmStatic
        @NotNull
        public static final PathPart fromEncoded(@Nullable String encoded) {
            return Companion.fromEncoded(encoded);
        }

        @JvmStatic
        @NotNull
        public static final PathPart fromDecoded(@Nullable String decoded) {
            return Companion.fromDecoded(decoded);
        }

        @JvmStatic
        @NotNull
        public static final PathPart from(@Nullable String encoded, @Nullable String decoded) {
            return Companion.from(encoded, decoded);
        }

        @JvmStatic
        @NotNull
        public static final PathPart makeAbsolute(@NotNull PathPart oldPart) {
            return Companion.makeAbsolute(oldPart);
        }

        public /* synthetic */ PathPart(String encoded, String decoded, DefaultConstructorMarker $constructor_marker) {
            this(encoded, decoded);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u001c\u0010\u000e\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0007J\u0012\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0007J\u0012\u0010\u0012\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0007J\u001c\u0010\u0013\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0007J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0015"}, d2={"Landroid/net/Uri$PathPart$Companion;", "", "<init>", "()V", "NULL", "Landroid/net/Uri$PathPart;", "getNULL", "()Landroid/net/Uri$PathPart;", "EMPTY", "getEMPTY", "appendEncodedSegment", "oldPart", "newSegment", "", "appendDecodedSegment", "decoded", "fromEncoded", "encoded", "fromDecoded", "from", "makeAbsolute", "firebase-java-sdk"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PathPart getNULL() {
                return NULL;
            }

            @NotNull
            public final PathPart getEMPTY() {
                return EMPTY;
            }

            @JvmStatic
            @NotNull
            public final PathPart appendEncodedSegment(@Nullable PathPart oldPart, @Nullable String newSegment) {
                int oldPathLength;
                if (oldPart == null) {
                    return this.fromEncoded("/" + newSegment);
                }
                String oldPath = oldPart.getEncoded();
                if (oldPath == null) {
                    oldPath = "";
                }
                String newPath = (oldPathLength = oldPath.length()) == 0 ? "/" + newSegment : (oldPath.charAt(oldPathLength - 1) == '/' ? oldPath + newSegment : oldPath + "/" + newSegment);
                return this.fromEncoded(newPath);
            }

            @JvmStatic
            @NotNull
            public final PathPart appendDecodedSegment(@Nullable PathPart oldPart, @Nullable String decoded) {
                String encoded = android.net.Uri$Companion.encode$default(Uri.Companion, decoded, null, 2, null);
                return this.appendEncodedSegment(oldPart, encoded);
            }

            @JvmStatic
            @NotNull
            public final PathPart fromEncoded(@Nullable String encoded) {
                return this.from(encoded, "NOT CACHED");
            }

            @JvmStatic
            @NotNull
            public final PathPart fromDecoded(@Nullable String decoded) {
                return this.from("NOT CACHED", decoded);
            }

            @JvmStatic
            @NotNull
            public final PathPart from(@Nullable String encoded, @Nullable String decoded) {
                if (encoded == null) {
                    return this.getNULL();
                }
                if (encoded.length() == 0) {
                    return this.getEMPTY();
                }
                return new PathPart(encoded, decoded, null);
            }

            @JvmStatic
            @NotNull
            public final PathPart makeAbsolute(@NotNull PathPart oldPart) {
                String oldPath;
                Intrinsics.checkNotNullParameter((Object)oldPart, (String)"oldPart");
                boolean encodedCached = oldPart.get_encoded() != "NOT CACHED";
                String string = oldPath = encodedCached ? oldPart.get_encoded() : oldPart.get_decoded();
                if (oldPath == null || oldPath.length() == 0 || StringsKt.startsWith$default((String)oldPath, (String)"/", (boolean)false, (int)2, null)) {
                    return oldPart;
                }
                String newEncoded = encodedCached ? "/" + oldPart.get_encoded() : "NOT CACHED";
                boolean decodedCached = oldPart.get_decoded() != "NOT CACHED";
                String newDecoded = decodedCached ? "/" + oldPart.get_decoded() : "NOT CACHED";
                return new PathPart(newEncoded, newDecoded, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u000f2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003:\u0001\u000fB!\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u0007H\u0096\u0002R\u001a\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Landroid/net/Uri$PathSegments;", "Ljava/util/AbstractList;", "", "Ljava/util/RandomAccess;", "segments", "", "size", "", "<init>", "([Ljava/lang/String;I)V", "[Ljava/lang/String;", "getSize", "()I", "get", "index", "Companion", "firebase-java-sdk"})
    public static final class PathSegments
    extends AbstractList<String>
    implements RandomAccess {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String[] segments;
        private final int size;
        @NotNull
        private static final PathSegments EMPTY = new PathSegments(null, 0);

        public PathSegments(@Nullable String[] segments, int size) {
            this.segments = segments;
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        @Override
        @Nullable
        public String get(int index) {
            if (index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            Intrinsics.checkNotNull((Object)this.segments);
            return this.segments[index];
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroid/net/Uri$PathSegments$Companion;", "", "<init>", "()V", "EMPTY", "Landroid/net/Uri$PathSegments;", "getEMPTY", "()Landroid/net/Uri$PathSegments;", "firebase-java-sdk"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PathSegments getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012R\u001a\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Landroid/net/Uri$PathSegmentsBuilder;", "", "<init>", "()V", "segments", "", "", "[Ljava/lang/String;", "size", "", "getSize", "()I", "setSize", "(I)V", "add", "", "segment", "build", "Landroid/net/Uri$PathSegments;", "firebase-java-sdk"})
    public static final class PathSegmentsBuilder {
        @Nullable
        private String[] segments;
        private int size;

        public final int getSize() {
            return this.size;
        }

        public final void setSize(int n) {
            this.size = n;
        }

        public final void add(@Nullable String segment) {
            if (this.segments == null) {
                this.segments = new String[4];
            } else {
                Intrinsics.checkNotNull((Object)this.segments);
                if (this.size + 1 == this.segments.length) {
                    Intrinsics.checkNotNull((Object)this.segments);
                    String[] expanded = new String[this.segments.length * 2];
                    Intrinsics.checkNotNull((Object)this.segments);
                    Intrinsics.checkNotNull((Object)this.segments);
                    System.arraycopy(this.segments, 0, expanded, 0, this.segments.length);
                    this.segments = expanded;
                }
            }
            Intrinsics.checkNotNull((Object)this.segments);
            int n = this.size;
            this.size = n + 1;
            this.segments[n] = segment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final PathSegments build() {
            if (this.segments == null) {
                return PathSegments.Companion.getEMPTY();
            }
            try {
                PathSegments pathSegments = new PathSegments(this.segments, this.size);
                return pathSegments;
            }
            finally {
                this.segments = null;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 K2\u00020\u0001:\u0001KB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u0010\u001a\u00020\u0007J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\"\u001a\u00020\u0003J\b\u00107\u001a\u0004\u0018\u00010\u0003J\b\u0010=\u001a\u0004\u0018\u00010\u0003J\b\u0010E\u001a\u0004\u0018\u00010\u0003J\b\u0010H\u001a\u00020\u0003H\u0016J\b\u0010I\u001a\u00020JH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R$\u0010\u0016\u001a\u0004\u0018\u00010\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u00038V@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001a8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0018R\u0016\u0010 \u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0018R\u0010\u0010#\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u0016\u0010&\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0018R\u0016\u0010(\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0018R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0016\u0010/\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0018R\u0016\u00101\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0018R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u0003048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0010\u00108\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00109\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001dR\u0016\u0010;\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0018R\u0016\u0010>\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0018R\u0010\u0010@\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010A\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u001dR\u0016\u0010C\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u0018R\u0016\u0010F\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u0018\u00a8\u0006L"}, d2={"Landroid/net/Uri$StringUri;", "Landroid/net/Uri$AbstractHierarchicalUri;", "uriString", "", "<init>", "(Ljava/lang/String;)V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "cachedSsi", "findSchemeSeparator", "cachedFsi", "findFragmentSeparator", "isHierarchical", "", "()Z", "isRelative", "value", "scheme", "getScheme", "()Ljava/lang/String;", "parseScheme", "Landroid/net/Uri$Part;", "ssp", "getSsp", "()Landroid/net/Uri$Part;", "encodedSchemeSpecificPart", "getEncodedSchemeSpecificPart", "schemeSpecificPart", "getSchemeSpecificPart", "parseSsp", "_authorityPart", "authorityPart", "getAuthorityPart", "encodedAuthority", "getEncodedAuthority", "authority", "getAuthority", "_pathPart", "Landroid/net/Uri$PathPart;", "pathPart", "getPathPart", "()Landroid/net/Uri$PathPart;", "path", "getPath", "encodedPath", "getEncodedPath", "pathSegments", "", "getPathSegments", "()Ljava/util/List;", "parsePath", "_queryPart", "queryPart", "getQueryPart", "encodedQuery", "getEncodedQuery", "parseQuery", "query", "getQuery", "_fragmentPart", "fragmentPart", "getFragmentPart", "encodedFragment", "getEncodedFragment", "parseFragment", "fragment", "getFragment", "toString", "buildUpon", "Landroid/net/Uri$Builder;", "Companion", "firebase-java-sdk"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$StringUri\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    private static final class StringUri
    extends AbstractHierarchicalUri {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String uriString;
        private volatile int cachedSsi = -2;
        private volatile int cachedFsi = -2;
        @Nullable
        private volatile String scheme = "NOT CACHED";
        @Nullable
        private Part ssp;
        @Nullable
        private Part _authorityPart;
        @Nullable
        private PathPart _pathPart;
        @Nullable
        private Part _queryPart;
        @Nullable
        private Part _fragmentPart;
        public static final int TYPE_ID = 1;

        public StringUri(@Nullable String uriString) {
            if (uriString == null) {
                throw new NullPointerException("uriString");
            }
            this.uriString = uriString;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            parcel.writeInt(1);
            parcel.writeString8(this.uriString);
        }

        public final int findSchemeSeparator() {
            int n;
            if (this.cachedSsi == -2) {
                int n2;
                int it = n2 = StringsKt.indexOf$default((CharSequence)this.uriString, (char)':', (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                this.cachedSsi = it;
                n = n2;
            } else {
                n = this.cachedSsi;
            }
            return n;
        }

        public final int findFragmentSeparator() {
            int n;
            if (this.cachedFsi == -2) {
                int n2;
                int it = n2 = StringsKt.indexOf$default((CharSequence)this.uriString, (char)'#', (int)this.findSchemeSeparator(), (boolean)false, (int)4, null);
                boolean bl = false;
                this.cachedFsi = it;
                n = n2;
            } else {
                n = this.cachedFsi;
            }
            return n;
        }

        @Override
        public boolean isHierarchical() {
            int ssi = this.findSchemeSeparator();
            if (ssi == -1) {
                return true;
            }
            if (this.uriString.length() == ssi + 1) {
                return false;
            }
            return this.uriString.charAt(ssi + 1) == '/';
        }

        @Override
        public boolean isRelative() {
            return this.findSchemeSeparator() == -1;
        }

        @Override
        @Nullable
        public String getScheme() {
            String string;
            boolean cached;
            boolean bl = cached = this.scheme != "NOT CACHED";
            if (cached) {
                string = this.scheme;
            } else {
                String string2;
                String it = string2 = this.parseScheme();
                boolean bl2 = false;
                this.scheme = it;
                string = string2;
            }
            return string;
        }

        @Nullable
        public final String parseScheme() {
            String string;
            int ssi = this.findSchemeSeparator();
            if (ssi == -1) {
                string = null;
            } else {
                String string2 = this.uriString.substring(0, ssi);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            return string;
        }

        @Nullable
        public final Part getSsp() {
            Part part;
            if (this.ssp == null) {
                Part part2;
                Part it = part2 = Part.Companion.fromEncoded(this.parseSsp());
                boolean bl = false;
                this.ssp = it;
                part = part2;
            } else {
                part = this.ssp;
            }
            return part;
        }

        @Override
        @Nullable
        public String getEncodedSchemeSpecificPart() {
            Part part = this.getSsp();
            Intrinsics.checkNotNull((Object)part);
            return part.getEncoded();
        }

        @Override
        @Nullable
        public String getSchemeSpecificPart() {
            Part part = this.getSsp();
            Intrinsics.checkNotNull((Object)part);
            return part.getDecoded();
        }

        @NotNull
        public final String parseSsp() {
            String string;
            int ssi = this.findSchemeSeparator();
            int fsi = this.findFragmentSeparator();
            if (fsi == -1) {
                String string2 = this.uriString.substring(ssi + 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                String string3 = this.uriString.substring(ssi + 1, fsi);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
            return string;
        }

        @NotNull
        public final Part getAuthorityPart() {
            if (this._authorityPart == null) {
                Part part;
                String encodedAuthority = Companion.parseAuthority(this.uriString, this.findSchemeSeparator());
                Part it = part = Part.Companion.fromEncoded(encodedAuthority);
                boolean bl = false;
                this._authorityPart = it;
                return part;
            }
            Part part = this._authorityPart;
            Intrinsics.checkNotNull((Object)part);
            return part;
        }

        @Override
        @Nullable
        public String getEncodedAuthority() {
            return this.getAuthorityPart().getEncoded();
        }

        @Override
        @Nullable
        public String getAuthority() {
            return this.getAuthorityPart().getDecoded();
        }

        @NotNull
        public final PathPart getPathPart() {
            PathPart pathPart;
            if (this._pathPart == null) {
                PathPart pathPart2;
                PathPart it = pathPart2 = PathPart.Companion.fromEncoded(this.parsePath());
                boolean bl = false;
                this._pathPart = it;
                pathPart = pathPart2;
            } else {
                PathPart pathPart3 = this._pathPart;
                pathPart = pathPart3;
                Intrinsics.checkNotNull((Object)pathPart3);
            }
            return pathPart;
        }

        @Override
        @Nullable
        public String getPath() {
            return this.getPathPart().getDecoded();
        }

        @Override
        @Nullable
        public String getEncodedPath() {
            return this.getPathPart().getEncoded();
        }

        @Override
        @NotNull
        public List<String> getPathSegments() {
            return CollectionsKt.filterNotNull((Iterable)this.getPathPart().getPathSegments());
        }

        @Nullable
        public final String parsePath() {
            String uriString = this.uriString;
            int ssi = this.findSchemeSeparator();
            if (ssi > -1) {
                boolean schemeOnly;
                boolean bl = schemeOnly = ssi + 1 == uriString.length();
                if (schemeOnly) {
                    return null;
                }
                if (uriString.charAt(ssi + 1) != '/') {
                    return null;
                }
            }
            return Companion.parsePath(uriString, ssi);
        }

        @NotNull
        public final Part getQueryPart() {
            Part part;
            if (this._queryPart == null) {
                Part part2;
                Part it = part2 = Part.Companion.fromEncoded(this.parseQuery());
                boolean bl = false;
                this._queryPart = it;
                part = part2;
            } else {
                Part part3 = this._queryPart;
                part = part3;
                Intrinsics.checkNotNull((Object)part3);
            }
            return part;
        }

        @Override
        @Nullable
        public String getEncodedQuery() {
            return this.getQueryPart().getEncoded();
        }

        @Nullable
        public final String parseQuery() {
            int qsi = StringsKt.indexOf$default((CharSequence)this.uriString, (char)'?', (int)this.findSchemeSeparator(), (boolean)false, (int)4, null);
            if (qsi == -1) {
                return null;
            }
            int fsi = this.findFragmentSeparator();
            if (fsi == -1) {
                String string = this.uriString.substring(qsi + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            if (fsi < qsi) {
                return null;
            }
            String string = this.uriString.substring(qsi + 1, fsi);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        @Override
        @Nullable
        public String getQuery() {
            return this.getQueryPart().getDecoded();
        }

        @NotNull
        public final Part getFragmentPart() {
            Part part;
            if (this._fragmentPart == null) {
                Part part2;
                Part it = part2 = Part.Companion.fromEncoded(this.parseFragment());
                boolean bl = false;
                this._fragmentPart = it;
                part = part2;
            } else {
                Part part3 = this._fragmentPart;
                part = part3;
                Intrinsics.checkNotNull((Object)part3);
            }
            return part;
        }

        @Override
        @Nullable
        public String getEncodedFragment() {
            return this.getFragmentPart().getEncoded();
        }

        @Nullable
        public final String parseFragment() {
            String string;
            int fsi = this.findFragmentSeparator();
            if (fsi == -1) {
                string = null;
            } else {
                String string2 = this.uriString.substring(fsi + 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            return string;
        }

        @Override
        @Nullable
        public String getFragment() {
            return this.getFragmentPart().getDecoded();
        }

        @Override
        @NotNull
        public String toString() {
            return this.uriString;
        }

        @Override
        @NotNull
        public Builder buildUpon() {
            return this.isHierarchical() ? new Builder().scheme(this.getScheme()).authority(this.getAuthorityPart()).path(this.getPathPart()).query(this.getQueryPart()).fragment(this.getFragmentPart()) : new Builder().scheme(this.getScheme()).opaquePart(this.getSsp()).fragment(this.getFragmentPart());
        }

        @JvmStatic
        @NotNull
        public static final Uri readFrom(@NotNull Parcel parcel) {
            return Companion.readFrom(parcel);
        }

        @JvmStatic
        @Nullable
        public static final String parseAuthority(@NotNull String uriString, int ssi) {
            return Companion.parseAuthority(uriString, ssi);
        }

        @JvmStatic
        @NotNull
        public static final String parsePath(@NotNull String uriString, int ssi) {
            return Companion.parsePath(uriString, ssi);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroid/net/Uri$StringUri$Companion;", "", "<init>", "()V", "TYPE_ID", "", "readFrom", "Landroid/net/Uri;", "parcel", "Landroid/os/Parcel;", "parseAuthority", "", "uriString", "ssi", "parsePath", "firebase-java-sdk"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Uri readFrom(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new StringUri(parcel.readString8());
            }

            @JvmStatic
            @Nullable
            public final String parseAuthority(@NotNull String uriString, int ssi) {
                Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
                int length = uriString.length();
                if (length > ssi + 2 && uriString.charAt(ssi + 1) == '/' && uriString.charAt(ssi + 2) == '/') {
                    int end;
                    block3: for (end = ssi + 3; end < length; ++end) {
                        switch (uriString.charAt(end)) {
                            case '#': 
                            case '/': 
                            case '?': 
                            case '\\': {
                                break block3;
                            }
                            default: {
                                continue block3;
                            }
                        }
                    }
                    String string = uriString.substring(ssi + 3, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    return string;
                }
                return null;
            }

            @JvmStatic
            @NotNull
            public final String parsePath(@NotNull String uriString, int ssi) {
                int pathEnd;
                int pathStart;
                int length;
                block11: {
                    Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
                    length = uriString.length();
                    pathStart = 0;
                    if (length > ssi + 2 && uriString.charAt(ssi + 1) == '/' && uriString.charAt(ssi + 2) == '/') {
                        pathStart = ssi + 3;
                        while (pathStart < length) {
                            switch (uriString.charAt(pathStart)) {
                                case '#': 
                                case '?': {
                                    return "";
                                }
                                case '/': 
                                case '\\': {
                                    break block11;
                                }
                                default: {
                                    ++pathStart;
                                    break;
                                }
                            }
                        }
                    } else {
                        pathStart = ssi + 1;
                    }
                }
                block8: for (pathEnd = pathStart; pathEnd < length; ++pathEnd) {
                    switch (uriString.charAt(pathEnd)) {
                        case '#': 
                        case '?': {
                            break block8;
                        }
                        default: {
                            continue block8;
                        }
                    }
                }
                String string = uriString.substring(pathStart, pathEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

