/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.text;

import android.icu.util.ULocale;
import android.os.Build;
import android.util.Log;
import androidx.annotation.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

public final class ICUCompat {
    private static final String TAG = "ICUCompat";
    private static Method sGetScriptMethod;
    private static Method sAddLikelySubtagsMethod;

    @Nullable
    public static String maximizeAndGetScript(Locale locale) {
        if (Build.VERSION.SDK_INT >= 24) {
            ULocale uLocale = ULocale.addLikelySubtags((ULocale)ULocale.forLocale((Locale)locale));
            return uLocale.getScript();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Object[] args = new Object[]{locale};
                return ((Locale)sAddLikelySubtagsMethod.invoke(null, args)).getScript();
            }
            catch (InvocationTargetException e) {
                Log.w(TAG, e);
            }
            catch (IllegalAccessException e) {
                Log.w(TAG, e);
            }
            return locale.getScript();
        }
        String localeWithSubtags = ICUCompat.addLikelySubtags(locale);
        if (localeWithSubtags != null) {
            return ICUCompat.getScript(localeWithSubtags);
        }
        return null;
    }

    private static String getScript(String localeStr) {
        try {
            if (sGetScriptMethod != null) {
                Object[] args = new Object[]{localeStr};
                return (String)sGetScriptMethod.invoke(null, args);
            }
        }
        catch (IllegalAccessException e) {
            Log.w(TAG, e);
        }
        catch (InvocationTargetException e) {
            Log.w(TAG, e);
        }
        return null;
    }

    private static String addLikelySubtags(Locale locale) {
        String localeStr = locale.toString();
        try {
            if (sAddLikelySubtagsMethod != null) {
                Object[] args = new Object[]{localeStr};
                return (String)sAddLikelySubtagsMethod.invoke(null, args);
            }
        }
        catch (IllegalAccessException e) {
            Log.w(TAG, e);
        }
        catch (InvocationTargetException e) {
            Log.w(TAG, e);
        }
        return localeStr;
    }

    private ICUCompat() {
    }

    static {
        if (Build.VERSION.SDK_INT < 21) {
            try {
                Class<?> clazz = Class.forName("libcore.icu.ICU");
                if (clazz != null) {
                    sGetScriptMethod = clazz.getMethod("getScript", String.class);
                    sAddLikelySubtagsMethod = clazz.getMethod("addLikelySubtags", String.class);
                }
            }
            catch (Exception e) {
                sGetScriptMethod = null;
                sAddLikelySubtagsMethod = null;
                Log.w(TAG, e);
            }
        } else if (Build.VERSION.SDK_INT < 24) {
            try {
                Class<?> clazz = Class.forName("libcore.icu.ICU");
                sAddLikelySubtagsMethod = clazz.getMethod("addLikelySubtags", Locale.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

