/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.graphics.Rect;
import android.os.Build;
import android.view.WindowInsets;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.graphics.Insets;
import androidx.core.util.ObjectsCompat;
import androidx.core.view.DisplayCutoutCompat;
import java.util.Objects;

public class WindowInsetsCompat {
    private final Object mInsets;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @VisibleForTesting
    WindowInsetsCompat(@Nullable Object insets) {
        this.mInsets = insets;
    }

    public WindowInsetsCompat(WindowInsetsCompat src) {
        this.mInsets = Build.VERSION.SDK_INT >= 20 ? (src == null ? null : new WindowInsets((WindowInsets)src.mInsets)) : null;
    }

    public int getSystemWindowInsetLeft() {
        if (Build.VERSION.SDK_INT >= 20) {
            return ((WindowInsets)this.mInsets).getSystemWindowInsetLeft();
        }
        return 0;
    }

    public int getSystemWindowInsetTop() {
        if (Build.VERSION.SDK_INT >= 20) {
            return ((WindowInsets)this.mInsets).getSystemWindowInsetTop();
        }
        return 0;
    }

    public int getSystemWindowInsetRight() {
        if (Build.VERSION.SDK_INT >= 20) {
            return ((WindowInsets)this.mInsets).getSystemWindowInsetRight();
        }
        return 0;
    }

    public int getSystemWindowInsetBottom() {
        if (Build.VERSION.SDK_INT >= 20) {
            return ((WindowInsets)this.mInsets).getSystemWindowInsetBottom();
        }
        return 0;
    }

    public boolean hasSystemWindowInsets() {
        if (Build.VERSION.SDK_INT >= 20) {
            return ((WindowInsets)this.mInsets).hasSystemWindowInsets();
        }
        return false;
    }

    public boolean hasInsets() {
        if (Build.VERSION.SDK_INT >= 20) {
            return ((WindowInsets)this.mInsets).hasInsets();
        }
        return false;
    }

    public boolean isConsumed() {
        if (Build.VERSION.SDK_INT >= 21) {
            return ((WindowInsets)this.mInsets).isConsumed();
        }
        return false;
    }

    public boolean isRound() {
        if (Build.VERSION.SDK_INT >= 20) {
            return ((WindowInsets)this.mInsets).isRound();
        }
        return false;
    }

    public WindowInsetsCompat consumeSystemWindowInsets() {
        if (Build.VERSION.SDK_INT >= 20) {
            return new WindowInsetsCompat(((WindowInsets)this.mInsets).consumeSystemWindowInsets());
        }
        return null;
    }

    public WindowInsetsCompat replaceSystemWindowInsets(int left, int top, int right, int bottom) {
        if (Build.VERSION.SDK_INT >= 20) {
            return new WindowInsetsCompat(((WindowInsets)this.mInsets).replaceSystemWindowInsets(left, top, right, bottom));
        }
        return null;
    }

    public WindowInsetsCompat replaceSystemWindowInsets(Rect systemWindowInsets) {
        if (Build.VERSION.SDK_INT >= 21) {
            return new WindowInsetsCompat(((WindowInsets)this.mInsets).replaceSystemWindowInsets(systemWindowInsets));
        }
        return null;
    }

    public int getStableInsetTop() {
        if (Build.VERSION.SDK_INT >= 21) {
            return ((WindowInsets)this.mInsets).getStableInsetTop();
        }
        return 0;
    }

    public int getStableInsetLeft() {
        if (Build.VERSION.SDK_INT >= 21) {
            return ((WindowInsets)this.mInsets).getStableInsetLeft();
        }
        return 0;
    }

    public int getStableInsetRight() {
        if (Build.VERSION.SDK_INT >= 21) {
            return ((WindowInsets)this.mInsets).getStableInsetRight();
        }
        return 0;
    }

    public int getStableInsetBottom() {
        if (Build.VERSION.SDK_INT >= 21) {
            return ((WindowInsets)this.mInsets).getStableInsetBottom();
        }
        return 0;
    }

    public boolean hasStableInsets() {
        if (Build.VERSION.SDK_INT >= 21) {
            return ((WindowInsets)this.mInsets).hasStableInsets();
        }
        return false;
    }

    public WindowInsetsCompat consumeStableInsets() {
        if (Build.VERSION.SDK_INT >= 21) {
            return new WindowInsetsCompat(((WindowInsets)this.mInsets).consumeStableInsets());
        }
        return null;
    }

    @Nullable
    public DisplayCutoutCompat getDisplayCutout() {
        if (Build.VERSION.SDK_INT >= 28) {
            return DisplayCutoutCompat.wrap(((WindowInsets)this.mInsets).getDisplayCutout());
        }
        return null;
    }

    public WindowInsetsCompat consumeDisplayCutout() {
        if (Build.VERSION.SDK_INT >= 28) {
            return new WindowInsetsCompat(((WindowInsets)this.mInsets).consumeDisplayCutout());
        }
        return this;
    }

    @NonNull
    public Insets getSystemWindowInsets() {
        if (Build.VERSION.SDK_INT >= 29) {
            return Insets.wrap(((WindowInsets)this.mInsets).getSystemWindowInsets());
        }
        return Insets.of(this.getSystemWindowInsetLeft(), this.getSystemWindowInsetTop(), this.getSystemWindowInsetRight(), this.getSystemWindowInsetBottom());
    }

    @NonNull
    public Insets getStableInsets() {
        if (Build.VERSION.SDK_INT >= 29) {
            return Insets.wrap(((WindowInsets)this.mInsets).getStableInsets());
        }
        return Insets.of(this.getStableInsetLeft(), this.getStableInsetTop(), this.getStableInsetRight(), this.getStableInsetBottom());
    }

    @NonNull
    public Insets getMandatorySystemGestureInsets() {
        if (Build.VERSION.SDK_INT >= 29) {
            return Insets.wrap(((WindowInsets)this.mInsets).getMandatorySystemGestureInsets());
        }
        return this.getSystemWindowInsets();
    }

    @NonNull
    public Insets getTappableElementInsets() {
        if (Build.VERSION.SDK_INT >= 29) {
            return Insets.wrap(((WindowInsets)this.mInsets).getTappableElementInsets());
        }
        return this.getSystemWindowInsets();
    }

    @NonNull
    public Insets getSystemGestureInsets() {
        if (Build.VERSION.SDK_INT >= 29) {
            return Insets.wrap(((WindowInsets)this.mInsets).getSystemGestureInsets());
        }
        return this.getSystemWindowInsets();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WindowInsetsCompat)) {
            return false;
        }
        WindowInsetsCompat other = (WindowInsetsCompat)o;
        return ObjectsCompat.equals(this.mInsets, other.mInsets);
    }

    public int hashCode() {
        return this.mInsets == null ? 0 : this.mInsets.hashCode();
    }

    @Nullable
    @RequiresApi(value=20)
    public WindowInsets toWindowInsets() {
        return (WindowInsets)this.mInsets;
    }

    @NonNull
    @RequiresApi(value=20)
    public static WindowInsetsCompat toWindowInsetsCompat(@NonNull WindowInsets insets) {
        return new WindowInsetsCompat(Objects.requireNonNull(insets));
    }
}

