/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.Transformation;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArraySet;
import androidx.core.util.DebugUtils;
import androidx.core.util.LogWriter;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.BackStackRecord;
import androidx.fragment.app.BackStackState;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentContainer;
import androidx.fragment.app.FragmentHostCallback;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentManagerNonConfig;
import androidx.fragment.app.FragmentManagerState;
import androidx.fragment.app.FragmentState;
import androidx.fragment.app.FragmentTransaction;
import androidx.fragment.app.FragmentTransition;
import androidx.fragment.app.OneShotPreDrawListener;
import androidx.fragment.app.SuperNotCalledException;
import androidx.lifecycle.ViewModelStore;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

final class FragmentManagerImpl
extends FragmentManager
implements LayoutInflater.Factory2 {
    static boolean DEBUG = false;
    static final String TAG = "FragmentManager";
    static final String TARGET_REQUEST_CODE_STATE_TAG = "android:target_req_state";
    static final String TARGET_STATE_TAG = "android:target_state";
    static final String VIEW_STATE_TAG = "android:view_state";
    static final String USER_VISIBLE_HINT_TAG = "android:user_visible_hint";
    ArrayList<OpGenerator> mPendingActions;
    boolean mExecutingActions;
    int mNextFragmentIndex = 0;
    final ArrayList<Fragment> mAdded = new ArrayList();
    SparseArray<Fragment> mActive;
    ArrayList<BackStackRecord> mBackStack;
    ArrayList<Fragment> mCreatedMenus;
    ArrayList<BackStackRecord> mBackStackIndices;
    ArrayList<Integer> mAvailBackStackIndices;
    ArrayList<FragmentManager.OnBackStackChangedListener> mBackStackChangeListeners;
    private final CopyOnWriteArrayList<FragmentLifecycleCallbacksHolder> mLifecycleCallbacks = new CopyOnWriteArrayList();
    int mCurState = 0;
    FragmentHostCallback mHost;
    FragmentContainer mContainer;
    Fragment mParent;
    @Nullable
    Fragment mPrimaryNav;
    static Field sAnimationListenerField = null;
    boolean mNeedMenuInvalidate;
    boolean mStateSaved;
    boolean mStopped;
    boolean mDestroyed;
    String mNoTransactionsBecause;
    boolean mHavePendingDeferredStart;
    ArrayList<BackStackRecord> mTmpRecords;
    ArrayList<Boolean> mTmpIsPop;
    ArrayList<Fragment> mTmpAddedFragments;
    Bundle mStateBundle = null;
    SparseArray<Parcelable> mStateArray = null;
    ArrayList<StartEnterTransitionListener> mPostponedTransactions;
    FragmentManagerNonConfig mSavedNonConfig;
    Runnable mExecCommit = new Runnable(){

        @Override
        public void run() {
            FragmentManagerImpl.this.execPendingActions();
        }
    };
    static final Interpolator DECELERATE_QUINT = new DecelerateInterpolator(2.5f);
    static final Interpolator DECELERATE_CUBIC = new DecelerateInterpolator(1.5f);
    static final Interpolator ACCELERATE_QUINT = new AccelerateInterpolator(2.5f);
    static final Interpolator ACCELERATE_CUBIC = new AccelerateInterpolator(1.5f);
    static final int ANIM_DUR = 220;
    public static final int ANIM_STYLE_OPEN_ENTER = 1;
    public static final int ANIM_STYLE_OPEN_EXIT = 2;
    public static final int ANIM_STYLE_CLOSE_ENTER = 3;
    public static final int ANIM_STYLE_CLOSE_EXIT = 4;
    public static final int ANIM_STYLE_FADE_ENTER = 5;
    public static final int ANIM_STYLE_FADE_EXIT = 6;

    FragmentManagerImpl() {
    }

    static boolean modifiesAlpha(AnimationOrAnimator anim) {
        if (anim.animation instanceof AlphaAnimation) {
            return true;
        }
        if (anim.animation instanceof AnimationSet) {
            List anims = ((AnimationSet)anim.animation).getAnimations();
            for (int i = 0; i < anims.size(); ++i) {
                if (!(anims.get(i) instanceof AlphaAnimation)) continue;
                return true;
            }
            return false;
        }
        return FragmentManagerImpl.modifiesAlpha(anim.animator);
    }

    static boolean modifiesAlpha(Animator anim) {
        block4: {
            block3: {
                if (anim == null) {
                    return false;
                }
                if (!(anim instanceof ValueAnimator)) break block3;
                ValueAnimator valueAnim = (ValueAnimator)anim;
                PropertyValuesHolder[] values = valueAnim.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (!"alpha".equals(values[i].getPropertyName())) continue;
                    return true;
                }
                break block4;
            }
            if (!(anim instanceof AnimatorSet)) break block4;
            ArrayList animList = ((AnimatorSet)anim).getChildAnimations();
            for (int i = 0; i < animList.size(); ++i) {
                if (!FragmentManagerImpl.modifiesAlpha((Animator)animList.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    static boolean shouldRunOnHWLayer(View v, AnimationOrAnimator anim) {
        if (v == null || anim == null) {
            return false;
        }
        return Build.VERSION.SDK_INT >= 19 && v.getLayerType() == 0 && ViewCompat.hasOverlappingRendering(v) && FragmentManagerImpl.modifiesAlpha(anim);
    }

    private void throwException(RuntimeException ex) {
        Log.e(TAG, ex.getMessage());
        Log.e(TAG, "Activity state:");
        LogWriter logw = new LogWriter(TAG);
        PrintWriter pw = new PrintWriter(logw);
        if (this.mHost != null) {
            try {
                this.mHost.onDump("  ", null, pw, new String[0]);
            }
            catch (Exception e) {
                Log.e(TAG, "Failed dumping state", e);
            }
        } else {
            try {
                this.dump("  ", null, pw, new String[0]);
            }
            catch (Exception e) {
                Log.e(TAG, "Failed dumping state", e);
            }
        }
        throw ex;
    }

    @Override
    public FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    @Override
    public boolean executePendingTransactions() {
        boolean updates = this.execPendingActions();
        this.forcePostponedTransactions();
        return updates;
    }

    @Override
    public void popBackStack() {
        this.enqueueAction(new PopBackStackState(null, -1, 0), false);
    }

    @Override
    public boolean popBackStackImmediate() {
        this.checkStateLoss();
        return this.popBackStackImmediate(null, -1, 0);
    }

    @Override
    public void popBackStack(@Nullable String name, int flags) {
        this.enqueueAction(new PopBackStackState(name, -1, flags), false);
    }

    @Override
    public boolean popBackStackImmediate(@Nullable String name, int flags) {
        this.checkStateLoss();
        return this.popBackStackImmediate(name, -1, flags);
    }

    @Override
    public void popBackStack(int id2, int flags) {
        if (id2 < 0) {
            throw new IllegalArgumentException("Bad id: " + id2);
        }
        this.enqueueAction(new PopBackStackState(null, id2, flags), false);
    }

    @Override
    public boolean popBackStackImmediate(int id2, int flags) {
        this.checkStateLoss();
        this.execPendingActions();
        if (id2 < 0) {
            throw new IllegalArgumentException("Bad id: " + id2);
        }
        return this.popBackStackImmediate(null, id2, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean popBackStackImmediate(String name, int id2, int flags) {
        FragmentManager childManager;
        this.execPendingActions();
        this.ensureExecReady(true);
        if (this.mPrimaryNav != null && id2 < 0 && name == null && (childManager = this.mPrimaryNav.peekChildFragmentManager()) != null && childManager.popBackStackImmediate()) {
            return true;
        }
        boolean executePop = this.popBackStackState(this.mTmpRecords, this.mTmpIsPop, name, id2, flags);
        if (executePop) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.doPendingDeferredStart();
        this.burpActive();
        return executePop;
    }

    @Override
    public int getBackStackEntryCount() {
        return this.mBackStack != null ? this.mBackStack.size() : 0;
    }

    @Override
    public FragmentManager.BackStackEntry getBackStackEntryAt(int index) {
        return this.mBackStack.get(index);
    }

    @Override
    public void addOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener listener2) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList();
        }
        this.mBackStackChangeListeners.add(listener2);
    }

    @Override
    public void removeOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener listener2) {
        if (this.mBackStackChangeListeners != null) {
            this.mBackStackChangeListeners.remove(listener2);
        }
    }

    @Override
    public void putFragment(Bundle bundle, String key, Fragment fragment) {
        if (fragment.mIndex < 0) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        bundle.putInt(key, fragment.mIndex);
    }

    @Override
    @Nullable
    public Fragment getFragment(Bundle bundle, String key) {
        int index = bundle.getInt(key, -1);
        if (index == -1) {
            return null;
        }
        Fragment f = this.mActive.get(index);
        if (f == null) {
            this.throwException(new IllegalStateException("Fragment no longer exists for key " + key + ": index " + index));
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Fragment> getFragments() {
        if (this.mAdded.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            return (List)this.mAdded.clone();
        }
    }

    List<Fragment> getActiveFragments() {
        if (this.mActive == null) {
            return null;
        }
        int count = this.mActive.size();
        ArrayList<Fragment> fragments = new ArrayList<Fragment>(count);
        for (int i = 0; i < count; ++i) {
            fragments.add(this.mActive.valueAt(i));
        }
        return fragments;
    }

    int getActiveFragmentCount() {
        if (this.mActive == null) {
            return 0;
        }
        return this.mActive.size();
    }

    @Override
    @Nullable
    public Fragment.SavedState saveFragmentInstanceState(Fragment fragment) {
        if (fragment.mIndex < 0) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        if (fragment.mState > 0) {
            Bundle result = this.saveFragmentBasicState(fragment);
            return result != null ? new Fragment.SavedState(result) : null;
        }
        return null;
    }

    @Override
    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("FragmentManager{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" in ");
        if (this.mParent != null) {
            DebugUtils.buildShortClassTag(this.mParent, sb);
        } else {
            DebugUtils.buildShortClassTag(this.mHost, sb);
        }
        sb.append("}}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        Fragment f;
        int i;
        int N;
        String innerPrefix = prefix + "    ";
        if (this.mActive != null && (N = this.mActive.size()) > 0) {
            writer.print(prefix);
            writer.print("Active Fragments in ");
            writer.print(Integer.toHexString(System.identityHashCode(this)));
            writer.println(":");
            for (i = 0; i < N; ++i) {
                f = this.mActive.valueAt(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f);
                if (f == null) continue;
                f.dump(innerPrefix, fd, writer, args);
            }
        }
        if ((N = this.mAdded.size()) > 0) {
            writer.print(prefix);
            writer.println("Added Fragments:");
            for (i = 0; i < N; ++i) {
                f = this.mAdded.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f.toString());
            }
        }
        if (this.mCreatedMenus != null && (N = this.mCreatedMenus.size()) > 0) {
            writer.print(prefix);
            writer.println("Fragments Created Menus:");
            for (i = 0; i < N; ++i) {
                f = this.mCreatedMenus.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f.toString());
            }
        }
        if (this.mBackStack != null && (N = this.mBackStack.size()) > 0) {
            writer.print(prefix);
            writer.println("Back Stack:");
            for (i = 0; i < N; ++i) {
                BackStackRecord bs = this.mBackStack.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(bs.toString());
                bs.dump(innerPrefix, fd, writer, args);
            }
        }
        FragmentManagerImpl i2 = this;
        synchronized (i2) {
            if (this.mBackStackIndices != null && (N = this.mBackStackIndices.size()) > 0) {
                writer.print(prefix);
                writer.println("Back Stack Indices:");
                for (int i3 = 0; i3 < N; ++i3) {
                    BackStackRecord bs = this.mBackStackIndices.get(i3);
                    writer.print(prefix);
                    writer.print("  #");
                    writer.print(i3);
                    writer.print(": ");
                    writer.println(bs);
                }
            }
            if (this.mAvailBackStackIndices != null && this.mAvailBackStackIndices.size() > 0) {
                writer.print(prefix);
                writer.print("mAvailBackStackIndices: ");
                writer.println(Arrays.toString(this.mAvailBackStackIndices.toArray()));
            }
        }
        if (this.mPendingActions != null && (N = this.mPendingActions.size()) > 0) {
            writer.print(prefix);
            writer.println("Pending Actions:");
            for (int i4 = 0; i4 < N; ++i4) {
                OpGenerator r = this.mPendingActions.get(i4);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i4);
                writer.print(": ");
                writer.println(r);
            }
        }
        writer.print(prefix);
        writer.println("FragmentManager misc state:");
        writer.print(prefix);
        writer.print("  mHost=");
        writer.println(this.mHost);
        writer.print(prefix);
        writer.print("  mContainer=");
        writer.println(this.mContainer);
        if (this.mParent != null) {
            writer.print(prefix);
            writer.print("  mParent=");
            writer.println(this.mParent);
        }
        writer.print(prefix);
        writer.print("  mCurState=");
        writer.print(this.mCurState);
        writer.print(" mStateSaved=");
        writer.print(this.mStateSaved);
        writer.print(" mStopped=");
        writer.print(this.mStopped);
        writer.print(" mDestroyed=");
        writer.println(this.mDestroyed);
        if (this.mNeedMenuInvalidate) {
            writer.print(prefix);
            writer.print("  mNeedMenuInvalidate=");
            writer.println(this.mNeedMenuInvalidate);
        }
        if (this.mNoTransactionsBecause != null) {
            writer.print(prefix);
            writer.print("  mNoTransactionsBecause=");
            writer.println(this.mNoTransactionsBecause);
        }
    }

    static AnimationOrAnimator makeOpenCloseAnimation(Context context, float startScale, float endScale, float startAlpha, float endAlpha) {
        AnimationSet set = new AnimationSet(false);
        ScaleAnimation scale = new ScaleAnimation(startScale, endScale, startScale, endScale, 1, 0.5f, 1, 0.5f);
        scale.setInterpolator(DECELERATE_QUINT);
        scale.setDuration(220L);
        set.addAnimation((Animation)scale);
        AlphaAnimation alpha = new AlphaAnimation(startAlpha, endAlpha);
        alpha.setInterpolator(DECELERATE_CUBIC);
        alpha.setDuration(220L);
        set.addAnimation((Animation)alpha);
        return new AnimationOrAnimator((Animation)set);
    }

    static AnimationOrAnimator makeFadeAnimation(Context context, float start, float end) {
        AlphaAnimation anim = new AlphaAnimation(start, end);
        anim.setInterpolator(DECELERATE_CUBIC);
        anim.setDuration(220L);
        return new AnimationOrAnimator((Animation)anim);
    }

    AnimationOrAnimator loadAnimation(Fragment fragment, int transit, boolean enter, int transitionStyle) {
        block25: {
            int nextAnim = fragment.getNextAnim();
            Animation animation = fragment.onCreateAnimation(transit, enter, nextAnim);
            if (animation != null) {
                return new AnimationOrAnimator(animation);
            }
            Animator animator = fragment.onCreateAnimator(transit, enter, nextAnim);
            if (animator != null) {
                return new AnimationOrAnimator(animator);
            }
            if (nextAnim != 0) {
                String dir = this.mHost.getContext().getResources().getResourceTypeName(nextAnim);
                boolean isAnim = "anim".equals(dir);
                boolean successfulLoad = false;
                if (isAnim) {
                    try {
                        animation = AnimationUtils.loadAnimation((Context)this.mHost.getContext(), (int)nextAnim);
                        if (animation != null) {
                            return new AnimationOrAnimator(animation);
                        }
                        successfulLoad = true;
                    }
                    catch (Resources.NotFoundException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                if (!successfulLoad) {
                    try {
                        animator = AnimatorInflater.loadAnimator((Context)this.mHost.getContext(), (int)nextAnim);
                        if (animator != null) {
                            return new AnimationOrAnimator(animator);
                        }
                    }
                    catch (RuntimeException e) {
                        if (isAnim) {
                            throw e;
                        }
                        animation = AnimationUtils.loadAnimation((Context)this.mHost.getContext(), (int)nextAnim);
                        if (animation == null) break block25;
                        return new AnimationOrAnimator(animation);
                    }
                }
            }
        }
        if (transit == 0) {
            return null;
        }
        int styleIndex = FragmentManagerImpl.transitToStyleIndex(transit, enter);
        if (styleIndex < 0) {
            return null;
        }
        switch (styleIndex) {
            case 1: {
                return FragmentManagerImpl.makeOpenCloseAnimation(this.mHost.getContext(), 1.125f, 1.0f, 0.0f, 1.0f);
            }
            case 2: {
                return FragmentManagerImpl.makeOpenCloseAnimation(this.mHost.getContext(), 1.0f, 0.975f, 1.0f, 0.0f);
            }
            case 3: {
                return FragmentManagerImpl.makeOpenCloseAnimation(this.mHost.getContext(), 0.975f, 1.0f, 0.0f, 1.0f);
            }
            case 4: {
                return FragmentManagerImpl.makeOpenCloseAnimation(this.mHost.getContext(), 1.0f, 1.075f, 1.0f, 0.0f);
            }
            case 5: {
                return FragmentManagerImpl.makeFadeAnimation(this.mHost.getContext(), 0.0f, 1.0f);
            }
            case 6: {
                return FragmentManagerImpl.makeFadeAnimation(this.mHost.getContext(), 1.0f, 0.0f);
            }
        }
        if (transitionStyle == 0 && this.mHost.onHasWindowAnimations()) {
            transitionStyle = this.mHost.onGetWindowAnimations();
        }
        if (transitionStyle == 0) {
            return null;
        }
        return null;
    }

    public void performPendingDeferredStart(Fragment f) {
        if (f.mDeferStart) {
            if (this.mExecutingActions) {
                this.mHavePendingDeferredStart = true;
                return;
            }
            f.mDeferStart = false;
            this.moveToState(f, this.mCurState, 0, 0, false);
        }
    }

    private static void setHWLayerAnimListenerIfAlpha(View v, AnimationOrAnimator anim) {
        if (v == null || anim == null) {
            return;
        }
        if (FragmentManagerImpl.shouldRunOnHWLayer(v, anim)) {
            if (anim.animator != null) {
                anim.animator.addListener((Animator.AnimatorListener)new AnimatorOnHWLayerIfNeededListener(v));
            } else {
                Animation.AnimationListener originalListener = FragmentManagerImpl.getAnimationListener(anim.animation);
                v.setLayerType(2, null);
                anim.animation.setAnimationListener((Animation.AnimationListener)new AnimateOnHWLayerIfNeededListener(v, originalListener));
            }
        }
    }

    private static Animation.AnimationListener getAnimationListener(Animation animation) {
        Animation.AnimationListener originalListener = null;
        try {
            if (sAnimationListenerField == null) {
                sAnimationListenerField = Animation.class.getDeclaredField("mListener");
                sAnimationListenerField.setAccessible(true);
            }
            originalListener = (Animation.AnimationListener)sAnimationListenerField.get(animation);
        }
        catch (NoSuchFieldException e) {
            Log.e(TAG, "No field with the name mListener is found in Animation class", e);
        }
        catch (IllegalAccessException e) {
            Log.e(TAG, "Cannot access Animation's mListener field", e);
        }
        return originalListener;
    }

    boolean isStateAtLeast(int state) {
        return this.mCurState >= state;
    }

    void moveToState(Fragment f, int newState, int transit, int transitionStyle, boolean keepActive) {
        if ((!f.mAdded || f.mDetached) && newState > 1) {
            newState = 1;
        }
        if (f.mRemoving && newState > f.mState) {
            newState = f.mState == 0 && f.isInBackStack() ? 1 : f.mState;
        }
        if (f.mDeferStart && f.mState < 3 && newState > 2) {
            newState = 2;
        }
        if (f.mState <= newState) {
            if (f.mFromLayout && !f.mInLayout) {
                return;
            }
            if (f.getAnimatingAway() != null || f.getAnimator() != null) {
                f.setAnimatingAway(null);
                f.setAnimator(null);
                this.moveToState(f, f.getStateAfterAnimating(), 0, 0, true);
            }
            switch (f.mState) {
                case 0: {
                    if (newState > 0) {
                        if (DEBUG) {
                            Log.v(TAG, "moveto CREATED: " + f);
                        }
                        if (f.mSavedFragmentState != null) {
                            f.mSavedFragmentState.setClassLoader(this.mHost.getContext().getClassLoader());
                            f.mSavedViewState = f.mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
                            f.mTarget = this.getFragment(f.mSavedFragmentState, TARGET_STATE_TAG);
                            if (f.mTarget != null) {
                                f.mTargetRequestCode = f.mSavedFragmentState.getInt(TARGET_REQUEST_CODE_STATE_TAG, 0);
                            }
                            if (f.mSavedUserVisibleHint != null) {
                                f.mUserVisibleHint = f.mSavedUserVisibleHint;
                                f.mSavedUserVisibleHint = null;
                            } else {
                                f.mUserVisibleHint = f.mSavedFragmentState.getBoolean(USER_VISIBLE_HINT_TAG, true);
                            }
                            if (!f.mUserVisibleHint) {
                                f.mDeferStart = true;
                                if (newState > 2) {
                                    newState = 2;
                                }
                            }
                        }
                        f.mHost = this.mHost;
                        f.mParentFragment = this.mParent;
                        FragmentManagerImpl fragmentManagerImpl = f.mFragmentManager = this.mParent != null ? this.mParent.mChildFragmentManager : this.mHost.getFragmentManagerImpl();
                        if (f.mTarget != null) {
                            if (this.mActive.get(f.mTarget.mIndex) != f.mTarget) {
                                throw new IllegalStateException("Fragment " + f + " declared target fragment " + f.mTarget + " that does not belong to this FragmentManager!");
                            }
                            if (f.mTarget.mState < 1) {
                                this.moveToState(f.mTarget, 1, 0, 0, true);
                            }
                        }
                        this.dispatchOnFragmentPreAttached(f, this.mHost.getContext(), false);
                        f.mCalled = false;
                        f.onAttach(this.mHost.getContext());
                        if (!f.mCalled) {
                            throw new SuperNotCalledException("Fragment " + f + " did not call through to super.onAttach()");
                        }
                        if (f.mParentFragment == null) {
                            this.mHost.onAttachFragment(f);
                        } else {
                            f.mParentFragment.onAttachFragment(f);
                        }
                        this.dispatchOnFragmentAttached(f, this.mHost.getContext(), false);
                        if (!f.mIsCreated) {
                            this.dispatchOnFragmentPreCreated(f, f.mSavedFragmentState, false);
                            f.performCreate(f.mSavedFragmentState);
                            this.dispatchOnFragmentCreated(f, f.mSavedFragmentState, false);
                        } else {
                            f.restoreChildFragmentState(f.mSavedFragmentState);
                            f.mState = 1;
                        }
                        f.mRetaining = false;
                    }
                }
                case 1: {
                    this.ensureInflatedFragmentView(f);
                    if (newState > 1) {
                        if (DEBUG) {
                            Log.v(TAG, "moveto ACTIVITY_CREATED: " + f);
                        }
                        if (!f.mFromLayout) {
                            ViewGroup container = null;
                            if (f.mContainerId != 0) {
                                if (f.mContainerId == -1) {
                                    this.throwException(new IllegalArgumentException("Cannot create fragment " + f + " for a container view with no id"));
                                }
                                if ((container = (ViewGroup)this.mContainer.onFindViewById(f.mContainerId)) == null && !f.mRestored) {
                                    String resName;
                                    try {
                                        resName = f.getResources().getResourceName(f.mContainerId);
                                    }
                                    catch (Resources.NotFoundException e) {
                                        resName = "unknown";
                                    }
                                    this.throwException(new IllegalArgumentException("No view found for id 0x" + Integer.toHexString(f.mContainerId) + " (" + resName + ") for fragment " + f));
                                }
                            }
                            f.mContainer = container;
                            f.performCreateView(f.performGetLayoutInflater(f.mSavedFragmentState), container, f.mSavedFragmentState);
                            if (f.mView != null) {
                                f.mInnerView = f.mView;
                                f.mView.setSaveFromParentEnabled(false);
                                if (container != null) {
                                    container.addView(f.mView);
                                }
                                if (f.mHidden) {
                                    f.mView.setVisibility(8);
                                }
                                f.onViewCreated(f.mView, f.mSavedFragmentState);
                                this.dispatchOnFragmentViewCreated(f, f.mView, f.mSavedFragmentState, false);
                                f.mIsNewlyAdded = f.mView.getVisibility() == 0 && f.mContainer != null;
                            } else {
                                f.mInnerView = null;
                            }
                        }
                        f.performActivityCreated(f.mSavedFragmentState);
                        this.dispatchOnFragmentActivityCreated(f, f.mSavedFragmentState, false);
                        if (f.mView != null) {
                            f.restoreViewState(f.mSavedFragmentState);
                        }
                        f.mSavedFragmentState = null;
                    }
                }
                case 2: {
                    if (newState > 2) {
                        if (DEBUG) {
                            Log.v(TAG, "moveto STARTED: " + f);
                        }
                        f.performStart();
                        this.dispatchOnFragmentStarted(f, false);
                    }
                }
                case 3: {
                    if (newState <= 3) break;
                    if (DEBUG) {
                        Log.v(TAG, "moveto RESUMED: " + f);
                    }
                    f.performResume();
                    this.dispatchOnFragmentResumed(f, false);
                    f.mSavedFragmentState = null;
                    f.mSavedViewState = null;
                }
            }
        } else if (f.mState > newState) {
            switch (f.mState) {
                case 4: {
                    if (newState < 4) {
                        if (DEBUG) {
                            Log.v(TAG, "movefrom RESUMED: " + f);
                        }
                        f.performPause();
                        this.dispatchOnFragmentPaused(f, false);
                    }
                }
                case 3: {
                    if (newState < 3) {
                        if (DEBUG) {
                            Log.v(TAG, "movefrom STARTED: " + f);
                        }
                        f.performStop();
                        this.dispatchOnFragmentStopped(f, false);
                    }
                }
                case 2: {
                    if (newState < 2) {
                        if (DEBUG) {
                            Log.v(TAG, "movefrom ACTIVITY_CREATED: " + f);
                        }
                        if (f.mView != null && this.mHost.onShouldSaveFragmentState(f) && f.mSavedViewState == null) {
                            this.saveFragmentViewState(f);
                        }
                        f.performDestroyView();
                        this.dispatchOnFragmentViewDestroyed(f, false);
                        if (f.mView != null && f.mContainer != null) {
                            f.mContainer.endViewTransition(f.mView);
                            f.mView.clearAnimation();
                            AnimationOrAnimator anim = null;
                            if (this.mCurState > 0 && !this.mDestroyed && f.mView.getVisibility() == 0 && f.mPostponedAlpha >= 0.0f) {
                                anim = this.loadAnimation(f, transit, false, transitionStyle);
                            }
                            f.mPostponedAlpha = 0.0f;
                            if (anim != null) {
                                this.animateRemoveFragment(f, anim, newState);
                            }
                            f.mContainer.removeView(f.mView);
                        }
                        f.mContainer = null;
                        f.mView = null;
                        f.mViewLifecycleOwner = null;
                        f.mViewLifecycleOwnerLiveData.setValue(null);
                        f.mInnerView = null;
                        f.mInLayout = false;
                    }
                }
                case 1: {
                    if (newState >= 1) break;
                    if (this.mDestroyed) {
                        if (f.getAnimatingAway() != null) {
                            View v = f.getAnimatingAway();
                            f.setAnimatingAway(null);
                            v.clearAnimation();
                        } else if (f.getAnimator() != null) {
                            Animator animator = f.getAnimator();
                            f.setAnimator(null);
                            animator.cancel();
                        }
                    }
                    if (f.getAnimatingAway() != null || f.getAnimator() != null) {
                        f.setStateAfterAnimating(newState);
                        newState = 1;
                        break;
                    }
                    if (DEBUG) {
                        Log.v(TAG, "movefrom CREATED: " + f);
                    }
                    if (!f.mRetaining) {
                        f.performDestroy();
                        this.dispatchOnFragmentDestroyed(f, false);
                    } else {
                        f.mState = 0;
                    }
                    f.performDetach();
                    this.dispatchOnFragmentDetached(f, false);
                    if (keepActive) break;
                    if (!f.mRetaining) {
                        this.makeInactive(f);
                        break;
                    }
                    f.mHost = null;
                    f.mParentFragment = null;
                    f.mFragmentManager = null;
                }
            }
        }
        if (f.mState != newState) {
            Log.w(TAG, "moveToState: Fragment state for " + f + " not updated inline; " + "expected state " + newState + " found " + f.mState);
            f.mState = newState;
        }
    }

    private void animateRemoveFragment(final @NonNull Fragment fragment, @NonNull AnimationOrAnimator anim, int newState) {
        final View viewToAnimate = fragment.mView;
        final ViewGroup container = fragment.mContainer;
        container.startViewTransition(viewToAnimate);
        fragment.setStateAfterAnimating(newState);
        if (anim.animation != null) {
            EndViewTransitionAnimator animation = new EndViewTransitionAnimator(anim.animation, container, viewToAnimate);
            fragment.setAnimatingAway(fragment.mView);
            Animation.AnimationListener listener2 = FragmentManagerImpl.getAnimationListener((Animation)animation);
            animation.setAnimationListener(new AnimationListenerWrapper(listener2){

                @Override
                public void onAnimationEnd(Animation animation) {
                    super.onAnimationEnd(animation);
                    container.post(new Runnable(){

                        @Override
                        public void run() {
                            if (fragment.getAnimatingAway() != null) {
                                fragment.setAnimatingAway(null);
                                FragmentManagerImpl.this.moveToState(fragment, fragment.getStateAfterAnimating(), 0, 0, false);
                            }
                        }
                    });
                }
            });
            FragmentManagerImpl.setHWLayerAnimListenerIfAlpha(viewToAnimate, anim);
            fragment.mView.startAnimation((Animation)animation);
        } else {
            Animator animator = anim.animator;
            fragment.setAnimator(anim.animator);
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator anim) {
                    container.endViewTransition(viewToAnimate);
                    Animator animator = fragment.getAnimator();
                    fragment.setAnimator(null);
                    if (animator != null && container.indexOfChild(viewToAnimate) < 0) {
                        FragmentManagerImpl.this.moveToState(fragment, fragment.getStateAfterAnimating(), 0, 0, false);
                    }
                }
            });
            animator.setTarget((Object)fragment.mView);
            FragmentManagerImpl.setHWLayerAnimListenerIfAlpha(fragment.mView, anim);
            animator.start();
        }
    }

    void moveToState(Fragment f) {
        this.moveToState(f, this.mCurState, 0, 0, false);
    }

    void ensureInflatedFragmentView(Fragment f) {
        if (f.mFromLayout && !f.mPerformedCreateView) {
            f.performCreateView(f.performGetLayoutInflater(f.mSavedFragmentState), null, f.mSavedFragmentState);
            if (f.mView != null) {
                f.mInnerView = f.mView;
                f.mView.setSaveFromParentEnabled(false);
                if (f.mHidden) {
                    f.mView.setVisibility(8);
                }
                f.onViewCreated(f.mView, f.mSavedFragmentState);
                this.dispatchOnFragmentViewCreated(f, f.mView, f.mSavedFragmentState, false);
            } else {
                f.mInnerView = null;
            }
        }
    }

    void completeShowHideFragment(final Fragment fragment) {
        if (fragment.mView != null) {
            AnimationOrAnimator anim = this.loadAnimation(fragment, fragment.getNextTransition(), !fragment.mHidden, fragment.getNextTransitionStyle());
            if (anim != null && anim.animator != null) {
                anim.animator.setTarget((Object)fragment.mView);
                if (fragment.mHidden) {
                    if (fragment.isHideReplaced()) {
                        fragment.setHideReplaced(false);
                    } else {
                        final ViewGroup container = fragment.mContainer;
                        final View animatingView = fragment.mView;
                        container.startViewTransition(animatingView);
                        anim.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animation) {
                                container.endViewTransition(animatingView);
                                animation.removeListener((Animator.AnimatorListener)this);
                                if (fragment.mView != null) {
                                    fragment.mView.setVisibility(8);
                                }
                            }
                        });
                    }
                } else {
                    fragment.mView.setVisibility(0);
                }
                FragmentManagerImpl.setHWLayerAnimListenerIfAlpha(fragment.mView, anim);
                anim.animator.start();
            } else {
                if (anim != null) {
                    FragmentManagerImpl.setHWLayerAnimListenerIfAlpha(fragment.mView, anim);
                    fragment.mView.startAnimation(anim.animation);
                    anim.animation.start();
                }
                int visibility = fragment.mHidden && !fragment.isHideReplaced() ? 8 : 0;
                fragment.mView.setVisibility(visibility);
                if (fragment.isHideReplaced()) {
                    fragment.setHideReplaced(false);
                }
            }
        }
        if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
            this.mNeedMenuInvalidate = true;
        }
        fragment.mHiddenChanged = false;
        fragment.onHiddenChanged(fragment.mHidden);
    }

    void moveFragmentToExpectedState(Fragment f) {
        if (f == null) {
            return;
        }
        int nextState = this.mCurState;
        if (f.mRemoving) {
            nextState = f.isInBackStack() ? Math.min(nextState, 1) : Math.min(nextState, 0);
        }
        this.moveToState(f, nextState, f.getNextTransition(), f.getNextTransitionStyle(), false);
        if (f.mView != null) {
            Fragment underFragment = this.findFragmentUnder(f);
            if (underFragment != null) {
                View underView = underFragment.mView;
                ViewGroup container = f.mContainer;
                int underIndex = container.indexOfChild(underView);
                int viewIndex = container.indexOfChild(f.mView);
                if (viewIndex < underIndex) {
                    container.removeViewAt(viewIndex);
                    container.addView(f.mView, underIndex);
                }
            }
            if (f.mIsNewlyAdded && f.mContainer != null) {
                if (f.mPostponedAlpha > 0.0f) {
                    f.mView.setAlpha(f.mPostponedAlpha);
                }
                f.mPostponedAlpha = 0.0f;
                f.mIsNewlyAdded = false;
                AnimationOrAnimator anim = this.loadAnimation(f, f.getNextTransition(), true, f.getNextTransitionStyle());
                if (anim != null) {
                    FragmentManagerImpl.setHWLayerAnimListenerIfAlpha(f.mView, anim);
                    if (anim.animation != null) {
                        f.mView.startAnimation(anim.animation);
                    } else {
                        anim.animator.setTarget((Object)f.mView);
                        anim.animator.start();
                    }
                }
            }
        }
        if (f.mHiddenChanged) {
            this.completeShowHideFragment(f);
        }
    }

    void moveToState(int newState, boolean always) {
        if (this.mHost == null && newState != 0) {
            throw new IllegalStateException("No activity");
        }
        if (!always && newState == this.mCurState) {
            return;
        }
        this.mCurState = newState;
        if (this.mActive != null) {
            int numAdded = this.mAdded.size();
            for (int i = 0; i < numAdded; ++i) {
                Fragment f = this.mAdded.get(i);
                this.moveFragmentToExpectedState(f);
            }
            int numActive = this.mActive.size();
            for (int i = 0; i < numActive; ++i) {
                Fragment f = this.mActive.valueAt(i);
                if (f == null || !f.mRemoving && !f.mDetached || f.mIsNewlyAdded) continue;
                this.moveFragmentToExpectedState(f);
            }
            this.startPendingDeferredFragments();
            if (this.mNeedMenuInvalidate && this.mHost != null && this.mCurState == 4) {
                this.mHost.onSupportInvalidateOptionsMenu();
                this.mNeedMenuInvalidate = false;
            }
        }
    }

    void startPendingDeferredFragments() {
        if (this.mActive == null) {
            return;
        }
        for (int i = 0; i < this.mActive.size(); ++i) {
            Fragment f = this.mActive.valueAt(i);
            if (f == null) continue;
            this.performPendingDeferredStart(f);
        }
    }

    void makeActive(Fragment f) {
        if (f.mIndex >= 0) {
            return;
        }
        f.setIndex(this.mNextFragmentIndex++, this.mParent);
        if (this.mActive == null) {
            this.mActive = new SparseArray();
        }
        this.mActive.put(f.mIndex, f);
        if (DEBUG) {
            Log.v(TAG, "Allocated fragment index " + f);
        }
    }

    void makeInactive(Fragment f) {
        if (f.mIndex < 0) {
            return;
        }
        if (DEBUG) {
            Log.v(TAG, "Freeing fragment index " + f);
        }
        this.mActive.put(f.mIndex, null);
        f.initState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFragment(Fragment fragment, boolean moveToStateNow) {
        if (DEBUG) {
            Log.v(TAG, "add: " + fragment);
        }
        this.makeActive(fragment);
        if (!fragment.mDetached) {
            if (this.mAdded.contains(fragment)) {
                throw new IllegalStateException("Fragment already added: " + fragment);
            }
            ArrayList<Fragment> arrayList = this.mAdded;
            synchronized (arrayList) {
                this.mAdded.add(fragment);
            }
            fragment.mAdded = true;
            fragment.mRemoving = false;
            if (fragment.mView == null) {
                fragment.mHiddenChanged = false;
            }
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            if (moveToStateNow) {
                this.moveToState(fragment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFragment(Fragment fragment) {
        boolean inactive;
        if (DEBUG) {
            Log.v(TAG, "remove: " + fragment + " nesting=" + fragment.mBackStackNesting);
        }
        boolean bl = inactive = !fragment.isInBackStack();
        if (!fragment.mDetached || inactive) {
            ArrayList<Fragment> arrayList = this.mAdded;
            synchronized (arrayList) {
                this.mAdded.remove(fragment);
            }
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.mAdded = false;
            fragment.mRemoving = true;
        }
    }

    public void hideFragment(Fragment fragment) {
        if (DEBUG) {
            Log.v(TAG, "hide: " + fragment);
        }
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            fragment.mHiddenChanged = !fragment.mHiddenChanged;
        }
    }

    public void showFragment(Fragment fragment) {
        if (DEBUG) {
            Log.v(TAG, "show: " + fragment);
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            fragment.mHiddenChanged = !fragment.mHiddenChanged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachFragment(Fragment fragment) {
        if (DEBUG) {
            Log.v(TAG, "detach: " + fragment);
        }
        if (!fragment.mDetached) {
            fragment.mDetached = true;
            if (fragment.mAdded) {
                if (DEBUG) {
                    Log.v(TAG, "remove from detach: " + fragment);
                }
                ArrayList<Fragment> arrayList = this.mAdded;
                synchronized (arrayList) {
                    this.mAdded.remove(fragment);
                }
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                fragment.mAdded = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachFragment(Fragment fragment) {
        if (DEBUG) {
            Log.v(TAG, "attach: " + fragment);
        }
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (!fragment.mAdded) {
                if (this.mAdded.contains(fragment)) {
                    throw new IllegalStateException("Fragment already added: " + fragment);
                }
                if (DEBUG) {
                    Log.v(TAG, "add from attach: " + fragment);
                }
                ArrayList<Fragment> arrayList = this.mAdded;
                synchronized (arrayList) {
                    this.mAdded.add(fragment);
                }
                fragment.mAdded = true;
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
            }
        }
    }

    @Override
    @Nullable
    public Fragment findFragmentById(int id2) {
        Fragment f;
        int i;
        for (i = this.mAdded.size() - 1; i >= 0; --i) {
            f = this.mAdded.get(i);
            if (f == null || f.mFragmentId != id2) continue;
            return f;
        }
        if (this.mActive != null) {
            for (i = this.mActive.size() - 1; i >= 0; --i) {
                f = this.mActive.valueAt(i);
                if (f == null || f.mFragmentId != id2) continue;
                return f;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Fragment findFragmentByTag(@Nullable String tag) {
        Fragment f;
        int i;
        if (tag != null) {
            for (i = this.mAdded.size() - 1; i >= 0; --i) {
                f = this.mAdded.get(i);
                if (f == null || !tag.equals(f.mTag)) continue;
                return f;
            }
        }
        if (this.mActive != null && tag != null) {
            for (i = this.mActive.size() - 1; i >= 0; --i) {
                f = this.mActive.valueAt(i);
                if (f == null || !tag.equals(f.mTag)) continue;
                return f;
            }
        }
        return null;
    }

    public Fragment findFragmentByWho(String who) {
        if (this.mActive != null && who != null) {
            for (int i = this.mActive.size() - 1; i >= 0; --i) {
                Fragment f = this.mActive.valueAt(i);
                if (f == null || (f = f.findFragmentByWho(who)) == null) continue;
                return f;
            }
        }
        return null;
    }

    private void checkStateLoss() {
        if (this.isStateSaved()) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
        if (this.mNoTransactionsBecause != null) {
            throw new IllegalStateException("Can not perform this action inside of " + this.mNoTransactionsBecause);
        }
    }

    @Override
    public boolean isStateSaved() {
        return this.mStateSaved || this.mStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueAction(OpGenerator action, boolean allowStateLoss) {
        if (!allowStateLoss) {
            this.checkStateLoss();
        }
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            if (this.mDestroyed || this.mHost == null) {
                if (allowStateLoss) {
                    return;
                }
                throw new IllegalStateException("Activity has been destroyed");
            }
            if (this.mPendingActions == null) {
                this.mPendingActions = new ArrayList();
            }
            this.mPendingActions.add(action);
            this.scheduleCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleCommit() {
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            boolean pendingReady;
            boolean postponeReady = this.mPostponedTransactions != null && !this.mPostponedTransactions.isEmpty();
            boolean bl = pendingReady = this.mPendingActions != null && this.mPendingActions.size() == 1;
            if (postponeReady || pendingReady) {
                this.mHost.getHandler().removeCallbacks(this.mExecCommit);
                this.mHost.getHandler().post(this.mExecCommit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocBackStackIndex(BackStackRecord bse) {
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            if (this.mAvailBackStackIndices == null || this.mAvailBackStackIndices.size() <= 0) {
                if (this.mBackStackIndices == null) {
                    this.mBackStackIndices = new ArrayList();
                }
                int index = this.mBackStackIndices.size();
                if (DEBUG) {
                    Log.v(TAG, "Setting back stack index " + index + " to " + bse);
                }
                this.mBackStackIndices.add(bse);
                return index;
            }
            int index = this.mAvailBackStackIndices.remove(this.mAvailBackStackIndices.size() - 1);
            if (DEBUG) {
                Log.v(TAG, "Adding back stack index " + index + " with " + bse);
            }
            this.mBackStackIndices.set(index, bse);
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackStackIndex(int index, BackStackRecord bse) {
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            int N;
            if (this.mBackStackIndices == null) {
                this.mBackStackIndices = new ArrayList();
            }
            if (index < (N = this.mBackStackIndices.size())) {
                if (DEBUG) {
                    Log.v(TAG, "Setting back stack index " + index + " to " + bse);
                }
                this.mBackStackIndices.set(index, bse);
            } else {
                while (N < index) {
                    this.mBackStackIndices.add(null);
                    if (this.mAvailBackStackIndices == null) {
                        this.mAvailBackStackIndices = new ArrayList();
                    }
                    if (DEBUG) {
                        Log.v(TAG, "Adding available back stack index " + N);
                    }
                    this.mAvailBackStackIndices.add(N);
                    ++N;
                }
                if (DEBUG) {
                    Log.v(TAG, "Adding back stack index " + index + " with " + bse);
                }
                this.mBackStackIndices.add(bse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeBackStackIndex(int index) {
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            this.mBackStackIndices.set(index, null);
            if (this.mAvailBackStackIndices == null) {
                this.mAvailBackStackIndices = new ArrayList();
            }
            if (DEBUG) {
                Log.v(TAG, "Freeing back stack index " + index);
            }
            this.mAvailBackStackIndices.add(index);
        }
    }

    private void ensureExecReady(boolean allowStateLoss) {
        if (this.mExecutingActions) {
            throw new IllegalStateException("FragmentManager is already executing transactions");
        }
        if (this.mHost == null) {
            throw new IllegalStateException("Fragment host has been destroyed");
        }
        if (Looper.myLooper() != this.mHost.getHandler().getLooper()) {
            throw new IllegalStateException("Must be called from main thread of fragment host");
        }
        if (!allowStateLoss) {
            this.checkStateLoss();
        }
        if (this.mTmpRecords == null) {
            this.mTmpRecords = new ArrayList();
            this.mTmpIsPop = new ArrayList();
        }
        this.mExecutingActions = true;
        try {
            this.executePostponedTransaction(null, null);
        }
        finally {
            this.mExecutingActions = false;
        }
    }

    public void execSingleAction(OpGenerator action, boolean allowStateLoss) {
        if (allowStateLoss && (this.mHost == null || this.mDestroyed)) {
            return;
        }
        this.ensureExecReady(allowStateLoss);
        if (action.generateOps(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.doPendingDeferredStart();
        this.burpActive();
    }

    private void cleanupExec() {
        this.mExecutingActions = false;
        this.mTmpIsPop.clear();
        this.mTmpRecords.clear();
    }

    public boolean execPendingActions() {
        this.ensureExecReady(true);
        boolean didSomething = false;
        while (this.generateOpsForPendingActions(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
            didSomething = true;
        }
        this.doPendingDeferredStart();
        this.burpActive();
        return didSomething;
    }

    private void executePostponedTransaction(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop) {
        int numPostponed = this.mPostponedTransactions == null ? 0 : this.mPostponedTransactions.size();
        for (int i = 0; i < numPostponed; ++i) {
            int index;
            StartEnterTransitionListener listener2 = this.mPostponedTransactions.get(i);
            if (records != null && !listener2.mIsBack && (index = records.indexOf(listener2.mRecord)) != -1 && isRecordPop.get(index).booleanValue()) {
                listener2.cancelTransaction();
                continue;
            }
            if (!listener2.isReady() && (records == null || !listener2.mRecord.interactsWith(records, 0, records.size()))) continue;
            this.mPostponedTransactions.remove(i);
            --i;
            --numPostponed;
            if (records != null && !listener2.mIsBack && (index = records.indexOf(listener2.mRecord)) != -1 && isRecordPop.get(index).booleanValue()) {
                listener2.cancelTransaction();
                continue;
            }
            listener2.completeTransaction();
        }
    }

    private void removeRedundantOperationsAndExecute(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop) {
        if (records == null || records.isEmpty()) {
            return;
        }
        if (isRecordPop == null || records.size() != isRecordPop.size()) {
            throw new IllegalStateException("Internal error with the back stack records");
        }
        this.executePostponedTransaction(records, isRecordPop);
        int numRecords = records.size();
        int startIndex = 0;
        for (int recordNum = 0; recordNum < numRecords; ++recordNum) {
            int reorderingEnd;
            boolean canReorder = records.get((int)recordNum).mReorderingAllowed;
            if (canReorder) continue;
            if (startIndex != recordNum) {
                this.executeOpsTogether(records, isRecordPop, startIndex, recordNum);
            }
            if (isRecordPop.get(recordNum).booleanValue()) {
                for (reorderingEnd = recordNum + 1; reorderingEnd < numRecords && isRecordPop.get(reorderingEnd).booleanValue() && !records.get((int)reorderingEnd).mReorderingAllowed; ++reorderingEnd) {
                }
            }
            this.executeOpsTogether(records, isRecordPop, recordNum, reorderingEnd);
            startIndex = reorderingEnd;
            recordNum = reorderingEnd - 1;
        }
        if (startIndex != numRecords) {
            this.executeOpsTogether(records, isRecordPop, startIndex, numRecords);
        }
    }

    private void executeOpsTogether(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex) {
        boolean allowReordering = records.get((int)startIndex).mReorderingAllowed;
        boolean addToBackStack = false;
        if (this.mTmpAddedFragments == null) {
            this.mTmpAddedFragments = new ArrayList();
        } else {
            this.mTmpAddedFragments.clear();
        }
        this.mTmpAddedFragments.addAll(this.mAdded);
        Fragment oldPrimaryNav = this.getPrimaryNavigationFragment();
        for (int recordNum = startIndex; recordNum < endIndex; ++recordNum) {
            BackStackRecord record = records.get(recordNum);
            boolean isPop = isRecordPop.get(recordNum);
            oldPrimaryNav = !isPop ? record.expandOps(this.mTmpAddedFragments, oldPrimaryNav) : record.trackAddedFragmentsInPop(this.mTmpAddedFragments, oldPrimaryNav);
            addToBackStack = addToBackStack || record.mAddToBackStack;
        }
        this.mTmpAddedFragments.clear();
        if (!allowReordering) {
            FragmentTransition.startTransitions(this, records, isRecordPop, startIndex, endIndex, false);
        }
        FragmentManagerImpl.executeOps(records, isRecordPop, startIndex, endIndex);
        int postponeIndex = endIndex;
        if (allowReordering) {
            ArraySet addedFragments = new ArraySet();
            this.addAddedFragments((ArraySet<Fragment>)addedFragments);
            postponeIndex = this.postponePostponableTransactions(records, isRecordPop, startIndex, endIndex, (ArraySet<Fragment>)addedFragments);
            this.makeRemovedFragmentsInvisible((ArraySet<Fragment>)addedFragments);
        }
        if (postponeIndex != startIndex && allowReordering) {
            FragmentTransition.startTransitions(this, records, isRecordPop, startIndex, postponeIndex, true);
            this.moveToState(this.mCurState, true);
        }
        for (int recordNum = startIndex; recordNum < endIndex; ++recordNum) {
            BackStackRecord record = records.get(recordNum);
            boolean isPop = isRecordPop.get(recordNum);
            if (isPop && record.mIndex >= 0) {
                this.freeBackStackIndex(record.mIndex);
                record.mIndex = -1;
            }
            record.runOnCommitRunnables();
        }
        if (addToBackStack) {
            this.reportBackStackChanged();
        }
    }

    private void makeRemovedFragmentsInvisible(ArraySet<Fragment> fragments) {
        int numAdded = fragments.size();
        for (int i = 0; i < numAdded; ++i) {
            Fragment fragment = (Fragment)fragments.valueAt(i);
            if (fragment.mAdded) continue;
            View view = fragment.getView();
            fragment.mPostponedAlpha = view.getAlpha();
            view.setAlpha(0.0f);
        }
    }

    private int postponePostponableTransactions(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex, ArraySet<Fragment> added) {
        int postponeIndex = endIndex;
        for (int i = endIndex - 1; i >= startIndex; --i) {
            boolean isPostponed;
            BackStackRecord record = records.get(i);
            boolean isPop = isRecordPop.get(i);
            boolean bl = isPostponed = record.isPostponed() && !record.interactsWith(records, i + 1, endIndex);
            if (!isPostponed) continue;
            if (this.mPostponedTransactions == null) {
                this.mPostponedTransactions = new ArrayList();
            }
            StartEnterTransitionListener listener2 = new StartEnterTransitionListener(record, isPop);
            this.mPostponedTransactions.add(listener2);
            record.setOnStartPostponedListener(listener2);
            if (isPop) {
                record.executeOps();
            } else {
                record.executePopOps(false);
            }
            if (i != --postponeIndex) {
                records.remove(i);
                records.add(postponeIndex, record);
            }
            this.addAddedFragments(added);
        }
        return postponeIndex;
    }

    void completeExecute(BackStackRecord record, boolean isPop, boolean runTransitions, boolean moveToState) {
        if (isPop) {
            record.executePopOps(moveToState);
        } else {
            record.executeOps();
        }
        ArrayList<BackStackRecord> records = new ArrayList<BackStackRecord>(1);
        ArrayList<Boolean> isRecordPop = new ArrayList<Boolean>(1);
        records.add(record);
        isRecordPop.add(isPop);
        if (runTransitions) {
            FragmentTransition.startTransitions(this, records, isRecordPop, 0, 1, true);
        }
        if (moveToState) {
            this.moveToState(this.mCurState, true);
        }
        if (this.mActive != null) {
            int numActive = this.mActive.size();
            for (int i = 0; i < numActive; ++i) {
                Fragment fragment = this.mActive.valueAt(i);
                if (fragment == null || fragment.mView == null || !fragment.mIsNewlyAdded || !record.interactsWith(fragment.mContainerId)) continue;
                if (fragment.mPostponedAlpha > 0.0f) {
                    fragment.mView.setAlpha(fragment.mPostponedAlpha);
                }
                if (moveToState) {
                    fragment.mPostponedAlpha = 0.0f;
                    continue;
                }
                fragment.mPostponedAlpha = -1.0f;
                fragment.mIsNewlyAdded = false;
            }
        }
    }

    private Fragment findFragmentUnder(Fragment f) {
        ViewGroup container = f.mContainer;
        View view = f.mView;
        if (container == null || view == null) {
            return null;
        }
        int fragmentIndex = this.mAdded.indexOf(f);
        for (int i = fragmentIndex - 1; i >= 0; --i) {
            Fragment underFragment = this.mAdded.get(i);
            if (underFragment.mContainer != container || underFragment.mView == null) continue;
            return underFragment;
        }
        return null;
    }

    private static void executeOps(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            BackStackRecord record = records.get(i);
            boolean isPop = isRecordPop.get(i);
            if (isPop) {
                record.bumpBackStackNesting(-1);
                boolean moveToState = i == endIndex - 1;
                record.executePopOps(moveToState);
                continue;
            }
            record.bumpBackStackNesting(1);
            record.executeOps();
        }
    }

    private void addAddedFragments(ArraySet<Fragment> added) {
        if (this.mCurState < 1) {
            return;
        }
        int state = Math.min(this.mCurState, 3);
        int numAdded = this.mAdded.size();
        for (int i = 0; i < numAdded; ++i) {
            Fragment fragment = this.mAdded.get(i);
            if (fragment.mState >= state) continue;
            this.moveToState(fragment, state, fragment.getNextAnim(), fragment.getNextTransition(), false);
            if (fragment.mView == null || fragment.mHidden || !fragment.mIsNewlyAdded) continue;
            added.add((Object)fragment);
        }
    }

    private void forcePostponedTransactions() {
        if (this.mPostponedTransactions != null) {
            while (!this.mPostponedTransactions.isEmpty()) {
                this.mPostponedTransactions.remove(0).completeTransaction();
            }
        }
    }

    private void endAnimatingAwayFragments() {
        int numFragments = this.mActive == null ? 0 : this.mActive.size();
        for (int i = 0; i < numFragments; ++i) {
            Fragment fragment = this.mActive.valueAt(i);
            if (fragment == null) continue;
            if (fragment.getAnimatingAway() != null) {
                int stateAfterAnimating = fragment.getStateAfterAnimating();
                View animatingAway = fragment.getAnimatingAway();
                Animation animation = animatingAway.getAnimation();
                if (animation != null) {
                    animation.cancel();
                    animatingAway.clearAnimation();
                }
                fragment.setAnimatingAway(null);
                this.moveToState(fragment, stateAfterAnimating, 0, 0, false);
                continue;
            }
            if (fragment.getAnimator() == null) continue;
            fragment.getAnimator().end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateOpsForPendingActions(ArrayList<BackStackRecord> records, ArrayList<Boolean> isPop) {
        boolean didSomething = false;
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            if (this.mPendingActions == null || this.mPendingActions.size() == 0) {
                return false;
            }
            int numActions = this.mPendingActions.size();
            for (int i = 0; i < numActions; ++i) {
                didSomething |= this.mPendingActions.get(i).generateOps(records, isPop);
            }
            this.mPendingActions.clear();
            this.mHost.getHandler().removeCallbacks(this.mExecCommit);
        }
        return didSomething;
    }

    void doPendingDeferredStart() {
        if (this.mHavePendingDeferredStart) {
            this.mHavePendingDeferredStart = false;
            this.startPendingDeferredFragments();
        }
    }

    void reportBackStackChanged() {
        if (this.mBackStackChangeListeners != null) {
            for (int i = 0; i < this.mBackStackChangeListeners.size(); ++i) {
                this.mBackStackChangeListeners.get(i).onBackStackChanged();
            }
        }
    }

    void addBackStackState(BackStackRecord state) {
        if (this.mBackStack == null) {
            this.mBackStack = new ArrayList();
        }
        this.mBackStack.add(state);
    }

    boolean popBackStackState(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, String name, int id2, int flags) {
        if (this.mBackStack == null) {
            return false;
        }
        if (name == null && id2 < 0 && (flags & 1) == 0) {
            int last = this.mBackStack.size() - 1;
            if (last < 0) {
                return false;
            }
            records.add(this.mBackStack.remove(last));
            isRecordPop.add(true);
        } else {
            int index = -1;
            if (name != null || id2 >= 0) {
                BackStackRecord bss;
                for (index = this.mBackStack.size() - 1; index >= 0; --index) {
                    bss = this.mBackStack.get(index);
                    if (name != null && name.equals(bss.getName()) || id2 >= 0 && id2 == bss.mIndex) break;
                }
                if (index < 0) {
                    return false;
                }
                if ((flags & 1) != 0) {
                    --index;
                    while (index >= 0) {
                        bss = this.mBackStack.get(index);
                        if ((name == null || !name.equals(bss.getName())) && (id2 < 0 || id2 != bss.mIndex)) break;
                        --index;
                    }
                }
            }
            if (index == this.mBackStack.size() - 1) {
                return false;
            }
            for (int i = this.mBackStack.size() - 1; i > index; --i) {
                records.add(this.mBackStack.remove(i));
                isRecordPop.add(true);
            }
        }
        return true;
    }

    FragmentManagerNonConfig retainNonConfig() {
        FragmentManagerImpl.setRetaining(this.mSavedNonConfig);
        return this.mSavedNonConfig;
    }

    private static void setRetaining(FragmentManagerNonConfig nonConfig) {
        List<FragmentManagerNonConfig> children;
        if (nonConfig == null) {
            return;
        }
        List<Fragment> fragments = nonConfig.getFragments();
        if (fragments != null) {
            for (Fragment fragment : fragments) {
                fragment.mRetaining = true;
            }
        }
        if ((children = nonConfig.getChildNonConfigs()) != null) {
            for (FragmentManagerNonConfig child : children) {
                FragmentManagerImpl.setRetaining(child);
            }
        }
    }

    void saveNonConfig() {
        ArrayList<Fragment> fragments = null;
        ArrayList<Object> childFragments = null;
        ArrayList<Object> viewModelStores = null;
        if (this.mActive != null) {
            for (int i = 0; i < this.mActive.size(); ++i) {
                int j;
                FragmentManagerNonConfig child;
                Fragment f = this.mActive.valueAt(i);
                if (f == null) continue;
                if (f.mRetainInstance) {
                    if (fragments == null) {
                        fragments = new ArrayList<Fragment>();
                    }
                    fragments.add(f);
                    int n = f.mTargetIndex = f.mTarget != null ? f.mTarget.mIndex : -1;
                    if (DEBUG) {
                        Log.v(TAG, "retainNonConfig: keeping retained " + f);
                    }
                }
                if (f.mChildFragmentManager != null) {
                    f.mChildFragmentManager.saveNonConfig();
                    child = f.mChildFragmentManager.mSavedNonConfig;
                } else {
                    child = f.mChildNonConfig;
                }
                if (childFragments == null && child != null) {
                    childFragments = new ArrayList<Object>(this.mActive.size());
                    for (j = 0; j < i; ++j) {
                        childFragments.add(null);
                    }
                }
                if (childFragments != null) {
                    childFragments.add(child);
                }
                if (viewModelStores == null && f.mViewModelStore != null) {
                    viewModelStores = new ArrayList<Object>(this.mActive.size());
                    for (j = 0; j < i; ++j) {
                        viewModelStores.add(null);
                    }
                }
                if (viewModelStores == null) continue;
                viewModelStores.add(f.mViewModelStore);
            }
        }
        this.mSavedNonConfig = fragments == null && childFragments == null && viewModelStores == null ? null : new FragmentManagerNonConfig(fragments, childFragments, viewModelStores);
    }

    void saveFragmentViewState(Fragment f) {
        if (f.mInnerView == null) {
            return;
        }
        if (this.mStateArray == null) {
            this.mStateArray = new SparseArray();
        } else {
            this.mStateArray.clear();
        }
        f.mInnerView.saveHierarchyState(this.mStateArray);
        if (this.mStateArray.size() > 0) {
            f.mSavedViewState = this.mStateArray;
            this.mStateArray = null;
        }
    }

    Bundle saveFragmentBasicState(Fragment f) {
        Bundle result = null;
        if (this.mStateBundle == null) {
            this.mStateBundle = new Bundle();
        }
        f.performSaveInstanceState(this.mStateBundle);
        this.dispatchOnFragmentSaveInstanceState(f, this.mStateBundle, false);
        if (!this.mStateBundle.isEmpty()) {
            result = this.mStateBundle;
            this.mStateBundle = null;
        }
        if (f.mView != null) {
            this.saveFragmentViewState(f);
        }
        if (f.mSavedViewState != null) {
            if (result == null) {
                result = new Bundle();
            }
            result.putSparseParcelableArray(VIEW_STATE_TAG, f.mSavedViewState);
        }
        if (!f.mUserVisibleHint) {
            if (result == null) {
                result = new Bundle();
            }
            result.putBoolean(USER_VISIBLE_HINT_TAG, f.mUserVisibleHint);
        }
        return result;
    }

    Parcelable saveAllState() {
        this.forcePostponedTransactions();
        this.endAnimatingAwayFragments();
        this.execPendingActions();
        this.mStateSaved = true;
        this.mSavedNonConfig = null;
        if (this.mActive == null || this.mActive.size() <= 0) {
            return null;
        }
        int N = this.mActive.size();
        FragmentState[] active = new FragmentState[N];
        boolean haveFragments = false;
        for (int i = 0; i < N; ++i) {
            FragmentState fs;
            Fragment f = this.mActive.valueAt(i);
            if (f == null) continue;
            if (f.mIndex < 0) {
                this.throwException(new IllegalStateException("Failure saving state: active " + f + " has cleared index: " + f.mIndex));
            }
            haveFragments = true;
            active[i] = fs = new FragmentState(f);
            if (f.mState > 0 && fs.mSavedFragmentState == null) {
                fs.mSavedFragmentState = this.saveFragmentBasicState(f);
                if (f.mTarget != null) {
                    if (f.mTarget.mIndex < 0) {
                        this.throwException(new IllegalStateException("Failure saving state: " + f + " has target not in fragment manager: " + f.mTarget));
                    }
                    if (fs.mSavedFragmentState == null) {
                        fs.mSavedFragmentState = new Bundle();
                    }
                    this.putFragment(fs.mSavedFragmentState, TARGET_STATE_TAG, f.mTarget);
                    if (f.mTargetRequestCode != 0) {
                        fs.mSavedFragmentState.putInt(TARGET_REQUEST_CODE_STATE_TAG, f.mTargetRequestCode);
                    }
                }
            } else {
                fs.mSavedFragmentState = f.mSavedFragmentState;
            }
            if (!DEBUG) continue;
            Log.v(TAG, "Saved state of " + f + ": " + fs.mSavedFragmentState);
        }
        if (!haveFragments) {
            if (DEBUG) {
                Log.v(TAG, "saveAllState: no fragments!");
            }
            return null;
        }
        int[] added = null;
        BackStackState[] backStack = null;
        N = this.mAdded.size();
        if (N > 0) {
            added = new int[N];
            for (int i = 0; i < N; ++i) {
                added[i] = this.mAdded.get((int)i).mIndex;
                if (added[i] < 0) {
                    this.throwException(new IllegalStateException("Failure saving state: active " + this.mAdded.get(i) + " has cleared index: " + added[i]));
                }
                if (!DEBUG) continue;
                Log.v(TAG, "saveAllState: adding fragment #" + i + ": " + this.mAdded.get(i));
            }
        }
        if (this.mBackStack != null && (N = this.mBackStack.size()) > 0) {
            backStack = new BackStackState[N];
            for (int i = 0; i < N; ++i) {
                backStack[i] = new BackStackState(this.mBackStack.get(i));
                if (!DEBUG) continue;
                Log.v(TAG, "saveAllState: adding back stack #" + i + ": " + this.mBackStack.get(i));
            }
        }
        FragmentManagerState fms = new FragmentManagerState();
        fms.mActive = active;
        fms.mAdded = added;
        fms.mBackStack = backStack;
        if (this.mPrimaryNav != null) {
            fms.mPrimaryNavActiveIndex = this.mPrimaryNav.mIndex;
        }
        fms.mNextFragmentIndex = this.mNextFragmentIndex;
        this.saveNonConfig();
        return fms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreAllState(Parcelable state, FragmentManagerNonConfig nonConfig) {
        Fragment f;
        int i;
        int count;
        if (state == null) {
            return;
        }
        FragmentManagerState fms = (FragmentManagerState)state;
        if (fms.mActive == null) {
            return;
        }
        List<FragmentManagerNonConfig> childNonConfigs = null;
        List<ViewModelStore> viewModelStores = null;
        if (nonConfig != null) {
            List<Fragment> nonConfigFragments = nonConfig.getFragments();
            childNonConfigs = nonConfig.getChildNonConfigs();
            viewModelStores = nonConfig.getViewModelStores();
            count = nonConfigFragments != null ? nonConfigFragments.size() : 0;
            for (i = 0; i < count; ++i) {
                int index;
                f = nonConfigFragments.get(i);
                if (DEBUG) {
                    Log.v(TAG, "restoreAllState: re-attaching retained " + f);
                }
                for (index = 0; index < fms.mActive.length && fms.mActive[index].mIndex != f.mIndex; ++index) {
                }
                if (index == fms.mActive.length) {
                    this.throwException(new IllegalStateException("Could not find active fragment with index " + f.mIndex));
                }
                FragmentState fs = fms.mActive[index];
                fs.mInstance = f;
                f.mSavedViewState = null;
                f.mBackStackNesting = 0;
                f.mInLayout = false;
                f.mAdded = false;
                f.mTarget = null;
                if (fs.mSavedFragmentState == null) continue;
                fs.mSavedFragmentState.setClassLoader(this.mHost.getContext().getClassLoader());
                f.mSavedViewState = fs.mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
                f.mSavedFragmentState = fs.mSavedFragmentState;
            }
        }
        this.mActive = new SparseArray(fms.mActive.length);
        for (int i2 = 0; i2 < fms.mActive.length; ++i2) {
            FragmentState fs = fms.mActive[i2];
            if (fs == null) continue;
            FragmentManagerNonConfig childNonConfig = null;
            if (childNonConfigs != null && i2 < childNonConfigs.size()) {
                childNonConfig = childNonConfigs.get(i2);
            }
            ViewModelStore viewModelStore = null;
            if (viewModelStores != null && i2 < viewModelStores.size()) {
                viewModelStore = viewModelStores.get(i2);
            }
            Fragment f2 = fs.instantiate(this.mHost, this.mContainer, this.mParent, childNonConfig, viewModelStore);
            if (DEBUG) {
                Log.v(TAG, "restoreAllState: active #" + i2 + ": " + f2);
            }
            this.mActive.put(f2.mIndex, f2);
            fs.mInstance = null;
        }
        if (nonConfig != null) {
            List<Fragment> nonConfigFragments = nonConfig.getFragments();
            count = nonConfigFragments != null ? nonConfigFragments.size() : 0;
            for (i = 0; i < count; ++i) {
                f = nonConfigFragments.get(i);
                if (f.mTargetIndex < 0) continue;
                f.mTarget = this.mActive.get(f.mTargetIndex);
                if (f.mTarget != null) continue;
                Log.w(TAG, "Re-attaching retained fragment " + f + " target no longer exists: " + f.mTargetIndex);
            }
        }
        this.mAdded.clear();
        if (fms.mAdded != null) {
            for (int i3 = 0; i3 < fms.mAdded.length; ++i3) {
                Fragment f3 = this.mActive.get(fms.mAdded[i3]);
                if (f3 == null) {
                    this.throwException(new IllegalStateException("No instantiated fragment for index #" + fms.mAdded[i3]));
                }
                f3.mAdded = true;
                if (DEBUG) {
                    Log.v(TAG, "restoreAllState: added #" + i3 + ": " + f3);
                }
                if (this.mAdded.contains(f3)) {
                    throw new IllegalStateException("Already added!");
                }
                ArrayList<Fragment> i4 = this.mAdded;
                synchronized (i4) {
                    this.mAdded.add(f3);
                    continue;
                }
            }
        }
        if (fms.mBackStack != null) {
            this.mBackStack = new ArrayList(fms.mBackStack.length);
            for (int i5 = 0; i5 < fms.mBackStack.length; ++i5) {
                BackStackRecord bse = fms.mBackStack[i5].instantiate(this);
                if (DEBUG) {
                    Log.v(TAG, "restoreAllState: back stack #" + i5 + " (index " + bse.mIndex + "): " + bse);
                    LogWriter logw = new LogWriter(TAG);
                    PrintWriter pw = new PrintWriter(logw);
                    bse.dump("  ", pw, false);
                    pw.close();
                }
                this.mBackStack.add(bse);
                if (bse.mIndex < 0) continue;
                this.setBackStackIndex(bse.mIndex, bse);
            }
        } else {
            this.mBackStack = null;
        }
        if (fms.mPrimaryNavActiveIndex >= 0) {
            this.mPrimaryNav = this.mActive.get(fms.mPrimaryNavActiveIndex);
        }
        this.mNextFragmentIndex = fms.mNextFragmentIndex;
    }

    private void burpActive() {
        if (this.mActive != null) {
            for (int i = this.mActive.size() - 1; i >= 0; --i) {
                if (this.mActive.valueAt(i) != null) continue;
                this.mActive.delete(this.mActive.keyAt(i));
            }
        }
    }

    public void attachController(FragmentHostCallback host, FragmentContainer container, Fragment parent) {
        if (this.mHost != null) {
            throw new IllegalStateException("Already attached");
        }
        this.mHost = host;
        this.mContainer = container;
        this.mParent = parent;
    }

    public void noteStateNotSaved() {
        this.mSavedNonConfig = null;
        this.mStateSaved = false;
        this.mStopped = false;
        int addedCount = this.mAdded.size();
        for (int i = 0; i < addedCount; ++i) {
            Fragment fragment = this.mAdded.get(i);
            if (fragment == null) continue;
            fragment.noteStateNotSaved();
        }
    }

    public void dispatchCreate() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.dispatchStateChange(1);
    }

    public void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.dispatchStateChange(2);
    }

    public void dispatchStart() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.dispatchStateChange(3);
    }

    public void dispatchResume() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.dispatchStateChange(4);
    }

    public void dispatchPause() {
        this.dispatchStateChange(3);
    }

    public void dispatchStop() {
        this.mStopped = true;
        this.dispatchStateChange(2);
    }

    public void dispatchDestroyView() {
        this.dispatchStateChange(1);
    }

    public void dispatchDestroy() {
        this.mDestroyed = true;
        this.execPendingActions();
        this.dispatchStateChange(0);
        this.mHost = null;
        this.mContainer = null;
        this.mParent = null;
    }

    private void dispatchStateChange(int nextState) {
        try {
            this.mExecutingActions = true;
            this.moveToState(nextState, false);
        }
        finally {
            this.mExecutingActions = false;
        }
        this.execPendingActions();
    }

    public void dispatchMultiWindowModeChanged(boolean isInMultiWindowMode) {
        for (int i = this.mAdded.size() - 1; i >= 0; --i) {
            Fragment f = this.mAdded.get(i);
            if (f == null) continue;
            f.performMultiWindowModeChanged(isInMultiWindowMode);
        }
    }

    public void dispatchPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
        for (int i = this.mAdded.size() - 1; i >= 0; --i) {
            Fragment f = this.mAdded.get(i);
            if (f == null) continue;
            f.performPictureInPictureModeChanged(isInPictureInPictureMode);
        }
    }

    public void dispatchConfigurationChanged(Configuration newConfig) {
        for (int i = 0; i < this.mAdded.size(); ++i) {
            Fragment f = this.mAdded.get(i);
            if (f == null) continue;
            f.performConfigurationChanged(newConfig);
        }
    }

    public void dispatchLowMemory() {
        for (int i = 0; i < this.mAdded.size(); ++i) {
            Fragment f = this.mAdded.get(i);
            if (f == null) continue;
            f.performLowMemory();
        }
    }

    public boolean dispatchCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        Fragment f;
        int i;
        if (this.mCurState < 1) {
            return false;
        }
        boolean show = false;
        ArrayList<Fragment> newMenus = null;
        for (i = 0; i < this.mAdded.size(); ++i) {
            f = this.mAdded.get(i);
            if (f == null || !f.performCreateOptionsMenu(menu, inflater)) continue;
            show = true;
            if (newMenus == null) {
                newMenus = new ArrayList<Fragment>();
            }
            newMenus.add(f);
        }
        if (this.mCreatedMenus != null) {
            for (i = 0; i < this.mCreatedMenus.size(); ++i) {
                f = this.mCreatedMenus.get(i);
                if (newMenus != null && newMenus.contains(f)) continue;
                f.onDestroyOptionsMenu();
            }
        }
        this.mCreatedMenus = newMenus;
        return show;
    }

    public boolean dispatchPrepareOptionsMenu(Menu menu) {
        if (this.mCurState < 1) {
            return false;
        }
        boolean show = false;
        for (int i = 0; i < this.mAdded.size(); ++i) {
            Fragment f = this.mAdded.get(i);
            if (f == null || !f.performPrepareOptionsMenu(menu)) continue;
            show = true;
        }
        return show;
    }

    public boolean dispatchOptionsItemSelected(MenuItem item) {
        if (this.mCurState < 1) {
            return false;
        }
        for (int i = 0; i < this.mAdded.size(); ++i) {
            Fragment f = this.mAdded.get(i);
            if (f == null || !f.performOptionsItemSelected(item)) continue;
            return true;
        }
        return false;
    }

    public boolean dispatchContextItemSelected(MenuItem item) {
        if (this.mCurState < 1) {
            return false;
        }
        for (int i = 0; i < this.mAdded.size(); ++i) {
            Fragment f = this.mAdded.get(i);
            if (f == null || !f.performContextItemSelected(item)) continue;
            return true;
        }
        return false;
    }

    public void dispatchOptionsMenuClosed(Menu menu) {
        if (this.mCurState < 1) {
            return;
        }
        for (int i = 0; i < this.mAdded.size(); ++i) {
            Fragment f = this.mAdded.get(i);
            if (f == null) continue;
            f.performOptionsMenuClosed(menu);
        }
    }

    public void setPrimaryNavigationFragment(Fragment f) {
        if (f != null && (this.mActive.get(f.mIndex) != f || f.mHost != null && f.getFragmentManager() != this)) {
            throw new IllegalArgumentException("Fragment " + f + " is not an active fragment of FragmentManager " + this);
        }
        this.mPrimaryNav = f;
    }

    @Override
    @Nullable
    public Fragment getPrimaryNavigationFragment() {
        return this.mPrimaryNav;
    }

    @Override
    public void registerFragmentLifecycleCallbacks(FragmentManager.FragmentLifecycleCallbacks cb, boolean recursive) {
        this.mLifecycleCallbacks.add(new FragmentLifecycleCallbacksHolder(cb, recursive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFragmentLifecycleCallbacks(FragmentManager.FragmentLifecycleCallbacks cb) {
        CopyOnWriteArrayList<FragmentLifecycleCallbacksHolder> copyOnWriteArrayList = this.mLifecycleCallbacks;
        synchronized (copyOnWriteArrayList) {
            int N = this.mLifecycleCallbacks.size();
            for (int i = 0; i < N; ++i) {
                if (this.mLifecycleCallbacks.get((int)i).mCallback != cb) continue;
                this.mLifecycleCallbacks.remove(i);
                break;
            }
        }
    }

    void dispatchOnFragmentPreAttached(@NonNull Fragment f, @NonNull Context context, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentPreAttached(f, context, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentPreAttached(this, f, context);
        }
    }

    void dispatchOnFragmentAttached(@NonNull Fragment f, @NonNull Context context, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentAttached(f, context, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentAttached(this, f, context);
        }
    }

    void dispatchOnFragmentPreCreated(@NonNull Fragment f, @Nullable Bundle savedInstanceState, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentPreCreated(f, savedInstanceState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentPreCreated(this, f, savedInstanceState);
        }
    }

    void dispatchOnFragmentCreated(@NonNull Fragment f, @Nullable Bundle savedInstanceState, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentCreated(f, savedInstanceState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentCreated(this, f, savedInstanceState);
        }
    }

    void dispatchOnFragmentActivityCreated(@NonNull Fragment f, @Nullable Bundle savedInstanceState, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentActivityCreated(f, savedInstanceState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentActivityCreated(this, f, savedInstanceState);
        }
    }

    void dispatchOnFragmentViewCreated(@NonNull Fragment f, @NonNull View v, @Nullable Bundle savedInstanceState, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentViewCreated(f, v, savedInstanceState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentViewCreated(this, f, v, savedInstanceState);
        }
    }

    void dispatchOnFragmentStarted(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentStarted(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentStarted(this, f);
        }
    }

    void dispatchOnFragmentResumed(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentResumed(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentResumed(this, f);
        }
    }

    void dispatchOnFragmentPaused(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentPaused(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentPaused(this, f);
        }
    }

    void dispatchOnFragmentStopped(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentStopped(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentStopped(this, f);
        }
    }

    void dispatchOnFragmentSaveInstanceState(@NonNull Fragment f, @NonNull Bundle outState, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentSaveInstanceState(f, outState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentSaveInstanceState(this, f, outState);
        }
    }

    void dispatchOnFragmentViewDestroyed(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentViewDestroyed(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentViewDestroyed(this, f);
        }
    }

    void dispatchOnFragmentDestroyed(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentDestroyed(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentDestroyed(this, f);
        }
    }

    void dispatchOnFragmentDetached(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentDetached(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentDetached(this, f);
        }
    }

    public static int reverseTransit(int transit) {
        int rev = 0;
        switch (transit) {
            case 4097: {
                rev = 8194;
                break;
            }
            case 8194: {
                rev = 4097;
                break;
            }
            case 4099: {
                rev = 4099;
            }
        }
        return rev;
    }

    public static int transitToStyleIndex(int transit, boolean enter) {
        int animAttr = -1;
        switch (transit) {
            case 4097: {
                animAttr = enter ? 1 : 2;
                break;
            }
            case 8194: {
                animAttr = enter ? 3 : 4;
                break;
            }
            case 4099: {
                animAttr = enter ? 5 : 6;
            }
        }
        return animAttr;
    }

    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        Fragment fragment;
        int containerId;
        if (!"fragment".equals(name)) {
            return null;
        }
        String fname = attrs.getAttributeValue(null, "class");
        TypedArray a = context.obtainStyledAttributes(attrs, FragmentTag.Fragment);
        if (fname == null) {
            fname = a.getString(0);
        }
        int id2 = a.getResourceId(1, -1);
        String tag = a.getString(2);
        a.recycle();
        if (!Fragment.isSupportFragmentClass(this.mHost.getContext(), fname)) {
            return null;
        }
        int n = containerId = parent != null ? parent.getId() : 0;
        if (containerId == -1 && id2 == -1 && tag == null) {
            throw new IllegalArgumentException(attrs.getPositionDescription() + ": Must specify unique android:id, android:tag, or have a parent with an id for " + fname);
        }
        Fragment fragment2 = fragment = id2 != -1 ? this.findFragmentById(id2) : null;
        if (fragment == null && tag != null) {
            fragment = this.findFragmentByTag(tag);
        }
        if (fragment == null && containerId != -1) {
            fragment = this.findFragmentById(containerId);
        }
        if (DEBUG) {
            Log.v(TAG, "onCreateView: id=0x" + Integer.toHexString(id2) + " fname=" + fname + " existing=" + fragment);
        }
        if (fragment == null) {
            fragment = this.mContainer.instantiate(context, fname, null);
            fragment.mFromLayout = true;
            fragment.mFragmentId = id2 != 0 ? id2 : containerId;
            fragment.mContainerId = containerId;
            fragment.mTag = tag;
            fragment.mInLayout = true;
            fragment.mFragmentManager = this;
            fragment.mHost = this.mHost;
            fragment.onInflate(this.mHost.getContext(), attrs, fragment.mSavedFragmentState);
            this.addFragment(fragment, true);
        } else {
            if (fragment.mInLayout) {
                throw new IllegalArgumentException(attrs.getPositionDescription() + ": Duplicate id 0x" + Integer.toHexString(id2) + ", tag " + tag + ", or parent id 0x" + Integer.toHexString(containerId) + " with another fragment for " + fname);
            }
            fragment.mInLayout = true;
            fragment.mHost = this.mHost;
            if (!fragment.mRetaining) {
                fragment.onInflate(this.mHost.getContext(), attrs, fragment.mSavedFragmentState);
            }
        }
        if (this.mCurState < 1 && fragment.mFromLayout) {
            this.moveToState(fragment, 1, 0, 0, false);
        } else {
            this.moveToState(fragment);
        }
        if (fragment.mView == null) {
            throw new IllegalStateException("Fragment " + fname + " did not create a view.");
        }
        if (id2 != 0) {
            fragment.mView.setId(id2);
        }
        if (fragment.mView.getTag() == null) {
            fragment.mView.setTag(tag);
        }
        return fragment.mView;
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        return this.onCreateView(null, name, context, attrs);
    }

    LayoutInflater.Factory2 getLayoutInflaterFactory() {
        return this;
    }

    private static class EndViewTransitionAnimator
    extends AnimationSet
    implements Runnable {
        private final ViewGroup mParent;
        private final View mChild;
        private boolean mEnded;
        private boolean mTransitionEnded;
        private boolean mAnimating = true;

        EndViewTransitionAnimator(@NonNull Animation animation, @NonNull ViewGroup parent, @NonNull View child) {
            super(false);
            this.mParent = parent;
            this.mChild = child;
            this.addAnimation(animation);
            this.mParent.post((Runnable)this);
        }

        public boolean getTransformation(long currentTime, Transformation t) {
            this.mAnimating = true;
            if (this.mEnded) {
                return !this.mTransitionEnded;
            }
            boolean more = super.getTransformation(currentTime, t);
            if (!more) {
                this.mEnded = true;
                OneShotPreDrawListener.add((View)this.mParent, this);
            }
            return true;
        }

        public boolean getTransformation(long currentTime, Transformation outTransformation, float scale) {
            this.mAnimating = true;
            if (this.mEnded) {
                return !this.mTransitionEnded;
            }
            boolean more = super.getTransformation(currentTime, outTransformation, scale);
            if (!more) {
                this.mEnded = true;
                OneShotPreDrawListener.add((View)this.mParent, this);
            }
            return true;
        }

        @Override
        public void run() {
            if (!this.mEnded && this.mAnimating) {
                this.mAnimating = false;
                this.mParent.post((Runnable)this);
            } else {
                this.mParent.endViewTransition(this.mChild);
                this.mTransitionEnded = true;
            }
        }
    }

    private static class AnimatorOnHWLayerIfNeededListener
    extends AnimatorListenerAdapter {
        View mView;

        AnimatorOnHWLayerIfNeededListener(View v) {
            this.mView = v;
        }

        public void onAnimationStart(Animator animation) {
            this.mView.setLayerType(2, null);
        }

        public void onAnimationEnd(Animator animation) {
            this.mView.setLayerType(0, null);
            animation.removeListener((Animator.AnimatorListener)this);
        }
    }

    private static class AnimateOnHWLayerIfNeededListener
    extends AnimationListenerWrapper {
        View mView;

        AnimateOnHWLayerIfNeededListener(View v, Animation.AnimationListener listener2) {
            super(listener2);
            this.mView = v;
        }

        @Override
        @CallSuper
        public void onAnimationEnd(Animation animation) {
            if (ViewCompat.isAttachedToWindow(this.mView) || Build.VERSION.SDK_INT >= 24) {
                this.mView.post(new Runnable(){

                    @Override
                    public void run() {
                        AnimateOnHWLayerIfNeededListener.this.mView.setLayerType(0, null);
                    }
                });
            } else {
                this.mView.setLayerType(0, null);
            }
            super.onAnimationEnd(animation);
        }
    }

    private static class AnimationListenerWrapper
    implements Animation.AnimationListener {
        private final Animation.AnimationListener mWrapped;

        AnimationListenerWrapper(Animation.AnimationListener wrapped) {
            this.mWrapped = wrapped;
        }

        @CallSuper
        public void onAnimationStart(Animation animation) {
            if (this.mWrapped != null) {
                this.mWrapped.onAnimationStart(animation);
            }
        }

        @CallSuper
        public void onAnimationEnd(Animation animation) {
            if (this.mWrapped != null) {
                this.mWrapped.onAnimationEnd(animation);
            }
        }

        @CallSuper
        public void onAnimationRepeat(Animation animation) {
            if (this.mWrapped != null) {
                this.mWrapped.onAnimationRepeat(animation);
            }
        }
    }

    private static class AnimationOrAnimator {
        public final Animation animation;
        public final Animator animator;

        AnimationOrAnimator(Animation animation) {
            this.animation = animation;
            this.animator = null;
            if (animation == null) {
                throw new IllegalStateException("Animation cannot be null");
            }
        }

        AnimationOrAnimator(Animator animator) {
            this.animation = null;
            this.animator = animator;
            if (animator == null) {
                throw new IllegalStateException("Animator cannot be null");
            }
        }
    }

    static class StartEnterTransitionListener
    implements Fragment.OnStartEnterTransitionListener {
        final boolean mIsBack;
        final BackStackRecord mRecord;
        private int mNumPostponed;

        StartEnterTransitionListener(BackStackRecord record, boolean isBack) {
            this.mIsBack = isBack;
            this.mRecord = record;
        }

        @Override
        public void onStartEnterTransition() {
            --this.mNumPostponed;
            if (this.mNumPostponed != 0) {
                return;
            }
            this.mRecord.mManager.scheduleCommit();
        }

        @Override
        public void startListening() {
            ++this.mNumPostponed;
        }

        public boolean isReady() {
            return this.mNumPostponed == 0;
        }

        public void completeTransaction() {
            boolean canceled = this.mNumPostponed > 0;
            FragmentManagerImpl manager = this.mRecord.mManager;
            int numAdded = manager.mAdded.size();
            for (int i = 0; i < numAdded; ++i) {
                Fragment fragment = manager.mAdded.get(i);
                fragment.setOnStartEnterTransitionListener(null);
                if (!canceled || !fragment.isPostponed()) continue;
                fragment.startPostponedEnterTransition();
            }
            this.mRecord.mManager.completeExecute(this.mRecord, this.mIsBack, !canceled, true);
        }

        public void cancelTransaction() {
            this.mRecord.mManager.completeExecute(this.mRecord, this.mIsBack, false, false);
        }
    }

    private class PopBackStackState
    implements OpGenerator {
        final String mName;
        final int mId;
        final int mFlags;

        PopBackStackState(String name, int id2, int flags) {
            this.mName = name;
            this.mId = id2;
            this.mFlags = flags;
        }

        @Override
        public boolean generateOps(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop) {
            FragmentManager childManager;
            if (FragmentManagerImpl.this.mPrimaryNav != null && this.mId < 0 && this.mName == null && (childManager = FragmentManagerImpl.this.mPrimaryNav.peekChildFragmentManager()) != null && childManager.popBackStackImmediate()) {
                return false;
            }
            return FragmentManagerImpl.this.popBackStackState(records, isRecordPop, this.mName, this.mId, this.mFlags);
        }
    }

    static interface OpGenerator {
        public boolean generateOps(ArrayList<BackStackRecord> var1, ArrayList<Boolean> var2);
    }

    static class FragmentTag {
        public static final int[] Fragment = new int[]{0x1010003, 0x10100D0, 0x10100D1};
        public static final int Fragment_id = 1;
        public static final int Fragment_name = 0;
        public static final int Fragment_tag = 2;

        private FragmentTag() {
        }
    }

    private static final class FragmentLifecycleCallbacksHolder {
        final FragmentManager.FragmentLifecycleCallbacks mCallback;
        final boolean mRecursive;

        FragmentLifecycleCallbacksHolder(FragmentManager.FragmentLifecycleCallbacks callback2, boolean recursive) {
            this.mCallback = callback2;
            this.mRecursive = recursive;
        }
    }
}

