/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.IBinder;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@KeepForSdk
public class BlockingServiceConnection
implements ServiceConnection {
    boolean zza = false;
    private final BlockingQueue zzb;

    @KeepForSdk
    @NonNull
    public IBinder getService() throws InterruptedException {
        Preconditions.checkNotMainThread("BlockingServiceConnection.getService() called on main thread");
        if (((BlockingServiceConnection)object).zza) {
            Object object = new IllegalStateException("Cannot call get on this connection more than once");
            throw object;
        }
        ((BlockingServiceConnection)object).zza = true;
        return (IBinder)((BlockingServiceConnection)object).zzb.take();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public IBinder getServiceWithTimeout(long timeout, @NonNull TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        void var3_2;
        void var1_1;
        Object object;
        Preconditions.checkNotMainThread("BlockingServiceConnection.getServiceWithTimeout() called on main thread");
        if (((BlockingServiceConnection)object).zza) {
            object = new IllegalStateException("Cannot call get on this connection more than once");
            throw object;
        }
        ((BlockingServiceConnection)object).zza = true;
        object = (IBinder)((BlockingServiceConnection)object).zzb.poll((long)var1_1, (TimeUnit)var3_2);
        if (object == null) {
            object = new TimeoutException("Timed out waiting for the service connection");
            throw object;
        }
        return object;
    }

    public BlockingServiceConnection() {
        LinkedBlockingQueue linkedBlockingQueue;
        this.zzb = linkedBlockingQueue = new LinkedBlockingQueue();
    }

    public final void onServiceConnected(@NonNull ComponentName componentName, @NonNull IBinder iBinder) {
        this.zzb.add(iBinder);
    }

    public final void onServiceDisconnected(@NonNull ComponentName componentName) {
    }
}

