/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.content.IntentSender;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;

public abstract class ResolvingResultCallbacks<R extends Result>
extends ResultCallbacks<R> {
    private final Activity zza;
    private final int zzb;

    /*
     * WARNING - void declaration
     */
    protected ResolvingResultCallbacks(@NonNull Activity activity, int requestCode) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(var1_1, "Activity must not be null");
        this.zza = var1_1;
        this.zzb = var2_2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public final void onFailure(@NonNull Status result) {
        void var1_1;
        if (!result.hasResolution()) {
            this.onUnresolvableFailure((Status)var1_1);
            return;
        }
        try {
            var1_1.startResolutionForResult(this.zza, this.zzb);
            return;
        }
        catch (IntentSender.SendIntentException sendIntentException) {
            Log.e("ResolvingResultCallback", "Failed to start resolution", sendIntentException);
            Status status = new Status(8);
            this.onUnresolvableFailure(status);
            return;
        }
    }

    @Override
    public abstract void onSuccess(@NonNull R var1);

    public abstract void onUnresolvableFailure(@NonNull Status var1);
}

