/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.internal.zaaa;
import com.google.android.gms.common.api.internal.zaay;
import com.google.android.gms.common.api.internal.zaaz;
import com.google.android.gms.common.api.internal.zaba;
import com.google.android.gms.common.api.internal.zabb;
import com.google.android.gms.common.api.internal.zabc;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabi;
import com.google.android.gms.common.api.internal.zabx;
import com.google.android.gms.common.api.internal.zabz;
import com.google.android.gms.common.api.internal.zaca;
import com.google.android.gms.common.api.internal.zada;
import com.google.android.gms.common.api.internal.zadc;
import com.google.android.gms.common.api.internal.zak;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.Common;
import com.google.android.gms.common.internal.service.zae;
import com.google.android.gms.common.internal.zaj;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zabe
extends GoogleApiClient
implements zabz {
    private final Lock zaj;
    private final com.google.android.gms.common.internal.zak zak;
    @Nullable
    private zaca zal = null;
    private final int zam;
    private final Context zan;
    private final Looper zao;
    @VisibleForTesting
    final Queue zaa;
    private volatile boolean zap;
    private long zaq;
    private long zar;
    private final zabc zas;
    private final GoogleApiAvailability zat;
    @Nullable
    @VisibleForTesting
    zabx zab;
    final Map zac;
    Set zad;
    final ClientSettings zae;
    final Map zaf;
    final Api.AbstractClientBuilder zag;
    private final ListenerHolders zau;
    private final ArrayList zav;
    private Integer zaw;
    @Nullable
    Set zah;
    final zadc zai;
    private final zaj zax;

    public static int zad(Iterable iterable, boolean bl) {
        Iterator iterator = iterable.iterator();
        boolean bl2 = false;
        boolean bl3 = false;
        while (iterator.hasNext()) {
            Api.Client client = (Api.Client)iterator.next();
            bl2 = client.requiresSignIn() | bl2;
            bl3 = client.providesSignIn() | bl3;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static /* bridge */ /* synthetic */ Context zae(zabe zabe2) {
        return zabe2.zan;
    }

    @Override
    public final Context getContext() {
        return this.zan;
    }

    @Override
    public final Looper getLooper() {
        return this.zao;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ConnectionResult blockingConnect() {
        int n = Looper.myLooper() != Looper.getMainLooper() ? 1 : 0;
        Preconditions.checkState(n != 0, "blockingConnect must not be called on the UI thread");
        this.zaj.lock();
        try {
            n = this.zam;
            if (n >= 0) {
                Integer n2 = this.zaw;
                boolean bl = n2 != null;
                Preconditions.checkState(bl, "Sign-in mode should have been set explicitly by auto-manage.");
            } else {
                Integer n3 = this.zaw;
                if (n3 == null) {
                    this.zaw = zabe.zad(this.zac.values(), false);
                } else {
                    int n4 = n3;
                    if (n4 == 2) {
                        IllegalStateException illegalStateException = new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
                        throw illegalStateException;
                    }
                }
            }
            this.zal(Preconditions.checkNotNull(this.zaw));
            this.zak.zab();
            ConnectionResult connectionResult = Preconditions.checkNotNull(this.zal).zab();
            this.zaj.unlock();
            return connectionResult;
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit object) {
        boolean bl = Looper.myLooper() != Looper.getMainLooper();
        Preconditions.checkState(bl, "blockingConnect must not be called on the UI thread");
        Preconditions.checkNotNull(object, "TimeUnit must not be null");
        this.zaj.lock();
        try {
            Integer n = this.zaw;
            if (n == null) {
                this.zaw = zabe.zad(this.zac.values(), false);
            } else {
                int n2 = n;
                if (n2 == 2) {
                    IllegalStateException illegalStateException = new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
                    throw illegalStateException;
                }
            }
            this.zal(Preconditions.checkNotNull(this.zaw));
            this.zak.zab();
            ConnectionResult connectionResult = Preconditions.checkNotNull(this.zal).zac(l, (TimeUnit)((Object)object));
            return connectionResult;
        }
        finally {
            this.zaj.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> object) {
        this.zaj.lock();
        try {
            boolean bl = this.isConnected();
            if (bl || (bl = this.zap)) {
                bl = this.zac.containsKey(((Api)object).zab());
                if (!bl) {
                    object = ((Api)object).zad();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((String)object);
                    stringBuilder.append(" was never registered with GoogleApiClient");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.toString());
                    throw illegalArgumentException;
                }
                ConnectionResult connectionResult = Preconditions.checkNotNull(this.zal).zad((Api)object);
                if (connectionResult != null) return connectionResult;
                boolean bl2 = this.zap;
                if (bl2) {
                    object = ConnectionResult.RESULT_SUCCESS;
                    return object;
                }
                Log.w("GoogleApiClientImpl", this.zaf());
                object = ((Api)object).zad();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)object);
                stringBuilder.append(" requested in getConnectionResult is not connected but is not present in the failed  connections map");
                object = new Exception();
                Log.wtf("GoogleApiClientImpl", stringBuilder.toString(), (Throwable)object);
                object = new ConnectionResult(8, null);
                return object;
            }
            object = new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            throw object;
        }
        finally {
            this.zaj.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.Client> C getClient(@NonNull Api.AnyClientKey<C> anyClientKey) {
        Api.Client client = (Api.Client)((zabe)((Object)client)).zac.get(anyClientKey);
        Preconditions.checkNotNull(client, "Appropriate Api was not requested.");
        return (C)client;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        Preconditions.checkState(((zabe)googleApiClient).isConnected(), "GoogleApiClient is not connected yet.");
        Integer n = ((zabe)googleApiClient).zaw;
        boolean bl = n != null ? n != 2 : true;
        Preconditions.checkState(bl, "Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        StatusPendingResult statusPendingResult = new StatusPendingResult(googleApiClient);
        if (((zabe)googleApiClient).zac.containsKey(Common.CLIENT_KEY)) {
            ((zabe)googleApiClient).zam(googleApiClient, statusPendingResult, false);
            return statusPendingResult;
        }
        AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
        zaaz zaaz2 = new zaaz((zabe)googleApiClient, atomicReference, statusPendingResult);
        zaba zaba2 = new zaba((zabe)googleApiClient, statusPendingResult);
        GoogleApiClient.Builder builder = new GoogleApiClient.Builder(((zabe)googleApiClient).zan);
        builder.addApi(Common.API);
        builder.addConnectionCallbacks(zaaz2);
        builder.addOnConnectionFailedListener(zaba2);
        builder.setHandler(((zabe)googleApiClient).zas);
        GoogleApiClient googleApiClient = builder.build();
        atomicReference.set(googleApiClient);
        googleApiClient.connect();
        return statusPendingResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T object) {
        Object object2 = ((BaseImplementation.ApiMethodImpl)object).getApi();
        boolean bl = this.zac.containsKey(((BaseImplementation.ApiMethodImpl)object).getClientKey());
        object2 = object2 != null ? ((Api)object2).zad() : "the API";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GoogleApiClient is not configured to use ");
        stringBuilder.append((String)object2);
        stringBuilder.append(" required for this call.");
        Preconditions.checkArgument(bl, stringBuilder.toString());
        this.zaj.lock();
        try {
            object2 = this.zal;
            if (object2 == null) {
                this.zaa.add(object);
                return (T)object;
            }
            BaseImplementation.ApiMethodImpl apiMethodImpl = object2.zae((BaseImplementation.ApiMethodImpl)object);
            return (T)apiMethodImpl;
        }
        finally {
            this.zaj.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T object) {
        Object object2 = ((BaseImplementation.ApiMethodImpl)object).getApi();
        boolean bl = this.zac.containsKey(((BaseImplementation.ApiMethodImpl)object).getClientKey());
        object2 = object2 != null ? ((Api)object2).zad() : "the API";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GoogleApiClient is not configured to use ");
        stringBuilder.append((String)object2);
        stringBuilder.append(" required for this call.");
        Preconditions.checkArgument(bl, stringBuilder.toString());
        this.zaj.lock();
        try {
            object2 = this.zal;
            if (object2 != null) {
                boolean bl2;
                bl = this.zap;
                if (!bl) {
                    BaseImplementation.ApiMethodImpl apiMethodImpl = object2.zaf((BaseImplementation.ApiMethodImpl)object);
                    return (T)apiMethodImpl;
                }
                this.zaa.add(object);
                while (!(bl2 = this.zaa.isEmpty())) {
                    object2 = (BaseImplementation.ApiMethodImpl)this.zaa.remove();
                    this.zai.zaa((BasePendingResult)object2);
                    ((BaseImplementation.ApiMethodImpl)object2).setFailedResult(Status.RESULT_INTERNAL_ERROR);
                }
                return (T)object;
            }
            IllegalStateException illegalStateException = new IllegalStateException("GoogleApiClient is not connected yet.");
            throw illegalStateException;
        }
        finally {
            this.zaj.unlock();
        }
    }

    @Override
    public final <L> ListenerHolder<L> registerListener(@NonNull L object) {
        this.zaj.lock();
        try {
            ListenerHolders listenerHolders = this.zau;
            Looper looper = this.zao;
            object = listenerHolders.zaa(object, looper, "NO_TYPE");
        }
        finally {
            this.zaj.unlock();
        }
        return object;
    }

    final String zaf() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.dump("", null, printWriter, null);
        return stringWriter.toString();
    }

    static String zag(int n) {
        switch (n) {
            default: {
                return "UNKNOWN";
            }
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
            case 1: 
        }
        return "SIGN_IN_MODE_REQUIRED";
    }

    static /* bridge */ /* synthetic */ void zah(zabe zabe2, GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        zabe2.zam(googleApiClient, statusPendingResult, true);
    }

    static /* bridge */ /* synthetic */ void zai(zabe zabe2) {
        block4: {
            zabe2.zaj.lock();
            boolean bl = zabe2.zap;
            if (!bl) break block4;
            try {
                zabe2.zan();
            }
            finally {
                zabe2.zaj.unlock();
            }
        }
    }

    static /* bridge */ /* synthetic */ void zaj(zabe zabe2) {
        block4: {
            zabe2.zaj.lock();
            boolean bl = zabe2.zak();
            if (!bl) break block4;
            try {
                zabe2.zan();
            }
            finally {
                zabe2.zaj.unlock();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public zabe(Context iterator, Lock object3, Looper looper, ClientSettings clientSettings, GoogleApiAvailability googleApiAvailability, Api.AbstractClientBuilder abstractClientBuilder, Map map2, List list, List list2, Map map3, int n, int n2, ArrayList arrayList) {
        LinkedList linkedList;
        this.zaa = linkedList = new LinkedList();
        long l = true != ClientLibraryUtils.isPackageSide() ? 120000L : 10000L;
        this.zaq = l;
        this.zar = 5000L;
        Object object2 = new HashSet();
        this.zad = object2;
        this.zau = object2 = new ListenerHolders();
        this.zaw = null;
        this.zah = null;
        this.zax = object2 = new zaay(this);
        this.zan = iterator;
        this.zaj = object3;
        iterator = new Iterator(looper, this.zax);
        this.zak = iterator;
        this.zao = looper;
        iterator = new Iterator(this, looper);
        this.zas = iterator;
        this.zat = googleApiAvailability;
        this.zam = n;
        if (n >= 0) {
            this.zaw = n2;
        }
        this.zaf = map2;
        this.zac = map3;
        this.zav = arrayList;
        iterator = new Iterator();
        this.zai = iterator;
        for (Object object3 : list) {
            object3 = (GoogleApiClient.ConnectionCallbacks)object3;
            this.zak.zaf((GoogleApiClient.ConnectionCallbacks)object3);
        }
        iterator = list2.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.zae = clientSettings;
                this.zag = abstractClientBuilder;
                return;
            }
            object3 = iterator.next();
            object3 = (GoogleApiClient.OnConnectionFailedListener)object3;
            this.zak.zag((GoogleApiClient.OnConnectionFailedListener)object3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zal(int n) {
        int n2;
        Object object;
        Integer n3 = ((zabe)object).zaw;
        if (n3 == null) {
            ((zabe)object).zaw = n;
        } else if (n3 != n) {
            object = ((zabe)object).zaw;
            int n4 = (Integer)object;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot use sign-in mode: ");
            stringBuilder.append(zabe.zag(n));
            stringBuilder.append(". Mode was already set to ");
            stringBuilder.append(zabe.zag(n4));
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
            throw illegalStateException;
        }
        if (((zabe)object).zal != null) {
            return;
        }
        Iterator iterator = ((zabe)object).zac.values().iterator();
        n = 0;
        boolean bl = false;
        while (iterator.hasNext()) {
            Api.Client client = (Api.Client)iterator.next();
            n = client.requiresSignIn() | n;
            n2 = client.providesSignIn() | n2;
        }
        switch (((zabe)object).zaw) {
            case 1: {
                if (n == 0) {
                    object = new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                    throw object;
                }
                if (n2 == false) break;
                object = new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
                throw object;
            }
            case 2: {
                if (n == 0) break;
                ((zabe)object).zal = zaaa.zag(((zabe)object).zan, (zabe)object, ((zabe)object).zaj, ((zabe)object).zao, ((zabe)object).zat, ((zabe)object).zac, ((zabe)object).zae, ((zabe)object).zaf, ((zabe)object).zag, ((zabe)object).zav);
                return;
            }
        }
        zabi zabi2 = new zabi(((zabe)object).zan, (zabe)object, ((zabe)object).zaj, ((zabe)object).zao, ((zabe)object).zat, ((zabe)object).zac, ((zabe)object).zae, ((zabe)object).zaf, ((zabe)object).zag, ((zabe)object).zav, (zabz)object);
        ((zabe)object).zal = zabi2;
    }

    private final void zam(GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        Object object = Common.zaa;
        object = ((zae)object).zaa(googleApiClient);
        zabb zabb2 = new zabb(this, statusPendingResult, bl, googleApiClient);
        ((PendingResult)object).setResultCallback(zabb2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void connect() {
        block16: {
            boolean bl;
            int n;
            block12: {
                block17: {
                    block14: {
                        Integer n2;
                        block15: {
                            block13: {
                                this.zaj.lock();
                                n = this.zam;
                                if (n < 0) break block13;
                                Integer n3 = this.zaw;
                                boolean bl2 = n3 != null;
                                Preconditions.checkState(bl2, "Sign-in mode should have been set explicitly by auto-manage.");
                                break block14;
                            }
                            n2 = this.zaw;
                            if (n2 != null) break block15;
                            this.zaw = zabe.zad(this.zac.values(), false);
                            break block14;
                        }
                        int n4 = n2;
                        if (n4 == 2) break block16;
                    }
                    n = Preconditions.checkNotNull(this.zaw);
                    this.zaj.lock();
                    if (n == 3) break block17;
                    if (n != 1) {
                        if (n == 2) {
                            n = 2;
                            bl = true;
                            break block12;
                        } else {
                            bl = false;
                        }
                        break block12;
                    } else {
                        bl = true;
                    }
                    break block12;
                }
                bl = true;
            }
            try {
                CharSequence charSequence = new StringBuilder();
                charSequence.append("Illegal sign-in mode: ");
                charSequence.append(n);
                charSequence = charSequence.toString();
                Preconditions.checkArgument(bl, charSequence);
                this.zal(n);
                this.zan();
                return;
            }
            finally {
                this.zaj.unlock();
            }
        }
        IllegalStateException illegalStateException = new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
        throw illegalStateException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void connect(int n) {
        boolean bl;
        block7: {
            block8: {
                this.zaj.lock();
                if (n == 3) break block8;
                if (n != 1) {
                    if (n == 2) {
                        n = 2;
                        bl = true;
                        break block7;
                    } else {
                        bl = false;
                    }
                    break block7;
                } else {
                    bl = true;
                }
                break block7;
            }
            bl = true;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Illegal sign-in mode: ");
            stringBuilder.append(n);
            Preconditions.checkArgument(bl, stringBuilder.toString());
            this.zal(n);
            this.zan();
            return;
        }
        finally {
            this.zaj.unlock();
        }
    }

    @GuardedBy(value="mLock")
    private final void zan() {
        this.zak.zab();
        Preconditions.checkNotNull(this.zal).zaq();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void disconnect() {
        boolean bl;
        this.zaj.lock();
        this.zai.zab();
        Object object = this.zal;
        if (object != null) {
            object.zar();
        }
        this.zau.zab();
        object = this.zaa.iterator();
        while (bl = object.hasNext()) {
            BaseImplementation.ApiMethodImpl apiMethodImpl = (BaseImplementation.ApiMethodImpl)object.next();
            apiMethodImpl.zan(null);
            apiMethodImpl.cancel();
        }
        this.zaa.clear();
        object = this.zal;
        if (object == null) {
            this.zaj.unlock();
            return;
        }
        this.zak();
        this.zak.zaa();
        return;
    }

    @Override
    public final void dump(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(((zabe)((Object)zaca2)).zan);
        printWriter.append(string2).append("mResuming=").print(((zabe)((Object)zaca2)).zap);
        printWriter.append(" mWorkQueue.size()=").print(((zabe)((Object)zaca2)).zaa.size());
        zadc zadc2 = ((zabe)((Object)zaca2)).zai;
        printWriter.append(" mUnconsumedApiCalls.size()=").println(zadc2.zab.size());
        zaca zaca2 = ((zabe)((Object)zaca2)).zal;
        if (zaca2 != null) {
            zaca2.zas(string2, fileDescriptor, printWriter, stringArray);
            return;
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa(ConnectionResult connectionResult) {
        if (!this.zat.isPlayServicesPossiblyUpdating(this.zan, connectionResult.getErrorCode())) {
            this.zak();
        }
        if (!this.zap) {
            this.zak.zac(connectionResult);
            this.zak.zaa();
            return;
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zab(@Nullable Bundle bundle) {
        while (!this.zaa.isEmpty()) {
            ((GoogleApiClient)this).execute((BaseImplementation.ApiMethodImpl)this.zaa.remove());
        }
        this.zak.zad(bundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @GuardedBy(value="mLock")
    public final void zac(int n, boolean n2) {
        block5: {
            block4: {
                block6: {
                    block7: {
                        if (n != 1) break block5;
                        if (n2 != 0) break block6;
                        if (!this.zap) break block7;
                        n = 1;
                        break block5;
                    }
                    this.zap = true;
                    if (this.zab != null || ClientLibraryUtils.isPackageSide()) break block4;
                    try {
                        GoogleApiAvailability googleApiAvailability = this.zat;
                        Context context = this.zan;
                        context = context.getApplicationContext();
                        zabd zabd2 = new zabd(this);
                        this.zab = googleApiAvailability.zac(context, zabd2);
                        break block4;
                    }
                    catch (SecurityException securityException) {}
                }
                n = 1;
                break block5;
            }
            zabc zabc2 = this.zas;
            zabc2.sendMessageDelayed(zabc2.obtainMessage(1), this.zaq);
            zabc2 = this.zas;
            zabc2.sendMessageDelayed(zabc2.obtainMessage(2), this.zar);
            n = 1;
        }
        BasePendingResult[] basePendingResultArray = this.zai.zab.toArray(new BasePendingResult[0]);
        int n3 = basePendingResultArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            basePendingResultArray[n2].forceFailureUnlessReady(zadc.zaa);
        }
        this.zak.zae(n);
        this.zak.zaa();
        if (n == 2) {
            this.zan();
            return;
        }
    }

    @Override
    public final void maybeSignOut() {
        zaca zaca2 = ((zabe)((Object)zaca2)).zal;
        if (zaca2 != null) {
            zaca2.zau();
            return;
        }
    }

    @Override
    public final void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zak.zaf(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zak.zag(onConnectionFailedListener);
    }

    @Override
    public final void zao(zada zada2) {
        this.zaj.lock();
        try {
            HashSet hashSet = this.zah;
            if (hashSet == null) {
                this.zah = hashSet = new HashSet();
            }
            this.zah.add(zada2);
        }
        finally {
            this.zaj.unlock();
        }
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        LifecycleActivity lifecycleActivity = new LifecycleActivity(fragmentActivity);
        if (((zabe)object).zam < 0) {
            Object object = new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
            throw object;
        }
        com.google.android.gms.common.api.internal.zak.zaa(lifecycleActivity).zae(((zabe)object).zam);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zak.zah(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zak.zai(onConnectionFailedListener);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zap(zada object) {
        zaca zaca2;
        block12: {
            Set set;
            block11: {
                this.zaj.lock();
                Set set2 = this.zah;
                if (set2 == null) {
                    object = new Exception();
                    Log.wtf("GoogleApiClientImpl", "Attempted to remove pending transform when no transforms are registered.", (Throwable)object);
                    return;
                }
                boolean bl = set2.remove(object);
                if (!bl) {
                    Exception exception = new Exception();
                    Log.wtf("GoogleApiClientImpl", "Failed to remove pending transform - this may lead to memory leaks!", exception);
                    return;
                }
                this.zaj.lock();
                set = this.zah;
                if (set != null) break block11;
                {
                    catch (Throwable throwable) {
                        this.zaj.unlock();
                        throw throwable;
                    }
                }
                this.zaj.unlock();
                break block12;
            }
            boolean bl = set.isEmpty();
            bl ^= true;
            this.zaj.unlock();
            if (bl) return;
        }
        if ((zaca2 = this.zal) == null) return;
        zaca2.zat();
        return;
        finally {
            this.zaj.unlock();
        }
    }

    @Override
    public final boolean hasApi(@NonNull Api<?> api) {
        return this.zac.containsKey(api.zab());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((zabe)((Object)client)).isConnected()) {
            return false;
        }
        Api.Client client = (Api.Client)((zabe)((Object)client)).zac.get(api.zab());
        return client != null && client.isConnected();
    }

    @Override
    public final boolean isConnected() {
        zaca zaca2 = ((zabe)((Object)zaca2)).zal;
        return zaca2 != null && zaca2.zaw();
    }

    @Override
    public final boolean isConnecting() {
        zaca zaca2 = ((zabe)((Object)zaca2)).zal;
        return zaca2 != null && zaca2.zax();
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zak.zaj(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zak.zak(onConnectionFailedListener);
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        zaca zaca2 = ((zabe)((Object)zaca2)).zal;
        return zaca2 != null && zaca2.zay(signInConnectionListener);
    }

    @GuardedBy(value="mLock")
    final boolean zak() {
        if (!this.zap) {
            return false;
        }
        this.zap = false;
        this.zas.removeMessages(2);
        this.zas.removeMessages(1);
        zabx zabx2 = this.zab;
        if (zabx2 != null) {
            zabx2.zab();
            this.zab = null;
        }
        return true;
    }
}

