/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.AccountAccessor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzm;

@SafeParcelable.Reserved(value={9})
@SafeParcelable.Class(creator="GetServiceRequestCreator")
@KeepForSdk
public class GetServiceRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<GetServiceRequest> CREATOR;
    static final Scope[] zza;
    static final Feature[] zzb;
    @SafeParcelable.VersionField(id=1)
    final int zzc;
    @SafeParcelable.Field(id=2)
    final int zzd;
    @SafeParcelable.Field(id=3)
    int zze;
    @SafeParcelable.Field(id=4)
    String zzf;
    @SafeParcelable.Field(id=5)
    @Nullable
    IBinder zzg;
    @SafeParcelable.Field(id=6, defaultValueUnchecked="GetServiceRequest.EMPTY_SCOPES")
    Scope[] zzh;
    @SafeParcelable.Field(id=7, defaultValueUnchecked="new android.os.Bundle()")
    Bundle zzi;
    @SafeParcelable.Field(id=8)
    @Nullable
    Account zzj;
    @SafeParcelable.Field(id=10, defaultValueUnchecked="GetServiceRequest.EMPTY_FEATURES")
    Feature[] zzk;
    @SafeParcelable.Field(id=11, defaultValueUnchecked="GetServiceRequest.EMPTY_FEATURES")
    Feature[] zzl;
    @SafeParcelable.Field(id=12)
    boolean zzm;
    @SafeParcelable.Field(id=13, defaultValue="0")
    int zzn;
    @SafeParcelable.Field(id=14, getter="isRequestingTelemetryConfiguration")
    boolean zzo;
    @Nullable
    @SafeParcelable.Field(id=15, getter="getAttributionTag")
    private String zzp;

    @KeepForSdk
    @NonNull
    public Bundle getExtraArgs() {
        return this.zzi;
    }

    static {
        zzm zzm2;
        CREATOR = zzm2 = new zzm();
        zza = new Scope[0];
        zzb = new Feature[0];
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    GetServiceRequest(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) int n3, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) @Nullable IBinder iBinder, @SafeParcelable.Param(id=6) Scope[] scopeArray, @SafeParcelable.Param(id=7) Bundle bundle, @SafeParcelable.Param(id=8) @Nullable Account account, @SafeParcelable.Param(id=10) Feature[] featureArray, @SafeParcelable.Param(id=11) Feature[] featureArray2, @SafeParcelable.Param(id=12) boolean bl, @SafeParcelable.Param(id=13) int n4, @SafeParcelable.Param(id=14) boolean bl2, @SafeParcelable.Param(id=15) @Nullable String string3) {
        if (scopeArray == null) {
            scopeArray = zza;
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (featureArray == null) {
            featureArray = zzb;
        }
        if (featureArray2 == null) {
            featureArray2 = zzb;
        }
        this.zzc = n;
        this.zzd = n2;
        this.zze = n3;
        this.zzf = "com.google.android.gms".equals(string2) ? "com.google.android.gms" : string2;
        if (n < 2) {
            Account account2 = iBinder != null ? AccountAccessor.getAccountBinderSafe(IAccountAccessor.Stub.asInterface(iBinder)) : null;
            this.zzj = account2;
        } else {
            this.zzg = iBinder;
            this.zzj = account;
        }
        this.zzh = scopeArray;
        this.zzi = bundle;
        this.zzk = featureArray;
        this.zzl = featureArray2;
        this.zzm = bl;
        this.zzn = n4;
        this.zzo = bl2;
        this.zzp = string3;
    }

    @Override
    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        com.google.android.gms.common.internal.zzm.zza(this, parcel, n);
    }

    @Nullable
    public final String zza() {
        return this.zzp;
    }
}

